﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentHint = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);

	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	this._automaticHideTimerInterval = 0;

	this.offsetLeft = 15;
	this.offsetRight = 15;
	this.offsetTop = 25;
	this.offsetBottom = 65;

	this.hintKeyLength = 25;
	this.hintDescLength = 50;
};

componentHint.prototype = new __componentText;
componentHint.prototype.type = "componentHint";

componentHint.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();

	this.resourcesStatus = (page.allowCommunication()) ? PlayerInterface.GetValue("resourcesStatus") : PageInterface.GetValue("resourcesStatus");
	this.resourcesURL = (this.disableOnlineOfflineMix) ? resourcesURL : ((page.allowCommunication()) ? PlayerInterface.GetValue("resourcesURL") : PageInterface.GetValue("resourcesURL"));

	this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [ this.topleftSrc, this.toprightSrc, this.bottomleftSrc, this.bottomrightSrc ];
	this.getPreloadImagesArr();
};

componentHint.prototype.componentHintBaseOnCreate = componentHint.prototype.onCreate;
componentHint.prototype.onCreate = function(obj)
{
	this.font.family = this.fontFamily;
	this.font.size = this.fontSize;
	this.font.color = this.fontColor;

	this.componentHintBaseOnCreate();
	document.getElementById(this.id + "_contentObjBckg").src = this.getSrc(this.position);
	this._automaticHideTimerInterval = this.automaticHideTimerInterval;

	this.placeHTMLObiects(this.position);
};

componentHint.prototype.placeHTMLObiects = function(mode)
{
	var captionTextDIV = document.getElementById(this.id + "_captionTextDIV");
	var textDIV = document.getElementById(this.id + "_textDIV");

	switch (mode) {
		case "topleft":
			captionTextDIV.style.top = 0;
			textDIV.style.top = this.headerHeight;
			textDIV.style.height = this.h - (this.offsetBottom + this.headerHeight + this.footerHeight);
			textDIV.style.clip = 'rect ( 0px '+textDIV.style.width+' '+textDIV.style.height+' 0px)';
			break;
		case "bottomleft":
			captionTextDIV.style.top = this.offsetBottom;
			textDIV.style.top = this.offsetBottom + this.headerHeight;
			textDIV.style.height = this.h - (this.offsetBottom + this.headerHeight + this.footerHeight);
			textDIV.style.clip = 'rect ( 0px '+textDIV.style.width+' '+textDIV.style.height+' 0px)';
			break;
		case "bottomright":
			captionTextDIV.style.top = this.offsetBottom;
			textDIV.style.top = this.offsetBottom + this.headerHeight;
			textDIV.style.height = this.h - (this.offsetBottom + this.headerHeight + this.footerHeight);
			textDIV.style.clip = 'rect ( 0px '+textDIV.style.width+' '+textDIV.style.height+' 0px)';
			break;
		default:
			captionTextDIV.style.top = 0;
			textDIV.style.top = this.headerHeight;
			textDIV.style.height = this.h - (this.offsetBottom + this.headerHeight + this.footerHeight);
			textDIV.style.clip = 'rect ( 0px '+textDIV.style.width+' '+textDIV.style.height+' 0px)';
			break;
	};
};

componentHint.prototype.componentHintBaseEventMouseDown = componentHint.prototype.eventMouseDown;
componentHint.prototype.eventMouseDown = function(e)
{
	this.hide();
	return this.componentHintBaseEventMouseDown(e);
};

componentHint.prototype.componentHintBaseSetHTMLDef = componentHint.prototype._setHTMLDef;
componentHint.prototype._setHTMLDef = function(text, rep)
{
	text = this._getHTMLDef(text);
	document.getElementById(this.id + "_textDIV").innerHTML = text;
	document.getElementById(this.id + "_contentObjBckg").src = this.getSrc(this.position);
	this.reinit();
};

componentHint.prototype.getSrc = function(value)
{
	var result = this.resourcesURL + this.toprightSrc;
	switch (value) {
		case "topleft":
			result = this.resourcesURL + this.topleftSrc;
			break;
		case "topright":
			result = this.resourcesURL + this.toprightSrc;
			break;
		case "bottomleft":
			result = this.resourcesURL + this.bottomleftSrc;
			break;
		case "bottomright":
			result = this.resourcesURL + this.bottomrightSrc;
			break;
	};
	return result;
};

componentHint.prototype.showHint = function(text, type)
{
	var _x = page.cursorX;
	var _y = page.cursorY;
	var _c_width = this.w;
	var _c_height = this.h;
	var mode = "";

	if (_y - this.h < 0) {
		mode = "bottom";
	} else {
		mode = "top";
		_y -= this.h;
	};
	if (_x + this.w > page.pageWidth) {
		mode += "left";
		_x -= this.w; 
	} else {
		mode += "right";
	};

	switch (mode) {
		case "topleft":
			_y -= 10;
			break;
		case "topright":
			_y -= 10;
			break;
		case "bottomleft":
			_y += 10;
			break;
		case "bottomright":
			_y += 10;
			break;
	};

	PageInterface.Execute("setOnTop", this);
	document.getElementById(this.id + "_contentObjBckg").src = this.getSrc(mode);
	this.placeHTMLObiects(mode);
	this.setValue(text);

	if (type == "lexicon") {
		this.setCaption("Lexicon");
	} else
	if (type == "dictionary") {
		this.setCaption("Dictionary");
	} else {
		this.setCaption(this.caption);
	};

	this.moveTo(_x, _y, false);
	this.show();
};

componentHint.prototype.setCaption = function(value)
{
	if (typeof(value) == "undefined" && value == null) return false;
	var obj = document.getElementById(this.id + "_captionContentObj");
	if (obj) {
		obj.innerHTML = value;
		obj.style.color = "#FFFFFF";
		obj.style.fontWeight = "bold";
		return true;
	};
	return false;
};

componentHint.prototype.componentHintBaseEventMouseOver = componentHint.prototype.eventMouseOver;
componentHint.prototype.eventMouseOver = function(e)
{
	this._automaticHideTimerStop();
	this.automaticHideTimerInterval = 0;
	return this.componentHintBaseEventMouseOver(e);
};

componentHint.prototype.componentHintBaseEventMouseOut = componentHint.prototype.eventMouseOut;
componentHint.prototype.eventMouseOut = function(e)
{
	this.automaticHideTimerInterval = this._automaticHideTimerInterval;
	this._automaticHideTimerRun();
	return this.componentHintBaseEventMouseOut(e);
};
