﻿/*
/*
 * Copyright (C) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentSLWSlideShow = function(name)
{
	this.__componentImage = __componentImage;
	this.__componentImage(name);
	
	this.keys = new Array();
	this.displayedImageIndex = 0;
	this.tempChars = "";
	this.startInterval = false;
	this.stepsTextsArr = new Array();

	this.TimerID = null;
	this.hintTimerID = null;
	
	this.hintComp = null;
	this.hintTextComp = null;
	this.howManyWrongKeyPressed = 0;
	this.endSequence = false;
	this.keyboardSimulator = false;
};

componentSLWSlideShow.prototype = new __componentImage();
componentSLWSlideShow.prototype.type = "componentSLWSlideShow";

componentSLWSlideShow.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();
	this.keys = this.codesList.split("||");
	
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	}		
	this.resourcesURL = unescape(this.resourcesURL);
	
	this.imagesNameArr = this.randImages.split("||");
	this.getPreloadImagesArr();	
};

componentSLWSlideShow.prototype.getCaptionWidth = function(text, fontFamily, fontSize)
{
	var obj = document.getElementById(this.id+"sizeDiv");
	
	if (obj) {
		obj.innerHTML = text;
		obj.style.fontFamily = fontFamily;
		obj.style.fontSize = fontSize;
		return obj.offsetWidth;
	};
	return 0;
}
componentSLWSlideShow.prototype.getCaptionHeight = function(text, fontFamily, fontSize)
{
	var obj = document.getElementById(this.id+"sizeDiv");
	if (obj) {
		obj.innerHTML = text;
		obj.style.fontFamily = fontFamily;
		obj.style.fontSize = fontSize;
		return obj.offsetHeight;
	};
	return 0;
}

componentSLWSlideShow.prototype.showTrainingFromApplicationHint = function ()
{
	if (typeof(e) == "undefined") e = true;
	if (this.timerID != null) window.clearTimeout(this.timerID);
	
	var textW = this.getCaptionWidth(this.hintText, this.hintTextFontFamily, getFontSize(this.hintTextFontSize, 'px')) + 2*this.borderHintWidth + 10;
	var textH = this.getCaptionHeight(this.hintText, this.hintTextFontFamily, getFontSize(this.hintTextFontSize, 'px')) + 2*this.borderHintWidth;
	
	switch (this.hintPosition) {
		case "nw":
			var imageX = this.x - this.hintImageWidth;
			var imageY = this.y - this.hintImageHeight;
			var rectangleX = imageX - textW - this.borderHintWidth*2;
			var rectangleY = imageY - textH - this.borderHintWidth*2;
			var src = this.hintImageSrcUpLeft;
			break;
		case "ne":
			var imageX = this.x + this.w;
			var imageY = this.y - this.hintImageHeight;
			var rectangleX = imageX + this.hintImageWidth;
			var rectangleY = imageY - textH - this.borderHintWidth*2;
			var src = this.hintImageSrcUpRight;
			break;
		case "se":
			var imageX = this.x + this.w;
			var imageY = this.y + this.h;
			var rectangleX = imageX + this.hintImageWidth;
			var rectangleY = imageY + this.hintImageHeight;
			var src = this.hintImageSrcDownLeft;
			break;
		case "sw":
			var imageX = this.x - this.hintImageWidth;
			var imageY = this.y + this.h;
			var rectangleX = imageX - textW - this.borderHintWidth*2;
			var rectangleY = imageY + this.hintImageHeight;
			var src = this.hintImageSrcDownRight;
			break;
	};	
	
	if (this.anotherPopup == "-") {
		var newObj = PageInterface.Execute("createChild", "componentImage", this.id + "_hintComp");
		this.hintComp = PageInterface.Execute("addChild", newObj);	
		if (this.hintComp) {
			this.hintComp.x = imageX;
			this.hintComp.y = imageY;
			this.hintComp.w = this.hintImageWidth;
			this.hintComp.h = this.hintImageHeight;
			this.hintComp.cursor = "default";
			this.hintComp.src = src;
			this.hintComp.cursor = "default";
			this.hintComp.borderColor = "transparent";
			this.hintComp.borderWidth = 0;
			this.hintComp.step = 0;
			this.hintComp.visibleIf = "";
			this.hintComp.infoText = "Put an image here";
			this.hintComp.contentMode = 0;
			this.hintComp.stayOnTop = false;
			this.hintComp.alphaOpacity = "100";
			this.hintComp.altHint = "";
			this.hintComp.layer = 1;
			this.hintComp.disableOnlineOfflineMix = false;
			this.hintComp.automaticHideTimerInterval = 0;
		    this.hintComp.setBorder(this.hintComp.borderColor, this.hintComp.borderWidth);
			this.hintComp.p_checkMarkers = this.p_checkMarkers;
			this.hintComp.p_checkPNG = this.p_checkPNG;
			this.hintComp.pngFix = this.pngFix;
			if (!this.endSequence) this.hintComp.show();
			page.setOnTop(this.hintComp);
		}	
		
		var newObj = PageInterface.Execute("createChild", "componentText", this.id + "_hintText");
		this.hintTextComp = PageInterface.Execute("addChild", newObj);
		if (this.hintTextComp) {
			this.hintTextComp.x = rectangleX;
			this.hintTextComp.y = rectangleY;
			this.hintTextComp.w = textW + (this.borderHintWidth*2);
			this.hintTextComp.h = textH + (this.borderHintWidth*2);
			this.hintTextComp.align = this.hintTextAlign;
			this.hintTextComp.valign = this.hintTextValign;
			this.hintTextComp.font.family = this.hintTextFontFamily;
			this.hintTextComp.font.size = this.hintTextFontSize;
			this.hintTextComp.font.color = this.hintTextFontColor; 
			this.hintTextComp.bgColor = this.bgHintColor;
			this.hintTextComp.wrap = true;
			this.hintTextComp.padding = 3;
			this.hintTextComp.text = this.hintText;
			this.hintTextComp.lineHeight = this.lineHeight;
			this.hintTextComp.cursor = "default";
			this.hintTextComp.borderColor = this.borderHintColor;
			this.hintTextComp.borderWidth = this.borderHintWidth;
			this.hintTextComp.step = 0;
			this.hintTextComp.visibleIf = "";
			this.hintTextComp.contentMode = 0;
			this.hintTextComp.stayOnTop = false;
			this.hintTextComp.alphaOpacity = "100";
			this.hintTextComp.altHint = "";
			this.hintTextComp.layer = 1;
			this.hintTextComp.disableOnlineOfflineMix = false;
			this.hintTextComp.automaticHideTimerInterval = 0;
			this.hintTextComp.allowGF = this.allowGF;
			this.hintTextComp.p_checkMarkers = this.p_checkMarkers;
			this.hintTextComp.p_checkPNG = this.p_checkPNG;
			this.hintTextComp.pngFix = this.pngFix;
			this.hintTextComp.setBorder(this.hintTextComp.borderColor, this.hintTextComp.borderWidth);
			if (!this.endSequence) this.hintTextComp.show();
			page.setOnTop(this.hintTextComp);	
		};
	} else {
		var popup = PageInterface.GetValue("getChild", this.anotherPopup);
		popup.invokedFromDetectComponent = true; //pg2- do not repaint twice and overwrite text to standard one defined for (and within) popup component - just as in detect components
		if (!this.endSequence && popup) {
			if (popup.execution){
				var popupContent = popup.findContentObj();
				popupContent.innerHTML = this.hintText;
			}else{
				popup.text.text = this.hintText;
			};
			if (popup.visible) popup.paint();
			else popup.show();					
		}
	}	
}

componentSLWSlideShow.prototype.onHide = function()
{	
	this.removeListener();
	this.hideHint();
	this.typing = 'endTyping';
	this.startInterval = false;
	this.onFree();
};

componentSLWSlideShow.prototype.onPaint = function()
{
	if (PageInterface.GetValue("state") == psDesigning){
		this.displayedImageIndex = this.imagesNameArr.length-1;
		this.setInnerHTML();
	};
};

componentSLWSlideShow.prototype.componentSLWSlideShowBaseResetElement = componentSLWSlideShow.prototype.resetElement;
componentSLWSlideShow.prototype.resetElement = function()
{
	this.componentSLWSlideShowBaseResetElement();
	this.displayedImageIndex = 0;
	var obj = document.getElementById(this.id+"_contentObj");
	if (obj) obj.innerHTML = "";
}

componentSLWSlideShow.prototype.addListener = function()
{
	if (!this.keyboardSimulator) {
		addKeyDownListener(this.id);
	}
}

componentSLWSlideShow.prototype.removeListener = function()
{
	if (!this.keyboardSimulator) {
		removeKeyDownListener(this.id);
	}
}

componentSLWSlideShow.prototype.setInnerHTML = function()
{
	var obj = document.getElementById(this.id+"_contentObj");
	if (obj) {
		var t = "";
		t += '<img id="' + this.id + '_img" src="' + this.resourcesURL + this.imagesNameArr[this.displayedImageIndex++] + '" width="100%" height="100%" />';
		obj.innerHTML = t;
	}
}

componentSLWSlideShow.prototype.onShow = function()
{
	if (this.userTyping) this.typing = 'isTyping';
	this.displayedImageIndex = 0;
	this.tempChars = this.codesList;
	
	if (PageInterface.GetValue("state") == psDesigning || !this.userTyping){
		if (!this.keyboardSimulator)
		{
			this.setInnerHTML();
		}
	};
	
	if (this.displayedImageIndex < this.imagesNameArr.length && !this.userTyping && !this.startInterval){
		this.startInterval = true;
		var stepTime = 0;
		if (typeof(page.steps[page.stepIndex + 1]) == 'undefined') 
		{
			stepTime = this.intervalTime;
		}else{
			stepTime = page.steps[page.stepIndex + 1][0];
		}
		if (this.keyboardSimulator)
		{
			var slideShowTime = this.imagesNameArr.length * 100;
			if (slideShowTime > stepTime)
			{
				slideShowTime = stepTime;
			}
			var oneSlideTime = parseInt(slideShowTime / this.imagesNameArr.length);
			var startShowTime = stepTime - slideShowTime;
			this.intervalTime = oneSlideTime;
		} else {
			var startShowTime = stepTime;
		}
		this.TimerID = window.setTimeout('pc.' + this.id + '.invokeEvent("Interval");', startShowTime);
	};
	this.addListener();
};

componentSLWSlideShow.prototype.componentSLWSlideShowBaseShowObject = componentSLWSlideShow.prototype.show;
componentSLWSlideShow.prototype.show = function()
{
	this.componentSLWSlideShowBaseShowObject();
	
	var condition = true;
	/* //pg2-removed
	if (!this.endSequence && this.showHints && (eval(unescape(this.visibleIf) == true) || this.visibleIf == '')){
		this.timerID = window.setTimeout('pc.' + this.id + '.showTrainingFromApplicationHint();', this.hintTime); 
	}*/
	try {
		condition = (!this.endSequence && this.showHints && (eval(unescape(this.visibleIf) == true) || this.visibleIf == ''));
	} catch(e) {
		condition = true;
		if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.show() eval visibleIf execution error\nMessage:\n' + e.message); //pg2
	}
	if (condition) {
		this.timerID = window.setTimeout('pc.' + this.id + '.showTrainingFromApplicationHint();', this.hintTime); 
	}
};

componentSLWSlideShow.prototype.onInterval = function()
{
	this.setInnerHTML();
	
	if (this.displayedImageIndex < this.imagesNameArr.length){
		this.TimerID = window.setTimeout('pc.' + this.id + '.invokeEvent("Interval");', this.intervalTime);
	}else{	
		this.endSequence = true;
		this.hideHint();
		this.invokeEvent("EndSequence");
	};
};

componentSLWSlideShow.prototype.checkCorrectKeyPressed = function(key)
{
	if (key == this.keys[this.displayedImageIndex]) {
		this.setInnerHTML();

		if (this.displayedImageIndex >= this.keys.length) {
			this.endSequence = true;	
			this.typing = 'endTyping';
			this.hideHint();
			this.invokeEvent("EndSequence");
			//PageInterface.SetValue('setSLWTypingComponent', "");
			this.removeListener();
		}
	} else {
		if (this.howManyWrongKeyPressed == 0){
			if (this.onAfterFirstWrongKeyPress) this.onAfterFirstWrongKeyPress();
		}else if (this.howManyWrongKeyPressed == 1){
			if (this.onAfterSecondWrongKeyPress) this.onAfterSecondWrongKeyPress();
		};
		this.howManyWrongKeyPressed++;
	};
}

componentSLWSlideShow.prototype.hideHint = function() 
{
	if (this.anotherPopup == "-") {
		if (this.hintComp) this.hintComp.hide();
		if (this.hintTextComp) this.hintTextComp.hide();
	}else{
		var popup = PageInterface.GetValue("getChild", this.anotherPopup);
		popup.hide();
	};
}

componentSLWSlideShow.prototype.onFree = function() 
{
	this.removeListener();
	if (this.TimerID != null) 
		window.clearTimeout(this.TimerID);
	if (this.hintTimerID != null) 
		window.clearTimeout(this.hintTimerID);
};

componentSLWSlideShow.prototype.onKeyDown = function(e)
{
	var ev = (window.event) ? event : e;	
	var alt = (ev.altKey)?1:0;
	var shift = (ev.shiftKey)?1:0;
	var ctrl = (ev.ctrlKey)?1:0;
	var keyCode = ev.keyCode;
	
	if (is.moz && ev.keyCode == 109) keyCode = 189;
	var charTyping = keyCode+':'+alt+':'+shift;
	this.checkCorrectKeyPressed(charTyping);
}
