﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentRandomImage = function(name)
{
	//inherited
	this.__componentImage = __componentImage;
	this.__componentImage(name);

	this.orderNumber = 0;
	this.iTimerID = null;
};

componentRandomImage.prototype = new __componentImage();
componentRandomImage.prototype.type = "componentRandomImage";

componentRandomImage.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();

	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
	    this.resourcesURL = unescape(this.resourcesURL);

		this.imagesNameArr = this.randImages.split("||");
		this.getPreloadImagesArr();
	};
};

componentRandomImage.prototype.componentRandomImageBaseShow = componentRandomImage.prototype.show;
componentRandomImage.prototype.show = function()
{
	this.componentRandomImageBaseShow();
	if (this.enableTimeInterval) this.startTimer();
};

componentRandomImage.prototype.componentRandomImageBaseHide = componentRandomImage.prototype.hide;
componentRandomImage.prototype.hide = function()
{
	this.stopTimer();
	this.componentRandomImageBaseHide();
};

componentRandomImage.prototype.startTimer = function()
{
	this.stopTimer();
	if (this.iTimerID == null) {
		this.iTimerID = window.setTimeout('pc.' + this.id + '.invokeEvent("Interval");', this.time);
	};
};

componentRandomImage.prototype.stopTimer = function()
{
	if (this.iTimerID != null) {
		window.clearTimeout(this.iTimerID);
		this.iTimerID = null;
	};
};

componentRandomImage.prototype.nextImage = function()
{
	if (this.type == 1)	{
		var number = this.orderNumber;
		this.orderNumber++;
		if (this.orderNumber >= this.imagesNameArr.length) this.orderNumber = 0;
	} else {
		var number = Math.floor(Math.random() * this.imagesNameArr.length);	
	};

	this.setValue(resourcesURL + this.imagesNameArr[number]);
	var objImg = this.findContentObj();

	if (this.checkImgSize == 1) {
		var img = new Image();										
		img.src = resourcesURL + this.imagesNameArr[number];
		this.obj.style.width = img.width;
		this.obj.style.height = img.height;
		this.obj.style.clip = 'rect(0px '+img.width+'px '+img.height+'px 0px)';	
		objImg.width = img.width;
		objImg.height = img.height;
	} else {
		this.obj.style.width = this.w;
		this.obj.style.height = this.h;
		this.obj.style.clip = 'rect(0px '+this.w+'px '+this.h+'px 0px)';		
		objImg.width = this.w;
		objImg.height = this.h;
	};
	//this.startTimer();
};

componentRandomImage.prototype.onInterval = function()
{
	if (this.type == 1) {
		var number = this.orderNumber;
		this.orderNumber++;
		if (this.orderNumber >= this.imagesNameArr.length) this.orderNumber = 0;
	} else {
		var number = Math.floor(Math.random() * this.imagesNameArr.length);
	};

	this.setValue(resourcesURL + this.imagesNameArr[number]);
	var objImg = this.findContentObj();

	if (this.checkImgSize == 1) {
		var img = new Image();
		img.src = resourcesURL + this.imagesNameArr[number];
		this.obj.style.width = img.width;
		this.obj.style.height = img.height;
		this.obj.style.clip = 'rect(0px '+img.width+'px '+img.height+'px 0px)';
		objImg.width = img.width;
		objImg.height = img.height;
	} else {
		this.obj.style.width = this.w;
		this.obj.style.height = this.h;
		this.obj.style.clip = 'rect(0px '+this.w+'px '+this.h+'px 0px)';
		objImg.width = this.w;
		objImg.height = this.h;
	};

	this.startTimer();
};
