var ScormHelper;
(function (_ScormHelper) {
    var ScormHelper = (function () {
        function ScormHelper() {
            throw new Error("Cannot create new instance of this Class!");
        }
        ScormHelper.setExamCompleted = function (scoreMin, scoreMax, score) {
            console.log("ScoreMin " + scoreMin + " ScoreMax " + scoreMax + " score " + score + " score/scoremax " + score / scoreMax);
            if (this.openConnection()) {
                var sMin = pipwerks.SCORM.set("cmi.score.min", scoreMin);
                var sMax = pipwerks.SCORM.set("cmi.score.max", scoreMax);
                var sRaw = pipwerks.SCORM.set("cmi.score.raw", score * 10);
                var successStatus = pipwerks.SCORM.set("cmi.success_status", "passed");
                var sScaled = pipwerks.SCORM.set("cmi.score.scaled", String(score / scoreMax));
                var progressMeasure = pipwerks.SCORM.set("cmi.progress_measure", String(score / scoreMax));
                var completionStatus = pipwerks.SCORM.set("cmi.completion_status", "completed");
                if (sMin && sMax && sRaw && successStatus && completionStatus) {
                    if (pipwerks.SCORM.save()) {
                        pipwerks.SCORM.quit();
                        return;
                    }
                }
                else {
                    this.handleError("Error: Score couldn't be saved!");
                }
            }
            else {
                this.handleError("Error: Could not connect with LMS");
            }
            this.handleError("Error: Score couldn't be saved!");
            pipwerks.SCORM.quit();
        };
        ScormHelper.setWorkCardCompleted = function () {
            if (this.openConnection()) {
                var sMin = pipwerks.SCORM.set("cmi.score.min", "0");
                var sMax = pipwerks.SCORM.set("cmi.score.max", "100");
                var sRaw = pipwerks.SCORM.set("cmi.score.raw", "100");
                var successStatus = pipwerks.SCORM.set("cmi.success_status", "passed");
                var sScaled = pipwerks.SCORM.set("cmi.score.scaled", "1");
                var progressMeasure = pipwerks.SCORM.set("cmi.progress_measure", "1");
                var completionStatus = pipwerks.SCORM.set("cmi.completion_status", "completed");
                if (sMin && sMax && sRaw && successStatus && sScaled && progressMeasure && completionStatus) {
                    if (pipwerks.SCORM.save()) {
                        pipwerks.SCORM.quit();
                        return;
                    }
                }
                else {
                    this.handleError("Error: Score couldn't be saved!");
                }
            }
            else {
                this.handleError("Error: Could not connect with LMS!");
            }
            this.handleError("Error: Score couldn't be saved!");
            pipwerks.SCORM.quit();
        };
        ScormHelper.openConnection = function () {
            return this.isConnected = pipwerks.SCORM.init();
        };
        ScormHelper.handleError = function (msg) {
            var c = pipwerks.SCORM.debug.getCode();
            var desc = pipwerks.SCORM.debug.getInfo(c);
            console.error(desc);
            alert(msg);
        };
        ScormHelper.isConnected = false;
        return ScormHelper;
    })();
    _ScormHelper.ScormHelper = ScormHelper;
})(ScormHelper || (ScormHelper = {}));
//# sourceMappingURL=Scorm.js.map