﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
componentInput = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.isChanged = false;
	this.correctAnswer = "";
	this.correctAnswersList = new Array();
	this.interactions = true;
	this.interactionsType = "fill-in";

	this.hintRectangle = null;
	this.hintImage = null;
	this.hintTextAll = null;

	this.timerID = null;
	this.allowGF = true;

	this.hintTextFontFamily = "Arial";
	this.hintTextFontSize = 2;
	this.hintTextFontColor = "#000000";
	this.inputBgColor = "transparent";

	this.wasColored = false;
	this.fakeInputToRemoveFocus = 'fakeInputToRemoveFocus'; //pg2-remove focus from input

	this.internalCheckAnswer = false; //pg2-prevent from invoke 'onCorrect/Incorrect from page.js and from input.js ('cause actions will be invoked several times)
	this.emptyAnswerMarker = '[empty]'; //pg2-AKA -allow empty answer
	
	//pg2-BI_AF
	//this.invokeWrongAnswerEventCharsCount = 3;
	this.givenAnswer = '';
	//...
};

componentInput.prototype = new componentElement;
componentInput.prototype.type = "componentInput";

componentInput.prototype.onBaseCreate = function(obj)
{
	this.resourcesURL = unescape(this.resourcesURL); 
	this.captureMouseEvents();
};

componentInput.prototype.onCreate = function(obj)
{
	this.correctAnswersList = this.correctAnswer.split("||");

	var font = {};
	font.family = this.hintTextFontFamily;
	font.size = this.hintTextFontSize;
	font.color = this.hintTextFontColor;

	if (this.allowGF && project.globalFormating && isDefaultFont(font) && !isDefaultFont(project.font)) {
		this.hintTextFontFamily = project.font.family;
		this.hintTextFontSize = project.font.size;
		this.hintTextFontColor = project.font.color;
	};
	this._setHTMLDef(this.value);
};

componentInput.prototype._getStyleDef = function()
{
	var styleDef = "";
	if (this.inputBgColor == 'transparent' && (this.borderColor == 'transparent' || !this.borderColor)) {
		styleDef = "style='background-color:" + this.inputBgColor + "; border: 0px solid transparent;";
		styleDef += " font-family: " + this.fontFamily + "; font-size: " + getFontSize(this.fontSize, 'px') + "px;"; 
		styleDef += " color:" + this.fontColor + "; width:" + this.w + "px; "; 
		styleDef += " text-align:" + this.textAlign + "; ";
		styleDef += "font-decoration: " + (this.fontUnderline?"underline":"normal") + "; "; //pg2-PCEN
		styleDef += "font-style: " + (this.fontStyle?"italic":"normal") + "; ";
		styleDef += "font-weight: " + (this.fontWeight?"bold":"normal") + "; ";
		styleDef += "'";
	} else {
		var borderStyle = (this.borderColor != null ? ("border: 1px solid " + this.borderColor + ";") : "");
		styleDef = "style='background-color:" + this.inputBgColor + ";" + borderStyle + ";";
		styleDef += " font-family: " + this.fontFamily + "; font-size: " + getFontSize(this.fontSize, 'px') + "px;"; 
		styleDef += " color:" + this.fontColor + "; width:" + this.w + "px; "; 
		styleDef += " text-align:" + this.textAlign + "; ";
		styleDef += "font-decoration: " + (this.fontUnderline?"underline":"normal") + "; "; //pg2-PCEN
		styleDef += "font-style: " + (this.fontStyle?"italic":"normal") + "; ";
		styleDef += "font-weight: " + (this.fontWeight?"bold":"normal") + "; ";
		styleDef += "'";
	};
	return styleDef;
};

componentInput.prototype._setHTMLDef = function(valStr)
{
	// bgColor
	if (this.bgColor == null) this.bgColor = is.ns4 ? null : 'transparent';
	// borderColor
	if ((this.borderColor == null) || (this.borderColor == "null") || (this.borderColor == "" ) || (this.borderColor == 'transparent' )) this.borderColor = null;
	valStr = (valStr ? valStr : "");
	if (valStr == " ") valStr = "";

	var t = '<form name="' + this.id + 'Form" id="' + this.id + 'Form">';
	t += '<input dir="' + this.dir + '" id="' + this.id + '_contentObj" name="' + this.id + '_contentObj" type="' + this.fieldType + '" value="' + valStr + '" ';

	if (this.maxLength != -1) t += 'maxlength="' + this.maxLength + '" ';
	if (this.disabled == true) t += 'disabled ';

	if (is.ns4) {
		var cols;
		if (this.w == 0) cols = 0;
		else {
			if (this.w < 25) cols = 1;
			else cols = 1 + (parseInt((this.w - 18) / 8));
		};
		t += ' size="' + cols + '"';
	};

	t += this._getStyleDef();

	t += ' onfocus="pc.' + this.id + '.fnOnFocusIn();"';
	t += ' onblur="pc.' + this.id + '.fnOnFocusOut();"';
	t += ' onkeydown="pc.' + this.id + '.fnOnKeyDown();"';
	t += ' onkeypress="pc.' + this.id + '.fnOnKeyPress();"';
	t += ' onkeyup="pc.' + this.id + '.fnOnKeyUp();"';
	t += ' onchange="pc.' + this.id + '.fnOnChange();"';

	if (this.readonly) t += ' readonly />'; else t += '>';

	var answerArray = this.correctAnswer.split("||");
	for (var i=0; i < answerArray.length; i++) {
		t += '<p id="' + this.id + '_Text_' + i + '" style="font-family: ' + this.fontFamily + '; '; //pg2-nik -fontFamily instead of textFontFamily
		t += 'font-decoration: ' + (this.fontUnderline?'underline':'normal') + '; '; //pg2-PCEN
		t += 'font-style: ' + (this.fontStyle?'italic':'normal') + '; ';
		t += 'font-weight: ' + (this.fontWeight?'bold':'normal') + '; ';
		t += ' font-size: ' + this.fontSize + 'px; color: ' + this.correctAnswersColor + ';"></p>'; //pg2-nik -fontSize instead of textFontSize
	};
	t += '</form>';

	if (this.showHints && !this.hintShowInStep && (this.hintWidth == 0 || this.hintHeight == 0)) {
		t += '<div id="' + this.id + '_textSize" style="position:absolute; visibility:hidden; left:0px; top:0px; border: solid #000000 0px;"></div>';
	};

	this.setHTML(t);
	this.contentObj = this.findContentObj();

	if (this.fieldType == 'password') { //pg2-autocomplete off
		var obj = document.getElementById(this.id + 'Form');
		if (obj) {
			obj.autocomplete = 'off';
		};
	};
};

componentInput.prototype.componentInputBaseFnOnKeyUp = componentInput.prototype.fnOnKeyUp;
componentInput.prototype.fnOnKeyUp = function()
{
	this.componentInputBaseFnOnKeyUp();
	if (this.controlAnswer) {
		this.internalCheckAnswer = true; //pg2-if input checks its answer during typing, internal, 'OnCorrect/Incorrect will be invoked, otherwise only page->checkAnswer & invokeEvent will be executed
		this.checkElementAnswer();
		this.internalCheckAnswer = false; //pg2-
	};

	if (this.wasColored) {
		this.contentObj = this.findContentObj();
		if (this.contentObj) this.contentObj.style.background = this.inputBgColor;
	};
};

componentInput.prototype.onFocusIn = function()
{
	if (this.id == this.fakeInputToRemoveFocus) return; //pg2-remove focus from input
	page.lastFocusedInput = this;
};

componentInput.prototype.isNationalChar = function(keyCode)
{
	var plNationalChar = [281, 243, 261, 347, 322, 380, 378, 263, 324, 346, 262, 379, 377, 323, 321, 211, 280, 260];

	for (var i=0; i < plNationalChar.length; i++) {
		if (plNationalChar[i] == keyCode) return true;
	};
	return false;
};

componentInput.prototype.componentInputBaseFnOnKeyPress = componentInput.prototype.fnOnKeyPress;
componentInput.prototype.fnOnKeyPress = function()
{
	this.componentInputBaseFnOnKeyPress();
	var ev = (window.event) ? event : e;
	var keyCode = (ev.keyCode != 0)?ev.keyCode:ev.charCode;
	var keyCode = (ev.keyCode != 0)?ev.keyCode:ev.charCode;

	switch(this.fillChars) {
		case "full":
			ev.returnValue = true;
			break;
		case "letters":
			ev.returnValue = (keyCode >= 65 && keyCode <= 90) || 
								(keyCode >= 97 && keyCode <= 122) || 
								(keyCode == 95) || 
								this.isNationalChar(keyCode) || 
								(keyCode == 32) || (keyCode == 8); //pg2-allow backspace key
			break;
		case "numbers":
			ev.returnValue = (keyCode >= 48 && keyCode <= 57) || (keyCode == 8); //pg2-allow backspace key
			break;
	};
	var which = ev.keyCode?ev.keyCode:ev.which;
	if (which == 13) ev.returnValue = false;
};

componentInput.prototype.onPaint = function(obj)
{
	var w = this.w;
	var h = this.h;
	this.w = ( ( w == null ) ? this.w : ( w < 0 ? 0 : w ) );
	this.h = ( ( h == null ) ? this.h : ( h < 0 ? 0 : ( !is.ns4 ? h : 25 ) ) );

	if ((this.w == null) && (this.h == null)) {
	} else {
		if (this.style != null) {
			if (is.ns4) {
				this.style.clip.width = this.w;
				this.style.clip.height = this.h;
			} else {
				this.style.width = this.w;
				this.style.height = this.h;
				this.style.clip = 'rect(0px ' + (this.w || 0) + 'px ' + (this.h || 0) + 'px 0px)';
			};
		};
	};
	//this._setHTMLDef(this.getAnswer());
	this.onRepaint();
};

componentInput.prototype.__setMyColorInLinkElements = function(c)
{
	var a = this.linkElements.split(",");
	for (var s in a) {
		try {
			pc[a[s]].obj.style.backgroundColor = c;
		} catch(e) {};
	};
};

componentInput.prototype.onRepaint = function(obj)
{
	this.contentObj = this.findContentObj();

	if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) {
		var obj = document.getElementById(this.id + '_contentCAI');
		if (obj) obj.style.visibility = "inherit";
		if (!this.checkAnswer()) {
			if (this.mycolor) {
				var answerArray = this.correctAnswer.split("||");
				for (var i=0; i < answerArray.length; i++) {
					var text = document.getElementById(this.id + '_Text_' + i);
					if (text) text.innerHTML = answerArray[i];
				};
				this.bgColor = this.incorrectColor;
				this.inputBgColor = this.incorrectColor;
				this.borderColor = this.incorrectColor;
				this.paint();
			} else {
				var answerArray = this.correctAnswer.split("||");
				for (var i=0; i < answerArray.length; i++) {
					var text = document.getElementById(this.id + '_Text_' + i);
					if (text) text.innerHTML = answerArray[i];
				};
				if (this.contentObj) this.contentObj.style.background = this.incorrectColor;
			};
		} else {
			if (this.mycolor) {
				this.bgColor = this.correctColor;
				this.inputBgColor = this.correctColor;
				this.borderColor = this.correctColor;
				this.paint();
			} else {
				if (this.contentObj) this.contentObj.style.background = this.correctColor;
			};
		};
	};
};

componentInput.prototype.componentInputBaseUnselectable = componentInput.prototype.unselectable;
componentInput.prototype.unselectable = function()
{
	this.componentInputBaseUnselectable();
	var form = getForm(this.id + "Form");
	if (form) form[0].unselectable = "";
};

componentInput.prototype.componentInputBaseLock = componentInput.prototype.lock;
componentInput.prototype.lock = function()
{
	this.obj.focus(); //pg2-lxmd_test
	var form = getForm(this.id + "Form");
	if (form) valStr = form[0].disabled = true;

	if (this.showHints) { 
		if (this.hintRectangle != null) this.hintRectangle.hide();
		if (this.hintImage != null) this.hintImage.hide();
		if (this.hintTextAll != null) this.hintTextAll.hide();
		if (this.timerID != null) window.clearTimeout(this.timerID);
	};
	this.componentInputBaseLock();
};

componentInput.prototype.componentInputBaseUnLock = componentInput.prototype.unlock;
componentInput.prototype.unlock = function()
{
	var form = getForm(this.id + "Form");
	if (form) valStr = form[0].disabled = false;
	this.componentInputBaseUnLock();
};

//an action in Wbtexpres
componentInput.prototype.setReadOnly = function()
{
	var form = getForm(this.id + "Form");
	if (form) {
		this.readonly = true;
		this.paint();
	};
	return(true);
};

//an action in Wbtexpres
componentInput.prototype.setCursorInObject = function() 
{
	this.focus();
};

componentInput.prototype.focus = function() 
{
	this.obj.focus(); //pg2-lxmd_test
	var form = getForm(this.id + "Form");
	if (form && this.visible) {
		try {
			form[0].focus();
			form[0].value=form[0].value;
		} catch(e) {};
	};
	
	if (this.id == this.fakeInputToRemoveFocus) return; //pg2-remove focus from input
	page.lastFocusedInput = this; //pg2-remove focus from input
};

componentInput.prototype.checkIsFocused = function() 
{
	var form = getForm(this.id + "Form");
	return (form[0] == document.activeElement);
};

componentInput.prototype.removeCursorFromObject = function() //pg2-remove focus from input
{
	this.blur();
};

componentInput.prototype.blur = function() //pg2-remove focus from input
{
	var form = getForm(this.id + "Form");
	if (form && this.visible) {
		try {
			form[0].blur();
		} catch(e) {};
	};

	if (is.ie && this.id != this.fakeInputToRemoveFocus) {
		var fakeInputObj = pc[this.fakeInputToRemoveFocus];
		var fakeInputContentObj = document.getElementById(this.fakeInputToRemoveFocus + '_contentObj');
		if (fakeInputObj == null) {
			fakeInputObj = new componentInput(this.fakeInputToRemoveFocus);
			fakeInputObj.myParent = this; 
			fakeInputObj.x = 0;
			fakeInputObj.y = 0;
			fakeInputObj.w = 0;
			fakeInputObj.h = 0;
			fakeInputObj.ignoreAnswer = 1;
			fakeInputObj.interactions = false;
			fakeInputObj.hide();
			page.addChild(fakeInputObj);
		};
		fakeInputObj.show();
		fakeInputObj.focus();
		fakeInputObj.hide();
	};
};

componentInput.prototype.getValue = function()
{
	this.contentObj = this.findContentObj();
	if (this.contentObj) {
		if (this.ignoreWhiteChars && config.exportDetails != 'exam') { //pg2-in case of exam, answer is checked at lms side and there there is no such a function
			var userAnsArr = this.contentObj.value.split("");
			var i = 0;
			while (userAnsArr[i] == " " ) {
				userAnsArr[i++] = ""
			};
			i = userAnsArr.length-1;
			switch (userAnsArr[i]) {
				case ',' : userAnsArr[i--] = ""; break;
				case '.' : userAnsArr[i--] = ""; break;
				case ';' : userAnsArr[i--] = ""; break;
				case '?' : userAnsArr[i--] = ""; break;
			};
			while (userAnsArr[i] == " ") {
				userAnsArr[i--] = ""
			};
			var userAns = userAnsArr.join("");
			return userAns;
		} else {
			var valStr = this.contentObj.value;
			if (config && config.exportDetails == 'exam' && !this.caseSensitive) { //pg2-if !caseSensitive and exam- in case of correct answer it must be taken from corrAnsList- 'cause it is checked at lms side
				var tmpAns = valStr.toLowerCase();
				if (this.correctAnswersList.length > 0) {
					for (var i=0; i<this.correctAnswersList.length; i++) {
						var corrAnsNLowerCases = this.correctAnswersList[i].toLowerCase();
						if (corrAnsNLowerCases == tmpAns) {
							valStr = this.correctAnswersList[i];
							break;
						};
					};
				};
			};
			return valStr;
		};
	};
	return "";
};

componentInput.prototype.setValue = function(value)
{
	if (typeof(value) == "undefined" && value == null) return false;

	this.contentObj = this.findContentObj();
	if (this.contentObj) {
		this.contentObj.value = value;
		return true;
	};
	return false;
};

componentInput.prototype.componentInputBaseResetElement = componentInput.prototype.resetElement;
componentInput.prototype.resetElement = function()
{
	this.componentInputBaseResetElement();
	var form = getForm(this.id + "Form");
	if (form) form[0].value = '';

	this.contentObj = this.findContentObj();
	if (this.contentObj) this.contentObj.style.background = this.inputBgColor;
};

componentInput.prototype.getAnswer = function()
{
	return this.getValue();
};

componentInput.prototype.setAnswer = function(value, showCorrect)
{
	if (showCorrect == null || showCorrect == "undefined") showCorrect = true;
	if (showCorrect && (this.isChanged && this.isCorrectAnswer(this.getAnswer()))) return;
	//if (this.startupValue != '' && value == '') value = this.startupValue;

	if (value.indexOf('||') > -1) {
		var arrAns = value.split('||');
		value = arrAns[0];
	};

	if (value == this.emptyAnswerMarker) value = ''; //if (value == 'empty') value = ''; //pg2-AKA -allow empty answer -restore feature
	this.setValue(value);
	this.onRepaint();
	return value;
};

componentInput.prototype.getCorrectAnswer = function()
{
	var a = this.correctAnswer.split('||');
	return (a.length > 0) ? a[0] : "";
};

componentInput.prototype.isCorrectAnswer = function(v)
{
	var isCorrect = false;
	var atd = this.correctAnswer.split('||');

	for (var i = 0; i < atd.length; i++) {
		if (v == atd[i]) {
			isCorrect = true;
			break;
		};
	};
	return(isCorrect);
};

componentInput.prototype.setAnswersProps = function(doAnswers, answers)
{
	this.setDoCheckAnswers(doAnswers);
	this.setAnswers(answers);
};

componentInput.prototype.setDoCheckAnswers = function(doAnswers)
{
	this.doCheckAnswers = doAnswers;
};

componentInput.prototype.splitAnswer = function(s)
{
	var ans = new Array();

	if (s.charAt(0) == '"') s = s.substr(1, s.length);
	if (s.charAt(s.length-1) == '"') s = s.substr(0, s.length-1);
	ans = s.split('||');

	for(var i=0; i < ans.length; i++) {
		ans[i] = ans[i].replace(new RegExp('#&034', "g"), '"');
	};
	return(ans);
};

componentInput.prototype.checkAnswer = function()
{
	var ans = this.parseCheckAnswer();

	//if (this.internalCheckAnswer) { //pg2-if input checks its answer during typing, internal, 'OnCorrect/Incorrect will be invoked, otherwise only page->checkAnswer & invokeEvent will be executed //pg2-axa -removed, invoke event each time, react on keyboard- distinguished in proper event method handler
		if (ans) {
			this.inputFixKeyControl = false;
			this.invokeEvent("CorrectAnswer");
			this.inputFixKeyControl = true;
		} else {
			//pg2-BI_AF
			if (this.internalCheckAnswer) {
				if (this.invokeWrongAnswerEventCharsCount <= 0) this.invokeEvent("IncorrectAnswer"); else
				if (this.givenAnswer.length >= this.invokeWrongAnswerEventCharsCount) this.invokeEvent("IncorrectAnswer");
			} else
			this.invokeEvent("IncorrectAnswer"); //pg2-BI_AF -default
		};
	//};
	return ans;
};

componentInput.prototype.parseCheckAnswer = function()
{
	var splitStr = "||";
	var actAnswer = this.getAnswer().toString();
	var ans = "";
	var arrCorrAns = new Array();
	
	//pg2-pcen -in 'getValue()' there is checking and parsing to remove white chars, but in next step- it is compared with correct answers which hasn't been devoided of them
	var raw_correctAnswer = this.correctAnswer;
	
	if (this.ignoreWhiteChars && config.exportDetails != 'exam') {
		var userAnsArr = raw_correctAnswer.split("");
		var i = 0;
		while (userAnsArr[i] == " " ) {
			userAnsArr[i++] = "";
		};
		i = userAnsArr.length-1;
		switch (userAnsArr[i]) {
			case ',' : userAnsArr[i--] = ""; break;
			case '.' : userAnsArr[i--] = ""; break;
			case ';' : userAnsArr[i--] = ""; break;
			case '?' : userAnsArr[i--] = ""; break;
		};
		while (userAnsArr[i] == " ") {
			userAnsArr[i--] = "";
		};
		raw_correctAnswer = userAnsArr.join("");
	};
	//...
	
	arrCorrAns = unquotedString(raw_correctAnswer).split(splitStr); //pg2-pcen -raw_correctAnswer instead of this.correctAnswer

	if (!this.caseSensitive) actAnswer = actAnswer.toLowerCase();

	for (var i = 0; i < arrCorrAns.length; i++) {
		ans = (this.caseSensitive) ? arrCorrAns[i]:arrCorrAns[i].toLowerCase();
		this.contentObj = this.findContentObj();
		if (this.ignoreWhiteChars && ans.substring(ans.length-1, ans.length) == '.') actAnswer += '.';

		if (this.invokeWrongAnswerEventCharsCount != 0) this.givenAnswer = actAnswer; //pg2-BI_AF
		
		if ((actAnswer == ans) || (ans == this.emptyAnswerMarker && actAnswer == '')) { //pg2-AKA -allow empty answer -restore feature//(ans == 'empty' && actAnswer == '')) {
			if (this.showAnswerIndicatorAnyTime) {
				if (this.contentObj) {
					this.contentObj.style.background = this.correctColor;
					this.wasColored = true;
				};
			};
			return true;
		} else {
			if (this.showAnswerIndicatorAnyTime) {
				if (this.contentObj) {
					this.contentObj.style.background = this.incorrectColor;
					this.wasColored = true;
				};
			};
		};
	};
	return (false);
};

componentInput.prototype.clearValue = function() 
{
	var form = getForm(this.id + "Form");
	if (form) form[0].value = "";
};

componentInput.prototype.onClear = function() 
{
	if (!this.locked && !this.checkAnswer()) this.clearValue();
};

componentInput.prototype.checkElementAnswer = function()
{
	this.checkAnswer(); 
	/*if (this.checkAnswer()) { //pg2-removed, the same is in method 'checkAnswer', so is invoked twice...
		this.inputFixKeyControl = false;
		this.invokeEvent("CorrectAnswer");
		this.inputFixKeyControl = true;
	} else {
		this.invokeEvent("IncorrectAnswer");
	}*/
};

//get text dimensions
componentInput.prototype.getFontDimensions = function(sContent, sFont, sFontSize)
{
	if (!sFont) sFont = "";
	if (!sFontSize) sFontSize = "1";

	switch (sFontSize) {
		case "1": sFontSize = "8pt"; break;
		case "2": sFontSize = "10pt"; break;
		case "3": sFontSize = "12pt"; break;
		case "4": sFontSize = "14pt"; break;
		case "5": sFontSize = "18pt"; break;
		case "6": sFontSize = "24pt"; break;
		case "7": sFontSize = "36pt"; break;
	};

	var elem = document.getElementById(this.id + "_textSize");
	elem.style.fontFamily = sFont;
	elem.style.fontSize = sFontSize;
	elem.innerHTML = sContent;
	return { width:elem.offsetWidth, height:elem.offsetHeight };
};

componentInput.prototype.showTrainingFromApplicationHint = function()
{
	var hintRectangleWidth = this.hintWidth;
	var hintRectangleHeight = this.hintHeight;

	if (!this.visible) return;

	if (this.hintWidth == 0 || this.hintHeight == 0) {
		var textSize = this.getFontDimensions(this.hintText, this.hintTextFontFamily, this.hintTextFontSize);
		hintRectangleWidth = textSize.width + (parseInt(this.hintBorderWidth)*2);
		hintRectangleHeight = textSize.height + (parseInt(this.hintBorderWidth)*2)+5;
	};
	switch (this.hintPosition) {
		case "nw":
			var imageX = this.x - this.hintImageWidth;
			var imageY = this.y - this.hintImageHeight;
			var rectangleX = imageX - hintRectangleWidth;
			var rectangleY = imageY - hintRectangleHeight;
			var src = this.hintImageSrcUpLeft;
			break;
		case "ne":
			var imageX = this.x + this.w;
			var imageY = this.y - this.hintImageHeight;
			var rectangleX = imageX + this.hintImageWidth;
			var rectangleY = imageY - hintRectangleHeight;
			var src = this.hintImageSrcUpRight;
			break;
		case "se":
			var imageX = this.x + this.w;
			var imageY = this.y + this.h;
			var rectangleX = imageX + this.hintImageWidth;
			var rectangleY = imageY + this.hintImageHeight;
			var src = this.hintImageSrcDownLeft;
			break;
		case "sw":
			var imageX = this.x - this.hintImageWidth;
			var imageY = this.y + this.h;
			var rectangleX = imageX - hintRectangleWidth;
			var rectangleY = imageY + this.hintImageHeight;
			var src = this.hintImageSrcDownRight;
			break;
	};

	if (this.anotherPopup == "-") {
		var newObj = PageInterface.Execute("createChild", "componentRectangle", this.id + "_hintRectangle");
		this.hintRectangle = PageInterface.Execute("addChild", newObj);
		if (this.hintRectangle) {
			this.hintRectangle.x = rectangleX;
			this.hintRectangle.y = rectangleY;
			this.hintRectangle.w = hintRectangleWidth;
			this.hintRectangle.h = hintRectangleHeight;
			this.hintRectangle.cursor = "default";
			this.hintRectangle.bgColor = this.hintBGColor;
			this.hintRectangle.borderColor = this.hintBorderColor;
			this.hintRectangle.borderWidth = this.hintBorderWidth;
			this.hintRectangle.step = 0;
			this.hintRectangle.contentMode = 0;
			this.hintRectangle.visibleIf = "";
			this.hintRectangle.stayOnTop = false;
			this.hintRectangle.alphaOpacity = "100";
			this.hintRectangle.layer = 1;
			this.hintRectangle.automaticHideTimerInterval = 0;
	        this.hintRectangle.setBorder(this.hintRectangle.borderColor, this.hintRectangle.borderWidth);
			this.hintRectangle.show();
			page.setOnTop(this.hintRectangle);
		};
	};

	var newObj = PageInterface.Execute("createChild", "componentImage", this.id + "_hintArrow");
	this.hintImage = PageInterface.Execute("addChild", newObj);
	if (this.hintImage) {
		this.hintImage.x = imageX;
		this.hintImage.y = imageY;
		this.hintImage.w = this.hintImageWidth;
		this.hintImage.h = this.hintImageHeight;
		this.hintImage.cursor = "default";
		this.hintImage.src = src;
		this.hintImage.cursor = "default";
		this.hintImage.borderColor = "transparent";
		this.hintImage.borderWidth = 0;
		this.hintImage.step = 0;
		this.hintImage.visibleIf = "";
		this.hintImage.infoText = "Put an image here";
		this.hintImage.contentMode = 0;
		this.hintImage.stayOnTop = false;
		this.hintImage.alphaOpacity = "100";
		this.hintImage.altHint = "";
		this.hintImage.layer = 1;
		this.hintImage.disableOnlineOfflineMix = false;
		this.hintImage.automaticHideTimerInterval = 0;
	    this.hintImage.setBorder(this.hintImage.borderColor, this.hintImage.borderWidth);
		this.hintImage.p_checkMarkers = this.p_checkMarkers;
		this.hintImage.p_checkPNG = this.p_checkPNG;
		this.hintImage.pngFix = this.pngFix;
		this.hintImage.show();
		page.setOnTop(this.hintImage);
	};

	if (this.anotherPopup == "-") {
		var newObj = PageInterface.Execute("createChild", "componentText", this.id + "_hintText");
		this.hintTextAll = PageInterface.Execute("addChild", newObj);
		if (this.hintTextAll) {
			this.hintTextAll.x = rectangleX;
			this.hintTextAll.y = rectangleY;
			this.hintTextAll.w = hintRectangleWidth + (this.hintBorderWidth*2);
			this.hintTextAll.h = hintRectangleHeight + (this.hintBorderWidth*2);
			this.hintTextAll.align = this.hintTextAlign;
			this.hintTextAll.valign = this.hintTextValign;
			this.hintTextAll.font.family = this.hintTextFontFamily;
			this.hintTextAll.font.size = this.hintTextFontSize;
			this.hintTextAll.font.color = this.hintTextFontColor; 
			this.hintTextAll.bgColor = this.hintTextBgColor;
			this.hintTextAll.wrap = this.hintTextWrap;
			this.hintTextAll.padding = this.hintRectangle.borderWidth+2;
			this.hintTextAll.text = this.hintText.replace("[CORRECT_ANSWER]", this.correctAnswer.split("||")[0]);
			this.hintTextAll.lineHeight = this.lineHeight;
			this.hintTextAll.cursor = "default";
			this.hintTextAll.borderColor = "transparent";
			this.hintTextAll.borderWidth = 0;
			this.hintTextAll.step = 0;
			this.hintTextAll.visibleIf = "";
			this.hintTextAll.contentMode = 0;
			this.hintTextAll.stayOnTop = false;
			this.hintTextAll.alphaOpacity = "100";
			this.hintTextAll.altHint = "";
			this.hintTextAll.layer = 1;
			this.hintTextAll.disableOnlineOfflineMix = false;
			this.hintTextAll.automaticHideTimerInterval = 0;
			this.hintTextAll.allowGF = this.allowGF;
			this.hintTextAll.p_checkMarkers = this.p_checkMarkers;
			this.hintTextAll.p_checkPNG = this.p_checkPNG;
			this.hintTextAll.pngFix = this.pngFix;
			this.hintTextAll.show();
			page.setOnTop(this.hintTextAll);
		};
	} else {
		var popup = PageInterface.GetValue("getChild", this.anotherPopup);
		if (popup) {
			popup.invokedFromDetectComponent = true; //pg2- do not repaint twice and overwrite text to standard one defined for (and within) popup component - just as in detect components
			if (popup.execution) {
				var popupContent = popup.findContentObj();
				popupContent.innerHTML = this.hintText.replace("[CORRECT_ANSWER]", this.correctAnswer.split("||")[0]);
			} else {
				popup.text.text = this.hintText.replace("[CORRECT_ANSWER]", this.correctAnswer.split("||")[0]);
			};
			if (popup.visible) popup.paint();
			else popup.show();
		};
	};
};

componentInput.prototype.componentInputBaseShowObject = componentInput.prototype.show;
componentInput.prototype.show = function()
{
	this.componentInputBaseShowObject();
	
	if (this.startupValue != '' &&
		(!this.locked || page.pageStatus == 'completed' || page.pageStatus == 'incomplete') //pg2-axa_awo -set default value for simulation pages
		&& this.getValue() == '') this.setValue(this.startupValue); //pg2-default value of input (on its startup)
	
	if (this.showHints && !this.hintShowInStep) {
		if (this.timerID != null) window.clearTimeout(this.timerID);
		var condition = true;
		try {
			condition = ((eval(unescape(this.visibleIf)) == true) || (this.visibleIf == ''));
		} catch(e) {
			condition = true;
			if (typeof(page) != "undefined" && page.state == psView) alert(this.id + '.show() eval execution error\nMessage:\n' + e.message);
		};
		if (condition) {
			this.timerID = window.setTimeout('pc.' + this.id + '.showTrainingFromApplicationHint();', this.hintTime);
		};
	};
	//if (page.stepFirstInputFocus == null) { //pg2-removed //pg2-remove focus from input
		if (!config.FocusManegementForSynthesizer && !this.doNotSetFocusInOnShow && !this.locked) { //pg2-lxmd_test
			//this.setCursorInObject();
			//this.obj.focus();
			window.setTimeout('pc.' + this.id + '.focus();', 200);
		};
		//page.stepFirstInputFocus = this; //pg2-removed
	//}
};

componentInput.prototype.componentInputBaseHideObject = componentInput.prototype.hide;
componentInput.prototype.hide = function()
{
	// var content = this.findContentObj();
	// if (document.activeElement == content) {
		// this.obj.focus();
	// }
	this.componentInputBaseHideObject();

	if (this.showHints) { 
		if (this.hintRectangle != null) this.hintRectangle.hide();
		if (this.hintImage != null) this.hintImage.hide();
		if (this.hintTextAll != null) this.hintTextAll.hide();
		if (this.anotherPopup != '-') {
			var popup = PageInterface.GetValue("getChild", this.anotherPopup);
			if (popup) popup.hide();
		};
		if (this.timerID != null) window.clearTimeout(this.timerID);
		this.timerID = null;
	};
};

componentInput.prototype.onFree = function()
{
	if (this.timerID != null) window.clearTimeout(this.timerID);
};

componentInput.prototype.interactionsCorrectResponsesCount = function()
{
	return this.correctAnswersList.length;
};

componentInput.prototype.interactionsCorrectResponses = function(index)
{
	return this.correctAnswersList[index];
};

componentInput.prototype.interactionsStudentResponse = function()
{
	return this.getAnswer();
};

componentInput.prototype.interactionsCorrectResponsesAsText = function(index)
{
	return escape(this.interactionsCorrectResponses(index)); //pg2-escape
};

componentInput.prototype.interactionsStudentResponseAsText = function()
{
	return escape(this.interactionsStudentResponse()); //pg2-escape
};

componentInput.prototype.showHint = function(e)
{
	this.showTrainingFromApplicationHint(e);
};
