﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
componentExerciseHotspot = function(name)
{
	this.__componentImage = __componentImage;
	this.__componentImage(name);

	this.howManyClicks = 0;
	this.isLocked = false;

	this.allowsCountPoints = false;
	this.iTimerID == null;

	this.interactions = true;
	this.interactionsType = "true_false";
};

componentExerciseHotspot.prototype = new __componentImage();
componentExerciseHotspot.prototype.type = "componentExerciseHotspot";

componentExerciseHotspot.prototype.onCreate = function(obj)
{
	this.captureMouseEvents();

	//if page is SLW exercise check page is in other way
	//PageInterface.SetValue("setSLWSimulation", true); //pg2-removed - we can not assume that page is recorded in SLW
};

componentExerciseHotspot.prototype.componentExerciseHotspotBaseOnMouseDown = componentExerciseHotspot.prototype.onMouseDown;
componentExerciseHotspot.prototype.onMouseDown = function()
{
	if (this.isLocked || !this.allowsCountPoints) return;
	this.howManyClicks++;

	if (this.howManyClicks > this.maxClicks ) {
		this.warningComponentHide();
		PageInterface.Execute("checkAnswer", this);
	} else {
		var popup = PageInterface.GetValue("getChild", this.warningComponent);
		if (popup) {
			if (popup.execution){
				var popupContent = popup.findContentObj();
				popupContent.innerHTML = popup.textText.replace("[number]", this.howManyClicks); //popup.text.replace("[number]", this.howManyClicks); //pg2-axa_af -.text doesn't exist
			};
			popup.show();
		};
	};
	this.componentExerciseHotspotBaseOnMouseDown();
};

componentExerciseHotspot.prototype.warningComponentHide = function()
{
	var popup = PageInterface.GetValue("getChild", this.warningComponent);
	if (popup) popup.hide();
};

componentExerciseHotspot.prototype.onStep = function()
{
	this.warningComponentHide();
};

componentExerciseHotspot.prototype.onRepaint = function()
{
	var pageStatus = PageInterface.GetValue("getPageStatus");
	if (pageStatus != 'passed') {
		if (this.coverElem != '-' && page.all[this.coverElem]) {
			page.all[this.coverElem].show();
		};
	};
};

componentExerciseHotspot.prototype.actionAfterTime = function(obj)
{
	this.allowsCountPoints = true;
	if (this.hideElem != '-' && page.all[this.hideElem]){
		switch (this.hideElemAction){
			case 'show' : page.all[this.hideElem].show(); break; 
			case 'hide' : page.all[this.hideElem].hide(); break; 
		};
	};
};

componentExerciseHotspot.prototype.componentExerciseHotspotBaseShow = componentExerciseHotspot.prototype.show;
componentExerciseHotspot.prototype.show = function()
{
	this.iTimerID = window.setTimeout('pc.'+this.id+'.actionAfterTime();', this.timeToCount);
	this.componentExerciseHotspotBaseShow();
};

componentExerciseHotspot.prototype.stopTimer = function() 
{
	if (this.iTimerID != null) {
		window.clearTimeout(this.iTimerID);
		this.iTimerID = null;
	};
};

componentExerciseHotspot.prototype.checkAnswer = function() 
{
	return(this.parseCheckAnswer());
};

componentExerciseHotspot.prototype.parseCheckAnswer = function() 
{
	/* //pg2-remove entire block
	var userScore = PageInterface.GetValue("userScore");
	var masteryScore = PageInterface.GetValue("masteryScore");
	var maxScore = PageInterface.GetValue("maxScore");
	var answerWeighting = PageInterface.GetValue("answerWeighting");
	var corAns = (answerWeighting) ? (userScore >= masteryScore) : (userScore == maxScore);*/

	var corAns = (this.howManyClicks <= this.maxClicks); //pg2-new

	if (corAns) {
		return true;
	} else {
		return false;
	};
};

componentExerciseHotspot.prototype.componentExerciseHotspotBaseResetElement = componentExerciseHotspot.prototype.resetElement;
componentExerciseHotspot.prototype.resetElement = function()
{
	this.componentExerciseHotspotBaseResetElement();
	this.stopTimer();
}

componentExerciseHotspot.prototype.getAnswer = function() 
{
	return this.howManyClicks;
};

componentExerciseHotspot.prototype.setAnswer = function(v, showCorr) 
{
	this.howManyClicks = 0;
};

componentExerciseHotspot.prototype.interactionsCorrectResponsesCount = function()
{
	return this.maxClicks+1;
};

componentExerciseHotspot.prototype.interactionsCorrectResponses = function(index)
{
	return index;
};

componentExerciseHotspot.prototype.interactionsCorrectResponsesAsText = function(index)
{
	return index.toString();
};

componentExerciseHotspot.prototype.interactionsStudentResponse = function()
{
	if (this.howManyClicks > this.maxClicks ) {
		return this.howManyClicks;
	} else {
		return 0;
	};
};

componentExerciseHotspot.prototype.interactionsStudentResponseAsText = function()
{
	return this.interactionsStudentResponse().toString();
};

componentExerciseHotspot.prototype.resetComponentPoints = function()
{
	this.howManyClicks = 0;
};

componentExerciseHotspot.prototype.lock = function()
{
	this.isLocked = true;
};

componentExerciseHotspot.prototype.unlock = function()
{
	this.isLocked = false;
};

componentExerciseHotspot.prototype.onFree = function() 
{
	this.stopTimer();
};
