﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentFlashAudioPlayer = function(name)
{
	//inherited
	this.componentFlash = componentFlash;
	this.componentFlash(name);
	this.resourcesStatus = "online";
	this.resourcesURL = "";
	this.showScrollbars = false;
	this.showAndStop = false;
	this.mediaStatus = "online";

	this.timer = null;
	this.allowNextStep = true;
	this.isPlaying = false;
};

componentFlashAudioPlayer.prototype = new componentFlash;
componentFlashAudioPlayer.prototype.type = "componentFlashAudioPlayer";

componentFlashAudioPlayer.prototype.onBaseCreate = function(obj)
{
	this.disableOnlineOfflineMix = true; //pg2- flash CAN'T be load from other domain than course
	this.mediaStatus = (lms) ? lms.mediaStatus() : 'online';

	this.resourcesURL = resourcesURL;
	this.captureMouseEvents();
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
	};
    this.resourcesURL = unescape(this.resourcesURL);
};

componentFlashAudioPlayer.prototype.onCreate = function(obj)
{
	if (!this.showPlayerButtons && PageInterface.GetValue("state") != psDesigning){
		this.movieWidth = 1;
		this.movieHeight = 1;
		this.w = 1;
		this.h = 1;
		this.setSize(this.w, this.h);
	};
};

componentFlashAudioPlayer.prototype.isStopped = function()
{
	var res = false;
	var obj = this.getFlashMovieObject(this.id + "flashPlayer");
	if (obj) {
		try {
			res = !(obj.IsPlaying());
		} catch(e){};
	};
	return res;
};

componentFlashAudioPlayer.prototype.prepareNextStep = function()
{
	var flashPlayer = document.getElementById(this.id + "flashPlayer");
	if (flashPlayer) {
		if (this.isStopped()) {
			this.isPlaying = false;
			this.allowNextStep = true;
			this.killTimer();
			if (!this.showPlayerButtons) this.hide();
		} else {
			this.isPlaying = true;
			this.timer = window.setTimeout('var o=pc.' + this.id + '; if(o) {o.prepareNextStep();}', 200);
		};
	};
	this.mediaStatus = (lms) ? lms.mediaStatus() : 'online';
	if (this.mediaStatus == "off" || this.mediaStatus == "textOnly") {
		this.isPlaying = false;
		this.allowNextStep = true;
		this.killTimer();
		if (!this.showPlayerButtons) this.hide();
	};
};

componentFlashAudioPlayer.prototype.killTimer = function()
{
	if (this.timer) {
		window.clearTimeout(this.timer);
		this.timer = null;
	};
};

componentFlashAudioPlayer.prototype.componentFlashAudioPlayerBaseShow = componentFlashAudioPlayer.prototype.show;
componentFlashAudioPlayer.prototype.show = function(obj)
{
	this.mediaStatus = (lms) ? lms.mediaStatus() : 'online';
	if (this.mediaStatus == "off" || this.mediaStatus == "textOnly") { //pg2-audioOnOff_new - if mediaStatus is 'textOnly', do not play audio too...
		this.allowNextStep = true;
		return false;
	};

	if (this.showPlayerButtons){
		this.flashVars = "autoStart=false";
		this.componentFlashAudioPlayerBaseShow();
	} else {
		if (PageInterface.GetValue("state") == psDesigning){
			var t = '<img src="'+ this.resourcesURL + this.iconSrc +'" />';
			this.setHTML(t);
		} else {
			this.flashVars = "autoStart=true";

			this.componentFlashAudioPlayerBaseShow();
			this.isPlaying = true;
		};
	};
	if (this.nextStepWaitToEnd) {
		this.allowNextStep = false;
		this.prepareNextStep();
	};
};

componentFlashAudioPlayer.prototype.componentFlashAudioPlayerHide = componentFlashAudioPlayer.prototype.hide;
componentFlashAudioPlayer.prototype.hide = function(obj)
{
	this.actionFlashStop();
	this.componentFlashAudioPlayerHide();
}

componentFlashAudioPlayer.prototype.actionFlashStop  = function(obj)
{
	var obj = this.getFlashMovieObject(this.id + "flashPlayer");
	if (obj) {
		try {
			obj.StopPlay();
		} catch(e){};
	};
	this.stop();
};

componentFlashAudioPlayer.prototype.actionFlashPlay = function(obj)
{
	this.mediaStatus = (lms) ? lms.mediaStatus() : 'online';
	if (this.mediaStatus == "off" || this.mediaStatus == "textOnly") { //pg2-audioOnOff_new - if mediaStatus is 'textOnly', do not play audio too...
		this.allowNextStep = true;
		return false;
	};
	this.show();

	this.isPlaying = true;
	this.allowNextStep = false;
	this.prepareNextStep();
};

componentFlashAudioPlayer.prototype.stop = function(obj)
{
	if (!this.showPlayerButtons){
		this.flashVars = "";
		this.setHTML('');
	};
	this.isPlaying = false;
	this.allowNextStep = true;
	this.killTimer();
};

componentFlashAudioPlayer.prototype.stepStop = function()
{
	this.hide();
	this.stop();
};
