var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var ClickAndWrite;
(function (_ClickAndWrite) {
    var ClickAndWrite = (function (_super) {
        __extends(ClickAndWrite, _super);
        function ClickAndWrite(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        ClickAndWrite.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        ClickAndWrite.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        ClickAndWrite.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            EU.createStaticElements(this);
            this.createClickableElements();
        };
        ClickAndWrite.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        ClickAndWrite.prototype.createClickableElements = function () {
            for (var i = 0; i < this.Elements.ClickableElements.length; i++) {
                var el = this.game.add.text(0, 0, this.Elements.ClickableElements[i].text, this.Elements.Options.Style);
                el.name = i.toString();
                var posX = this.Elements.ClickableElements[i].pos.x;
                var posY = this.Elements.ClickableElements[i].pos.y;
                el.position.set(posX + this.getJustedPositionX(this.Elements.Options.Just.x, el), posY + this.getJustedPositionY(this.Elements.Options.Just.y, el));
                el.inputEnabled = true;
                el.events.onInputDown.add(this.onInputDown, this);
                this.addChild(el);
            }
        };
        ClickAndWrite.prototype.getJustedPositionX = function (just, element) {
            var posX = 0;
            switch (just) {
                case "center":
                    posX += (Global.Main.mainContainerDims.wd - 120) / 2 - element.width / 2;
                    break;
                case "right":
                    posX += Global.Main.mainContainerDims.wd - 120 - element.width;
                    break;
            }
            return posX;
        };
        ClickAndWrite.prototype.getJustedPositionY = function (just, element) {
            var posY = 0;
            switch (just) {
                case "center":
                    posY += (Global.Main.mainContainerDims.hg - 65) / 2 - element.height / 2;
                    break;
                case "bottom":
                    posY += Global.Main.mainContainerDims.hg - 65 - element.height;
                    break;
            }
            return posY;
        };
        ClickAndWrite.prototype.onInputDown = function (el, pointer) {
            var BoxSize = 8 / 5 * this.Elements.FillElements.Options.CharacterSize;
            var LetterAmountmultipler = 70 * (this.Elements.FillElements.Options.MaxCharacters / 2);
            var inputBoxStyle = { "font": null, "fill": "black" };
            inputBoxStyle.font = "normal " + this.Elements.FillElements.Options.CharacterSize + "pt Arial";
            var bmd = this.game.add.bitmapData(LetterAmountmultipler, BoxSize);
            bmd.ctx.rect(0, 0, LetterAmountmultipler, BoxSize);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();
            EU.createOneFillElement(parseInt(el.name), bmd, LetterAmountmultipler, inputBoxStyle, this);
            el.visible = false;
        };
        ClickAndWrite.prototype.checkIfEverythingIsCorrect = function () {
            if (EU.checkIfFillsAreCorrect(this)) {
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        };
        ClickAndWrite.prototype.calculateMaxPoints = function () {
        };
        ClickAndWrite.prototype.calculatePlayerPoints = function () {
        };
        return ClickAndWrite;
    })(Base.BasicGroup);
    _ClickAndWrite.ClickAndWrite = ClickAndWrite;
})(ClickAndWrite || (ClickAndWrite = {}));
//# sourceMappingURL=ClickAndWrite.js.map