var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Animation;
(function (_Animation) {
    var Animation = (function (_super) {
        __extends(Animation, _super);
        function Animation(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Animation.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.loadSpriteSheets();
            this.game.load.start();
        };
        Animation.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Animation.prototype.loadSpriteSheets = function () {
            for (var i = 0; i < this.Elements.SpriteSheets.length; i++)
                this.game.load.spritesheet(this.PREFIX + this.Elements.SpriteSheets[i].key, this.Elements.SpriteSheets[i].src, this.Elements.SpriteSheets[i].width, this.Elements.SpriteSheets[i].height);
        };
        Animation.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            EU.setGameCompletion(this.parent, 1);
            this.createAnimations();
        };
        Animation.prototype.createAnimations = function () {
            for (var i = 0; i < this.Elements.Animations.length; i++) {
                var el = this.game.add.sprite(this.Elements.Animations[i].pos.x, this.Elements.Animations[i].pos.y, this.PREFIX + this.Elements.Animations[i].key);
                this.addChild(el);
                el.animations.add("all");
                el.inputEnabled = true;
                el.events.onInputDown.add(this.Play, this);
            }
        };
        Animation.prototype.Play = function (el, pointer) {
            el.animations.play("all", 10, true);
        };
        Animation.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Animation.prototype.checkIfEverythingIsCorrect = function () {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this) && EU.checkIfFillsAreCorrect(this))
                EU.Log("Correct!!!");
        };
        return Animation;
    })(Base.BasicGroup);
    _Animation.Animation = Animation;
})(Animation || (Animation = {}));
//# sourceMappingURL=Animation.js.map