var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var FillShuffle;
(function (_FillShuffle) {
    var FillShuffle = (function (_super) {
        __extends(FillShuffle, _super);
        function FillShuffle(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        FillShuffle.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.Prefix;
            this.loadGraphics();
            this.game.load.start();
        };
        FillShuffle.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        FillShuffle.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        FillShuffle.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            EU.createStaticElements(this);
            this.createButtons();
            EU.createSelectableElements(this);
            EU.createFillElements(this);
        };
        FillShuffle.prototype.createButtons = function () {
            var el = this.game.add.text(725, 670, "CHECK", { font: "60px Arial", fill: 'blue', });
            el.setShadow(5, 5, "lightblue");
            el.inputEnabled = true;
            el.events.onInputDown.add(this.check, this);
            this.addChild(el);
        };
        FillShuffle.prototype.check = function () {
            if (this.Elements.FillElements) {
                EU.killKeyboard();
                EU.setGameCompletion(this.parent, 0);
                var allcompleted = true;
                for (var i = 0; i < this.Elements.FillElements.el.length; i++) {
                    if (!this.Elements.FillElements.el[i].name || this.Elements.FillElements.el[i].name.text != this.Elements.FillElements.el[i].Answer) {
                        var el = this.game.add.text(this.Elements.FillElements.el[i].pos.x, this.Elements.FillElements.el[i].pos.y + 50, this.Elements.FillElements.el[i].Answer, { font: "60px Arial", fill: 'green', });
                        el.setShadow(5, 5, "lightgreen");
                        this.addChild(el);
                        allcompleted = false;
                    }
                }
                if (allcompleted)
                    EU.setGameCompletion(this.parent, 1);
                return true;
            }
        };
        FillShuffle.prototype.checkIfEverythingIsCorrect = function () {
            EU.setGameCompletion(this.parent, 0);
            for (var i = 0; i < this.Elements.FillElements.el.length; i++) {
                if (!this.Elements.FillElements.el[i].name || this.Elements.FillElements.el[i].name.text != this.Elements.FillElements.el[i].Answer) {
                    return false;
                }
            }
            EU.setGameCompletion(this.parent, 1);
        };
        return FillShuffle;
    })(Base.BasicGroup);
    _FillShuffle.FillShuffle = FillShuffle;
})(FillShuffle || (FillShuffle = {}));
//# sourceMappingURL=FillShuffle.js.map