﻿module Animation {
    export class Animation extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.loadSpriteSheets();
            this.game.load.start();
        }

        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }


        loadSpriteSheets() {
            for (var i = 0; i < this.Elements.SpriteSheets.length; i++)
                this.game.load.spritesheet(this.PREFIX + this.Elements.SpriteSheets[i].key, this.Elements.SpriteSheets[i].src,
                    this.Elements.SpriteSheets[i].width, this.Elements.SpriteSheets[i].height);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }

            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            EU.setGameCompletion(this.parent, 1);
            this.createAnimations();

        }


        createAnimations() {

            for (var i = 0; i < this.Elements.Animations.length; i++) {
                var el = this.game.add.sprite(this.Elements.Animations[i].pos.x, this.Elements.Animations[i].pos.y, this.PREFIX + this.Elements.Animations[i].key);
                this.addChild(el);
                el.animations.add("all");

                el.inputEnabled = true;
                el.events.onInputDown.add(this.Play, this);
            }

        }

        private Play(el: Phaser.Sprite, pointer) {
            el.animations.play("all", 5, true);
        }



        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

        checkIfEverythingIsCorrect() {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this) && EU.checkIfFillsAreCorrect(this)) EU.Log("Correct!!!");
        }
    }
} 