﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentDictionaryContent = function(name)
{
	this.componentSimplePopup = componentSimplePopup;
	this.componentSimplePopup(name);

	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;

	this.key = null;
	this.description = null;
	this.imagesCompleteInfo = new Array();

	this.headerHeight = 50;
	this.borderWidth = 0;
	this.contentPadding = 0;
	this.sounds = false;
	this.closeButtonOffsetTop = 0;
	this.closeButtonOffsetRight = 0;
	this.headerTextOffsetTop = 0;
	this.headerTextOffsetLeft = 0;
	this.headerTextOffsetRight = 0;
	this.textAreaOffsetTop = 0;
	this.textAreaOffsetDown = 0;
	this.textAreaOffsetLeft = 0;
	this.textAreaOffsetRight = 0;
};

componentDictionaryContent.prototype = new componentSimplePopup;
componentDictionaryContent.prototype.type = "componentDictionaryContent";

componentDictionaryContent.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = (typeof(PlayerInterface) != 'undefined' && page.allowCommunication()) ? PlayerInterface.GetValue("resourcesStatus") : PageInterface.GetValue("resourcesStatus");
	this.resourcesURL = (this.disableOnlineOfflineMix) ? resourcesURL : ((typeof(PlayerInterface) != 'undefined' && page.allowCommunication()) ? PlayerInterface.GetValue("resourcesURL") : PageInterface.GetValue("resourcesURL"));

    this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [ this.src, this.arrowTopOver, this.arrowTopOut, this.arrowBottomOver, this.arrowBottomOut, this.sliderOver, this.sliderOut, this.sliderBckg ];
	this.getPreloadImagesArr();

	this.setCompleteArrayInfo(this.completeInfoStyleImages);
	this.captureMouseEvents();
};

componentDictionaryContent.prototype.componentDictionaryContentBaseOnPaint = componentDictionaryContent.prototype.onPaint;
componentDictionaryContent.prototype.onPaint = function(obj)
{
	this.componentDictionaryContentBaseOnPaint();
	if (PageInterface.GetValue("state") == psDesigning) {
		this.reFillComponent(dictionary.items[0]);
	};

	var titlePointer = document.getElementById(this.id + "_titlePointer");
	var titleText = document.getElementById(this.id + "_titleText");
	var contentText = document.getElementById(this.id + "_tableDiv");
	var table = document.getElementById(this.id + "Table");
	var activeX = document.getElementById(this.id + "_activeX");

	activeX.innerHTML = this.getActiveXHTMLDef(this.id+'_controlActiveX');

	table.style.width = this.w - 25;
	if (this.dir == "rtl") {
		this.RTLElement(titlePointer);
		this.RTLElement(titleText);
		this.RTLElement(contentText);
	};
};

componentDictionaryContent.prototype.componentDictionaryContentBaseSetHTMLObiects = componentDictionaryContent.prototype.setHTMLObiects;
componentDictionaryContent.prototype.setHTMLObiects = function(obj)
{
	this.componentDictionaryContentBaseSetHTMLObiects();

	var titlePointerImg = document.getElementById(this.id + "_titlePointerImg");
	var titlePointer = document.getElementById(this.id + "_titlePointer");
	var titleText = document.getElementById(this.id + "_titleText");
	var contentText = document.getElementById(this.id + "_tableDiv");
	var table = document.getElementById(this.id + "Table");
	var sizeDiv = document.getElementById(this.id + "_sizeDiv");
	var activeX = document.getElementById(this.id + "_activeX");

	titlePointerImg.src = this.resourcesURL + this.src;

	var dotH = getImageHeight(this.src);
	var dotW = getImageWidth(this.src);
	var font = this.getProjectFont(this.allowGF, this.fontFamily, this.fontSize, this.fontColor );
	var titleHeight = parseInt(getFontSize(font.size, 'px')*1.5);

	sizeDiv.style.width = this.w - dotW - 25;
	var topPadding = Math.max(dotH, titleHeight, sizeDiv.offsetHeight)+15;
	if (this.sounds) {
		this.headerHeight = topPadding + this.audioSrcH + 10;
	} else {
		this.headerHeight = topPadding + 10;
	};

	titleText.style.width = this.w - dotW - 25;
	titleText.style.height = this.headerHeight;
	titleText.style.top = 10;
	titleText.style.left = 15+dotW;
	titleText.style.clip = 'rect(0px '+eval(this.w - dotW - 20)+'px '+this.headerHeight+'px 0px)';

	titlePointer.style.width = dotW;
	titlePointer.style.height = dotH;
	titlePointer.style.top = 15;//10 + topPadding/2 - dotH/2;
	titlePointer.style.left = 10;
	titlePointer.style.clip = 'rect(0px '+dotW+'px '+dotH+'px 0px)';

	activeX.style.top = 19;
	activeX.style.left = 13;

	if (this._scrollable) {
		contentText.owner = null;
		/*
		if (this._vertScrollbars) {
			contentText.style.cssText += '; overflow-x: hidden; overflow-y: auto;';
		} else {
			contentText.style.cssText += '; overflow-x: auto; overflow-y: auto;';
		};
		*/
	};

	contentText.style.width = this.w - 25;
	contentText.style.height = this.h - topPadding;
	contentText.style.top = this.headerHeight;
	contentText.style.left = this.borderWidth + this.contentPadding + this.textSpacing;
	contentText.style.clip = 'rect(0px '+eval(this.w - 20)+'px '+eval(this.h - topPadding)+'px 0px)';

	var titleContentObj = document.getElementById(this.id + "_titleContentObj");
	var contentContentObj = document.getElementById(this.id + "_contentObj");
	var font = this.getProjectFont(this.allowGF, this.fontFamily, this.fontSize, this.fontColor)

	titleContentObj.style.fontFamily = font.family;
	titleContentObj.style.fontSize = getFontSize(font.size, 'px');
	titleContentObj.style.color = font.color;

	contentContentObj.style.fontFamily = font.family;
	contentContentObj.style.fontSize = getFontSize(font.size, 'px');
	contentContentObj.style.color = font.color;
};

componentDictionaryContent.prototype.setScrollTop = function(obj)
{
	var	tableDiv = document.getElementById(this.id + "_tableDiv");
	var	trackDiv = document.getElementById(this.id + "_trackDiv");
	tableDiv.scrollTop = 0;
	trackDiv.style.top = this.sliderLowOffset;
};

componentDictionaryContent.prototype.reFillComponent = function(obj)
{
	this.setScrollTop();
	this.audioStop();

	if (obj) {
		this.setPhraseTitle(obj.key);
		this.setPhraseContent(obj.description);
		this.setAudio(obj.sounds);
	} else {
		this.setPhraseTitle("");
		this.setPhraseContent("");
		this.setAudio([]);
	};

	this.getTextHeight();
	this.setHTMLObiects();
	this.placeHTMLObiects();
	this.playFilters();
};

componentDictionaryContent.prototype.audioStop = function(sounds)
{
	var player = document.getElementById(this.id + "MediaPlayer");
	if (player && player.controls) {
		if (is.ie ) {
			player.controls.stop();
		} else
		if (is.moz){
			player.controls.stop();
		};
	};
};

componentDictionaryContent.prototype.setAudio = function(sounds)
{
	var audioIcons = document.getElementById(this.id + "_audioIcons");
	var t = "";

	this.sounds = (sounds.length > 0);
	for (var i=0; i< sounds.length; i++){
		t += '<img src="'+this.resourcesURL+this.audioSrc+'" onclick="pc.'+this.id+'.playSound(\''+sounds[i]+'\');" />';
		t += '&nbsp';
	};
	audioIcons.innerHTML = t;
}

componentDictionaryContent.prototype.playSound = function(sound)
{
	var player = document.getElementById(this.id + "MediaPlayer");
	if (player) {
		if (is.ie && player.controls) {
			player.URL = this.resourcesURL+sound;
			player.controls.play();
		} else
		if (is.moz){
			player.URL = this.resourcesURL+sound;
			player.controls.play();
		};
	};
};

componentDictionaryContent.prototype.setPhraseTitle = function(text)
{
	this.key = text;
	var titleContentObj = document.getElementById(this.id + "_titleContentObj");
	var sizeDiv = document.getElementById(this.id + "_sizeDiv");

	if (this.boldPhrase) {
		titleContentObj.innerHTML = '<b>'+text+'</br>';
		sizeDiv.innerHTML = '<b>'+text+'</br>';
	} else {
		titleContentObj.innerHTML = text;
		sizeDiv.innerHTML = text;
	};
};

componentDictionaryContent.prototype.setPhraseContent = function(text)
{
	this.description = text;
	text = text.replace(/\\n/ig, "<br>");
	var contentContentObj = document.getElementById(this.id + "_contentObj");
	contentContentObj.innerHTML = text;
};

componentDictionaryContent.prototype.onMouseClickImageLoad = function()
{
	var obj = document.getElementById(this.myParent.id + '_controlActiveXactiveX');
	var fileName = this.fileName;
	if (obj && fileName != '') {
		obj.WavPattern = this.myParent.resourcesURL + fileName;
		if (typeof(obj.ResizeForm) != 'undefined') obj.ResizeForm(341, 230, 1);
	};
	return(true);
};

componentDictionaryContent.prototype.getActiveXHTMLDef = function(id)
{
	var s = "";
	if (is.ie) {
		// WMP 7up code
		s += '	<OBJECT id="' + this.id + 'MediaPlayer" ';
		s += '		width="1" height="1" ';
		s += '		CLASSID=CLSID:6BF52A52-394A-11D3-B153-00C04F79FAA6 ';
		s += '		standby="Loading Microsoft Windows Media Player components..."';
		s += '		TYPE="application/x-oleobject">';
		s += '		<param name="url" VALUE="" />';
		s += '		<param name="uiMode" value="none" />';
		s += '		<param name="Volume" value="100" />';
		s += '		<param name="ShowControls" VALUE="false" />';
		s += '		<param name="ShowTracker" VALUE="false" />';
		s += '		<param name="ShowStatusBar" VALUE="false" />';
		s += '		<param name="VideoBorder3D" VALUE="false" />';
		s += '		<param name="VideoBorderWidth" VALUE="false" />';
		s += '		<param name="AutoStart" value="false" />';
		s += '		<param name="AnimationAtStart" value="false" />';
		s += '		<param name="TransparentAtStart" value="false" />';
		s += '	</OBJECT>';
	} else
	if (is.moz){
		s += '<OBJECT id="' + this.id + 'MediaPlayer" type="application/x-ms-wmp"'; 
		s += ' width="1" height="1" >';
		s += '<PARAM name="enableContextMenu" value="false" />';
		s += '<PARAM name="enabled" value="false" />';
		s += '<param name="uiMode" value="none" />';
		s += ' </OBJECT>';
	};
	return s;
};

componentDictionaryContent.prototype.isReady = function()
{
	return preloadImage(this, "_0");
};

componentDictionaryContent.prototype.print = function()
{
	var d_setting = "toolbar=no,location=no,directories=no,menubar=no,"
		+ "scrollbars=yes,width=640, height=480, left=0, top=0";
	var content = '<p><b>' + this.key + '</b></p>';
	content += '<p>' + this.description + '</p>';

	var printWin = window.open("", "", d_setting);
	printWin.document.open();
	printWin.document.write('<html><head><title>' + project.pageName + '</title>'); 
	printWin.document.write('</head><body onload="self.print();">');
	printWin.document.write(content);
	printWin.document.write('</body></html>');
	printWin.document.close();
	printWin.focus();
};
