﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
if (typeof(moduleDone) != "undefined") moduleDone("dictionary.js");

DictionaryItem = function()
{
	this.visible = true;
	this.id = null;
	this.key = null;
	this.description = null;
	this.sounds = null;
	this.links = null;
};

DictionaryItem.prototype.free = function()
{
	this.visible = true;
	this.id = null;
	this.key = null;
	this.description = null;
	this.sounds = null;
	this.links = null;
};

DictionaryGroupItem = function()
{
	this.id = null;
	this.caption = null;
	this.items = null;
};

DictionaryGroupItem.prototype.free = function()
{
	this.id = null;
	this.caption = null;
	for (var i=0; i<this.items.length; i++) {
		var item = this.items[i];
		item.free();
		item = null;
	};
	this.items = null;
};

Dictionary = function()
{
	this.items = new Array();
	this.groups = new Array();
	this.filter = "";
};

Dictionary.prototype.add = function(id, key, desc, sounds, links)
{
	var result = false;
	if (typeof(id) != "undefined" && id != ""
			&& typeof(key) != "undefined" && key != ""
			&& typeof(desc) != "undefined")
	{
		var index = this.items.length;
		this.items[index] = new DictionaryItem();
		this.items[index].id = id;
		this.items[index].key = key;
		this.items[index].description = desc;
		if (sounds != "") this.items[index].sounds = sounds.split(",");
		else this.items[index].sounds = new Array();
		if (links != "") this.items[index].links = links.split(",");
		else this.items[index].links = new Array();
		result = true;
	}
	return result;
};

Dictionary.prototype.addGroup = function(id, caption, items)
{
	var result = false;
	if (typeof(caption) != "undefined" && caption != ""
			&& typeof(items) != "undefined")
	{
		var index = this.groups.length;
		this.groups[index] = new DictionaryGroupItem();
		this.groups[index].id = id;
		this.groups[index].caption = caption;
		this.groups[index].items = items.split(",");
		result = true;
	};
	return result;
};

Dictionary.prototype.getGroup = function(value)
{
	var result = null;
	for (var i=0; i<this.groups.length; i++) {
		if (this.groups[i].id == value) {
			result = this.groups[i];
			break;
		};
	};
	return result;
};

Dictionary.prototype.inGroup = function(id, group)
{
	var result = false;
	for (var i=0; i<group.items.length; i++) {
		if (group.items[i] == id) {
			result = true;
			break;
		};
	};
	return result;
};

Dictionary.prototype.setFilter = function(value)
{
	/*var group = this.getGroup(value); //pg2-removed -it does not work
	if (group) {
		for (var i=0; i<this.items.length; i++) {
			this.items[i].visible = (this.inGroup(this.items[i].id, group));
		};
	} else {
		for (var i=0; i<this.items.length; i++) {
			this.items[i].visible = true;
		};
	};*/
	this.filter = value.toLowerCase(); //pg2-new
	for (var i=0; i<this.items.length; i++) {
		var ffch = this.items[i].key.charAt(0);
		var ffk = this.items[i].key.substr(0, this.filter.length).toLowerCase();
		var nos = (ffch >= "0" && ffch <= "9");

		this.items[i].visible = (this.filter == "" || ffk == this.filter || (this.filter == "0-9" && nos));
	};

	var dict_tree_comp = page.getElementsType("componentDictionaryTree");
	for (var i=0; i<dict_tree_comp.length; i++) {
		var comp = dict_tree_comp[i];
		comp.reinit();
	};
};

Dictionary.prototype.setActiveKey = function(value)
{
	if (value && value != "") {
		var dict_tree_comp = page.getElementsType("componentDictionaryTree");
		for (var i=0; i<dict_tree_comp.length; i++) {
			var comp = dict_tree_comp[i];
			comp.setKey(value);
		};
	};
};

Dictionary.prototype.getItem = function(key)
{
	var result = null;
	for (var i=0; i<this.items.length; i++) {
		if (this.items[i].key == key) {
			result = this.items[i];
			break;
		};
	};
	return result;
};

Dictionary.prototype.free = function()
{
	for (var i=0; i<this.items.length; i++) {
		var item = this.items[i];
		item.free();
		item = null;
	};
};

Dictionary.prototype.existsKey = function(key, partCheck) //pg2-new
{
	var result = false;
	if (key != "") {
		for (var i=0; i<this.items.length; i++) {
			var item = this.items[i];
			if (key == "0-9") {
				result = !isNaN(item.key.toLowerCase().charAt(0));
				if (result) break; //pg2- it must be, 'cause in next iteration result could be changed to false and...dupa
			} else
			if (typeof(partCheck) != "undefined" && partCheck) {
				if (item.key.toLowerCase().charAt(0) == key.toLowerCase().charAt(0)) {
					result = true;
					break;
				};
			} else
			if (item.toLowerCase() == key.toLowerCase()) {
				result = true;
				break;
			};
		};
	};
	return result;
};

dictionary = new Dictionary();
