﻿module MainGame {
    export class MainGameState extends BasicModule.BasicState {

        outfitNum: number;
        girl: any;
        boy: any;

        guide: Phaser.Group;
        oGroup: Phaser.Group;
        isHelpShown: boolean = false;
        cloudText: Phaser.Text;
        firstRun: boolean = true;
        isSafari: boolean = true;
        cloud: Phaser.Image;
        helpBtn: Phaser.Image;
        halp: Phaser.Button;
        tipsBtn: Phaser.Button;
        ggCount: number = 0;
        instruction: any;
        applause: any;
        sndTryAgain: any;
        tableOutfits: number[] = [1,2,3,4,5,6];


        constructor() {
            super();
        }

        preload() {
            super.preload();
            for (var i = 0; i < 9; i++) {
                this.game.load.image(this.getOutfit(i, false) + "_01_b", "Graphics/game/boy/" + this.getOutfit(i, false) + "_01.png");
                this.game.load.image(this.getOutfit(i, false) + "_02_b", "Graphics/game/boy/" + this.getOutfit(i, false) + "_02.png");
                this.game.load.image(this.getOutfit(i, false) + "_03_b", "Graphics/game/boy/" + this.getOutfit(i, false) + "_03.png");
                this.game.load.image(this.getOutfit(i, false) + "_01_g", "Graphics/game/girl/" + this.getOutfit(i, false) + "_01.png");
                this.game.load.image(this.getOutfit(i, false) + "_02_g", "Graphics/game/girl/" + this.getOutfit(i, false) + "_02.png");
                this.game.load.image(this.getOutfit(i, false) + "_03_g", "Graphics/game/girl/" + this.getOutfit(i, false) + "_03.png");
            }

            for (var i = 0; i < 3; i++) {
                this.game.load.spritesheet("previous" + (i + 1), "Graphics/gui/" + "previous" + (i + 1) + ".png", 53, 62, 2, 0, 0);
                this.game.load.spritesheet("next" + (i + 1), "Graphics/gui/" + "next" + (i + 1) + ".png", 53, 62, 2, 0, 0);
            }

            this.game.load.image("frame", "Graphics/gui/frame.png");
            this.game.load.spritesheet("ready", "Graphics/gui/ready.png", 220, 71, 2, 0, 0);
            this.game.load.image("boy", "Graphics/game/boy.png");
            this.game.load.image("girl", "Graphics/game/girl.png");
            this.game.load.spritesheet("help", "Graphics/gui/help.png", 104, 108, 2, 0, 8);
            this.game.load.spritesheet("replay", "Graphics/gui/replay.png", 108, 111, 2, 0, 0);
            this.game.load.image("gameGuide", "Graphics/gui/guide.png");
            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");
            this.game.load.spritesheet("tips", "Graphics/gui/tips.png", 220, 71, 2);

            for (var i = 0; i < 3; i++) {
                this.game.load.spritesheet("next" + (i + 1), "Graphics/gui/previous" + (i + 1) + ".png", 53, 62, 2, 0, 0);
                this.game.load.spritesheet("previous" + (i + 1), "Graphics/gui/next" + (i + 1) + ".png", 53, 62, 2, 0, 0);
            }


            this.instruction = new Audio("./Sounds/goal.mp3");
            this.applause = new Audio("./Sounds/applause.mp3");
            this.sndTryAgain = new Audio("./Sounds/tryagain.mp3");

        }

        shuffle(o) { 
            for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
            return o;
        }

        create() {
            super.create();
            // old ->> this.outfitNum = Math.floor(Math.random() * 6) + 1;
            this.shuffle(this.tableOutfits);
            this.outfitNum = this.tableOutfits[0];

            this.boy = { "cl": -1, "parts": [] };
            this.girl = { "cl": -1, "parts": [] };

            this.game.add.image(432, 17, "boy");
            this.game.add.image(1087, 17, "girl");
            var fr = this.game.add.image(351, 0, "frame");
            fr.y = this.game.height - fr.height;
            var txt = this.game.add.text(0, 0, "Wybierz strój " + this.getOutfit(this.outfitNum, true), { font: "normal 30pt Arial" });
            txt.anchor.set(0.5, 0.5);
            txt.position.setTo(fr.width / 2, fr.height * 0.6);
            fr.addChild(txt);
            this.helpBtn = this.game.add.button(1778, 22, "help", this.showHelp, this, 0, 0, 1, 0);
            this.game.add.button(45, 22, "replay", this.replay, this, 0, 0, 1, 0);
          

            var arX = 339;
            var arY = 212;

            for (var i = 0; i < 3; i++) {
                this.game.add.button(arX, arY + (62 + 198) * i, "previous" + (i + 1), function (e) { this.changeOutfit(e, this.boy, "_b", -1); }, this, 0, 0, 1, 0);
                this.game.add.button(arX + 520, arY + (62 + 198) * i, "next" + (i + 1), function (e) { this.changeOutfit(e, this.boy, "_b", 1); }, this, 0, 0, 1, 0);
            }
            arX = 1029;
            for (var i = 0; i < 3; i++) {
                this.game.add.button(arX, arY + (62 + 198) * i, "previous" + (i + 1), function (e) { this.changeOutfit(e, this.girl, "_g", -1); }, this, 0, 0, 1, 0);
                this.game.add.button(arX + 520, arY + (62 + 198) * i, "next" + (i + 1), function (e) { this.changeOutfit(e, this.girl, "_g", 1); }, this, 0, 0, 1, 0);
            }

            var hat = this.game.add.image(432, 17, "bawarski_01_b");
            hat.alpha = 1;
            var leggins = this.game.add.image(432, 17 + 502, "bawarski_03_b");
            leggins.alpha = 1;
            var torso = this.game.add.image(432, 17 + 323, "bawarski_02_b");
            torso.alpha = 1;

            this.boy.parts.push(hat);
            this.boy.parts.push(torso);
            this.boy.parts.push(leggins);

            var hat = this.game.add.image(1087, 17, "bawarski_01_g");
            hat.alpha = 1;
            var leggins = this.game.add.image(1087, 17 + 497, "bawarski_03_g");
            leggins.alpha = 1;
            var torso = this.game.add.image(1087, 17 + 374, "bawarski_02_g");
            torso.alpha = 1;

            this.girl.parts.push(hat);
            this.girl.parts.push(torso);
            this.girl.parts.push(leggins);

            var ready = this.game.add.button(971, 24, "ready", this.isDone, this, 0, 0, 1, 0);
            fr.addChild(ready);


            this.tipsBtn = this.game.add.button(20, 24, "tips", this.showOutfits, this, 0, 0, 1, 0);
            fr.addChild(this.tipsBtn);

            this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud");
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "Ubierz postacie w stroje ludowe z poszczególnych części świata. Dobierz górę, dół i nakrycie głowy.", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);

            this.createOutfitHelp();

            this.guide.y = this.game.world.height;

            if (this.ggCount == 0) this.showHelp();
        }

        changeOutfit(spr: Phaser.Button, obj, sfx, idx) {
            var temp = spr.key.substring(0, spr.key.length - 1);
            var piece = parseInt(spr.key[spr.key.length - 1]);
            obj.cl += idx;

            if (temp === "next") {
                if (obj.cl > 8) {
                    obj.cl = -1;
                }
                if (obj.cl === -1) {
                    obj.parts[piece - 1].alpha = 1;
                } else {
                    obj.parts[piece - 1].loadTexture(this.getOutfit(obj.cl, false) + "_0" + piece + "" + sfx, 0);
                    obj.parts[piece - 1].alpha = 1;
                }
            } else {
                if (obj.cl < -1) {
                    obj.cl = 8;
                }
                if (obj.cl === -1) {
                    obj.parts[piece - 1].alpha = 2;
                } else {
                    obj.parts[piece - 1].loadTexture(this.getOutfit(obj.cl, false) + "_0" + piece + "" + sfx, 0);
                    obj.parts[piece - 1].alpha = 1;
                }
            }
        }
        

        isDone() {
            var win = true;
            var correct = this.getOutfit(this.outfitNum, false);
         
    
            for (var i = 0; i < this.boy.parts.length; i++) {
                if (i == 0 && (correct === "japonski" || correct === "koreanski" || correct === "szkocki")) {
                    if ((this.boy.parts[i].key.split("_")[0] !== "japonski" && this.boy.parts[i].key.split("_")[0] !== "koreanski" && this.boy.parts[i].key.split("_")[0] !== "szkocki" && this.boy.parts[i].alpha !== 0) ) {
                        win = false;
                    }
                } else if (i == 0 && (correct === "meksykanski" || correct === "hiszpanski")) {
                    if ((this.boy.parts[i].key.split("_")[0] !== "meksykanski" && this.boy.parts[i].key.split("_")[0] !== "hiszpanski" && this.boy.parts[i].alpha !== 0)) {
                        win = false;
                    }

                } else {
                    if (this.boy.parts[i].key.split("_")[0] !== correct || this.boy.parts[i].alpha === 0) {
                        win = false;
                    }
                }
            }
            
            
            for (var i = 0; i < this.girl.parts.length; i++) {
                if (i == 0 && ( correct === "koreanski" || correct === "szkocki" || correct === "bawarski")) {
                    if ((this.girl.parts[i].key.split("_")[0] !== "koreanski" && this.girl.parts[i].key.split("_")[0] !== "bawarski" && this.girl.parts[i].key.split("_")[0] !== "szkocki" && this.girl.parts[i].alpha !== 0) ) {
                        win = false;
                    }
                } else {
                    if (this.girl.parts[i].key.split("_")[0] !== correct || this.girl.parts[i].alpha === 0) {
                        win = false;
                    }
                }
            }
      
            
            if (win) {
                this.showWin();
            }

            else {
                this.showTryAgain();
            }

        }

        getOutfit(num, pol) {
            var ret = "bawarski";
            switch (num) {
                case 1:
                    ret = "grecki";
                    break;
                case 2:
                    ret = "hiszpanski";
                    if (pol) {
                        ret = "hiszpański";
                    }
                    break;
                case 3:
                    ret = "indianski";
                    if (pol) {
                        ret = "indiański";
                    }
                    break;
                case 4:
                    ret = "japonski";
                    if (pol) {
                        ret = "japoński";
                    }
                    break;
                case 5:
                    ret = "koreanski";
                    if (pol) {
                        ret = "koreański";
                    }
                    break;
                case 6:
                    ret = "meksykanski";
                    if (pol) {
                        ret = "meksykański";
                    }
                    break;
                case 7:
                    ret = "peruwianski";
                    if (pol) {
                        ret = "peruwiański";
                    }
                    break;
                case 8:
                    ret = "szkocki";
                    break;

                    
            }
            return ret;
        }

        showHelp() {
            

            var tw = null;
            this.cloudText.setText("Ubierz postacie w stroje ludowe z poszczególnych części świata. Dobierz górę, dół i nakrycie głowy.");
            var point = this.game.world.height;
            this.isHelpShown = !this.isHelpShown;

            if (this.isHelpShown) {
                point -= this.guide.height;
                try {
                    this.instruction.currentTime = 0;
                    this.instruction.play();
                    if (this.firstRun) {
                        this.helpBtn.inputEnabled = false;
                        var tmr = this.game.time.events.add(Phaser.Timer.SECOND * 4, this.changeHelp, this);
                    }
                } catch (e) { }
            } else {
                try {
                    this.instruction.pause();
                    this.instruction.currentTime = 0;
                } catch (e) { }
            }

            tw = this.game.add.tween(this.guide);
            tw.to({ y: point }, 800, Phaser.Easing.Cubic.Out);
            tw.start();
        }

        showWin() {
            
            this.tableOutfits.splice(0, 1);
            if (this.tableOutfits.length == 0) this.tableOutfits = [1, 2, 3, 4, 5, 6];
            this.ggCount++;
            var tw = this.game.add.tween(this.guide);
            this.cloudText.setText("GRATULACJE!");
            this.halp.visible = false;
            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 4, function () {
                    try {
                        this.applause.pause();
                        this.applause.currentTime = 0;
                        this.reload(); 
                        //this.replay();
                    } catch (e) { }
                }, this);
            }, this);
            tw.start();


            try {
                this.applause.currentTime = 0;
                this.applause.play();
            } catch (e) { }
        }

        showTryAgain() {
            
            var tw = this.game.add.tween(this.guide);
            var tw2 = this.game.add.tween(this.guide);
            this.cloudText.setText("SPRÓBUJ JESZCZE RAZ");
            this.halp.visible = true;

            try {
                this.sndTryAgain.currentTime = 0
                this.sndTryAgain.play();
            } catch (e) { }

            tw2.to({ y: this.game.world.height }, 800, Phaser.Easing.Cubic.Out);

            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 2, function () {
                    
                   
                    tw2.start();

                }, this);
            }, this);
            tw.start();
        
        }

        changeHelp() {
            this.showHelp();
            this.helpBtn.inputEnabled = true;
            this.cloudText.y = this.cloud.height * 0.4;
            //this.tipsBtn = this.game.add.button(this.cloud.width / 2, this.cloud.height * 0.7, "tips", this.showOutfits, this, 0, 0, 1, 0);
            //this.tipsBtn.anchor.setTo(0.5, 0.5);
            //this.cloud.addChild(this.tipsBtn);
        }

        showOutfits() {
            this.oGroup.visible = true;
        }

        hideOutfits() {
            this.oGroup.visible = false;
        }

        createOutfitHelp() {
            this.oGroup = this.game.add.group();
            this.oGroup.z = 20;

            var back: Phaser.Sprite;
            var bmd = this.game.add.bitmapData(1920, 1080);

            bmd.ctx.rect(0, 0, 1920, 1080);
            bmd.ctx.fillStyle = '#000000';
            bmd.ctx.fill();
            back = this.game.add.sprite(this.game.world.centerX, this.game.world.centerY, bmd);
            back.anchor.setTo(0.5, 0.5);
            back.alpha = 0.7;
            back.inputEnabled = true;
            this.oGroup.addChild(back);

            var x = 600;
            var y = 320;
            var temp = 0;

            for (var i = 0; i < 3; i++) {
                for (var j = 0; j < 3; j++) {
                    var b = this.game.add.image(j * x + 170, i * y + 20, "boy");
                    var hat = this.game.add.image(0, 0, this.getOutfit(temp, false) + "_01_b");
                    var torso = this.game.add.image(0,  17 + 317, this.getOutfit(temp, false) + "_02_b");
                    var leggins = this.game.add.image(0, 17 + 497, this.getOutfit(temp, false) + "_03_b");
                    b.addChild(hat);
                    b.addChild(leggins);
                    b.addChild(torso);
                    b.scale.setTo(0.3, 0.3);
                    this.oGroup.addChild(b);

                    var g = this.game.add.image(j * x + 360, i * y + 20, "girl");
                    var hat = this.game.add.image(0, 0, this.getOutfit(temp, false) + "_01_g");
                    var torso = this.game.add.image(0, 17 + 370, this.getOutfit(temp, false) + "_02_g");
                    var leggins = this.game.add.image(0, 17 + 490, this.getOutfit(temp, false) + "_03_g");
                    g.addChild(hat);
                    g.addChild(leggins);
                    g.addChild(torso);
                    g.scale.setTo(0.3, 0.3);
                    this.oGroup.addChild(g);

                    var txt = this.game.add.text(0, b.y + b.height + 2, this.getOutfit(temp, true), { font: "normal 40pt Arial", fill: "white", stroke: "black", strokeThickness: 5 });
                    txt.x = b.x + ((300 - txt.width) / 2);
                    this.oGroup.addChild(txt);
                    temp++;
                }
            }

            this.halp = this.game.add.button(1778, 22, "help", this.hideOutfits, this, 0, 0, 1, 0, this.oGroup);
            this.oGroup.visible = false;
        }
        reload() {
            //this.outfitNum = 0;
            this.firstRun = true;
            this.boy = { "cl": -1, "parts": [] };
            this.girl = { "cl": -1, "parts": [] };
            this.game.state.start("MainGameState",false,false);
        }
        replay() {
            //this.outfitNum = 0;
            this.firstRun = true;
            this.boy = { "cl": -1, "parts": [] };
            this.girl = { "cl": -1, "parts": [] };
            this.ggCount = 0;
            //zmienan a przejscie do glowenj strony
            this.game.state.start("TitleScreenState");
        }
    }
}