/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentInfoPanel = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.stepsTextArr = new Array();
	this.tdArray = new Array();
	this.naviPointsArray = new Array();

	this.contentTableHeight = 0;
	this.actualDisplayStep = 0;
	this.pageStepsCount = 0;

	this.showFeedback = false;
	this.feedbacksArr = new Array();
	this.feedbacksImagesArr = new Array();

	this.isFeedbackDisplayed = false;
	this.imagesCompleteInfo = new Array();
	this.iTimerID = null;
};

componentInfoPanel.prototype = new componentElement();
componentInfoPanel.prototype.type = "componentInfoPanel";

componentInfoPanel.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
    this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [this.leftTop, this.centerTop, this.rightTop, this.topMiddle, this.centerMiddle, this.bottomMiddle, this.leftBottom, this.bottom, this.rightBottom,
							this.naviTopOut, this.naviTopOver, this.naviMiddle, this.naviBottomOut, this.naviBottomOver, this.pointNotVisited, this.pointVisited, this.feedbackOkHeader,
							this.feedbackOkBckg, this.feedbackTryHeader, this.feedbackTryBckg, this.feedbackBadHeader, this.feedbackBadBckg, this.feedbackCloseOut, this.feedbackCloseOver,
							this.leftSteps, this.centerSteps, this.rightSteps, this.buttonPrintOut, this.buttonPrintOver
						];
	this.getPreloadImagesArr();
	this.setCompleteArrayInfo(this.completeInfoStyleImages, this.completeInfoFeedbacksImages, this.completeInfoButtonsImages);
};

componentInfoPanel.prototype.setCompleteArrayInfo = function(style, feedback, buttons)
{
	var imagesStr = style + feedback + buttons;
	var imgArr = imagesStr.split(';');
	for (var i = 0; i < imgArr.length; i++) {
		var oneImg = imgArr[i].split(',');
		if (!this.imagesCompleteInfo[oneImg[0]]) {
			this.imagesCompleteInfo[oneImg[0]] = new Array();
			this.imagesCompleteInfo[oneImg[0]][0] = oneImg[1];
			this.imagesCompleteInfo[oneImg[0]][1] = oneImg[2];
		};
	};
};

componentInfoPanel.prototype.onCreate = function(obj)
{
	this.pageStepsCount = 5;

	if (PageInterface.GetValue("state") != psDesigning) {
		this.pageStepsCount = PageInterface.GetValue("pageStepsCount");
	};

	this.setHTMLObiekts();
	this.setStepsTextArr(this.content);
	this.makeTRInTable(this.cellsNo);
	this.makeNaviPoints();
	this.getObjectPointToArray(this.pageStepsCount);
	this.getObjectTDToArray(this.cellsNo);
	this.changePointsGraphics(0);
};

componentInfoPanel.prototype.setHTMLObiekts = function(obj)
{

	document.getElementById(this.id + "_leftTop").src = this.resourcesURL + this.leftTop;
	document.getElementById(this.id + "_centerTop").src = this.resourcesURL + this.centerTop;
	document.getElementById(this.id + "_rightTop").src = this.resourcesURL + this.rightTop;
	document.getElementById(this.id + "_topTableDiv").style.height = this.getImageHeight('centerTop');
	document.getElementById(this.id + "_topLeft").style.width = this.getImageWidth('leftTop');
	document.getElementById(this.id + "_headerTextDiv").style.height = this.getImageHeight('centerTop');
	document.getElementById(this.id + "_rightTop").style.width = this.getImageWidth('rightTop');
	document.getElementById(this.id + "_topCenter").style.width = this.w - this.getImageWidth('leftTop') - this.getImageWidth('rightTop');
	document.getElementById(this.id + "_centerTop").width = this.w - this.getImageWidth('leftTop') - this.getImageWidth('rightTop');
	document.getElementById(this.id + "_topMiddle").src = this.resourcesURL + this.topMiddle;
	document.getElementById(this.id + "_centerMiddle").src = this.resourcesURL + this.centerMiddle;
	document.getElementById(this.id + "_bottomMiddle").src = this.resourcesURL + this.bottomMiddle;

	document.getElementById(this.id + "_middleTableTop").style.height = this.getImageHeight('topMiddle');
	document.getElementById(this.id + "_middleTableBottom").style.height = this.getImageHeight('bottomMiddle');

	document.getElementById(this.id + "_leftBottom").src = this.resourcesURL + this.leftBottom;
	document.getElementById(this.id + "_centerBottom").src = this.resourcesURL + this.bottom;
	document.getElementById(this.id + "_rightBottom").src = this.resourcesURL + this.rightBottom;

	document.getElementById(this.id + "_leftBottom").style.height = this.getImageHeight('leftBottom');
	document.getElementById(this.id + "_centerBottom").style.height = this.getImageHeight('bottom');
	document.getElementById(this.id + "_rightBottom").style.height = this.getImageHeight('rightBottom');

	document.getElementById(this.id + "_bottomLeft").style.width = this.getImageWidth('leftBottom');
	document.getElementById(this.id + "_bottomRight").style.width = this.getImageWidth('rightBottom');
	document.getElementById(this.id + "_bottomCenter").style.width = this.w - this.getImageWidth('leftBottom') - this.getImageWidth('rightBottom');
	document.getElementById(this.id + "_centerBottom").width = this.w - this.getImageWidth('leftBottom') - this.getImageWidth('rightBottom');

	document.getElementById(this.id + "_bottomTableDiv").style.height = this.getImageHeight('bottom');

	this.setMiddleDivHeight(
							document.getElementById(this.id + "_middleTableDiv"), 
							document.getElementById(this.id + "_topTableDiv"), 
							document.getElementById(this.id + "_bottomTableDiv")
						);
	document.getElementById(this.id + "_buttonClose").src = this.resourcesURL + this.buttonCloseOut;
	document.getElementById(this.id + "_buttonDIV").style.left = this.w - this.buttonCloseX;
	document.getElementById(this.id + "_buttonDIV").style.width = this.getImageWidth('buttonCloseOut');
	document.getElementById(this.id + "_buttonDIV").style.height = this.getImageHeight('buttonCloseOut');
	document.getElementById(this.id + "_buttonDIV").style.clip = 'rect(0px '+this.getImageWidth('buttonCloseOut')+'px '+this.getImageHeight('buttonCloseOut')+'px 0px)';
	if (document.getElementById(this.id + "_closeFeedback")) {
		document.getElementById(this.id + "_closeFeedback").src = this.resourcesURL + this.feedbackCloseOut;
	};
	if (document.getElementById(this.id + "_closeFeedbackDIV")) {
		document.getElementById(this.id + "_closeFeedbackDIV").style.visibility = 'hidden';
		document.getElementById(this.id + "_closeFeedbackDIV").style.left = this.w - this.buttonCloseX;
		document.getElementById(this.id + "_closeFeedbackDIV").style.width = this.getImageWidth('feedbackCloseOut');
		document.getElementById(this.id + "_closeFeedbackDIV").style.height = this.getImageHeight('feedbackCloseOut');
		document.getElementById(this.id + "_closeFeedbackDIV").style.clip = 'rect(0px '+this.getImageWidth('feedbackCloseOut')+'px '+this.getImageHeight('feedbackCloseOut')+'px 0px)';
	};

	if (document.getElementById(this.id + "_leftStepsBckg")) {
		document.getElementById(this.id + "_leftStepsBckg").src = this.resourcesURL + this.leftSteps;
	};
	if (document.getElementById(this.id + "_bottomStepsBckg")) {
		document.getElementById(this.id + "_bottomStepsBckg").src = this.resourcesURL + this.centerSteps;
	};
	if (document.getElementById(this.id + "_rightStepsBckg")) {
		document.getElementById(this.id + "_rightStepsBckg").src = this.resourcesURL + this.rightSteps;
	};

	if (document.getElementById(this.id + "_stepsBckgDiv")) {
		if (this.runStepsInPanel) {
			document.getElementById(this.id + "_leftStepsTD").width = this.getImageWidth('leftSteps');
			document.getElementById(this.id + "_rightStepsTD").width = this.getImageWidth('rightSteps');
			document.getElementById(this.id + "_stepsBckgDiv").style.top = this.h - this.getImageHeight('bottom');
			document.getElementById(this.id + "_stepsBckgDiv").style.left = this.getStepsDivLeft();
			document.getElementById(this.id + "_stepsBckgDiv").style.height = this.getImageHeight('centerSteps');
			document.getElementById(this.id + "_stepsBckgDiv").style.width = this.getStepsDivWidth();
			document.getElementById(this.id + "_stepsBckgDiv").style.clip = 'rect(0px '+this.getStepsDivWidth()+'px '+this.getImageHeight('buttonPrintOut')+'px 0px)';
		} else {
			document.getElementById(this.id + "_stepsBckgDiv").style.visibility = 'hidden';
		};
	};

	if (document.getElementById(this.id + "_stepsTextDiv")) {
		if (this.runStepsInPanel) {
			document.getElementById(this.id + "_stepsTextDiv").style.top = this.h - this.getImageHeight('bottom');
			document.getElementById(this.id + "_stepsTextDiv").style.left = this.getStepsDivLeft();
			document.getElementById(this.id + "_stepsTextDiv").style.height = this.getImageHeight('centerSteps');
			document.getElementById(this.id + "_stepsTextDiv").style.width = this.getStepsDivWidth();
			document.getElementById(this.id + "_stepsTextDiv").style.clip = 'rect(0px '+this.getStepsDivWidth()+'px '+this.getImageHeight('buttonPrintOut')+'px 0px)';
		} else {
			document.getElementById(this.id + "_stepsTextDiv").style.visibility = 'hidden';
		};
	};

	if (document.getElementById(this.id + "_printButton")) {
		document.getElementById(this.id + "_printButton").src = this.resourcesURL + this.buttonPrintOut;
	};

	if (document.getElementById(this.id + "_printDiv")) {
		var buttonPrintH = this.getImageHeight('buttonPrintOut');
		var buttonPrintW = this.getImageWidth('buttonPrintOut');
		document.getElementById(this.id + "_printDiv").style.top = this.h - this.getImageHeight('bottom');
		document.getElementById(this.id + "_printDiv").style.left = this.w - this.buttonCloseX;
		document.getElementById(this.id + "_printDiv").style.height = buttonPrintH;
		document.getElementById(this.id + "_printDiv").style.width = buttonPrintW;
		document.getElementById(this.id + "_printDiv").style.clip = 'rect(0px '+buttonPrintW+'px '+buttonPrintH+'px 0px)';
	};

	if (document.getElementById(this.id + "_naviPointsDiv")) {
		document.getElementById(this.id + "_naviPointsDiv").style.top = 2 + this.getImageHeight('centerTop') + this.getImageHeight('naviTopOut');
		document.getElementById(this.id + "_naviPointsDiv").style.left = this.w - this.getImageWidth('naviMiddle')-4;
		document.getElementById(this.id + "_naviPointsDiv").style.height = this.h - this.getImageHeight('centerTop') - this.getImageHeight('bottom')-6-this.getImageHeight('naviTopOut')-this.getImageHeight('naviBottomOut');
		document.getElementById(this.id + "_naviPointsDiv").style.width = this.getImageWidth('naviMiddle');
	};

	if (document.getElementById(this.id + "_naviBarTableTop")){
		document.getElementById(this.id + "_naviBarTableTop").style.height = this.getImageHeight('naviTopOut');
		document.getElementById(this.id + "_naviBarTableTop").style.width = this.getImageWidth('naviTopOut');
	};

	if (document.getElementById(this.id + "_naviBarTableBottom")) {
		document.getElementById(this.id + "_naviBarTableBottom").style.height = this.getImageHeight('naviBottomOut');
	};
	if (document.getElementById(this.id + "_naviBarTop")) {
		document.getElementById(this.id + "_naviBarTop").src = this.resourcesURL + this.naviTopOut;
	};
	if (document.getElementById(this.id + "_naviBarBottom")) {
		document.getElementById(this.id + "_naviBarBottom").src = this.resourcesURL + this.naviBottomOut;
	};

	if (document.getElementById(this.id + "_contentDiv")) {
		document.getElementById(this.id + "_contentDiv").style.left = 2;
		document.getElementById(this.id + "_contentDiv").style.top = this.getImageHeight('centerTop');
		this.contentTableHeight = this.h - this.getImageHeight('centerTop') - this.getImageHeight('bottom') - this.cellBorderWidth*2-1;

		document.getElementById(this.id + "_contentDiv").style.height = this.contentTableHeight;
		document.getElementById(this.id + "_contentDiv").style.width = this.w - this.getImageWidth('naviMiddle');
		document.getElementById(this.id + "_contentDiv").style.clip = 'rect(0px '+eval(this.w - this.getImageWidth('naviMiddle')-6)+' '+this.contentTableHeight+'px 0px)';
	};

	if (document.getElementById(this.id + "_naviBarTableMiddleTD")) {
		document.getElementById(this.id + "_naviBarTableMiddleTD").style.backgroundImage = 'url("'+this.resourcesURL + this.naviMiddle+'")';
	};

	if(document.getElementById(this.id + "_naviBarDiv")) {
		document.getElementById(this.id + "_naviBarTop").width = this.getImageWidth('naviTopOut');
		document.getElementById(this.id + "_naviBarTop").height = this.getImageHeight('naviTopOut');

		document.getElementById(this.id + "_naviBarBottom").width = this.getImageWidth('naviBottomOut');
		document.getElementById(this.id + "_naviBarBottom").height = this.getImageHeight('naviBottomOut');

		document.getElementById(this.id + "_naviBarDiv").style.top = 2 + this.getImageHeight('centerTop');
		document.getElementById(this.id + "_naviBarDiv").style.left = this.w - this.getImageWidth('naviMiddle')-4;
		document.getElementById(this.id + "_naviBarDiv").style.height = this.h - this.getImageHeight('centerTop') - this.getImageHeight('bottom')-6;
		document.getElementById(this.id + "_naviBarDiv").style.width = this.getImageWidth('naviMiddle');
	};

	if (this.showMove && PageInterface.GetValue("state") != psDesigning) {
		document.getElementById(this.id + "_moveDIV").style.left = this.w;
	};

	if (document.getElementById(this.id + "_shadowLeftImg")) {
		document.getElementById(this.id + "_shadowLeftImg").src = this.resourcesURL + this.shadowLeft;
	};
	if (document.getElementById(this.id + "_shadowRightImg")) {
		document.getElementById(this.id + "_shadowRightImg").src = this.resourcesURL + this.shadowRight;
	};
};

componentInfoPanel.prototype.getStepsDivLeft = function(obj)
{
	return this.w - this.getImageWidth('leftSteps') - this.getImageWidth('centerSteps') - this.getImageWidth('rightSteps') - this.buttonCloseX - 10;
};

componentInfoPanel.prototype.getStepsDivWidth = function(obj)
{
	return this.getImageWidth('leftSteps') + this.getImageWidth('centerSteps') + this.getImageWidth('rightSteps');
};

componentInfoPanel.prototype.getFeedbackImages = function(obj)
{
	this.feedbacksImagesArr['correct'] = new Array();
	this.feedbacksImagesArr['notCorrYet'] = new Array();
	this.feedbacksImagesArr['incorrect'] = new Array();

	this.feedbacksImagesArr['correct'][0] = this.feedbackOkHeader;
	this.feedbacksImagesArr['correct'][1] = this.feedbackOkBckg;

	this.feedbacksImagesArr['notCorrYet'][0] = this.feedbackTryHeader;
	this.feedbacksImagesArr['notCorrYet'][1] = this.feedbackTryBckg;

	this.feedbacksImagesArr['incorrect'][0] = this.feedbackBadHeader;
	this.feedbacksImagesArr['incorrect'][1] = this.feedbackBadBckg;
};

componentInfoPanel.prototype.onShow = function(obj)
{
	if (this.showMove && PageInterface.GetValue("state") != psDesigning){
		var moveDIV = document.getElementById(this.id + "_moveDIV");
		this.iTimerID = setTimeout('pc.'+this.id+'.moveDivLeft();', 100);
	};
};

componentInfoPanel.prototype.onHide = function(obj)
{
	if (this.showMove) {
		var moveDIV = document.getElementById(this.id + "_moveDIV");
		moveDIV.style.left = this.w;
	};
};

componentInfoPanel.prototype.moveDivLeft = function(obj)
{
	var moveDIV = document.getElementById(this.id + "_moveDIV");
	var left = moveDIV.style.left.replace('px', '');

	if (left > 0) {
		this.iTimerID = null;
		if ((parseInt(left) - 5) > 0 && (parseInt(left) - this.moveSpeed) > 0) {
			moveDIV.style.left = parseInt(left) - this.moveSpeed;
		} else {
			moveDIV.style.left = 0;
		};
		this.iTimerID = setTimeout('pc.'+this.id+'.moveDivLeft();', 100);
	};
};

componentInfoPanel.prototype.onAfterLoad = function(obj)
{
	if (page.pageType == 'Exercise' && this.showFeedbackHere == 1) {
		for (var i=0; i < page.children.length; i++) {
			var obj = page.children[i];
			if (obj.type == 'componentFeedback'){
				if (!this.feedbacksArr[obj.id]) {
					this.feedbacksArr[obj.id] = new Array();
				};
				if (obj.execution) {
					this.feedbacksArr[obj.id] = page.children[i].textText;
				} else {
					this.feedbacksArr[obj.id] = page.children[i].text.text;
				};
				obj.infoPanel = this;
				obj.show = this.showCorrectFeedback;
			};
		};
		this.getFeedbackImages();
	};
};

componentInfoPanel.prototype.getDivHeight = function(obj)
{
	var height = obj.style.height;
	height = height.replace('px', '');
	return height;
};

componentInfoPanel.prototype.getDivWidth = function(obj)
{
	var img = new Image();
	img.src = this.resourcesURL + imgName;
	return img.width;
};

componentInfoPanel.prototype.getObjectHeight = function(imgName)
{
	var img = new Image();
	img.src = this.resourcesURL + imgName;
	return img.height;
};

componentInfoPanel.prototype.getObjectWidth = function(imgName)
{
	var img = new Image();
	img.src = this.resourcesURL + imgName;
	return img.width;
};

componentInfoPanel.prototype.setObjectHeight = function(obj, imgName)
{
	var img = new Image();
	img.src = this.resourcesURL + imgName;
	obj.style.height = img.height;
};

componentInfoPanel.prototype.setObjectTop = function(obj, maxH, imgName)
{
	var img = new Image();
	img.src = this.resourcesURL + imgName;
	obj.style.top = maxH - img.height;
};

componentInfoPanel.prototype.setObjectWidth = function(obj, imgLeft, imgCenter, imgRight)
{
	var width = 0;
	var img = new Image();
	img.src = this.resourcesURL + imgLeft;
	width += img.width;

	img.src = this.resourcesURL + imgCenter;
	width += img.width;

	img.src = this.resourcesURL + imgRight;
	width += img.width;
	obj.style.width = width;
};

componentInfoPanel.prototype.setMiddleDivHeight = function(middleDiv, topDiv, bottomDiv)
{
	var topH = topDiv.style.height.replace('px', '');
	var bottH = bottomDiv.style.height.replace('px', '');

	var height = this.h - topH - bottH;
	middleDiv.style.height = height;
};

componentInfoPanel.prototype.setStepsTextArr = function(content)
{
	var stepsText = unescape(content);
	var stepsArr = stepsText.split('||');
	for (var i=0; i < stepsArr.length; i++){
		var oneStepArr = stepsArr[i].split('#!#');
		this.stepsTextArr[oneStepArr[0]] = oneStepArr[1];
	};
};

componentInfoPanel.prototype.makeNaviPoints = function(count)
{
	var table = document.getElementById(this.id + "_naviPointsTable");

	for (var i=0; i < this.pageStepsCount; i++) {
		var index = table.rows.length;
		var row = table.insertRow(index);
		row.style.height = 15;
		row.style.width = '100%';
		row.style.cursor = 'pointer';
		var cell = row.insertCell(0);
		cell.align = 'left';
		cell.valign = 'middle';
		cell.innerHTML = '<img id="'+this.id+'_naviPoint_'+i+'" src="'+this.resourcesURL+this.pointNotVisited+'" onClick="pc.'+this.id+'.changeDisplayStep('+this.cellsNo+', '+i+')">'
	};
};

componentInfoPanel.prototype.makeTRInTable = function(count)
{
	var sepH = 3;//this.getImageHeight('___.infoPanel.rowSep.gif');
	var table = document.getElementById(this.id + "__contentTable");
	var rowLength = eval(2*count-1);
	var rowHeight = parseInt((this.contentTableHeight-(count-1)*sepH)/count);

	for (var i=0; i < rowLength; i++){
		var index = table.rows.length;
		var row = table.insertRow(index);
		var cell = row.insertCell(0);
		cell.id = this.id+'_contentTD_'+i;
		if (i % 2 == 0) {
			cell.style.height = rowHeight;
		};
	};
	table.border = this.cellBorderWidth;
	table.borderColor = this.cellBorderColor;
};

componentInfoPanel.prototype.getObjectTDToArray = function(count)
{
	for (var i=0; i < eval(2*count-1); i++){
		this.tdArray[i] = document.getElementById(this.id + "_contentTD_"+i);
	};
};

componentInfoPanel.prototype.getObjectPointToArray = function(count)
{
	for (var i=0; i < count; i++) {
		this.naviPointsArray[i] = document.getElementById(this.id + "_naviPoint_"+i);
	};
};

componentInfoPanel.prototype.onPaint = function()
{
	this.setHTMLObiekts();
	this.fillTableTD(this.cellsNo, page.stepIndex);
};

componentInfoPanel.prototype.changeDisplayStep = function(count, actual)
{
	//if (actual < page.stepIndex) 
	this.fillTableTD(count, actual);
};

componentInfoPanel.prototype.fillTableTD = function(count, actual)
{
	if (typeof(this.stepText) == 'undefined') return;
	var text = this.stepText.replace('[step]', eval(actual+1));

	if (this.pageStepsCount > 0) text = text.replace('[max_step]', this.pageStepsCount); else text = text.replace('[max_step]', 0);

	var font = this.getProjectFont(this.otherAllowGF == 1, this.otherFontFamily, this.otherFontSize, this.otherFontColor );

	var beginFontTAG = '<font style="font-family:'+font.family+'; font-size:'+getFontSize(font.size, "px")+'px;';
	beginFontTAG += ' color:' + font.color + ';">';
	var endFontTAG = '</font>';
	var sepH = 3;//this.getImageHeight('___.infoPanel.rowSep.gif');

	var stepText = document.getElementById(this.id + "_stepText");
	if (stepText) stepText.innerHTML = beginFontTAG + text + endFontTAG;

	var index = 0;
	if (this.tdArray != ''){
		if ((actual == 0 || actual == 1) || count == 1){
			for (var i=0; i < eval(2*count-1); i++){
				if (i%2 == 1) {
					this.tdArray[i].innerHTML = '<img src="'+this.resourcesURL+'___.infoPanel.rowSep.gif" width="'+eval(this.w - this.getImageWidth('naviMiddle'))+'">';
				} else {
					if (typeof(this.stepsTextArr[eval(index+1)]) != 'undefined' && typeof(this.stepsTextArr[eval(actual+1)]) != 'undefined'){
						if (count == 1) {
							this.tdArray[i].innerHTML = this.stepsTextArr[eval(actual+1)];
						} else {
							this.tdArray[i].innerHTML = this.stepsTextArr[eval(index+1)];
						};
					} else {
						this.tdArray[i].innerHTML = '&nbsp;';
					};
					if (actual == index || count == 1) {
						this.tdArray[i].style.backgroundColor = this.actualRowColor;
					} else {
						this.tdArray[i].style.backgroundColor = this.otherRowColor;
					};
					index++;
				};
			};
		} else {
			for (var i=0; i < eval(2*count-1); i++) {
				if (i%2 == 1) {
					this.tdArray[i].innerHTML = '<img src="'+this.resourcesURL+'___.infoPanel.rowSep.gif" width="'+eval(this.w - this.getImageWidth('naviMiddle'))+'">';
				} else {
					if (typeof(this.stepsTextArr[eval(actual+index)]) != 'undefined') {
						this.tdArray[i].innerHTML = this.stepsTextArr[eval(actual+index)];
					} else {
						this.tdArray[i].innerHTML = '&nbsp;';
					};
					if (index == 1) {
						this.tdArray[i].style.backgroundColor = this.actualRowColor;
					} else {
						this.tdArray[i].style.backgroundColor = this.otherRowColor;
					};
					index++;
				}
			};
		};
	};

	var sepH = 3;//this.getImageHeight('___.infoPanel.rowSep.gif');
	var rowLength = eval(2*count-1);
	var rowHeight = parseInt((this.contentTableHeight-(count-1)*sepH)/count);

	this.showShadows(rowHeight, actual, sepH, count);
	this.actualDisplayStep = actual;
};

componentInfoPanel.prototype.changePointsGraphics = function(actual)
{
	for (var i=0; i < this.naviPointsArray.length; i++) {
		if (i == 0 || i <= actual) {
			this.naviPointsArray[i].src = this.resourcesURL+this.pointVisited;
		} else {
			this.naviPointsArray[i].src = this.resourcesURL+this.pointNotVisited;
		};
	};
};

componentInfoPanel.prototype.onStep = function()
{
	if (this.runStepsInPanel) {
		if (page.stepIndex == 0) return;
		this.fillTableTD(this.cellsNo, page.stepIndex-1);
		this.changePointsGraphics(page.stepIndex-1);
	};
};

componentInfoPanel.prototype.displayPrevStep = function()
{
	if (this.actualDisplayStep-1 > -1) this.fillTableTD(this.cellsNo, this.actualDisplayStep-1);
};

componentInfoPanel.prototype.displayNextStep = function()
{
	if (this.actualDisplayStep < this.pageStepsCount) this.fillTableTD(this.cellsNo, this.actualDisplayStep+1);
};

componentInfoPanel.prototype.printPreview = function()
{
	var sepH = 3;//this.getImageHeight('___.infoPanel.rowSep.gif');
	var inner = '';
	var index = 0;

	inner += '<style type="text/css">.P { margin: 0px;}</style>';
	inner += '<table width="100%" height="100%" >';

	inner += '<img src="'+this.resourcesURL+'___.infoPanel.rowSep.gif" width="100%">';
	for (var i=0; i < this.stepsTextArr.length; i++) {
		if (typeof(this.stepsTextArr[i]) != 'undefined') {
			inner += '<tr><td>';
			inner += this.stepsTextArr[i];
			inner += '</td></tr>';
			inner += '<tr height="'+sepH+'px"><td>';
			inner += '<img src="'+this.resourcesURL+'___.infoPanel.rowSep.gif" width="100%">';
			inner += '</td></tr>';
		}
	};
	inner += '</table>';

	var win = window.open("","_blank","toolbar=no, location=no, directories=no, status=no, menubar=yes, scrollbars=yes, resizable=yes, copyhistory=no, width=600, height=300");
	win.document.write(inner);
};

componentInfoPanel.prototype.recountTRInTable = function(count)
{
	var sepH = 3;//this.getImageHeight('___.infoPanel.rowSep.gif');
	var rowLength = eval(2*count-1);
	var rowHeight = parseInt((this.contentTableHeight-(count-1)*sepH)/count);

	for (var i=0; i < rowLength; i++){
		if (i % 2 == 0) {
			this.tdArray[i].style.height = rowHeight;
		};
	};
	this.showShadows(rowHeight, this.actualDisplayStep, sepH);
};

componentInfoPanel.prototype.showShadows = function(rowH, ind, sepH)
{
	var shadowLW = 8;//this.getImageWidth('shadowLeft');
	var shadowRW = 8;//this.getImageWidth('shadowRight');

	var centerTopH = this.getImageHeight('centerTop');
	var naviMiddleW = this.getImageWidth('naviMiddle');

	var shadowLeftDiv = document.getElementById(this.id + "_shadowLeftDiv");
	var shadowRightDiv = document.getElementById(this.id + "_shadowRightDiv");

	if (this.cellsNo != 1) var moveDown = rowH+sepH; else var moveDown = 0;

	if (shadowLeftDiv) {
		shadowLeftDiv.style.left = 1;
		shadowLeftDiv.style.top = centerTopH + moveDown;
		shadowLeftDiv.style.width = shadowLW;
		shadowLeftDiv.style.height = rowH;
		shadowLeftDiv.style.clip = 'rect(0px '+shadowLW+'px '+rowH+'px 0px)';
	};
};

componentInfoPanel.prototype.showCorrectFeedback = function()
{
	var td           = document.getElementById(this.infoPanel.id + "_feedbackTableTD");
	var middleTable  = document.getElementById(this.infoPanel.id + "_middleTableDiv");
	var content 	 = document.getElementById(this.infoPanel.id + "_contentDiv");
	var contentTable = document.getElementById(this.infoPanel.id + "__contentTable");
	var topTable     = document.getElementById(this.infoPanel.id + "_topTableDiv");
	var bottomTable  = document.getElementById(this.infoPanel.id + "_bottomTableDiv");
	var naviBarTable = document.getElementById(this.infoPanel.id + "_naviBarDiv");

	//td.width = this.infoPanel.w;
	var lastHeight = bottomTable.offsetHeight;
	var corAns = page.solved;
	var ans = Math.floor((page.maxScore / page._countQuestion) * page._countCorrectQuestion);
	var corAns = (page.answerWeighting)?(ans >= page.masteryScore):(ans == page.maxScore);

	if (page.countAnswers > 0) {
		if (corAns) {
			var headerGraph = this.infoPanel.feedbacksImagesArr['correct'][0];
			var bckgGraph = this.infoPanel.feedbacksImagesArr['correct'][1];
		} else {
			var headerGraph = this.infoPanel.feedbacksImagesArr['notCorrYet'][0];
			var bckgGraph = this.infoPanel.feedbacksImagesArr['notCorrYet'][1];
		};
	} else {
		if (corAns) {
			var headerGraph = this.infoPanel.feedbacksImagesArr['correct'][0];
			var bckgGraph = this.infoPanel.feedbacksImagesArr['correct'][1];
		} else { 
			var headerGraph = this.infoPanel.feedbacksImagesArr['incorrect'][0];
			var bckgGraph = this.infoPanel.feedbacksImagesArr['incorrect'][1];
		};
	};

	if (!this.infoPanel.isFeedbackDisplayed) {
		var s = '';
		s += '<table id="'+this.infoPanel.id+'_feedbackTable" cellpadding="0" cellspacing="0" height="100%" width="100%">';
		s += '<tr id="'+this.infoPanel.id+'_feedbackTableTop">';
		s += '<td width="100%">';
		s += '<img id="'+this.infoPanel.id+'_feedbackTop" src="'+this.infoPanel.resourcesURL + headerGraph+'" height="100%" width="100%">';
		s += '</td>';
		s += '</tr>';
		s += '<tr id="'+this.infoPanel.id+'_feedbackTableBottom">';
		s += '<td width="100%">';
		s += '<img id="'+this.infoPanel.id+'_feedbackBottom" src="'+this.infoPanel.resourcesURL + bckgGraph+'" height="100%" width="100%">';
		s += '</td>';
		s += '</tr>';
		s += '</table>';
		td.innerHTML = s; 

		var feedbackTop  = document.getElementById(this.infoPanel.id + "_feedbackTop");
		var feedbackBottom  = document.getElementById(this.infoPanel.id + "_feedbackBottom");

		feedbackTop.style.height = this.infoPanel.getObjectHeight(this.infoPanel.feedbackOkHeader);
		feedbackBottom.style.height = this.infoPanel.getObjectHeight(this.infoPanel.feedbackOkBckg);

		var headerHeight = this.infoPanel.getObjectHeight(this.infoPanel.feedbackOkHeader);
		var bckgHeight = this.infoPanel.getObjectHeight(this.infoPanel.feedbackOkBckg);

		var tdHeight = headerHeight + bckgHeight;
		td.style.height = tdHeight;

		var height = this.infoPanel.h - topTable.offsetHeight - tdHeight - lastHeight+1;
		this.infoPanel.contentTableHeight = height;

		middleTable.style.height = height;
		content.style.height = height-5;
		contentTable.height = height-5;
		var width = eval(this.infoPanel.w - this.infoPanel.getObjectWidth(this.infoPanel.naviMiddle)-6);

		content.style.clip = 'rect(0px '+width+'px '+eval(height-5)+'px 0px)';
		naviBarTable.style.height = height-4;

		this.infoPanel.recountTRInTable(this.infoPanel.cellsNo);
		this.infoPanel.isFeedbackDisplayed = true;
	} else {
		document.getElementById(this.infoPanel.id + "_feedbackTop").src = this.infoPanel.resourcesURL + headerGraph;
		document.getElementById(this.infoPanel.id + "_feedbackBottom").src = this.infoPanel.resourcesURL + bckgGraph;

		var headerHeight = this.infoPanel.getObjectHeight(this.infoPanel.feedbackOkHeader);
		var bckgHeight = this.infoPanel.getObjectHeight(this.infoPanel.feedbackOkBckg);
		var tdHeight = headerHeight + bckgHeight;

		var height = this.infoPanel.h - topTable.offsetHeight - tdHeight - lastHeight;
	};

	var feedbackText = this.infoPanel.feedbacksArr[this.id];
	this.infoPanel.setFeedbackText(this.infoPanel.contentTableHeight+topTable.offsetHeight, headerHeight, feedbackText,  this.infoPanel.feedbackHeaderText, bckgHeight);
};

componentInfoPanel.prototype.setFeedbackText = function(top, height, feedbackHeaderText, feedbackCommentText, bckgHeight)
{
	var headerDiv = document.getElementById(this.id + "_feedbackHeaderTextDiv");
	var textDiv = document.getElementById(this.id + "_feedbackTextDiv");
	var headerText = document.getElementById(this.id + "_feedbackText");
	var commentText = document.getElementById(this.id + "_feedbackHeaderText");
	var bottomDiv = document.getElementById(this.id + "_bottomTableDiv");
	var closeFeedback  = document.getElementById(this.id + "_closeFeedbackDIV");

	closeFeedback.style.top = top;
	closeFeedback.style.visibility = 'inherit';

	headerDiv.style.top = top;
	headerDiv.style.height = height;
	headerDiv.style.visibility = 'inherit';

	textDiv.style.top = top+height;
	textDiv.style.height = bckgHeight;
	textDiv.style.visibility = 'inherit';

	var font = this.getProjectFont(this.otherAllowGF == 1, this.otherFontFamily, this.otherFontSize, this.otherFontColor );

	var beginFontTAG = '<font style="font-family:'+font.family+'; font-size:'+getFontSize(font.size, "px")+'px;';
	beginFontTAG += ' color:' + font.color + ';">';
	var endFontTAG = '</font>';

	headerText.innerHTML = beginFontTAG + feedbackHeaderText + endFontTAG;
	commentText.innerHTML = beginFontTAG + feedbackCommentText + endFontTAG;
};

componentInfoPanel.prototype.hideFeedback = function()
{
	var headerDiv = document.getElementById(this.id + "_feedbackHeaderTextDiv");
	var textDiv = document.getElementById(this.id + "_feedbackTextDiv");
	var closeFeedback  = document.getElementById(this.id + "_closeFeedbackDIV");
	var feedbackTableTD  = document.getElementById(this.id + "_feedbackTableTD");
	var contentDiv  = document.getElementById(this.id + "_contentDiv");
	var contentTable  = document.getElementById(this.id + "__contentTable");
	var middleTable  = document.getElementById(this.id + "_middleTableDiv");
	var naviBarTable  = document.getElementById(this.id + "_naviBarDiv");
	var bottomTable  = document.getElementById(this.id + "_bottomTable");

	this.contentTableHeight = this.h - this.getImageHeight('centerTop') - this.getImageHeight('bottom') - this.cellBorderWidth*2-1;

	contentDiv.style.height = this.contentTableHeight;
	contentDiv.style.width = this.w - this.getImageWidth('naviMiddle')-6;

	var width = eval(this.w - this.getImageWidth('naviMiddle')-6);
	contentDiv.style.clip = 'rect(0px '+width+'px '+this.contentTableHeight+'px 0px)';
	contentTable.height = this.contentTableHeight;
	middleTable.style.height = this.contentTableHeight;
	naviBarTable.style.height = this.contentTableHeight-4;

	closeFeedback.style.visibility = 'hidden';
	headerDiv.style.visibility = 'hidden';
	textDiv.style.visibility = 'hidden';

	feedbackTableTD.innerHTML = '';
	feedbackTableTD.style.height = 0;

	this.recountTRInTable(this.cellsNo);

	this.isFeedbackDisplayed = false;
};

componentInfoPanel.prototype.changeImage = function(obj, imageName)
{
	obj.src = this.resourcesURL + imageName;
};

componentInfoPanel.prototype.onFree = function()
{
	if (this.iTimerID != null) window.clearTimeout(this.iTimerID);
};

componentInfoPanel.prototype.getProjectFont = function(fontGlobalFormating, family, size, color)
{
	var font = {};
	font.family = family;
	font.size = size;
	font.color = color;

	if (fontGlobalFormating && project.globalFormating) {
		font.family = project.font.family;
		font.size = project.font.size;
		font.color = project.font.color;
	};

	return font;
};

componentInfoPanel.prototype.getImageHeight = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][1]);
	/*
	var preloadDIV = document.getElementById(this.id + "_preloadDIV");
	var preloadImg = document.getElementById(this.id + "_preloadImg");

	preloadImg.src = this.resourcesURL + imgName;

	return preloadDIV.offsetHeight;
	*/
};

componentInfoPanel.prototype.getImageWidth = function( imgName )
{
	return parseInt(this.imagesCompleteInfo[imgName][0]);
	/*
	var preloadDIV = document.getElementById(this.id + "_preloadDIV");
	var preloadImg = document.getElementById(this.id + "_preloadImg");

	preloadImg.src = this.resourcesURL + imgName;

	return preloadDIV.offsetWidth;
	*/
};
