/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentMail = function(name) {
	this.componentElement = componentImage;
	this.componentElement(name);
};

componentMail.prototype = new componentImage();
componentMail.prototype.type = "componentMail";

componentMail.prototype.onBaseCreate = function(obj)
{
    this.resourcesURL = unescape(this.resourcesURL);
	this.captureMouseEvents();
};

componentMail.prototype.openWin = function(urlname,xpos,ypos,w,h,windowParam,windowName) 
{
	var newWindowPointer = null;
	x = xpos;
	y = ypos;

	if (!xpos) x = 100;
	if (!ypos) y = 100;
	if (!w) w = 400;
	if (!h) h = 300;

	if (!windowParam) windowParam = "resizable=yes";
	if (!windowName) windowName = "subWindow";

	if (newWindowPointer != null && newWindowPointer.closed==false) {
		newWindowPointer.close();
	};

	newWindowPointer=window.open(urlname, windowName, "width=" + w + ",height=" + h + ",screenX=" + x + ",screenY=" + y + "," + windowParam + "");
	newWindowPointer.moveTo(x,y);
	newWindowPointer.focus();
	return (newWindowPointer);
};

componentMail.prototype.sendMail = function() 
{
	var emailText;	
	var fieldName;
	var formValue;
	var str;	
	var counter = 1;
	var mailWindow = null;
	var nextLine = "\n";

	appVer = navigator.appVersion;
	var mailF = "";
	if (appVer.indexOf("MSIE 5.0") > -1) nextLine="%0A";
	mailF = this.mailFormat;
	var textStart = mailF.replace( /(.*)(\[START\])(.*)(\[END\])(.*)/ig ,"$1");
	var textEl    = mailF.replace( /(.*)(\[START\])(.*)(\[END\])(.*)/ig ,"$3");
	var textEnd   = mailF.replace( /(.*)(\[START\])(.*)(\[END\])(.*)/ig ,"$5");
	var elementsAll = "";

	var val = "";
	emailText = textStart;

	if (!this.noTextInMail) {
		for (var i=0; i<page.children.length; i++) {
			if (page.children[i].type == 'componentText' || page.children[i].type == 'componentTextarea' ||
				page.children[i].type == 'componentInput' || page.children[i].type == 'componentCheckBox' ||
				page.children[i].type == 'componentRadioButton' || page.children[i].type == 'componentCheckBoxLight' ||
				page.children[i].type == 'componentRadioButtonLight' || page.children[i].type == 'componentCombo' ||
				page.children[i].type == 'componentList' || page.children[i].type == 'componentChoice' ||
				page.children[i].type == 'componentSingleChoice' || page.children[i].type == "componentChoiceLight" || 
				page.children[i].type == "componentSingleChoiceLight")
			{
				if (!this.isOnTheList(page.children[i].id)) {
					switch(page.children[i].type) {
						case 'componentText':
							val = page.children[i].text.replace(/(<[^<>]*>)/ig,"");
							break;
						case 'componentTextarea':
							val = document.getElementById(page.children[i].id+"Form").elements[0].value;
							break;
						case 'componentInput':
							val = document.getElementById(page.children[i].id+"_contentObj").value;
							break;
						case ('componentCheckBox'):
							val = page.children[i].checked;
							break;
						case 'componentRadioButton':
							val = page.children[i].checked;
							break;
						case 'componentCheckBoxLight':
							val = document.getElementById("inputCheckBox_"+page.children[i].id).checked;
							break;
						case 'componentRadioButtonLight':
							val = document.getElementById("inputRadioButton_"+page.children[i].id).checked;
							break;
						case 'componentCombo':
							var obj = document.getElementById(page.children[i].id+"Select");
							if (obj && obj.selectedIndex != -1) val = obj.options[obj.selectedIndex].text; else val = ""; //pg2-if obj
							break;
						case 'componentList':
							var obj = document.getElementById(page.children[i].id+"Select");
							if (obj && obj.selectedIndex != -1) val = obj.options[obj.selectedIndex].text; else val = ""; //pg2-if obj
							break;
						case 'componentChoice':
							val = "";
							var imgChecked = resourcesURL + page.children[i].imgChecked;
							for (var j in document.getElementById(page.children[i].id).getElementsByTagName("img"))
							if (j != 'length') if (document.getElementById(page.children[i].id).getElementsByTagName("img")[j].src == imgChecked) {
								var nameID = document.getElementById(page.children[i].id).getElementsByTagName("img")[j].name.match(/[0-9]*$/);
								if (val == "") val += document.getElementById(page.children[i].id+"_text_"+nameID).innerHTML;
								else val += ", "+document.getElementById(page.children[i].id+"_text_"+nameID).innerHTML;
							};
							break;
						case 'componentSingleChoice':
							val = "";
							var imgChecked = resourcesURL + page.children[i].imgChecked;
							for (var j in document.getElementById(page.children[i].id).getElementsByTagName("img"))
							if (j != 'length') if (document.getElementById(page.children[i].id).getElementsByTagName("img")[j].src == imgChecked) {
								var nameID = document.getElementById(page.children[i].id).getElementsByTagName("img")[j].name.match(/[0-9]*$/);
								val += document.getElementById(page.children[i].id+"_text_"+nameID).innerHTML;
							};
							break;
						case 'componentChoiceLight':
							val = "";
							for (var j in document.getElementById(page.children[i].id).getElementsByTagName("input"))
							if (j != 'length')
							if (document.getElementById(page.children[i].id).getElementsByTagName("input")[j].checked) {
								var nameID = document.getElementById(page.children[i].id).getElementsByTagName("input")[j].name.match(/[0-9]*$/);
								if (val == "") val += document.getElementById(page.children[i].id+"_text_"+nameID).innerHTML;
								else val += ", "+document.getElementById(page.children[i].id+"_text_"+nameID).innerHTML;
							};
							break;
						case 'componentSingleChoiceLight':
							val = "";
							var obj = document.getElementById(page.children[i].id).getElementsByTagName("input");
							for (var j = 0; j < obj.length; j++) {
								if (j != 'length') if (obj[j].checked) {
									var nameID = obj[j].id.match(/[0-9]*$/);
									val += document.getElementById(page.children[i].id+"_text_"+nameID).innerHTML;
								};
							};
							break;
					};

					var textElBefore = textEl.replace(/(.*)(\[ELEMENT\])(.*)/ig,"$1");
					var textElAfter = textEl.replace(/(.*)(\[ELEMENT\])(.*)/ig,"$3");

					var objName = page.children[i].id.replace('__bckg_', '');
					emailText = emailText + textElBefore + objName + " = " + val + textElAfter + '\n\n';	
					counter++;
				};
			};
		};
	};
	emailText += textEnd;

	emailText = emailText.replace(/<BR>/ig, nextLine);
	emailText = emailText.replace(/&/ig, 'and');
	if (top.isWBTServer && !this.noTextInMail) {
		//mailWindow = this.openWin("/4ses/servlet/MainServlet?method=lms.SendMail&email="+this.email+"&title=" + "E-mail from "+page.name + "&mailBody=" + emailText,5,5,100,100,"resizable=yes","mailWindow"); //pg2-removed
		//pg2-kancelaria-new
		var emailBody = emailText;
		try {
			emailBody = emailBody.replace(/ą/ig, 'a');
	        emailBody = emailBody.replace(/Ą/ig, 'A');
	        emailBody = emailBody.replace(/ć/ig, 'c');
	        emailBody = emailBody.replace(/Ć/ig, 'C');
	        emailBody = emailBody.replace(/ę/ig, 'e');
	        emailBody = emailBody.replace(/Ę/ig, 'E');
	        emailBody = emailBody.replace(/ł/ig, 'l');
	        emailBody = emailBody.replace(/Ł/ig, 'L');
	        emailBody = emailBody.replace(/ń/ig, 'n');
	        emailBody = emailBody.replace(/Ń/ig, 'N');
	        emailBody = emailBody.replace(/ó/ig, 'o');
	        emailBody = emailBody.replace(/Ó/ig, 'O');
	        emailBody = emailBody.replace(/ś/ig, 's');
	        emailBody = emailBody.replace(/Ś/ig, 'S');
	        emailBody = emailBody.replace(/ż/ig, 'z');
	        emailBody = emailBody.replace(/Ż/ig, 'Z');
	        emailBody = emailBody.replace(/ź/ig, 'z');
	        emailBody = emailBody.replace(/Ź/ig, 'Z');
	        emailBody = emailBody.replace(/&/ig, 'and');
	        emailBody = emailBody.replace(new RegExp('&nbsp;', 'g'), ' ');
	        emailBody = emailBody.replace(new RegExp('&nbsp', 'g'), ' ');
	        emailBody = emailBody.replace(new RegExp('&amp;', 'g'), 'and');
	        emailBody = emailBody.replace(new RegExp('&amp', 'g'), 'and');
	        emailBody = emailBody.replace(new RegExp('\n', 'g'), '<br>');
		} catch(e) {};

		var emailTitle = '';
		var uelo = getUELO();
		if (uelo) {
			var p = uelo.FindPage(page.p_globalIndex);
			if (p) emailTitle = p.title;
		};
		try {
			emailTitle = emailTitle.replace(/ą/ig, 'a');
	        emailTitle = emailTitle.replace(/Ą/ig, 'A');
	        emailTitle = emailTitle.replace(/ć/ig, 'c');
	        emailTitle = emailTitle.replace(/Ć/ig, 'C');
	        emailTitle = emailTitle.replace(/ę/ig, 'e');
	        emailTitle = emailTitle.replace(/Ę/ig, 'E');
	        emailTitle = emailTitle.replace(/ł/ig, 'l');
	        emailTitle = emailTitle.replace(/Ł/ig, 'L');
	        emailTitle = emailTitle.replace(/ń/ig, 'n');
	        emailTitle = emailTitle.replace(/Ń/ig, 'N');
	        emailTitle = emailTitle.replace(/ó/ig, 'o');
	        emailTitle = emailTitle.replace(/Ó/ig, 'O');
	        emailTitle = emailTitle.replace(/ś/ig, 's');
	        emailTitle = emailTitle.replace(/Ś/ig, 'S');
	        emailTitle = emailTitle.replace(/ż/ig, 'z');
	        emailTitle = emailTitle.replace(/Ż/ig, 'Z');
	        emailTitle = emailTitle.replace(/ź/ig, 'z');
	        emailTitle = emailTitle.replace(/Ź/ig, 'Z');
	        emailTitle = emailTitle.replace(/&/ig, 'and');
		} catch(e) {};

		var x = 5;
		var y = 5;
		var w = 100;
		var h = 100;
		var windowName = 'mailWindow';
		var windowParam = 'resizable=no';
		var emailAddresses = this.email; //'p.grobelny@4system.com';
		emailBody = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">' + '<html><head><title>tytul</title>' + '<meta http-equiv="content-type" content="text/html; charset=iso-8859-2" />' + '</head><body>' + emailBody + '</body></html>';
        var urlName = '/4ses/servlet/MainServlet?method=lms.SendMail&email=' + emailAddresses + '&title=' + emailTitle + '&mailBody=' + emailBody;
        var mailWindow = window.open(urlName, windowName, 'width=' + w + ',height=' + h + ',screenX=' + x + ',screenY=' + y + ',' + windowParam);
		//pg2-kancelaria_end
	} else {
		window.location="mailto:" + this.email + "?subject=" + "E-mail from "+page.name + "&body=" + emailText,5,5,100,100,"resizable=yes","mailWindow";
	};
};

componentMail.prototype.componentMailBaseEventMouseOver = componentMail.prototype.eventMouseOver;
componentMail.prototype.eventMouseOver = function(e)
{
	if (this.srcIn) this.setValue(this.resourcesURL + this.srcIn);
	return this.componentMailBaseEventMouseOver(e);
};

componentMail.prototype.componentMailBaseEventMouseOut = componentMail.prototype.eventMouseOut;
componentMail.prototype.eventMouseOut = function(e)
{
	if (this.src) this.setValue(this.resourcesURL + this.src);
	return this.componentMailBaseEventMouseOut(e);
};

componentMail.prototype.isOnTheList = function(text)
{	
	var select = this.elementsToMail.split("||");
	for (var i=0; i < select.length; i++) {
		if (select[i] == text) return true;
	};
	return false;
};

componentMail.prototype.eventClick = function(e)
{
	this.sendMail();
	return false;
};
