/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentSearchWords = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.openButton  = this.addChild(new componentButton(this.id + '_openButton')); //this.openButton = this.addChild(new componentButton(null));
	this.popup       = this.addChild(new componentPopup(this.id + '_popup')); //this.popup      = this.addChild(new componentPopup(null));
	this.text 		 = this.popup.addChild(new componentText(this.id + '_popupText')); //this.text 		= this.popup.addChild(new componentText(null));
	this.input		 = this.popup.addChild(new componentInput(this.id + '_popupInput')); //this.input		= this.popup.addChild(new componentInput(null));
	this.button 	 = this.popup.addChild(new componentButton(this.id + '_popupButton')); //this.button 	= this.popup.addChild(new componentButton(null));
	this.list 		 = this.popup.addChild(new componentText(this.id + '_popupList')); //this.list 		= this.popup.addChild(new componentText(null));
	this.warningText = this.addChild(new componentText(this.id + '_warningText')); //this.warningText= this.addChild(new componentText(null));
	
	this.input.borderColor = '#000000';
	this.input.fontFamily = 'Arial';
	this.input.fontSize = '2';
	this.input.fontColor = '#000000';
	this.input.textAlign = 'left';
	this.list.valign = 'top';

	this.input.fnOnFocusIn = this.inputFocusIn;
	this.input.fnOnFocusOut = this.inputFocusOut;

	this.button.stopPropagation = true;
	this.button.onClick = this.buttonClick;

	this.openButton.onClick = this.openButtonClick;
	this.openButton.standardButton = false;

	this.popup.buttonCross.onClick = this.buttonCrossClick;
	this.popup.buttonVisible = false;
	this.popup.text.text = "";

	this.font = {};
	this.font.family = 'Arial';
	this.font.size = 2;
	this.font.color = '#000000';

	this.searchingInProgress = false;
};

componentSearchWords.prototype = new componentElement();
componentSearchWords.prototype.type = "componentSearchWords";

componentSearchWords.prototype.onCreate = function(obj)
{
	var width = this.list.w - 2 * this.popup.borderWidth;
	var height = this.list.h - 2 * this.popup.borderWidth;

	this.font = getProjectFont(this.allowGF == 1, this.textFontFamily, this.textFontSize, this.textFontColor );
	this.popup.buttonCross.onMouseDown = this.buttonCrossClick;

	this.input.x = this.text.w;
	this.input.y = this.button.y;
	this.popup.w = this.width;
	this.popup.h = this.height - this.openButton.h - 5;
	this.list.w = this.popup.w - 2 * this.popup.borderWidth;
	this.list.h = eval(this.popup.h - this.list.y);
	this.button.x = this.popup.w - this.button.w - 5;
	this.openButton.clickSrc = this.openButton.mouseOverSrc;

	this.list.text = '<input type="checkbox" id="case' + this.id + '">' + this.ignoreCaseText + '<br>';
	this.list.text += '<div size="' + this.list.listSize + '" id="search' + this.id + '" style="height:' + eval(this.list.h-this.text.h-2*this.popup.borderWidth) + 'px; width: 100%; overflow: auto;  visibility: hidden;">';
	this.list.text += '<table id="' + this.id + '_textTable" style="border: 0px solid #000000; visibility: inherit;"  border="0" cellpadding="" cellspacing="2" width="100%"></table>';
	this.list.text += '<div/>';
	
	this.imageSearch = this.addChild(new componentImage(this.id + '_searchImage')); //pg2-bsh_search_icon
	this.imageSearch.x = 0;
	this.imageSearch.y = 0;
	this.imageSearch.w = 50;
	this.imageSearch.h = 50;
	this.imageSearch.src = this.searchingInProgressSrc;
	this.imageSearch.imagesNameArr = [this.imageSearch.src];
	this.imageSearch.getPreloadImagesArr();
	this.imageSearch.x = Math.floor(this.w/2)-25;
	this.imageSearch.y = Math.floor(this.h/2)-25 + this.popup.y;
	this.imageSearch.setVisible(false);
};

componentSearchWords.prototype.onPaint = function()
{
	if (this.buttonVisible) {
		switch (this.buttonPos) {
			case 'bottomLeft':
				this.openButton.x = 0;
				this.openButton.y = this.height - this.openButton.h;
				this.popup.y = 0;
				this.warningText.x = this.openButton.w;
				this.warningText.y = this.popup.h;
				break;
			case 'bottomRight':
				this.openButton.x = this.width - this.openButton.w;
				this.openButton.y = this.height - this.openButton.h;
				this.popup.y = 0;
				this.warningText.x = 0;
				this.warningText.y = this.popup.h;
				break;
			case 'topRight':
				this.openButton.x = this.width - this.openButton.w;
				this.openButton.y = 0;
				this.popup.y = this.openButton.h + 5;
				this.warningText.x = 0;
				this.warningText.y = 0;
				break;
			default :
				this.openButton.x = 0;
				this.openButton.y = 0;
				this.popup.y = this.openButton.h + 5;
				this.warningText.x = this.openButton.w;
				this.warningText.y = 0;
				break;
		};
		this.setClip();
	} else {
		this.openButton.noDisplay();
		this.popup.x = 0;
		this.popup.y = 0;
		this.popup.w = this.w;
		this.popup.h = this.h;
		this.warningText.y = this.h - 50;
	};
};

componentSearchWords.prototype.componentSearchWordsShow = componentSearchWords.prototype.show;
componentSearchWords.prototype.show = function(e)
{
	this.componentSearchWordsShow();
	if (PageInterface.GetValue("state") == psDesigning) {
		this.warningText.show();
	} else {
		this.warningText.hide();
	};
	if (this.buttonVisible) {
		this.openButton.show();
		this.hidePopup();
	} else {
		this.showPopup();
	};
};

componentSearchWords.prototype.componentSearchWordsHide = componentSearchWords.prototype.hide;
componentSearchWords.prototype.hide = function()
{
	//this.deleteAllRows();
	this.hidePopup();
};

componentSearchWords.prototype.refreshElement = function(e)
{
	this.deleteAllRows();
	this.hidePopup();
};

componentSearchWords.prototype.setClip = function(e)
{
	if (PageInterface.GetValue("state") != psDesigning) {
		switch (this.buttonPos){
			case 'bottomLeft':
				this.obj.style.clip = 'rect(' + eval(this.h-this.openButton.h) + 'px ' + this.openButton.w + 'px ' + this.h + 'px 0px)';
				break;
			case 'bottomRight':
				this.obj.style.clip = 'rect(' + eval(this.h-this.openButton.h) + 'px ' + this.w + 'px ' + this.h + 'px ' + eval(this.w-this.openButton.w) + 'px)';
				break;
			case 'topRight':
				this.obj.style.clip = 'rect(0px ' + this.w + 'px ' + this.openButton.h + 'px ' + eval(this.w-this.openButton.w) + 'px)';
				break;
			default :
				this.obj.style.clip = 'rect(0px ' + this.openButton.w + 'px ' + this.openButton.h + 'px 0px)';
				break;
		};
	};
};

componentSearchWords.prototype.buttonClick = function(e)
{
	if (this.searchingInProgress) return; //pg2-bsh_search_icon
	
	try {
		var obj = document.getElementById('search' + this.parent.parent.id);
		var checkBox = document.getElementById('case' + this.parent.parent.id);
		var length = obj.length;

		obj.disabled = false;

		for (var i = 0; i < length; i++) obj.remove(0);

		var word = "";
		var words = "";

		var inpContentObject = this.parent.parent.input.findContentObj();
		word = inpContentObject.value;

		if (word != "") {
			this.searchingInProgress = true; //pg2-bsh_search_icon
			try {
				this.parent.parent.imageSearch.show();
			} catch(e) {};
			
			this.parent.parent.deleteAllRows();

			obj.style.visibility = "visible";

			var SW = page.getSW(); //pg2
			var words = null;
			if (SW) {
				//...
				if (!checkBox.checked) {
					words = SW.findPagesWithWord(word.toUpperCase(), 1);
				} else {
					words = SW.findPagesWithWord(word, 0);
				};

				//if (page.getSW()) {
				try {
					//pg2-bsh_search_word
					var courseVersion = '';
					try {
						if (typeof(player) == 'undefined') {
							if (typeof(PlayerInterface) != 'undefined') var player = PlayerInterface.connectedPlayer;
							if (typeof(player) == 'undefined' || player == null) var player = getPlayer();
						};
						courseVersion = player.courseVersion==0?'':player.courseVersion;
					} catch(e) {
						courseVersion = '';
					};
					//...
					
					for (var i = 0; i < words.length; i++) {
						//this.parent.parent.fillDivByPages(SW.pages[words[i]].pageName, SW.pages[words[i]].globalIndex); //pg2-bsh_search_word -removed, replaced with below one
						this.parent.parent.fillDivByPages(SW.pages[words[i]]["pageName"+courseVersion], SW.pages[words[i]].globalIndex); //pg2-bsh_search_word -page name in proper lang version
					};
				} catch(e) {
					//alert('error: ' + e.message);
				};
				//};

				if (words.length == 0) {
					this.parent.parent.fillDivByPages(this.parent.parent.textNotFound, 0);
				};
				delete words; //pg2-BSH_search_words_multiversions -cleanup
			};
		} else obj.style.visibility = "hidden";
		try {
			this.parent.parent.imageSearch.hide(); //pg2-bsh_search_icon
		} catch(e) {};
	} catch(e) {};
	this.searchingInProgress = false; //pg2-bsh_search_icon
};

componentSearchWords.prototype.fillDivByPages = function(pageName, pageId)
{
	var table 	= document.getElementById(this.id + "_textTable");

	var row 	= table.insertRow(table.rows.length);
	var cell 	= row.insertCell(0);
	if (pageId != 0) {
		cell.id = this.id + '_cell_' + pageId;
		cell.onclick = this.goToPage;
		cell.style.cursor  	= 'pointer';
	};
	cell.innerHTML 	= '<font face="' + this.font.family + '" color="' + this.font.color + '" size="' + this.font.size + '">' + pageName + '</font>';
};

componentSearchWords.prototype.deleteAllRows = function()
{
	var table 	= document.getElementById(this.id + "_textTable");
	if (!table) return;
	var length = table.rows.length;

	for (var i=0; i < length; i++) {
		table.deleteRow(0);
	};
};

componentSearchWords.prototype.goToPage = function()
{
	var arr = this.id.split('_cell_');
	var compObj = page.all[arr[0]];
	var pageGI = arr[arr.length-1];

	var pagePath = 'p00000';
	for (var i =0; i < pageGI.length; i++) pagePath = pagePath.substring(0, pagePath.length-1);


	if (compObj && compObj.openInNewWindow) {
		page.openDialog("wbtpages://" + pagePath + pageGI + "/_page.0.html", compObj.newWindowWidth, compObj.newWindowHeight, 0,0,0,1,0);
	} else {
		PlayerInterface.Execute('gotoPage', pageGI);
	};
};

componentSearchWords.prototype.hidePopup = function()
{
	var obj = document.getElementById('search' + this.parent.id);
	if (obj) {
		obj.style.visibility = "hidden";
	};
	this.popup.hide();
	this.text.hide();
	this.input.hide();
	this.button.hide();
	this.list.hide();
	this.setClip();
	if (this.input) {
		var content = this.input.findContentObj();
		if (content) content.blur(); //pg2-if
	};
	this.imageSearch.hide();
	this.searchingInProgress = false;
};

componentSearchWords.prototype.showPopup = function()
{
	if (PageInterface.GetValue("state") != psNormal) {
		this.warningText.show();
	};
	this.popup.show();
	this.obj.style.clip = 'rect(0px ' + this.w + 'px ' + this.h + 'px 0px)';
	this.input.setAnswer(this.wordToSearch);
	var content = this.input.findContentObj();
	if (content) content.style.color = '#808080'; //pg2-if
};

componentSearchWords.prototype.openButtonClick = function()
{
	if (!this.parent.popup.visible) {
		this.parent.showPopup();
	} else {
		this.parent.hidePopup();
	};
	this.parent.focusOut();
};

componentSearchWords.prototype.buttonCrossClick = function()
{
	var obj = document.getElementById('search' + this.parent.parent.id);
	if (obj) obj.style.visibility = "hidden"; //pg2-if
	this.parent.setVisible(false);
	this.parent.parent.setClip();
};

/********************************************************************/

componentSearchWords.prototype.inputFocusIn = function()
{
	var word = this.getAnswer();
	if (word == this.parent.parent.wordToSearch){
		this.isChanged = false;
		this.setAnswer('');
		var content = this.findContentObj();
		content.style.color = '#000000';
	}
}

componentSearchWords.prototype.inputFocusOut = function()
{
	var word = this.getAnswer();
	if (word == '')	{
		this.isChanged = false;
		this.setAnswer(this.parent.parent.wordToSearch);
		var content = this.findContentObj();
		if (content) content.style.color = '#808080'; //pg2-if
	};
};

componentSearchWords.prototype.focusOut = function()
{
	var content = this.input.findContentObj();
	if (content) content.blur(); //pg2-if
};
