var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var KeyboardGame;
(function (_KeyboardGame) {
    var KeyboardGame = (function (_super) {
        __extends(KeyboardGame, _super);
        function KeyboardGame(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        KeyboardGame.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        KeyboardGame.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        KeyboardGame.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            if (this.json.isFirst2 && this.json.isFirst2 == true) {
                EU.loadVocabulary(this);
            }
            ;
            this.createFillQuestion();
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
        };
        KeyboardGame.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        KeyboardGame.prototype.createFillQuestion = function () {
            this.addChild(this.game.add.image(450, 100, "kb"));
            var question;
            var flag = false;
            while (flag == false) {
                flag = true;
                this.categoryIndex = Math.floor((Math.random() * EU.groups.length));
                this.wordIndex = Math.floor((Math.random() * EU.groups[this.categoryIndex].vocabulary.length));
                EU.Log(this.categoryIndex + " " + this.wordIndex);
                question = EU.groups[this.categoryIndex].vocabulary[this.wordIndex];
                EU.Log(question);
                for (var i = 0; i < EU.usedWords.length; i++) {
                    if (EU.usedWords[i] == question) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            EU.usedWords.push(question);
            this.Qtext = this.game.add.text(840, 500, question, this.Elements.FillElements.Options.Style);
            this.Qtext.anchor.set(0.5, 0.5);
            this.addChild(this.Qtext);
            this.Elements.FillElements.el.push({
                "pos": this.Elements.Position,
                "Answer": question
            });
        };
        KeyboardGame.prototype.checkIfEverythingIsCorrect = function () {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this) && EU.checkIfFillsAreCorrect(this)) {
                EU.Log("Correct!!!");
                if (TYPE === "gm") {
                    _super.prototype.nextTask.call(this);
                }
                EU.setGameCompletion(this.parent, 1);
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        };
        return KeyboardGame;
    })(Base.BasicGroup);
    _KeyboardGame.KeyboardGame = KeyboardGame;
})(KeyboardGame || (KeyboardGame = {}));
//# sourceMappingURL=KeyboardGame.js.map