/*
 * Copyright Ä‚â€žÄąÄ…Ă„Ä…Ă„ËťÄ‚â€ąÄąÄ„ 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentCombo = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);
	this.multiple = false;
	this.isChanged = false;

	this.correctAnswersList = new Array();
	this.interactions = true;
	this.interactionsType = "numeric";	

	this.hintRectangle = null;
	this.hintImage = null;
	this.hintTextAll = null;

	this.timerID = null;
	this.allowGF = true;
	this.visibleCAI = false; //pg2-giub_cai
	this.answerCheckedInThisPageSession = false; //pg2-giub_cai -after back to the page do not show CAI
};

componentCombo.prototype = new componentElement;
componentCombo.prototype.type = "componentCombo";

componentCombo.prototype.onCreate = function(obj)
{
	if (is.ns4) {
		if (this.h < 25) this.h = 25;
	};

	this.captureMouseEvents();
	this.correctAnswersList = this.correctAnswer.split("||");

	var font = {};
	font.family = this.hintTextFontFamily;
	font.size = this.hintTextFontSize;
	font.color = this.hintTextFontColor;

	if (this.allowGF && project.globalFormating && this.isDefaultFont(font) && !this.isDefaultFont(project.font)) {
		this.hintTextFontFamily = project.font.family;
		this.hintTextFontSize = project.font.size;
		this.hintTextFontColor = project.font.color;
	};
};

componentCombo.prototype.isDefaultFont = function(font)
{
	var result = true;
	if (font.family != 'Arial') {
		result = false;
	} else
	if (font.size != 2) {
		result = false;
	} else
	if (font.color.replace(/#/g, "") != '000000') {
		result = false;
	};
	return result;
};

componentCombo.prototype.onPaint = function(obj)
{
	if (this.locked) return;

	var t = '<form id="' + this.id + 'Form" name="' + this.id + 'Form">';
	t += '<select dir="' + this.dir +'" style="width:' + this.w + 'px;';

	var fontSize = this.textFontSize; //pg2-pcen -backward compability
	if (fontSize < 12) fontSize = getFontSize(this.textFontSize, 'px');

	t += ' text-decoration: ' + (this.textFontUnderline?'underline':'normal') + ';' //pg2-pcen
	t += ' font-size: ' + fontSize + 'px; color: ' + this.textFontColor + ';'; //pg2-pcen
	t += ' font-style: ' + (this.textFontStyle?'italic':'normal') + '; font-weight: ' + (this.textFontWeight?'bold':'normal') + ';';
	t += ' font-family: ' + this.textFontFamily + ';';
	t += '" ';

	t += ' size="' + this.getSize() + '"';
	if (this.multiple) {
		t += ' multiple';
	};
	if (this.disabled == true) {
		t += ' disabled="disabled"';
	};
	t += ' onfocus="WBTObject.all[\''+this.id+'\'].invokeEvent(\'FocusIn\')"';
	t += ' onblur="WBTObject.all[\''+this.id+'\'].invokeEvent(\'FocusOut\')"';

	t += ' id="' + this.id + 'Select" onChange="page.findChildByName(\'' + this.id + '\').eventOnChange();"';
	t += '>';

    var changed = unquotedString(this.listValues);

    var arrOpt 	= changed.split("||");

	for (var i = 0; i < arrOpt.length; i++) {
		var sel = "";
		if (i == this.selectedIndex) sel = "selected";

		//pg2-rub
		var opt = arrOpt[i];
		while (opt.indexOf('<') > -1) opt = opt.replace('<', '&lt;');
		while (opt.indexOf('>') > -1) opt = opt.replace('>', '&gt;');
		//

		//t += '<option id="' + this.id + '_option' + i + '" value="' + i + '" ' + sel + '>' + arrOpt[i] + '</option>';
		t += '<option id="' + this.id + '_option' + i + '" value="' + i + '" ' + sel + '>' + opt + '</option>'; //pg2-rub
	};

	t += '</select><br><p id="' + this.id + 'Text" style="font-family: ' + this.textFontFamily + ';';
	t += ' font-size: ' + this.textFontSize + 'px; color: '+this.correctAnswersColor+';"></p>';

	t += "</form>";

	if (this.showHints && !this.hintShowInStep && ((this.hintWidth == 0 || this.hintHeight == 0))) {
		t += '<div id="'+this.id+'_textSize" style="position:absolute; visibility:hidden; left:0px; top:0px; border: solid #000000 0px;"></div>';
	};

	this.setHTML(t);
	this.onRepaint();
};

componentCombo.prototype.checkAnswer = function()
{
	var result = this.parseCheckAnswer(this);

	if (this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt && page.countAnswers > 0) { //pg2-giub_cai
		this.showCAI();
		if (result) this.lock(); else {
			//this.lock(); //stubborn IE kept focus (and visible blue selection) until click in some other place on the page
			//this.unlock();
		};
	} else
	if (this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt && page.countAnswers == 0) {
		this.showCAI();
	};

	this.answerCheckedInThisPageSession = true; //pg2-giub_cai

	if (is.ie) { //pg2-giub_cai -in IE, if the option is selected (and combo has a focus), blue selection is show and underneath it is red one
		var obj = document.getElementById(this.id + 'Select');
		if (obj) obj.blur();
	};

	return result;
};

componentCombo.prototype.getAnswer = function()
{
	var comboObj = document.getElementById(this.id + "Select");
	if (comboObj){
		this.selectedIndex = comboObj.selectedIndex;
	};
	return(this.selectedIndex);
};

componentCombo.prototype.setAnswer = function(valInt, showCorrect)
{
	if (valInt == 0 || valInt == "undefined") valInt = 0;
	if (showCorrect == null || showCorrect == "undefined") showCorrect = true;
	if (showCorrect && this.isCorrectAnswer(this.selectedIndex)) return;

	if (valInt.toString().indexOf('||') > -1) {
		var arrAns = valInt.split('||');
		valInt = arrAns[0];
	};

	this.selectedIndex = valInt;
	var select = document.getElementById(this.id + "Select");
	if (select)	select.selectedIndex = valInt;

	this.onRepaint();
	return(valInt);
};

//componentCombo.prototype.componentComboBaseEventClick = componentCombo.prototype.eventClick; //pg2-giub_cai3
//componentCombo.prototype.eventClick = function(e)
componentCombo.prototype.componentComboBaseEventMouseDown = componentCombo.prototype.eventMouseDown; //pg2-giub_cai3
componentCombo.prototype.eventMouseDown = function(e)
{
	//TODO
	//this.componentComboBaseEventMouseDown(e);

	//if (is.ie) return;
	//var selectedIndex = -1;
	if (!this.locked && this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt) {
		/*var select = document.getElementById(this.id + "Select");
		if (select) {
			selectedIndex = select.selectedIndex;
			var arrOpt = this.listValues.split("||");
			for (var i=0; i < arrOpt.length; i++) {
				//if (i.toString() == correctAns[0]) {
					if (select) select.style.backgroundColor = 'white'; //select.style.background = this.incorrectColor;
					var text = document.getElementById(this.id + "Text");
					//if (text) text.innerHTML = arrOpt[i];
					//break;
				//};
			};
		};

		try {
			var arrOpt = this.listValues.split("||");
			for (var i=0; i<arrOpt.length; i++) {
				var obj = document.getElementById(this.id + '_option' + i);
				if (obj) obj.style.backgroundColor = 'white';
			};
		} catch(e) {
			//alert('error: ' + e.message);
		};*/
		if (this.visibleCAI) this.hideCAI();
	};
	//if (is.ie) top.window.document.title = selectedIndex + ', ' + this.getAnswer() + ', ' + e.type;

	//this.componentComboBaseEventClick(e);
	//this.componentComboBaseEventMouseDown(e);
};

componentCombo.prototype.showCAI = function() //pg2-giub_cai
{
	if (PageInterface.GetValue("state") == psDesigning) return;

	this.visibleCAI = true;

	var result = this.parseCheckAnswer(this)
	var select = document.getElementById(this.id + "Select");
	var selectedIndex = -1;
	if (select) selectedIndex = select.selectedIndex;
	if (!result) { //if (!this.checkAnswer()) { //pg2-giub_cai
		var correctAns = this.correctAnswer.split("||");
		var arrOpt = this.listValues.split("||");
		for (var i=0; i < arrOpt.length; i++) {
			if (i.toString() == correctAns[0]) {
				if (select) select.style.backgroundColor = this.incorrectColor; //select.style.background = this.incorrectColor;
				if (page.countAnswers == 0) { //pg2-after lock only
					var text = document.getElementById(this.id + "Text");
					if (text) {
						text.style.fontSize = select.style.fontSize; //change text's size, otherwise is too small to see it
						text.style.fontFamily = select.style.fontFamily;
						text.innerHTML = arrOpt[i];
					};
				};
				break;
			};
		};
	} else {
		if (select) select.style.background = this.correctColor;
	};
	try {
		var arrOpt = this.listValues.split("||");
		for (var i=0; i<arrOpt.length; i++) {
			var obj = document.getElementById(this.id + '_option' + i);
			if (obj) obj.style.backgroundColor = result?this.correctColor:this.incorrectColor;
		};
	} catch(e) {
		//alert('error: ' + e.message);
	};
};

componentCombo.prototype.hideCAI = function() //pg2-giub_cai
{
	var select = document.getElementById(this.id + "Select");
	if (select) select.style.backgroundColor = '#FFFFFF';
	var arrOpt = this.listValues.split("||");
	for (var i=0; i<arrOpt.length; i++) {
		var obj = document.getElementById(this.id + '_option' + i);
		if (obj) obj.style.backgroundColor = '#FFFFFF';
	};
	this.visibleCAI = false;
};

/*componentCombo.prototype.componentComboBaseEventClick = componentCombo.prototype.eventClick; //pg2-giub_cai
componentCombo.prototype.eventClick = function(e)
{
	if (this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt && page.countAnswers > 0) {
		//this.hideCAI();
	};
	this.componentComboBaseEventClick();
};*/

componentCombo.prototype.onRepaint = function(obj)
{
	if ((PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) || (this.showCorrectAnswerIndicator && this.showCAIOnEachAttempt && page.countAnswers != page.baseTryCount)) {
		if (page.countAnswers == 0) {
			if (this.answerCheckedInThisPageSession) this.showCAI(); //pg2-giub_cai -do not show CAI after: checkAns, navi out of the page and return to this page - inconsistency to mltpChoice and D'n'D CAI mechanism
		} else
		if (this.showCAIOnEachAttempt) {
			var result = this.parseCheckAnswer(this);
			if (this.answerCheckedInThisPageSession) this.showCAI(); //pg2-giub_cai -do not show CAI after: checkAns, navi out of the page and return to this page - inconsistency to mltpChoice and D'n'D CAI mechanism
			if (result) this.lock();
		};
	};
};

componentCombo.prototype.isCorrectAnswer = function(v)
{
	var isCorrect = false;
	if (v == -1) return isCorrect;

	var atd = new Array();
	atd = this.correctAnswer.split('||');

	for (var i = 0; i < atd.length; i++) {
		if (v == parseInt(atd[i])) isCorrect = true;
	};
	return(isCorrect);
};

componentCombo.prototype.onLock = function()
{
	var form = page.doc.forms[this.id + "Form"];
	if (form) form[0].disabled = true;

	if (this.showHints) { 
		if (this.hintRectangle != null) this.hintRectangle.hide();
		if (this.hintImage != null) this.hintImage.hide();
		if (this.hintTextAll != null) this.hintTextAll.hide();
		//if (this.timerID != null) window.clearTimeout(this.timerID); //pg2-moved below
	};
	if (this.timerID != null) window.clearTimeout(this.timerID); //pg2
	this.timerID = null;

	return(true);
};

componentCombo.prototype.onUnLock = function()
{
	var form = page.doc.forms[this.id + "Form"];
	if (form) form[0].disabled = false;

	var select = document.getElementById(this.id + "Select");
	this.selectedIndex = 0;
	if (select) select.selectedIndex = 0;	

	return(true);
};

componentCombo.prototype.eventOnChange = function()
{
	this.isChanged = true;
	var select = document.getElementById(this.id + "Select");
	this.selectedIndex = select.selectedIndex;

	this.hideCAI(); //this.onPaint(); //pg2-giub_cai
	page.hideFeedbacks();

	this.hideCAI(); //this.onPaint(); //pg2-giub_cai
	if (this.parseCheckAnswer(this)) { //if (this.checkAnswer()) { //pg2-giub_cai -replaced
		this.invokeEvent("ChangeCorrectAnswer");
	} else {
		this.invokeEvent("ChangeIncorrectAnswer");
	};
};

componentCombo.prototype.getSize = function()
{
	return 1;
};

componentCombo.prototype.unselectable = function()
{
};

componentCombo.prototype.setSelectedIndex = function(index)
{
	document.getElementById(this.id + "Select").selectedIndex = index;
};

componentCombo.prototype.focus = function() 
{
	var form = getForm(this.id + "Form");
	if (form && this.visible) {
		form[0].focus();		
		form[0].value=form[0].value;		
	};
};

componentCombo.prototype.checkIsChanged = function()
{
	return(this.isChanged);
};

//get text dimensions
componentCombo.prototype.getFontDimensions = function(sContent, sFont, sFontSize)
{
	if (!sFont) sFont 	= "";
	if (!sFontSize) sFontSize = "1";
	
	switch (sFontSize) {
		case "1": sFontSize = "8pt"; break;
		case "2": sFontSize = "10pt"; break;
		case "3": sFontSize = "12pt"; break;
		case "4": sFontSize = "14pt"; break;
		case "5": sFontSize = "18pt"; break;
		case "6": sFontSize = "24pt"; break;
		case "7": sFontSize = "36pt"; break;
	};
	
	var elem = document.getElementById(this.id+"_textSize");
	elem.style.fontFamily = sFont;
	elem.style.fontSize = sFontSize;
	elem.innerHTML = sContent;

	return { width:elem.offsetWidth, height:elem.offsetHeight };
};

componentCombo.prototype.showTrainingFromApplicationHint = function()
{
	var hintRectangleWidth = this.hintWidth;
	var hintRectangleHeight = this.hintHeight;
	
	if (this.hintWidth == 0 || this.hintHeight == 0) {
		var textSize = this.getFontDimensions(this.hintText, this.hintTextFontFamily, this.hintTextFontSize);
		var hintRectangleWidth = textSize.width + (parseInt(this.borderHintWidth)*2) + 10;
		var hintRectangleHeight = textSize.height + (parseInt(this.borderHintWidth)*2) + 10;
	};

	switch (this.hintPosition) {
		case "nw":
			var imageX = this.x - this.hintImageWidth;
			var imageY = this.y - this.hintImageHeight;
			var rectangleX = imageX - hintRectangleWidth;
			var rectangleY = imageY - hintRectangleHeight;
			var src = "__.input._arrow_se.gif";
			break;
		case "ne":
			var imageX = this.x + this.w;
			var imageY = this.y - this.hintImageHeight;
			var rectangleX = imageX + this.hintImageWidth;
			var rectangleY = imageY - hintRectangleHeight;
			var src = "__.input._arrow_sw.gif";
			break;
		case "se":
			var imageX = this.x + this.w;
			var imageY = this.y + this.h;
			var rectangleX = imageX + this.hintImageWidth;
			var rectangleY = imageY + this.hintImageHeight;
			var src = "__.input._arrow_nw.gif";
			break;
		case "sw":
			var imageX = this.x - this.hintImageWidth;
			var imageY = this.y + this.h;
			var rectangleX = imageX - hintRectangleWidth;
			var rectangleY = imageY + this.hintImageHeight;
			var src = "__.input._arrow_ne.gif";
			break;
	};
	
	if (this.anotherPopup == "-") {
		this.hintRectangle = page.addChild(new componentRectangle(this.id + "_hintRectangle"));
		this.hintRectangle.x = rectangleX;
		this.hintRectangle.y = rectangleY;
		this.hintRectangle.w = hintRectangleWidth;
		this.hintRectangle.h = hintRectangleHeight;
		this.hintRectangle.cursor = "default";
		this.hintRectangle.bgColor = this.bgHintColor;
		this.hintRectangle.borderColor = this.borderHintColor;
		this.hintRectangle.borderWidth = this.borderHintWidth;
		this.hintRectangle.step = 0;
		this.hintRectangle.contentMode = 0;
		this.hintRectangle.visibleIf = "";
		this.hintRectangle.stayOnTop = false;
		this.hintRectangle.alphaOpacity = "100";
		this.hintRectangle.layer = 1;
		this.hintRectangle.automaticHideTimerInterval = 0;
		this.hintRectangle.setBorder(this.hintRectangle.borderColor, this.hintRectangle.borderWidth);
		this.hintRectangle.show();
	};
	
	this.hintImage = page.addChild(new componentImage(this.id + "_hintArrow"));
	this.hintImage.x = imageX;
	this.hintImage.y = imageY;
	this.hintImage.w = this.hintImageWidth;
	this.hintImage.h = this.hintImageHeight;
	this.hintImage.cursor = "default";
	this.hintImage.src = src;
	this.hintImage.cursor = "default";
	this.hintImage.borderColor = "transparent";
	this.hintImage.borderWidth = 0;
	this.hintImage.step = 0;
	this.hintImage.visibleIf = "";
	this.hintImage.infoText = "Put an image here";
	this.hintImage.contentMode = 0;
	this.hintImage.stayOnTop = false;
	this.hintImage.alphaOpacity = "100";
	this.hintImage.altHint = "";
	this.hintImage.layer = 1;
	this.hintImage.disableOnlineOfflineMix = false;
	this.hintImage.automaticHideTimerInterval = 0;
	this.hintImage.p_checkMarkers = this.p_checkMarkers;
	this.hintImage.p_checkPNG = this.p_checkPNG;
	this.hintImage.pngFix = this.pngFix;
	this.hintImage.show();
	
	if (this.anotherPopup == "-") {	
		this.hintTextAll = page.addChild(new componentText(this.id + "_hintText"));
		this.hintTextAll.x = rectangleX;
		this.hintTextAll.y = rectangleY;
		this.hintTextAll.w = hintRectangleWidth + (this.borderHintWidth*2);
		this.hintTextAll.h = hintRectangleHeight + (this.borderHintWidth*2);
		this.hintTextAll.align = this.hintTextAlign;
		this.hintTextAll.valign = this.hintTextValign;
		this.hintTextAll.font.family = this.hintTextFontFamily;
		this.hintTextAll.font.size = this.hintTextFontSize;
		this.hintTextAll.font.color = this.hintTextFontColor; 
		this.hintTextAll.bgColor = this.hintTextBgColor;
		this.hintTextAll.wrap = this.hintTextWrap;
		this.hintTextAll.padding = this.hintTextPadding;
		var index = this.correctAnswer.split("||")[0];
		this.hintTextAll.text = this.hintText.replace("[CORRECT_ANSWER]", this.listValues.split("||")[parseInt(index)]);
		this.hintTextAll.cursor = "default";
		this.hintTextAll.borderColor = "transparent";
		this.hintTextAll.borderWidth = 0;
		this.hintTextAll.step = 0;
		this.hintTextAll.visibleIf = "";
		this.hintTextAll.contentMode = 0;
		this.hintTextAll.stayOnTop = false;
		this.hintTextAll.alphaOpacity = "100";
		this.hintTextAll.altHint = "";
		this.hintTextAll.layer = 1;
		this.hintTextAll.disableOnlineOfflineMix = false;
		this.hintTextAll.automaticHideTimerInterval = 0;
		this.hintTextAll.allowGF = this.allowGF;
		this.hintTextAll.p_checkMarkers = this.p_checkMarkers;
		this.hintTextAll.p_checkPNG = this.p_checkPNG;
		this.hintTextAll.pngFix = this.pngFix;
		this.hintTextAll.show();
	} else
	if (page.all[this.anotherPopup]) {
		var popup = page.all[this.anotherPopup];
		var index = this.correctAnswer.split("||")[0];
		if (popup) {
			popup.invokedFromDetectComponent = true; //pg2- do not repaint twice and overwrite text to standard one defined for (and within) popup component - just as in detect components
			if (popup.execution) {
				var popupContent = popup.findContentObj();				
				popupContent.innerHTML = this.hintText.replace("[CORRECT_ANSWER]", this.listValues.split("||")[parseInt(index)]);
			} else {
				if (this.allowGF) {
					popup.text.font.family = this.hintTextFontFamily;
					popup.text.font.size = this.hintTextFontSize;
					popup.text.font.color = this.hintTextFontColor;
					popup.text.allowGF = this.allowGF;
				};
				popup.text.text = this.hintText.replace("[CORRECT_ANSWER]", this.listValues.split("||")[parseInt(index)]);
				popup.text.onCreate();
			};
			if (popup.visible) popup.paint();
			else popup.show();					
		};
		if (popup.visible) popup.paint(); else popup.show();
	};
};

componentCombo.prototype.componentComboBaseShowObject = componentCombo.prototype.show;
componentCombo.prototype.show = function()
{
	this.componentComboBaseShowObject();
	if (this.showHints && !this.hintShowInStep) {
		if (this.timerID == null)
			this.timerID = window.setTimeout('page.all["' + this.id + '"].showTrainingFromApplicationHint();', this.hintTime); 
	};
};

componentCombo.prototype.componentComboBaseHideObject = componentCombo.prototype.actionHideObject;
componentCombo.prototype.actionHideObject = function()
{
	this.componentComboBaseHideObject();
	if (this.showHints) { 
		if (this.hintRectangle != null) this.hintRectangle.hide();
		if (this.hintImage != null) this.hintImage.hide();
		if (this.hintTextAll != null) this.hintTextAll.hide();
		if (this.anotherPopup != '-') page.all[this.anotherPopup].hide();		
		//if (this.timerID != null) window.clearTimeout(this.timerID); //pg2-moved below
	};
	if (this.timerID != null) window.clearTimeout(this.timerID); //pg2
	this.timerID = null;
};

componentCombo.prototype.componentComboBaseHide = componentCombo.prototype.hide; //pg2
componentCombo.prototype.hide = function() //pg2
{
	this.componentComboBaseHide();
	if (this.showHints) { 
		if (this.hintRectangle != null) this.hintRectangle.hide();
		if (this.hintImage != null) this.hintImage.hide();
		if (this.hintTextAll != null) this.hintTextAll.hide();
		if (this.anotherPopup != '-') page.all[this.anotherPopup].hide();		
	};
	if (this.timerID != null) window.clearTimeout(this.timerID);
	this.timerID = null;
};

componentCombo.prototype.onFree = function()
{
	if (this.timerID != null) window.clearTimeout(this.timerID);
	this.timerID = null; //pg2
};

componentCombo.prototype.interactionsCorrectResponsesCount = function()
{
	return this.correctAnswersList.length;
};

componentCombo.prototype.interactionsCorrectResponses = function(index)
{
	return this.correctAnswersList[index];
};

componentCombo.prototype.interactionsStudentResponse = function()
{
	return this.getAnswer();
};

componentCombo.prototype.interactionsCorrectResponsesAsText = function(index)
{
	var changed = unquotedString(this.listValues);
	var textAnswersList = changed.split("||");	
	var correctAnswersList = this.correctAnswer.split("||");
	var result = "";
	var sep = "";
	
	for (var i=0; i<correctAnswersList.length; i++) {
		var index = parseInt(correctAnswersList[i]);

		result += sep + textAnswersList[index];
		if (result != "") sep = '||';
	};
	return escape(result);
};

componentCombo.prototype.interactionsStudentResponseAsText = function()
{
	var changed = unquotedString(this.listValues);
	var textAnswersList = changed.split("||");	
	var answersList = this.getAnswer().toString().split("||");
	var result = "";
	var sep = "";
	
	for (var i=0; i<answersList.length; i++) {
		var index = parseInt(answersList[i]);
		
		result += sep + textAnswersList[index];
		if (result != "") sep = '||';
	};
	return escape(result);
};
