/** Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

var trHorizontal = 'horizontal';
var trVertical = 'vertical';

componentTrackBar = function(name) 
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);

	if (arguments[1]) {
	} else {
		this.background = this.addChild(new __componentImage(null));
		this.track = this.addChild(new __componentImage(null));
		this.track.canDragging = true;
	}
	this.trackCanDragging = true;
	this.trackStep = 0;
	this.pos = 0;
	this.isChanged = false;
	this.correctAnswersList = new Array();
	this.interactions = true;
	this.interactionsType = "matching";
	this.startPosition = 0;

	this.dragobject = null;
	this.ty = 0;
	this.tx = 0;
};

componentTrackBar.prototype = new componentElement();
componentTrackBar.prototype.type = "componentTrackBar";

componentTrackBar.prototype.onBaseCreate = function(obj)
{
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};

	    this.resourcesURL = unescape(this.resourcesURL);

		this.imagesNameArr = [	this.backgroundSrc, this.trackSrc ];
		this.getPreloadImagesArr();
	}
	this.startPosition = this.position;
	this.oldPosition = this.position;
};

componentTrackBar.prototype.onCreate = function(obj)
{
	this.parseAnswers(this.correctAnswer);
	this.captureMouseEvents();
	if (!this.execution) {
		if (this.track.src != '___.trackbar.trackH.gif') {
			if (this.track.srcCorr == '___.trackbar.trackH.Corr.gif') {
				this.track.srcCorr = this.track.src;
			};
			if (this.track.srcIncorr == '___.trackbar.trackH.Incorr.gif') {
				this.track.srcIncorr = this.track.src;
			};
		};
		this.background.p_checkMarkers = this.p_checkMarkers;
		this.background.p_checkPNG = this.p_checkPNG;
		this.background.pngFix = this.pngFix;

		this.track.p_checkMarkers = this.p_checkMarkers;
		this.track.p_checkPNG = this.p_checkPNG;
		this.track.pngFix = this.pngFix;

		this.track.captureMouseEvents();
		this.track.calcPosX = this.trackDragX;
		this.track.calcPosY = this.trackDragY;
	} else {
		if (this.trackSrc != '___.trackbar.trackH.gif') {
			if (this.trackSrcCorr == '___.trackbar.trackH.Corr.gif') {
				this.trackSrcCorr = this.trackSrc;
			};
			if (this.trackSrcIncorr == '___.trackbar.trackH.Incorr.gif') {
				this.trackSrcIncorr = this.trackSrc;
			};
		};
		document.getElementById(this.id + "_imageBackDIV_contentObj").src = this.resourcesURL + this.backgroundSrc;
		document.getElementById(this.id + "_imageTrackDIV_contentObj").src = this.resourcesURL + this.trackSrc;
		document.getElementById(this.id + "_imageTrackDIV_contentObj").style.cursor = this.cursor;
		//this.captureTrackMouseEvents(document.getElementById(this.id + "_imageTrackDIV_contentObj"));
		this.captureTrackMouseEventsNEW(); //pg2-mouseEvt
	};
};

componentTrackBar.prototype.componentTrackBarSetSizeScaledElement = componentTrackBar.prototype.setSizeScaledElement;
componentTrackBar.prototype.setSizeScaledElement = function(x, y, w, h)
{
	if (this.execution) {
		document.getElementById(this.id + "_backgroundDIV").style.clip = 'rect(0px '+w+' '+h+' 0px)';
		document.getElementById(this.id + "_backgroundDIV").style.width = w;
		document.getElementById(this.id + "_backgroundDIV").style.height = h;
	};
	this.calcTrackStep();
	this.setPosition(this.position);
	this.componentTrackBarSetSizeScaledElement(x, y, w, h);
};

componentTrackBar.prototype.eventMouseDown = function(e)
{
	if (this.locked) return;

	this.setImageSrc(this.resourcesURL + this.trackSrc);

	if (!this.trackCanDragging) {
		this.position = this.oldPosition;
		return;
	};

	
	/*if (this.orientation == trHorizontal) {  //pg2-mouseEvt -removed
		if (is.ie) {
			var newPos = this.trackCalcPosX(e.x - this.x - this.trackLowOffset);
		} else {
			var newPos = this.trackCalcPosX(e.pageX - this.x - this.trackLowOffset);
		};
		if (!this.execution) {
			this.track.setX(newPos);
		} else {
			document.getElementById(this.id + "_trackDIV").style.left = newPos;
		};
	} else { 
		if (is.ie) {
			var newPos = this.trackCalcPosY(e.y - this.y - this.trackLowOffset);
		} else {
			var newPos = this.trackCalcPosY(e.pageY - this.y - this.trackLowOffset);
		};
		if (!this.execution) {
			this.track.setY(newPos);
		} else {
			document.getElementById(this.id + "_trackDIV").style.top = newPos;
		};
	};
	this.setImageSrc(this.resourcesURL + this.trackSrc);*/
};

componentTrackBar.prototype.eventMouseUp = function(e)
{
	if (this.locked) return;

	this.setImageSrc(this.resourcesURL + this.trackSrc);

	if (!this.trackCanDragging) {
		this.position = this.oldPosition;
		return;
	};

	/*if (this.orientation == trHorizontal) {  //pg2-mouseEvt -removed
		if (is.ie) {
			var newPos = this.trackCalcPosX(e.x - this.x - this.trackLowOffset);
		} else {
			var newPos = this.trackCalcPosX(e.pageX - this.x - this.trackLowOffset);
		};
		if (!this.execution) {
			this.track.setX(newPos);
		} else {
			document.getElementById(this.id + "_trackDIV").style.left = newPos;
		};
	} else { 
		if (is.ie)
			var newPos = this.trackCalcPosY(e.y - this.y - this.trackLowOffset);
		else {
			var newPos = this.trackCalcPosY(e.pageY - this.y - this.trackLowOffset);
		};
		if (!this.execution) {
			this.track.setY(newPos);
		} else {
			document.getElementById(this.id + "_trackDIV").style.top = newPos;
		};
	};*/
	if (this.position != this.oldPosition) {
		this.oldPosition = this.position;
		this.isChanged = true;
		this.invokeEvent("Change");
		
		if (this.integrateWithSteps) { //pg2-BI_stepsIntegration
			page.stepsIntegrationExecute('setStep', this.position);
		};
		
		if (this.checkIsCorrect()) {
			this.invokeEvent("ChangeCorrectAnswer");
		} else {
			this.invokeEvent("ChangeIncorrectAnswer");
		};
	};
};

componentTrackBar.prototype.trackDragX = function(x)
{
	if (this.parent.orientation == trHorizontal) {  
		var pos = x;
		var lowlimit = this.parent.trackLowOffset;
		var hilimit = this.parent.w-this.parent.trackHighOffset-this.w;
		if (pos <= lowlimit) pos = lowlimit;
		if (pos >= hilimit) pos = hilimit;
		return(pos);
	} else {
		return(this.parent.trackOffset); 
	};
};

componentTrackBar.prototype.trackDragY = function(y)
{
	if (this.parent.orientation == trHorizontal) {  
		return this.parent.trackOffset;
	} else {
		this.pos = y;
		var lowlimit = this.parent.trackLowOffset;
		var hilimit = this.parent.h-this.parent.trackHighOffset-this.h;
		if (this.pos <= lowlimit) this.pos = lowlimit;
		if (this.pos >= hilimit) this.pos = hilimit;
		return this.pos;
	};
};

componentTrackBar.prototype.trackCalcPosX = function(x)
{
	if (this.dir == "rtl") x = this.w - this.trackHighOffset - this.trackLowOffset - x;
	if (x < 0) x = 0;
	if (x > this.w - this.trackHighOffset - this.trackLowOffset) x = this.w - this.trackHighOffset - this.trackLowOffset;
	var pos = parseInt(x / this.trackStep);
	if (pos+this.positionMin <= this.positionMin) pos = 0;
	if (pos+this.positionMin >= this.positionMax) pos = this.positionMax - this.positionMin;
	this.position = pos+this.positionMin;
	if (this.dir == "rtl") pos = this.positionMax - this.positionMin - pos;
	return (this.trackLowOffset + (pos * this.trackStep));
};

componentTrackBar.prototype.trackCalcPosY = function(y)
{
	if (this.dir == "rtl") y = this.h - this.trackHighOffset - this.trackLowOffset - y;
	if (y < 0) x = 0;
	if (y > this.h - this.trackHighOffset - this.trackLowOffset) y = this.h - this.trackHighOffset - this.trackLowOffset;
	var pos = parseInt(y / this.trackStep);
	if (pos+this.positionMin <= this.positionMin) pos = 0;
	if (pos+this.positionMin >= this.positionMax) pos = this.positionMax - this.positionMin;
	this.position = pos+this.positionMin;
	if (this.dir == "rtl") pos = this.positionMax - this.positionMin - pos;
	return (this.trackLowOffset + (pos * this.trackStep));
};

componentTrackBar.prototype.onPaint = function(obj)
{
	if (!this.execution) {
		this.background.w = this.w;
		this.background.h = this.h;
	};
	this.calcTrackStep();
	this.setPosition(this.position);

	this.onRepaint();
};

componentTrackBar.prototype.onRepaint = function()
{
	if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) {
		var track = document.getElementById(this.id + "_imageTrackDIV_contentObj");
		if (this.checkAnswer()) {
			this.setImageSrc(this.resourcesURL + this.trackSrcCorr, track);
		} else {
			this.setImageSrc(this.resourcesURL + this.trackSrcIncorr, track);
		};
	};
};

componentTrackBar.prototype.setImageSrc = function(value, obj)
{
	if (!obj) {
		obj = document.getElementById(this.id + "_imageTrackDIV_contentObj");
	};

	value = unescape(value);

	if (obj) {
		if (this.pngFix && is.ie55UP && !is.ie7UP) {
			var is_span = (obj.tagName.toUpperCase() == 'SPAN');
			if (is_span) {
				var src = ".." + value.substr(value.lastIndexOf("/resources/"), value.length);
				obj.src = value;
				obj.style.filter = 'progid:DXImageTransform.Microsoft.AlphaImageLoader (src=\'' + src + '\',sizingMethod=\'image\'';
			} else {
				obj.src = value;
			};
		} else {
			obj.src = value;
		};
		return true;
	};
	return false;
};

componentTrackBar.prototype.componentTrackBarBaseResetElement = componentTrackBar.prototype.resetElement;
componentTrackBar.prototype.resetElement = function()
{
	this.componentTrackBarBaseResetElement();
	this.calcTrackStep();
	this.oldPosition = this.startPosition;
	this.setPosition(this.startPosition);
	this.setImageSrc(this.resourcesURL + this.trackSrc);
};

componentTrackBar.prototype.setPosition = function(newPos)
{
	if (newPos >= this.positionMin && newPos <= this.positionMax) {
		this.position = newPos;
		if (this.orientation == trHorizontal) {
			var pos = parseInt((newPos - this.positionMin) / this.positionStep);
			if (!this.execution) {
				this.track.moveTo(this.trackLowOffset + (this.trackStep * pos), this.trackOffset);
			} else {
				if (this.dir == "rtl") {
					document.getElementById(this.id + "_trackDIV").style.left = eval(this.trackLowOffset + (this.trackStep * (this.positionMax - this.positionMin)) - (this.trackStep * pos));
				} else {
					document.getElementById(this.id + "_trackDIV").style.left = eval(this.trackLowOffset + (this.trackStep * pos));
				};
				document.getElementById(this.id + "_trackDIV").style.top = this.trackOffset;
			}
		} else {
			var pos = parseInt((newPos - this.positionMin) / this.positionStep);
			if (!this.execution) 
				this.track.moveTo(this.trackOffset, this.trackLowOffset + (this.trackStep * pos));
			else {
				document.getElementById(this.id + "_trackDIV").style.left = this.trackOffset;
				if (this.dir == "rtl") {
					document.getElementById(this.id + "_trackDIV").style.top = eval(this.trackLowOffset + (this.trackStep * (this.positionMax - this.positionMin)) - (this.trackStep * pos));
				} else {
					document.getElementById(this.id + "_trackDIV").style.top = eval(this.trackLowOffset + (this.trackStep * pos));
				};
			};
		};
	};
};

componentTrackBar.prototype.calcTrackStep = function()
{
	if (this.orientation == trHorizontal) {  
		if (!this.execution) {
			this.trackStep = (this.w - this.trackLowOffset - this.trackHighOffset - this.track.w) / ((this.positionMax - this.positionMin) / this.positionStep);
		} else {
			this.trackStep = (this.w - this.trackLowOffset - this.trackHighOffset - this.trackW) / ((this.positionMax - this.positionMin) / this.positionStep);
		};
	} else {
		if (!this.execution) 
			this.trackStep = (this.h - this.trackLowOffset - this.trackHighOffset - this.track.h) / ((this.positionMax - this.positionMin) / this.positionStep);
		else
			this.trackStep = (this.h - this.trackLowOffset - this.trackHighOffset - this.trackH) / ((this.positionMax - this.positionMin) / this.positionStep);
	};
};
 
componentTrackBar.prototype.checkIsCorrect = function()
{
	var arrAns = this.correctAnswersList;
	var result = false;
	for (var i=0; i<arrAns.length; i++)
		if (arrAns[i] == this.position) result = true;
	return result;
};

componentTrackBar.prototype.checkAnswer = function()
{
	var arrAns = this.correctAnswersList;
	var result = false;
	for (var i=0; i<arrAns.length; i++)
		if (arrAns[i] == this.position) result = true;

	if (this.showAnswerIndicatorAnyTime && this.showCorrectAnswerIndicator) {
		if (result) {
			this.setImageSrc(this.resourcesURL + this.trackSrcCorr);
		} else {
			this.setImageSrc(this.resourcesURL + this.trackSrcIncorr);
		};
	};
	return result;
};

componentTrackBar.prototype.getAnswer = function()
{
	return(!this.ignoreAnswer || this.integrateWithSteps) ? this.position : 0; //pg2-BI_stepsIntegration -completion
};

componentTrackBar.prototype.setAnswer = function(v, showCorrect)
{
	if (showCorrect == null || showCorrect == "undefined") showCorrect = true;
	if (showCorrect && (this.isChanged && this.isCorrectAnswer(this.position))) return;

	if (v.toString().indexOf(',') > -1) {
		var arrAns = v.split(',');
		v = arrAns[0];
	};
	this.setPosition(v);
	this.onRepaint();
};

componentTrackBar.prototype.isCorrectAnswer = function(v) {
	var isCorrect = false;

	var atd = new Array();
	atd = this.correctAnswer.split(',');

	for (var i = 0; i < atd.length; i++) {
		if (v == atd[i]) isCorrect = true;
	};
	return(isCorrect);
};

componentTrackBar.prototype.onLock = function()
{
	if (!this.execution) {
		this.track.canDragging = false;
	};
	this.trackCanDragging = false;

	//if (!is.ie) { //pg2-new-mouseEvt -removed
		//this.resetTrackMouseEvents(document.getElementById(this.id + "_imageTrackDIV_contentObj")); //pg2-when locked, don't handle any events for slider (!IE)
	//};
	this.resetTrackMouseEventsNEW(); //pg2-new-mouseEvt -new

	return true;
};

componentTrackBar.prototype.onUnLock = function()
{
	if (!this.execution) {
		this.track.canDragging = true;
	};
	this.trackCanDragging = true;
	
	this.captureTrackMouseEventsNEW(); //pg2-mouseEvt -new
	
	return true;
};

componentTrackBar.prototype.isReady = function()
{
	if (this.execution) {
		var isLoaded = false
		for (var i=0; i < this.imagesNameArr.length; i++) {
			isLoaded = preloadImage(this, "_"+i);
			if (!isLoaded) return false;
		};
		this.isLoaded = isLoaded;
		return this.isLoaded;
	} else {
		return (this.background.isReady() && this.track.isReady());
	};
};

componentTrackBar.prototype.parseAnswers = function(s)
{
	this.correctAnswersList = s.split(',');
};

componentTrackBar.prototype.interactionsCorrectResponsesCount = function()
{
	return this.correctAnswersList.length;
};

componentTrackBar.prototype.interactionsCorrectResponses = function(index)
{
	return this.correctAnswersList[index];
};

componentTrackBar.prototype.interactionsStudentResponse = function()
{
	return this.position;
};

componentTrackBar.prototype.interactionsCorrectResponsesAsText = function(index)
{
	if (typeof(this.answerValuesString) == "string" && this.answerValuesString != "") {
		var ansArr = this.answerValuesString.split("||");
		var ans = ansArr[parseInt(this.correctAnswersList[index])-1];
		if (typeof(ans) != "undefined" && ans != "") {
			return ans;
		} else {
			return this.interactionsCorrectResponses(index);
		};
	} else {
		return this.interactionsCorrectResponses(index);
	};
};

componentTrackBar.prototype.interactionsStudentResponseAsText = function()
{
	if (typeof(this.answerValuesString) == "string" && this.answerValuesString != "") {
		var ansArr = this.answerValuesString.split("||");
		var ans = ansArr[parseInt(this.interactionsStudentResponse())-1];
		if (typeof(ans) != "undefined" && ans != "") {
			return ans;
		} else {
			return this.interactionsStudentResponse();
		};
	} else {
		return this.interactionsStudentResponse();
	};
};
//------------------------------------------------------------------------
//------------------------------------------------------------------------
componentTrackBar.prototype.resetTrackMouseEventsNEW = function() //pg2-mouseEvt
{
	var tObj = document.getElementById(this.id + '_imageBackDIV_contentObj'); //track obj
	var sObj = document.getElementById(this.id + '_imageTrackDIV_contentObj'); //slider obj
	if (tObj && sObj) {
		tObj.onmousedown = null;
		tObj.onmouseup = null;
		tObj.onmousemove = null;
		tObj.onmouseout = null;
		
		sObj.onmousedown = null;
		sObj.onmouseup = null;
		sObj.onmousemove = null;
		sObj.onmouseout = null;
	};
	this.isDragging = false;
};

componentTrackBar.prototype.captureTrackMouseEventsNEW = function() //pg2-mouseEvt
{
	var tObj = document.getElementById(this.id + '_imageBackDIV_contentObj'); //track obj
	var sObj = document.getElementById(this.id + '_imageTrackDIV_contentObj'); //slider obj
	if (tObj && sObj) {
		tObj.onmousedown = this.track_mousedown; //null;
		tObj.onmouseup = this.track_mouseup; //null;
		tObj.onmousemove = this.track_mousemove;
		tObj.onmouseout = this.track_mouseout; //null;
		tObj.setAttribute('mycomponentname', this.id);
		tObj.onselectstart = function(e) { return false; };
		tObj.ondragstart = function(e) { return false; };
		
		sObj.onmousedown = this.track_mousedown; // null;
		sObj.onmouseup = this.track_mouseup; //null;
		sObj.onmousemove = this.track_mousemove;
		sObj.onmouseout = this.track_mouseoutSlider; //null; //this.track_mouseout; //null;
		sObj.onmouseenter = this.track_mouseenter;
		sObj.setAttribute('mycomponentname', this.id);
		sObj.onselectstart = function(e) { return false; };
		sObj.ondragstart = function(e) { return false; };
	};
	this.object2Dragg = document.getElementById(this.id + '_trackDIV');
	this.isDragging = false;
};

componentTrackBar.prototype.track_moveObject = function(calculatePosition)
{
	if (typeof(calculatePosition) == 'undefined') calculatePosition = false;
	
	if (this.integrateWithSteps) calculatePosition = true; //pg2-BI_stepsIntegration2

	var mouseX = window.event.clientX; //mouse
	var mouseY = window.event.clientY;
	
	var compX = this.obj.offsetLeft;
	var compY = this.obj.offsetTop;
	
	if (this.orientation == 'horizontal') {
		var trackWidth = this.object2Dragg.offsetWidth;
		var compWidth = this.obj.offsetWidth;
		var newPosX = mouseX-compX-(parseInt(trackWidth/2));
		if (calculatePosition) newPosX = this.trackCalcPosX(newPosX);
		//check if track has been dragged out of the component
		if (newPosX+trackWidth > compWidth) {
			newPosX = compWidth-trackWidth;
			newPosX = this.trackCalcPosX(newPosX);
			//this.isDragging = false;
		} else
		if (newPosX < 0) { //parseInt(trackWidth/2)) {
			newPosX = parseInt(trackWidth/2);
			newPosX = this.trackCalcPosX(newPosX);
		};
		//...
		this.object2Dragg.style.left = newPosX; // + 'px;'   //.orientation == 'horizontal') {
	} else {
		var trackHeight = this.object2Dragg.offsetHeight;
		var compHeight = this.obj.offsetHeight;
		
		var newPosY = mouseY-compY-(parseInt(trackHeight/2));
		if (calculatePosition) newPosY = this.trackCalcPosY(newPosY);
		//check if track has been dragged out of the component
		if (newPosY+trackHeight > compHeight) {
			newPosY = compHeight-trackHeight;
			newPosY = this.trackCalcPosY(newPosY);
			//this.isDragging = false;
		} else
		if (newPosY < 0) { //parseInt(trackHeight/2)) {
			newPosY = parseInt(trackHeight/2);
			newPosY = this.trackCalcPosY(newPosY);
		}
		//...
		this.object2Dragg.style.top = newPosY; // + 'px;'   //.orientation == 'horizontal') {
	};
	
	if (this.integrateWithSteps) { //pg2-BI_stepsIntegration2
		page.stepsIntegrationExecute('setStep', this.position);
	};
};

componentTrackBar.prototype.track_mousedown = function(e) //pg2-mouseEvt
{
	var mainCompName = this.getAttribute('mycomponentname');
	if (mainCompName != '') {
		var mainCompObj = null;
		eval('mainCompObj = pc.' + mainCompName);
		if (mainCompObj) {
			mainCompObj.isDragging = true;
			mainCompObj.track_moveObject();
			//top.window.document.title = 'mouseDown:: ' + window.event.clientX + ',' + window.event.clientY + ' . ' + mainCompObj.isDragging + '.' + window.event.button;
		};
	};
};

componentTrackBar.prototype.track_mouseup = function(e) //pg2-new-mouseEvt
{
	var mainCompName = this.getAttribute('mycomponentname');
	if (mainCompName != '') {
		var mainCompObj = null;
		eval('mainCompObj = pc.' + mainCompName);
		if (mainCompObj) {
			if (mainCompObj.isDragging) mainCompObj.track_moveObject(true);
			mainCompObj.isDragging = false;
			
			//top.window.document.title = 'mouseUp:: ' + window.event.clientX + ',' + window.event.clientY + ' . ' + mainCompObj.isDragging + '.' + window.event.button;
		};
	};
};

componentTrackBar.prototype.track_mousemove = function(e) //pg2-new-mouseEvt
{
	var mainCompName = this.getAttribute('mycomponentname');
	if (mainCompName != '') {
		var mainCompObj = null;
		eval('mainCompObj = pc.' + mainCompName);
		if (mainCompObj && mainCompObj.isDragging) {// && mainCompObj.object2Dragg) {
			mainCompObj.track_moveObject();
		} else {
			//top.window.document.title = 'mouseMove0:: ' + window.event.clientX + ',' + window.event.clientY + ' . ' + mainCompObj.isDragging + '.' + window.event.button;
		};
		//top.window.document.title = 'mouseMove0:: ' + window.event.clientX + ',' + window.event.clientY + ' . ' + mainCompObj.isDragging + '.' + window.event.button;
	};
};

componentTrackBar.prototype.track_mouseout = function(e) //pg2-new-mouseEvt
{
	//top.window.document.title = 'OUT1: ' + getDateStr();
	var mainCompName = this.getAttribute('mycomponentname');
	if (mainCompName != '') {
		var mainCompObj = null;
		eval('mainCompObj = pc.' + mainCompName);
		if (mainCompObj && mainCompObj.isDragging && mainCompObj.object2Dragg) {
			var mouseX = window.event.clientX; //mouse
			var mouseY = window.event.clientY;
			
			var sliderX = mainCompObj.object2Dragg.offsetLeft; //slider
			var sliderY = mainCompObj.object2Dragg.offsetTop;
			var sliderWidth = mainCompObj.object2Dragg.offsetWidth; //slider
			var sliderHeight = mainCompObj.object2Dragg.offsetHeight; //slider
			
			var compX = mainCompObj.obj.offsetLeft;
			var compY = mainCompObj.obj.offsetTop;
			
			if (!(mouseX >= sliderX+compX && mouseX <= sliderX+compX+sliderWidth && mouseY >= sliderY+compY && mouseY <= sliderY+compY+sliderHeight)) {
				if (mainCompObj.isDragging) mainCompObj.track_moveObject(true);
				mainCompObj.isDragging = false;
				//top.window.document.title = 'mouseOut1:: ' + window.event.clientX + ',' + window.event.clientY + ' . ' + mainCompObj.isDragging;
			} else {
				if (mainCompObj.isDragging) mainCompObj.track_moveObject();
				//top.window.document.title = 'mouseOut2:: ' + window.event.clientX + ',' + window.event.clientY + ' . ' + mainCompObj.isDragging;
			};
			
		};
	};
};

componentTrackBar.prototype.track_mouseoutSlider = function(e) //pg2-new-mouseEvt
{
	var mainCompName = this.getAttribute('mycomponentname');
	if (mainCompName != '') {
		var mainCompObj = null;
		eval('mainCompObj = pc.' + mainCompName);
		if (mainCompObj) {// && mainCompObj.isDragging && mainCompObj.object2Dragg) {
			
			//top.window.document.title = 'mouseOUT_SLIDER:: ' + getDateStr();// + window.event.clientX + ',' + window.event.clientY + ' . ' + mainCompObj.isDragging;
			
			var mouseX = window.event.clientX; //mouse
			var mouseY = window.event.clientY;
			
			var compX = mainCompObj.obj.offsetLeft;
			var compY = mainCompObj.obj.offsetTop;
			var compWidth = mainCompObj.obj.offsetWidth;
			var compHeight = mainCompObj.obj.offsetHeight;
			
			if (mouseX >= compX && mouseY >= compY && mouseX <= compX+compWidth && mouseY <= compY+compHeight) {
				if (mainCompObj.isDragging) mainCompObj.track_moveObject();
			} else {
				if (mainCompObj.isDragging) mainCompObj.track_moveObject(true);
				mainCompObj.isDragging = false; //alert('OUT');
			};
			
		};
	};
};

componentTrackBar.prototype.track_mouseenter = function(e)
{
	//top.window.document.title = 'mouseEnter:: ';// + window.event.clientX + ',' + window.event.clientY + ' . ' + mainCompObj.isDragging;
};
//------------------------------------------------------------------------
// #################################################################
// ############## Nadpisywanie funkcji do przeciagania #############
// ######################## dla wersji wbte  #######################
// #################################################################
componentTrackBar.prototype.captureTrackMouseEvents = function (trackObj)
{
	if (trackObj) {
		trackObj.onmousedown = this.moveTrack_onmousedown;
		trackObj.onmouseup = this.moveTrack_onmouseup;
		trackObj.onmousemove = this.moveTrack_onmousemove;
		if (!is.ie) trackObj.onmouseout = this.moveTrack_onmouseout; //pg2-when leaving track, it must be handled, otherwise position (Firefox) will not be calculated (!IE)
	};
};

componentTrackBar.prototype.resetTrackMouseEvents = function (trackObj) //pg2- when locked, don't handle any events on trackbar (!IE)
{
	if (trackObj) {
		trackObj.onmousedown = null;
		trackObj.onmouseup = null;
		trackObj.onmousemove = null;
		trackObj.onmouseout = null;
	};
};

componentTrackBar.prototype.moveTrack_onmousedown = function ()
{
	//top.window.document.title = 'onMouseDown'; //pg2-test
	var parentName = this.getAttribute("myComponentName");
	var componentObj = eval('pc.'+parentName);

	if (!componentObj.trackCanDragging) {
		componentObj.position = componentObj.oldPosition;
		return;
	};

	parentName = this.getAttribute("myParentName");
	parentObj = document.getElementById(parentName);

	if (componentObj) {
		componentObj.dragobject = parentObj;
	} else componentObj.dragobject = null;

	if (componentObj.dragobject && parentObj) {
		componentObj.tx = window.event.clientX - componentObj.getLeftPos(parentObj);
		componentObj.ty = window.event.clientY - componentObj.getTopPos(parentObj);
	};
	window.event.returnValue = false;
	window.event.cancelBubble = true;
};

componentTrackBar.prototype.moveTrack_onmouseup = function () 
{
	//top.window.document.title = 'onMouseUp'; //pg2-test
	var parentName = this.getAttribute("myComponentName");
	var componentObj = eval('pc.'+parentName);

	if (componentObj.dragobject) {
		componentObj.eventMouseUp(event);
		componentObj.dragobject = null;
	};
};

componentTrackBar.prototype.moveTrack_onmousemove = function () 
{
	//top.window.document.title = 'onMouseMove'; //pg2-test
	var parentName = this.getAttribute("myComponentName");
	var componentObj = eval('pc.'+parentName);

	parentName = this.getAttribute("myParentName");
	parentObj = document.getElementById(parentName);

	//top.window.document.title = 'onMouseMove: ' + componentObj.dragobject + '; ' + window.event.clientX + ':' + window.event.clientY; //pg2-test
	if (componentObj.dragobject) {
		componentObj.setImageSrc(componentObj.resourcesURL + componentObj.trackSrc);

		if (window.event.clientX >= 0 && window.event.clientY >= 0) {
			if (componentObj.orientation == 'horizontal') {
				var trackW = parentObj.style.width.replace("px", "");
				if (eval(window.event.clientX - componentObj.tx) > componentObj.trackLowOffset 
					&& eval(window.event.clientX - componentObj.tx) < eval(componentObj.w - componentObj.trackHighOffset-trackW)) {
					componentObj.dragobject.style.left = window.event.clientX - componentObj.tx;
				};
			} else {
				var trackH = parentObj.style.height.replace("px", "");
				if (eval(window.event.clientY - componentObj.ty) > componentObj.trackLowOffset 
					&& eval(window.event.clientY - componentObj.ty) < eval(componentObj.h - componentObj.trackHighOffset-trackH)) {
					componentObj.dragobject.style.top = window.event.clientY - componentObj.ty;
				};
			};
		};
		window.event.returnValue = false;
		window.event.cancelBubble = true;
	};
};

componentTrackBar.prototype.moveTrack_onmouseout = function(e) //pg2-when leaving track, calculate position (!IE)
{
	//top.window.document.title = 'onMouseOut'; //pg2-test
	var parentName = this.getAttribute("myComponentName");
	var componentObj = eval('pc.'+parentName);

	if (componentObj.dragobject) {
		componentObj.eventMouseUp(event);
		componentObj.dragobject = null;
	};
};

componentTrackBar.prototype.getLeftPos = function (parObj) 
{
	if (is.ie) {
		if (parObj.currentStyle.left == "auto") {
			return 0;
		} else {
			return parseInt(parObj.currentStyle.left);
		};
	} else {
		var result = parObj.style.left.replace("px", "");
		return result;
	};
};

componentTrackBar.prototype.getTopPos = function (parObj)
{
	if (is.ie) {
		if (parObj.currentStyle.top == "auto") {
			return 0;
		} else {
			return parseInt(parObj.currentStyle.top);
		};
	}  else {
		var result = parObj.style.top.replace("px", "");
		return result;
	};
};
