﻿module KeyboardGame {
    export class KeyboardGame extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;

        categoryIndex: number;
        wordIndex: number;
        Qtext: any;

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }

        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            if (this.json.isFirst2 && this.json.isFirst2 == true) {
                EU.loadVocabulary(this);
            };
            this.createFillQuestion();
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
        }

        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }


        createFillQuestion() {

            this.addChild(this.game.add.image(450, 100, "kb"));
            var question;
            var flag = false;
            while (flag == false) {
                flag = true;
                this.categoryIndex = Math.floor((Math.random() * EU.groups.length));
                this.wordIndex = Math.floor((Math.random() * EU.groups[this.categoryIndex].vocabulary.length));
                EU.Log(this.categoryIndex + " " + this.wordIndex);
                question = EU.groups[this.categoryIndex].vocabulary[this.wordIndex];
                EU.Log(question);
                for (var i = 0; i < EU.usedWords.length; i++) {
                    if (EU.usedWords[i] == question) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            EU.usedWords.push(question);
            this.Qtext = this.game.add.text(840, 500, question, this.Elements.FillElements.Options.Style);
            this.Qtext.anchor.set(0.5, 0.5);
            this.addChild(this.Qtext);
            this.Elements.FillElements.el.push({
                "pos": this.Elements.Position,
                "Answer": question
            });
        }
        
       

        checkIfEverythingIsCorrect() {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this) && EU.checkIfFillsAreCorrect(this)) {
                EU.Log("Correct!!!");
                if (TYPE === "gm") {
                    super.nextTask();
                }
                EU.setGameCompletion(this.parent, 1);
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;

        }
    }
} 