﻿/*
 * Copyright (C) 1995-2005 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

function doLoad()
{
	detect.check('online');

	if (!lms) return;
	
	var v = lms.LMSGetValue("cmi.location");
	var gix = (v != null && v != "") ? v : player.getStartPage();
	if (uelo) uelo.showUserAnswers = false;
	if (lms.LMSGetValue) uelo.username = lms.LMSGetValue("cmi.learner_name");
	var d = lms.LMSGetValue("cmi.suspend_data");
	if (d) {
		d = d.split("|");
		if (d) {
			if (d.length >= 2) {
				struct.setColFromString("status", d[0]);
				suspendData.setFromString(d[1]);
				if (uelo) uelo.updateUELOFromSD(d[0], d[1], d[2], d[3]);
				uelo.courseOryginalStatus = lms.LMSGetValue("cmi.completion_status");
				uelo.courseOryginalScore = lms.getScore();				
			}
		}
	}
	if (is.moz && player.enablePagesPreloader && !player.wasLoaded) {
		player.wasLoaded = true;
		player._doLoad();
	}
	//player.gotoPage(gix);
	player.restoreExitPage(gix);
	InitializeStandardTree();
	
	lms.LMSSetValue("cmi.completion_status", lms.STATUS_INCOMPLETE);
};

function doUnload() 
{
	player.contentDestroy();
	if (lms) {
		//degug method - reset data on the platform
		if (is.ie55UP && window.event && window.event.altLeft) {
			lms.LMSSetValue("cmi.location", "");
			lms.LMSSetValue("cmi.exit", "normal");
			lms.LMSSetValue("cmi.completion_status", lms.STATUS_NOT_ATTEMPTED);
			lms.LMSSetValue("cmi.success_status", "unknown");
			lms.LMSSetValue("cmi.score.min", "0");
			lms.LMSSetValue("cmi.score.max", "100");
			lms.LMSSetValue("cmi.score.raw", "0");
			lms.LMSSetValue("cmi.suspend_data", "");
		} else {
			var v = lms.LMSGetValue("cmi.credit");
			var v = lms.LMSGetValue("cmi.mode");
			
			if (config.sendLessonLocationToServer) lms.LMSSetValue("cmi.location", "" + player.gix);
			
			lms.LMSSetValue("cmi.completion_status", player.getStatusCompletedIncompleted());
			lms.LMSSetValue("cmi.progress_measure", (player.getStatusCompletedIncompleted() == lms.STATUS_COMPLETED) ? "1.0" : "0.0");
			
			var raw = player.getTotalScore();
			var ls = player.getStatusPassedFailed();
			if (ls == player.STATUS_UNKNOWN) {
				lms.LMSSetValue("cmi.success_status", "unknown");
			} else {
				var passLevel = uelo.passThreshold;
				if (raw >= passLevel) {
					lms.LMSSetValue("cmi.success_status", "passed");
				} else {
					lms.LMSSetValue("cmi.success_status", "failed");
				}
				if (raw == 100) {
					lms.LMSSetValue("cmi.score.scaled", "1.0");
				} else {
					lms.LMSSetValue("cmi.score.scaled", "0." + raw);
				}
			}
			
			if (config.sendScoreToServer) {
				lms.LMSSetValue("cmi.score.min", "0");
				lms.LMSSetValue("cmi.score.max", "100");
				lms.LMSSetValue("cmi.score.raw", (raw != "") ? raw : "0");
			}
			lms.setTime();
			if (uelo) var tryNumbers = uelo.getExerciseTryNumber();
			lms.LMSSetValue("cmi.suspend_data", struct.getColToString("status") + "|"
												+ suspendData.getToString() + "|"
												+ tryNumbers + "|"
												+ uelo.getInteractionsStatus());
			SendInteractions();
			SendObjectives(); //pg2-objectives

			if (player.getStatusCompletedIncompleted() == lms.STATUS_COMPLETED) {
				lms.LMSSetValue("cmi.exit", "");
			} else {
				lms.LMSSetValue("cmi.exit", "suspend");
			}
		}
		
		lms.free();
		lms = null;
		delete lms;
	}
};

function SendInteractions()
{
	var interactions = uelo.getInteractions("SCORM13");
	var count = parseInt(lms.LMSGetValue("cmi.interactions._count"));
	
	for (var k in interactions) {
		var item = interactions[k];
		
		lms.LMSSetValue("cmi.interactions." + count + ".id", item["id"]);
		lms.LMSSetValue("cmi.interactions." + count + ".timestamp", item["timestamp"]);
		lms.LMSSetValue("cmi.interactions." + count + ".type", item["type"]);
		lms.LMSSetValue("cmi.interactions." + count + ".latency", item["latency"]);
		lms.LMSSetValue("cmi.interactions." + count + ".result", item["result"]);
		lms.LMSSetValue("cmi.interactions." + count + ".weighting", item["weighting"]);
		lms.LMSSetValue("cmi.interactions." + count + ".learner_response", item["learner_response"]);
		lms.LMSSetValue("cmi.interactions." + count + ".description", item["description"]);
		
		var correctResponses = item["correct_responses"];
		for (var j = 0; j < correctResponses.length; j++) {
			lms.LMSSetValue("cmi.interactions." + count + ".correct_responses."
				+ j + ".pattern", correctResponses[j]);
		}
		
		count++;
	}
};

function SendObjectives() //pg2-objectives
{
	if (typeof(objectives) != "undefined") {
		objectives.Commit();
		objectives.Free();
		delete objectives;
	}
}
