/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
if (typeof(moduleDone) != "undefined") moduleDone("lexicon.js");

LexiconItem = function()
{
	this.key = null;
	this.description = null;
	this.visible = true;
	this.groups = new Array();
};

LexiconItem.prototype.setGroups = function(s)
{
	var a = s.split(",");
	for (var i in a) {
		this.groups[trim(a[i])] = "X";
	};
};

LexiconItem.prototype.free = function()
{
	this.key = null;
	this.description = null;
	this.visible = true;
};

Lexicon = function()
{
	this.items = new Array();
	this.filter = "";
	this.groups = new Array();
};

Lexicon.prototype.addGroups = function(s)
{
	var a = s.split(",");
	for(var i in a) {
		var gkey = trim(a[i]);
		if (gkey !== "") {
			this.groups[gkey] = "X";
		};
	};
};

Lexicon.prototype.add = function(key, desc, groups)
{
	var result = false;
	if (typeof(key) != "undefined" && key != "" && typeof(desc) != "undefined") {
		var index = this.items.length;
		this.items[index] = new LexiconItem();
		this.items[index].key = key;
		this.items[index].description = desc;
		this.items[index].setGroups(groups);
		this.addGroups(groups);

		result = true;
	};
	return result;
};

Lexicon.prototype.setFilter = function(value)
{
	this.filter = value.toLowerCase();
	for (var i=0; i<this.items.length; i++) {
		var ffch = this.items[i].key.charAt(0);
		var ffk = this.items[i].key.substr(0, this.filter.length).toLowerCase();
		var nos = (ffch >= "0" && ffch <= "9");

		this.items[i].visible = (this.filter == "" || ffk == this.filter || (this.filter == "0-9" && nos));
	};

	var lex_tree_comp = page.getElementsType("componentLexiconTree");
	for (var i=0; i<lex_tree_comp.length; i++) {
		var comp = lex_tree_comp[i];
		comp.reinit();
	};
};

Lexicon.prototype.setActiveKey = function(value)
{
	if (value && value != "") {
		var lex_tree_comp = page.getElementsType("componentLexiconTree");
		for (var i=0; i<lex_tree_comp.length; i++) {
			var comp = lex_tree_comp[i];
			comp.setKey(value);
		};
	};
};

Lexicon.prototype.getItem = function(key)
{
	var result = null;
	for (var i=0; i<this.items.length; i++) {
		if (this.items[i].key == key) {
			result = this.items[i];
			break;
		};
	};
	return result;
};

Lexicon.prototype.free = function()
{
	for (var i=0; i<this.items.length; i++) {
		var item = this.items[i];
		item.free();
		item = null;
	};
};

Lexicon.prototype.existsKey = function(key, partCheck)
{
	var result = false;
	if (key != "") {
		for (var i=0; i<this.items.length; i++) {
			var item = this.items[i];
			if (key == "0-9") {
				result = !isNaN(item.key.toLowerCase().charAt(0));
				if (result) break; //pg2- it must be, 'cause in next iteration result could be changed to false and...dupa
			} else
			if (typeof(partCheck) != "undefined" && partCheck) {
				if (item.key.toLowerCase().charAt(0) == key.toLowerCase().charAt(0)) {
					result = true;
					break;
				};
			} else
			if (item.toLowerCase() == key.toLowerCase()) {
				result = true;
				break;
			};
		};
	};
	return result;
};

lexicon = new Lexicon();
