/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentDialogue = function(name) {
	this.__componentText = __componentText;
	this.__componentText(name);

	if (arguments[1]) {
	} else {
		this.cloud = this.addChild(new __componentImage(null));
		this.text = this.addChild(new __componentText(null));
	};
};

componentDialogue.prototype = new __componentText();
componentDialogue.prototype.type = "componentDialogue";

componentDialogue.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
		this.resourcesURL = unescape(this.resourcesURL);

		this.imagesNameArr = [ this.cloudSrc ];
		this.getPreloadImagesArr();
	} else {
		this.text.p_checkMarkers = this.p_checkMarkers;
		this.text.p_checkPNG = this.p_checkPNG;
		this.text.pngFix = this.pngFix;

		this.cloud.p_checkMarkers = this.p_checkMarkers;
		this.cloud.p_checkPNG = this.p_checkPNG;
		this.cloud.pngFix = this.pngFix;
	};
};

componentDialogue.prototype.onCreate = function()
{
	this.captureMouseEvents();
};

componentDialogue.prototype.onPaint = function(obj) 
{
	this.style.cursor = this.cursor;
	if (this.execution) {
		this.contentObj = this.findContentObj();
		if (this.contentObj) {
			this.contentObj.innerHTML = this.initText(this.textText);
		};
		document.getElementById(this.id + "_contentCloudObj").src = this.resourcesURL + this.cloudSrc;
		if (PageInterface.GetValue("state") == psDesigning) {
			var TableTD = document.getElementById(this.id + "TableTD");
			if (TableTD) TableTD.style.border = "1px solid red";
		};
	} else {
		this.text.cursor = this.cursor;
		this.text.wrap = true;
		this.text.x = this.cloud.x + this.textFromLeft;
		this.text.y = this.cloud.y + this.textFromUp;
		this.text.w = this.cloud.w - this.textFromLeft - this.textFromRight;
		this.text.h = this.cloud.h - this.textFromUp - this.textFromDown;
	};
};

componentDialogue.prototype.componentDialogueBaseSetSizeScaledElement = componentDialogue.prototype.setSizeScaledElement;
componentDialogue.prototype.setSizeScaledElement = function(x, y, w, h)
{
	if (this.execution) {
		document.getElementById(this.id + "_cloudDIV").style.width = w;	
		document.getElementById(this.id + "_cloudDIV").style.height = h;	
		document.getElementById(this.id + "_cloudDIV").style.clip = 'rect(0px '+w+'px '+h+'px 0px)';
		document.getElementById(this.id + "_textDIV").style.width = w;	
		document.getElementById(this.id + "_textDIV").style.height = h;	
		document.getElementById(this.id + "_textDIV").style.clip = 'rect(0px '+w+'px '+h+'px 0px)';
	} else {
		this.cloud.w = w;
		this.cloud.h = h;
		this.text.w = w;
		this.text.h = h;
	};

	this.componentDialogueBaseSetSizeScaledElement(x, y, w, h);
};

componentDialogue.prototype.isReady = function() {
	if (this.execution){
		return preloadImage(this, "_1");	
	} else {
		return this.cloud.isReady();
	};
};
