﻿module MainGame {
    export class MainGameState extends BasicModule.BasicState {
        game: Phaser.Game;
        wordObj: any;
        spaces: any;
        chances: any;
        chanceIdx: number;
        keyboard: any;

        // sounds
        win: any;
        err: any;
        clickS: any;

        constructor() {
            super();
        }

        preload() {
            this.load.spritesheet("key", "Graphics/game/key.png", 110, 110, 3, 0, 0);
            this.load.image("tree", "Graphics/game/tree.png");
            this.load.image("apple", "Graphics/game/apple.png");
            this.load.spritesheet("replay", "Graphics/gui/replay.png", 108, 111, 2, 0, 0);

            this.win = new Audio("./Sounds/applause.mp3");
            this.err = new Audio("./Sounds/err.mp3");
            this.clickS = new Audio("./Sounds/click.mp3");
        }

        create() {
            super.create();

            // Creating Keyboard
            this.keyboard = [];

            var letters = "AĄBCĆDEĘFGHIJKLŁMNŃOÓPQRSŚTUVWXYZŹŻ".split("");
            var lettersLen = letters.length;

            var tem = this.game.add.button(0, 0, "key", this.click, this, 0, 0, 1);
            var pos = EU.generateGridPositions(9, 4, tem.width * 0.85, tem.height * 0.85, 10, 10, 100, 400, false);
            tem.x = pos[0].x;
            tem.y = pos[1].y;
            var t = this.game.add.text(Math.floor(tem.width / 2), Math.floor(tem.height / 2), letters[0], { fill: "white", font: "normal 54pt Arial", align: "center", wordWrapWidth: tem.width });
            t.anchor.set(0.5, 0.5);
            tem.addChild(t);
            tem.scale.set(0.8, 0.8);
            this.keyboard.push(tem);

            for (var i = 1; i < lettersLen; i++) {
                var tem = this.game.add.button(pos[i].x, pos[i].y, "key", this.click, this, 0, 0, 1);
                var t = this.game.add.text(Math.floor(tem.width / 2), Math.floor(tem.height / 2), letters[i], { fill: "white", font: "normal 54pt Arial", align: "center", wordWrapWidth: tem.width });
                t.anchor.set(0.5, 0.5);
                tem.addChild(t);
                tem.scale.set(0.8, 0.8);
                this.keyboard.push(tem);
            }

            // Creating word spaces

            this.wordObj = this.loadJSON();
            this.add.text(240, 70, "kategoria: " + this.wordObj.category, { fill: "white", font: "bold 55pt Arial", align: "center", wordWrapWidth: tem.width });

            var zeroSpace = this.add.text(300, 230, "_", { fill: "white", font: "normal 72pt Arial", align: "center", wordWrapWidth: tem.width });
            var pos = EU.generatePositions(100, zeroSpace.width, 20, this.wordObj.word.length);
            zeroSpace.x = pos[0];
            this.spaces = [];
            this.spaces.push({ "elem": zeroSpace, "filled": false });
            var len = this.wordObj.word.length;
            for (var i = 1; i < len; i++) {
                var temp = this.add.text(pos[i], 230, "_", { fill: "white", font: "normal 72pt Arial", align: "center", wordWrapWidth: tem.width });
                this.spaces.push({ "elem": temp, "filled": false });
            }

            // adding tree and apples

            var c = this.add.image(0, 0, "tree");
            c.scale.y = 1.00;

            this.chances = [];
            var apples = [{ x: 1300, y: 400 }, { x: 1350, y: 170 }, { x: 1800, y: 250 }, { x: 1450, y: 50 }, { x: 1600, y: 140 }, { x: 1650, y: 370 }, { x: 1750, y: 40 }, { x: 1500, y: 280 }, { x: 1820, y: 410 }, {x: 1470, y: 420}];
            var applesLen = apples.length;

            for (var i = 0; i < applesLen; i++) {
                var apple = this.add.image(apples[i].x, apples[i].y, "apple");
                apple.scale.set(0.85, 0.85);
                this.chances.push(apple);
            }
            this.chanceIdx = 0;



        }

        click(sprite) {
            try {
                this.clickS.pause();
                this.clickS.currentTime = 0;
            } catch (e) { }

            this.clickS.play();
            sprite.freezeFrames = true;
            var letter = sprite.children[0].text.toLowerCase();
            console.log(letter);
            var found = false;
            var wordLen = this.spaces.length;
            for (var i = 0; i < wordLen; i++) {
                if (this.wordObj.word[i].toLowerCase() === letter) {
                    found = true;
                    this.spaces[i].elem.setText(this.wordObj.word[i]);
                    this.spaces[i].filled = true;
                }
            }

            if (!found) {
                var tw = this.game.add.tween(this.chances[this.chanceIdx]);
                tw.to({ y: this.game.world.height - this.chances[this.chanceIdx].height - 40 }, 1000 + Math.random() * 300, Phaser.Easing.Bounce.Out, true, 0, 0, false);
                tw.start();
                this.chanceIdx++;

                if (this.chanceIdx === this.chances.length) {
                    this.err.play();
                    this.showMessage("Spróbuj jeszcze raz.");
                }
            }

            sprite.input.enabled = false;
            sprite.frame = 2;

            if (this.isWinner()) {
                console.log("WON");
                this.win.play();
                this.showMessage("Wygrana!");
            }
        }

        showMessage(msg) {
            var gd = this.game.add.image(1100, 0, "guide2");
            gd.scale.x = 0.85;
            gd.scale.y = 0.85;
            gd.y = this.game.height - gd.height;
            var cloud = this.game.add.image(1000, 10, "cloud");
            var txt = this.game.add.text(0, 0, msg, {});
            txt.anchor.set(0.5, 0.5);
            txt.x = cloud.width / 2;
            txt.y = cloud.height / 3;
            cloud.addChild(txt);

            for (var i = 0; i < this.spaces.length; i++) {
                this.spaces[i].elem.setText(this.wordObj.word[i]);
            }

            var retry = this.game.add.button(0, 0, "replay", this.retry, this, 0, 0, 1);
            retry.anchor.set(0.5, 0.5);
            retry.x = cloud.width / 2;
            retry.y = cloud.height * 0.6;

            cloud.addChild(retry);

            var len = this.keyboard.length;
            for (var i = 0; i < len; i++) {
                this.keyboard[i].freezeFrames = true;
                this.keyboard[i].frame = 2;
                this.keyboard[i].input.enabled = false;
            }
        }

        retry() {
            try {
                this.win.pause();
            } catch (e) { };
            try {
                this.err.pause();
            } catch (e) { };
            this.game.state.start("ChooseDifficultyState", true, false);
        }

        isWinner() {
            var l = true;
            var len = this.spaces.length;
            for (var i = 0; i < len; i++) {
                l = l && this.spaces[i].filled;
            }
            return l;
        }

        loadJSON() {
            var word;
            var len = Globals.WORDS.length;
            for (var i = 0; i < len; i++) {
                if (Globals.WORDS[i].level === Globals.DIFFICULTY) {
                    var len2 = Globals.WORDS[i].words.length;
                    var r = Math.floor(Math.random() * len2);
                    var r2 = Math.floor(Math.random() * Globals.WORDS[i].words[r].wrds.length);
                    word = { "category": Globals.WORDS[i].words[r].catName, "word": Globals.WORDS[i].words[r].wrds[r2] };
                    console.log(word);
                    return word;
                }
            }
            console.log("JSON load failed");
            return null;
        }

    }
} 