var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var ChooseDifficulty;
(function (ChooseDifficulty) {
    var ChooseDifficultyState = (function (_super) {
        __extends(ChooseDifficultyState, _super);
        function ChooseDifficultyState() {
            _super.call(this);
        }
        ChooseDifficultyState.prototype.create = function () {
            _super.prototype.create.call(this);
            var lvls = ["very_easy", "easy", "medium", "hard"];
            var positions = [{ x: 760, y: 45 }, { x: 280, y: 74 }, { x: 590, y: 380 }, { x: 154, y: 506 }];
            var lvlsLen = lvls.length;
            for (var i = 0; i < lvlsLen; i++) {
                var temp = this.game.add.button(positions[i].x, positions[i].y, lvls[i], this.setDifficulty, this, 1, 0, 2, 0);
                temp.scale.x = 0.85;
                temp.scale.y = 0.85;
            }
            var gd = this.game.add.image(1200, this.game.height * 0.473, "guide2");
            gd.scale.x = 0.95;
            gd.scale.y = 0.95;
            var c = this.game.add.image(1250, 90, "cloud");
            c.scale.x = 0.85;
            c.scale.y = 0.85;
            var goal = this.game.add.text(0, 0, "Odgadnij słowa i uzupełnij w nich brakujace litery. Za każdą błędnie wybraną literę spadnie jabłko a Ty stracisz punkt. Możesz wybrać poziom trudności.", { font: "25pt Arial", wordWrap: true, wordWrapWidth: c.width });
            goal.anchor.set(0.5, 0.5);
            goal.x = c.width / 2 + 70;
            goal.y = c.height / 2 + 30;
            c.addChild(goal);
            this.objective.play();
            this.game.world.sort('z', Phaser.Group.SORT_ASCENDING);
        };
        ChooseDifficultyState.prototype.preload = function () {
            this.load.spritesheet("very_easy", "Graphics/gui/very_easy.png", 350, 350, 3, 0, 0);
            this.load.spritesheet("easy", "Graphics/gui/easy.png", 420, 420, 3, 0, 0);
            this.load.spritesheet("medium", "Graphics/gui/medium.png", 410, 410, 3, 0, 0);
            this.load.spritesheet("hard", "Graphics/gui/hard.png", 349, 349, 3, 0, 0);
            /// loading help
            this.load.image("guide2", "Graphics/gui/guide2.png");
            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");
            // load sounds
            this.objective = new Audio("./Sounds/goal.mp3");
        };
        ChooseDifficultyState.prototype.setDifficulty = function (sprite) {
            try {
                this.objective.pause();
            }
            catch (e) {
            }
            Globals.DIFFICULTY = sprite.key;
            this.game.state.start("MainGameState", true, false);
        };
        return ChooseDifficultyState;
    })(BasicModule.BasicState);
    ChooseDifficulty.ChooseDifficultyState = ChooseDifficultyState;
})(ChooseDifficulty || (ChooseDifficulty = {}));
//# sourceMappingURL=ChooseDifficultyState.js.map