﻿module TitleScreen {
    export class TitleScreenState extends BasicModule.BasicState {
        game: Phaser.Game;
        titleScreenImage: Phaser.Sprite;

        constructor() {
            super();
        }

        create() {
            super.create();

            this.game.add.image(this.game.width / 5, this.game.height / 10, "box");
            var spons = this.game.add.image(0, this.game.height * 0.83, "sponsors");
            spons.scale.y = 1.0;
            var guide = this.game.add.image(this.game.width * 0.65, this.game.height * 0.45, "introGuide");
            guide.scale.x = 0.85;
            guide.scale.y = 0.85;
            var play = this.game.add.button(this.game.width * 0.22, this.game.height * 0.66, "play", this.playDown, this, 1, 0, 2, 1);
            play.scale.x = 0.8;
            play.scale.y = 0.8;

            this.game.world.sort();
        }

        preload() {
            super.preload();
            ///loading Intro screen
            this.load.spritesheet("play", "Graphics/gui/play_btn.png", 200, 200, 3);
            this.load.image("box", "Graphics/gui/intro_box.png");
            this.load.image("sponsors", "Graphics/gui/sponsors.png");
            this.load.image("introGuide", "Graphics/gui/guide.png");
        }

        playDown(play, pointer) {
            this.game.state.start("ChooseDifficultyState", true, false);
        }
    }
}