﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

function CorrectResponses()
{
	this.pattern = "";
};

function Interactions(pageId, elementId, elementType)
{
	this.pageId = pageId;
	this.elementId = elementId;
	this.elementType = elementType;

	this.wbteSCOId = "";
	this.wbtePageId = "";
	
	this._children = "";
	this._count = 0;
	
	this.id = elementType + "_" + pageId + "_" + elementId;
	this.correctResponses = new Array();
	this.time = "";
	this.type = "";
	this.weighting = "";
	this.studentResponse = "";
	this.result = "";
	this.latency = "";
};

Interactions.prototype.AddCorrectResponses = function(pattern)
{
	var p = this.FindCorrectResponses(pattern);
	if (p == null) {
		p = this.correctResponses[this.correctResponses.length] = new CorrectResponses(); 
		p.pattern = pattern;
	};
	return p;
};

Interactions.prototype.FindCorrectResponses = function(pattern)
{
	for (var i = 0; i < this.correctResponses.length; i++) {
		var o = this.correctResponses[i];
		if (o.pattern == pattern) {
			return o;
		};
	};
	return null;
};

function Cmi()
{
	this.interactions = new Array();
	this.organisation = "";
	this.username = "";
	this.password = "";
	this.server = "";
	this.percentCompleted = "0";
	this.pagesCount = "0";
	this.exercisePagesCount = "0";
	this.pagesVisited = "0";
	this.pointsMax = "0";
	this.points = "0";
	this.columns = "sco_identifier;page_identifier;globalPageIndex;group;question;answers;score";
};

Cmi.prototype.AddInteractions = function(pageId, elementId, elementType)
{
	var inter = this.FindInteractions(pageId, elementId, elementType);
	if (inter == null) {
		return this.interactions[this.interactions.length] = new Interactions(pageId, elementId, elementType);
	} else {
		return inter;
	};
};

Cmi.prototype.FindInteractions = function(pageId, elementId, elementType)
{
	for (var i = 0; i < this.interactions.length; i++) {
		var inter = this.interactions[i];
		if (inter.pageId == pageId && inter.elementId == elementId && inter.elementType == elementType) {
			return inter;
		};
	};
	return null;
};

Cmi.prototype.toWBTSString = function()
{
	var r = "";
	r += "[UniversalElearningDataObjectHeader]\n";
	r += "Organisation=" + this.organisation +  "\n";
	r += "Username=" + this.username + "\n";
	r += "Password=" + this.password + "\n";
	r += "Server_for_check_Answers=" + this.server + "\n";
	r += "PercentCompleted=" + this.percentCompleted + "\n";
	r += "PagesCount=" + this.pagesCount + "\n";
	r += "ExercisePagesCount=" + this.exercisePagesCount + "\n";
	r += "PagesVisited=" + this.pagesVisited + "\n";
	r += "PointsMax=" + this.pointsMax + "\n";
	r += "Points=" + this.points + "\n";
	r += "\n";
	r += "[UniversalElearningDataObjectDataFormat]" + "\n";
	r += this.columns + "\n";
	r += "\n";
	r += "[UniversalElearningDataObjectData]" + "\n";
	
	for (var i = 0; i < this.interactions.length; i++) {
		var o = this.interactions[i];
		r += o.wbteSCOId + ";" + o.wbtePageId + ";" + o.pageId + ";" + o.id + ";*;" + o.studentResponse + ";*" + "\n";
	};
	return r;
};

function CSA()
{
	this.onSetScore = null;
	this.onSetStatus = null;
	this.doc = document;
	this.cmi = new Cmi();
};

CSA.prototype.initialize = function()
{
};

CSA.prototype.finish = function()
{
}

CSA.prototype.setScore = function(score)
{
//	var item = struct.findItem(player.gix);
//	if (item) {
//		item["score"] = parseInt(score);
//	}	
	var p = uelo.FindPage(player.gix);
	if (p) {
		p.score = parseInt(score);
	};
};

CSA.prototype.getScore = function()
{
	// var item = struct.findItem(player.gix);
	// if (item) {
		// return item["score"];
	// }	

	var p = uelo.FindPage(player.gix);
	if (p) {
		return p.score;
	};
	return 0; //pg2
};

CSA.prototype.setStatus = function(status)
{
	status = status.toUpperCase();
	var item = struct.findItem(player.gix);
	if (item) {
		if (status == "C" || status == "P" || status == "F") {
			item["status"] = status;
		} else {
			item["status"] = "I";
		};
	};
	if (this.onSetStatus) this.onSetStatus(status);
};

CSA.prototype.getStatus = function(status)
{
	var item = struct.findItem(player.gix);
	return (item) ? item["status"] : "I";
};

CSA.prototype.nextPage = function()
{
	player.nextPage();
};

CSA.prototype.previousPage = function()
{
	player.previousPage();
};

CSA.prototype.gotoPage = function(gix)
{
	player.gotoPage(gix);
};

CSA.prototype.gotoEncyclopedia = function(wordToSearch)
{
	player.gotoEncyclopedia(wordToSearch);
};

CSA.prototype.getData = function(name)
{	
	return suspendData.getValue(name);
};

CSA.prototype.setData = function(name, value)
{	
	suspendData.setValue(name, value);
};

CSA.prototype.getSID = function()
{
	return player.sid;
};

CSA.prototype.resetPagesStatus = function()
{
	player.resetPagesStatus();
};

CSA.prototype.lessonLocation = function(v)
{
	player.gix = v;
};

CSA.prototype.setLightVersion = function(b)
{
	player.setLightVersion(b);
};

CSA.prototype.getLightVersion = function()
{
	return player.getLightVersion();
};

CSA.prototype.getCMIValue = function(name)
{
	return lms.getCMIValue(name);
};

CSA.prototype.getStudentName = function()
{
	return lms.getStudentName();
};

CSA.prototype.getPassingScore = function()
{
	if (lms && lms.getPassingScore) return lms.getPassingScore();
	return 100;
};

csa = new CSA();
