﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentContainer = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);

	this.allowNextStep = true;
	this.stepsTimer = null;
	
	this.hiddenScrolls4Chrome = false; //pg2-'cause 'changeOverflow4Chrome' is invoked onCreate and onHide, it's not required doing it twice
};

componentContainer.prototype = new componentElement;
componentContainer.prototype.type = "componentContainer";

componentContainer.prototype.onCreate = function(obj)
{
	this.captureMouseEvents();

	if (is.ie9) this.style.boxSizing = "content-box";
	
	var notSet = false;
	for (var i=0; i<this.children.length; i++) {
		var obj = this.children[i];
		//this.children[i].stopPropagation = true; //pg2-odznaczenie
		if (obj.parentDragging) {
			obj.stopPropagation = false;
		} else {
			obj.stopPropagation = true;
		};
		if (obj.checkAnswer && !notSet) {
			this.checkAnswer = function(e) {
				return this.checkAnswerHidden();
			};
			notSet = true;
		};
	};
	this.changeOverflow4Chrome(true); //pg2
};

componentContainer.prototype.changeOverflow4Chrome= function(hideScrolls) //pg2-in Chrome on Win7 if scrolls are enabled, they show few steps before (for hidden elements- error in Chrome)
{
	if (is.chrome && is.operatingSystem == 'Windows7' && this.scrollable) { //pg2-odznaczone do testu
		if (hideScrolls && this.hiddenScrolls4Chrome) return;
		var obj = document.getElementById(this.id);
		if (obj) {
			if (hideScrolls) { //onCreate / onHide
				this.hiddenScrolls4Chrome = true;
				if (this.vertScrollbars) {
					obj.style.overflow = 'hidden';
					obj.style.overflowX = 'hidden';
					obj.style.overflowY = 'hidden';
				} else {
					obj.style.overflow = 'hidden';
					obj.style.overflowX = 'hidden';
					obj.style.overflowY = 'hidden';
				};
			} else { //onShow
				this.hiddenScrolls4Chrome = false;
				if (this.vertScrollbars) {
					obj.style.overflow = '';
					obj.style.overflowX = '';
					obj.style.overflowY = 'auto';
				} else {
					obj.style.overflow = 'auto';
					obj.style.overflowX = 'auto';
					obj.style.overflowY = 'auto';
				};
			};
		};
	};
};

componentContainer.prototype.componentContainerBaseShow = componentContainer.prototype.show;
componentContainer.prototype.show = function()
{
	this.componentContainerBaseShow();
	for (var i = 0; i < this.children.length; i++) {
		var child = this.children[i];
		if ((child.step != STEPS_HIDDEN && page.stepIndex == child.step) || child.step == 0) { //pg2-audio2fap_container -fap, step=5, do not play at startup
			child.show();
		} else {
			child.hide();
		};
	};
	this.allowNextStep = false;
	this._stepsTimerRun(100);

	this.changeOverflow4Chrome(false); //pg2

	if (this.canDragging) { //pg2- allow container to move
		if (PageInterface.GetValue("state") != psDesigning)
			PageInterface.Execute("setOnTop", this);
	};
};

componentContainer.prototype.showChildren = function() //pg2-audio2fap_container -fap.step=5 in container - if visible, play it in step #5
{
	if (!this.visible) return;
	for (var i = 0; i < this.children.length; i++) {
		var child = this.children[i];
		if ((child.step != STEPS_HIDDEN && page.stepIndex == child.step)) { // || child.step == 0) { //pg2-simpleFlash in container blinks
			child.show();
		};
	};
};

componentContainer.prototype.beginDrag = function(obj) //pg2- look above
{
	PageInterface.Execute("setOnTop", this);
}

componentContainer.prototype.componentContainerBaseHide = componentContainer.prototype.hide;
componentContainer.prototype.hide = function()
{
	this.componentContainerBaseHide();
	
	this.changeOverflow4Chrome(true); //pg2
	
	this._stepsTimerStop();
	this.allowNextStep = true;
	for (var i = 0; i < this.children.length; i++) {
		var child = this.children[i];
		if (page) page.childMediaStop(child); //pg2-if a child is a flash-based component, stop it
		child.hide();
	};
};

componentContainer.prototype.componentContainerBaseUnload = componentContainer.prototype.unload;
componentContainer.prototype.unload = function()
{
	this.componentContainerBaseUnload();
	this.hide();
}

componentContainer.prototype.repaint = function()
{
	for (var i = 0; i < this.children.length; i++) this.children[i].repaint();
};

var counter = 0;
componentContainer.prototype._stepsTimerRun = function(interval)
{
	if (this.stepsTimer) this._stepsTimerStop();
	if (page.stepsRunAutomate) {
		this.stepsTimer = window.setTimeout("pc." + this.id + ".prepareNextStep();", interval);
	};
};

componentContainer.prototype._stepsTimerStop = function()
{
	if (this.stepsTimer != null) {
		window.clearTimeout(this.stepsTimer);
		this.stepsTimer = null;
	};
};

componentContainer.prototype.prepareNextStep = function()
{
	counter++;
	for (var i = 0; i < this.children.length; i++) {
		var child = this.children[i];
		if (!child.allowNextStep || (child.anim && child.anim.animated)) {
			this.allowNextStep = false;
			this._stepsTimerRun(100);
			return;
		};
	};
	this.allowNextStep = true;
};

componentContainer.prototype.checkAnswerHidden = function()
{
	var result = true;
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].isComponentElement && this.children[i].checkAnswer
				&& (this.children[i].visible || page.checkHiddenElementsAnswer)) {//this.checkHiddenElementsAnswer)) { //pg2- this?!?!?!?! page!!!!
			result &= this.children[i].checkAnswer();
		};
	};
	return result;
};

componentContainer.prototype.componentContainerBaseLock = componentContainer.prototype.lock;
componentContainer.prototype.lock = function()
{
	for (var i = 0; i < this.children.length; i++) {
		this.children[i].lock();
	};
	this.locked = true;
	this.componentContainerBaseLock();
};

componentContainer.prototype.componentContainerBaseUnlock = componentContainer.prototype.unlock;
componentContainer.prototype.unlock = function()
{
	for (var i = 0; i < this.children.length; i++) {
		this.children[i].unlock();
	};
	this.locked = false;
	this.componentContainerBaseUnlock();
};

componentContainer.prototype.refreshElement = function()
{
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].type == "componentFlash") this.children[i].actionFlashRewind();
		this.children[i].show();
	};
	this.hide();
};

componentContainer.prototype.componentContainerBaseResetElement = componentContainer.prototype.resetElement;
componentContainer.prototype.resetElement = function()
{
	this.componentContainerBaseResetElement();

	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].resetElement) this.children[i].resetElement(); else //pg2-ie11 -reset input within container
		if (this.children[i].checkAnswer && this.children[i].visible) {
			this.children[i].repaint();
		};
		this.children[i].unlock();
	};

	this.unlock();
	this.refreshElement();
};

componentContainer.prototype.clearAnswer = function()
{
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].clearAnswer) this.children[i].clearAnswer();
		else if (this.children[i].setAnswer) this.children[i].setAnswer("");
	};
};

componentContainer.prototype.getAnswer = function()
{
	var answer = new Array();
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].getAnswer) {
			answer[answer.length] = this.children[i].getAnswer();
		};
	};
	return answer;
};

componentContainer.prototype.getAnswerString = function()
{
	var answer = new Array();
	var answerStr = "";
	var sep = "#|#";
	var pCount = this.getParentsCount();
	if (pCount > 0) sep = "#|" + pCount + "#";

	for (var i=0; i<this.children.length; i++) {
		if (this.children[i].getAnswerString) {
			answerStr += this.children[i].getAnswerString() + sep;
		} else if (this.children[i].getAnswer) {
			answerStr += this.children[i].getAnswer() + sep;
		};
	};
	return(answerStr);
};

componentContainer.prototype.setAnswer = function(answer, sep, showCorrect)
{
	var ans = new Array();
	this.clearAnswer();
	if (typeof(answer) == "string") {
		var sep = "#|#";
		var pCount = this.getParentsCount();
		if (pCount > 0) sep = "#|" + pCount + "#";
		ans = answer.split(sep);
	} else if (typeof(answer) == "array" || typeof(answer) == "object") {
		ans = answer;
	};
	var ai = 0;
	for (var i = 0; i < this.children.length; i++) {
		if (this.children[i].setAnswer) {
			if (ai >= ans.length) break;
			this.children[i].setAnswer(ans[ai++], "", showCorrect);
		};
	};
	for (var i = 0; i < this.children.length; i++) this.children[i].invokeEvent("Repaint");
};
