﻿/*
 * Copyright (C) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
 
componentSLWMenu = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);
	
	this.treeCreated = false;
	this.pagesArr = new Array();
	this.focusFontColor = '#ff00ff';	
	this.subMenuWidth = new Array();
	this.highlightedSpanID = "";
	this.submenuOpenedId = "";
	this.menu = "";		
	
	this.paddingVert = 10;
	this.paddingHor = 2;
};

componentSLWMenu.prototype = new __componentText();
componentSLWMenu.prototype.type = "__componentText";

componentSLWMenu.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
};

componentSLWMenu.prototype.onShow = function()
{
	//this.dir = 'rtl';
	this.obj.dir = this.dir;
	
	var treePagesArr = this.treeStruct.split('#!#');
	this.menu = "";
	var fontSize = getFontSize(this.fontSize, 'px');
	var editorPaint = (PageInterface.GetValue("state") == psDesigning);
	
	var root = new SLWMenuItem(
					this.id,
					0, //page index
					-1, //parent 
					'root',//title
					this.subMenuIcon,//icon
					'',//action
					this.resourcesURL,
					this.fontFamily,
					fontSize,
					this.fontColor,
					this.itemBckgColor,
					this.itemBorder,
					editorPaint,
					this.dir,
					this.paddingVert,
					this.paddingHor
				);	
	this.pagesArr['0'] = root;

	for (var i=0; i < treePagesArr.length; i++)
	{
		var actionArr = treePagesArr[i].split('$#$')
		var pageElemArr = actionArr[2].split('||')		
 		var item = new SLWMenuItem(
						this.id,
						eval(i+1), //page index
						pageElemArr[0], //parent 
						pageElemArr[pageElemArr.length-1],//title
						this.subMenuIcon,
						actionArr[1],//action
						this.resourcesURL,
						this.fontFamily,
						fontSize,
						this.fontColor,
						this.itemBckgColor,
						this.itemBorder,
						editorPaint,
						this.dir,
						this.paddingVert,
						this.paddingHor
					);		
		item.dir = this.dir;
		this.addChildToParent(pageElemArr[0], item);
		this.pagesArr[eval(i+1)] = item;
	};	
	
	for (var i in this.pagesArr)
	{
		if (this.pagesArr[i] && this.pagesArr[i].rootParent){
			this.menu += this.pagesArr[i].toString();
		};
	};	
	var div = document.getElementById(this.id+'_menuDIV');
	
	div.innerHTML = this.menu;
}

componentSLWMenu.prototype.addChildToParent = function( parentIndex, child )
{
	var item = this.pagesArr[parentIndex];
	
	if (item){
		item.children.push(child);
		item.open =  true;
		var width = this.getCaptionWidth(child.title, child.fontFamily, child.fontSize)+2*this.paddingVert+2;//paddingVert
		item.subMenuWidth = (item.subMenuWidth > width) ? item.subMenuWidth : width;		
		child.haveParent = true;
		child.parentObj = item;
		child.rootParent = (item.title == 'root');
	}else{
		child.haveParent = false;
	};
}

componentSLWMenu.prototype.getCaptionWidth = function(text, fontFamily, fontSize)
{
	var obj = document.getElementById(this.id+"sizeDiv");
	if (obj) {
		obj.innerHTML = text;
		obj.style.fontFamily = fontFamily;
		obj.style.fontSize = fontSize;
		return obj.offsetWidth;
	};
	return 0;
}

componentSLWMenu.prototype.getOffsetLeft = function( obj )
{
	var curleft = 0;
	if (obj.offsetParent) {
		//while (obj.offsetParent) {
		curleft += obj.offsetLeft;
		obj = obj.offsetParent;
		//}
	}
	else if (obj.x) {
		curleft += obj.x;
	}
	return curleft;
}

componentSLWMenu.prototype.getOffsetRight = function( obj )
{
	var curright = 0;
	if (obj.offsetParent) {
		//while (obj.offsetParent) {
		curright += obj.offsetLeft + obj.width;
		obj = obj.offsetParent;
		//}
	}
	else if (obj.x) {
		curright += obj.x + obj.width;
	}
	return curright;
}

componentSLWMenu.prototype.getOffsetTop = function( obj )
{
	var curtop = 0;
	if (obj.offsetParent) {
		//while (obj.offsetParent) {
		curtop += obj.offsetTop
		obj = obj.offsetParent;
		//}
	}
	else if (obj.y) {
		curtop += obj.y;
	}
	return curtop;
}

componentSLWMenu.prototype.mouseClickItem = function( ID, childrenDIV, isSubMenu, elemId )
{	
	this.submenuOpenedId = childrenDIV;
	var div = document.getElementById( childrenDIV );
	var elem = document.getElementById( ID );
	var offLeft = 0;
	var offTop = 0;
	if (elem) {
		offLeft = elem.offsetWidth;
		offTop = elem.offsetHeight;
	};
	if (div) {
		div.style.color = '#000000';
		div.style.visibility = 'visible';
		div.style.display = 'block';

		if (!this.subMenuWidth[ID]){
			this.subMenuWidth[ID] = 'expanded';
		};
		if (this.dir == "ltr")
		{
			if (isSubMenu == 'true'){
				div.style.top = this.getOffsetTop(elem)+offTop;
				div.style.left = this.getOffsetLeft(elem);//-div.offsetWidth+elem.offsetWidth;
			}else{
				div.style.top = this.getOffsetTop(elem);
				div.style.left = this.getOffsetLeft(elem)+elem.offsetWidth;//+offLeft-div.offsetWidth-elem.offsetWidth;
			};
		}else{
			if (isSubMenu == 'true'){
				div.style.top = this.getOffsetTop(elem)+offTop;
				div.style.left = this.getOffsetLeft(elem)-div.offsetWidth+elem.offsetWidth;
			}else{
				div.style.top = this.getOffsetTop(elem);
				div.style.left = this.getOffsetLeft(elem)+offLeft-div.offsetWidth-elem.offsetWidth;
			};
		}
		this.clearBackgroundMyDivSpans( div );
	};

	try{
		eval('pc.'+this.pagesArr[elemId].action+';');
	}catch(e){}	
}

componentSLWMenu.prototype.hideSubmenuDiv = function( objID )
{
	var child = document.getElementById(objID);
	if (child) {
		var ln = child.childNodes.length;
		for (var i=0; i<ln; i++) {
			elem = child.childNodes[i];
			if (elem.tagName == "DIV" && elem.className == "children") {
				elem.style.visibility = 'hidden';
				elem.style.display = 'none';
			};
		};
	};
}
componentSLWMenu.prototype.hideSubmenu = function( obj )
{	
	if (obj) {	
		var child = null;		
		var elem = null;
		for (var k in this.subMenuWidth) {
			this.hideSubmenuDiv(k);
		};			
	};
	this.subMenuWidth = new Array();
};

componentSLWMenu.prototype.highlightMyParents = function( ID, index)
{
	var span = document.getElementById(ID);
	if (span) {
		span.style.background = this.itemFocusColor;
		span.style.color = this.focusFontColor;
	};
	
	if (this.pagesArr[index]){
		var par = this.pagesArr[index].getMyParent();
		if (par)
		{
			try{
				this.highlightMyParents(par.id+'-anchor', par.index);
			}catch(e){
				//recoursive calling 
			};
		};
	};
}

componentSLWMenu.prototype.clearBackgroundMyDivSpans = function( parentDIV )
{
	var ln = parentDIV.childNodes.length;
	for (var i=0; i<ln; i++) {
		child = parentDIV.childNodes[i];
		if (child.tagName == "SPAN") {
			child.style.background = this.itemBckgColor;
			child.style.color = this.fontColor;
		};
	};
}

componentSLWMenu.prototype.checkMyParentId = function( obj, ID )
{
	if (obj) {	
		if ( obj.id == ID ) 
		{
			return true;
		}else {
			return this.checkMyParentId(obj.parentNode, ID);
		}
	};
	return false;	
}
componentSLWMenu.prototype.checkMyParentExpanded = function( obj, ID )
{
	var result = false;
	
	for (var k in this.subMenuWidth)
	{
		result = this.checkMyParentId(obj, k);
		if (!result) this.hideSubmenuDiv(k);
		//if (result) return true;
	}
	return result;
}

componentSLWMenu.prototype.mouseOverItem = function(e, obj, ID, index)
{		
	this.checkMyParentExpanded(obj, this.highlightedSpanID);
	/*
	if (this.highlightedSpanID != ID){
		this.clearBackgroundMyDivSpans( obj.offsetParent );
		this.hideSubmenu( document.getElementById(this.highlightedSpanID) );
	}
	*/
	this.highlightMyParents(ID, index);
	this.highlightedSpanID = ID;
	var ev = (window.event) ? event : e;
	ev.cancelBubble = true;
	if (ev.stopPropagation) ev.stopPropagation();
	//if (ev.preventBubble) ev.preventBubble();
}

componentSLWMenu.prototype.mouseOutItem = function( ID )
{	
	var span = document.getElementById(ID);
	if (span) {
		span.style.background = this.itemBckgColor;
		span.style.color = this.fontColor;
	};
}

function SLWMenuItem(compName, index, parentIndex, title, subMenu, action, resourcesURL, fontFamily, fontSize, fontColor, bckgColor, borderColor, editorPaint, direction, paddingVert, paddingHor )
{
	this.compName = compName;
	this.id = compName+'-item-'+index;
	this.index = index;
	this.parentIndex = parentIndex;
	this.title = title;
	this.haveParent = false;
	this.parentObj = null;
	this.rootParent = false;
	this.action = action;
	
	this.resourcesURL = resourcesURL;
	this.subMenu = subMenu;
	
	this.bckgColor = bckgColor;
	this.borderColor = borderColor;
	this.fontFamily = fontFamily;
	this.fontSize = fontSize;
	this.fontColor = fontColor;
	
	this.editorPaint = editorPaint;
	this.dir = direction;
	this.paddingVert = paddingVert;
	this.paddingHor = paddingHor;
	
	this.subMenuWidth = 0;
	this.children = new Array();
};

SLWMenuItem.prototype.getMyParent = function ()
{
	return this.parentObj;
}

SLWMenuItem.prototype.toString = function ()
{
	var elemWidth = this.getCaptionWidth(this.title, this.fontFamily, this.fontSize);
	var elemHeight = this.getCaptionHeight(this.title, this.fontFamily, this.fontSize);
		
	if (this.children.length > 0){
		var myChildrenDivID = this.id + '-children';
	}else{
		var myChildrenDivID = '';
	}
	
	//var breakLine = '<br>';
	var breakLine = '';
	var	topMenu = false;
	var display = "";
	if (this.rootParent) {
		display = "inline";
		topMenu = true;
		breakLine = '';
	}
	
	var extraAction = '';
	var str = '';
	//paddingVert = 0;
	if (this.title != "-"){
		str += "<div id=\"" + this.id + "-anchor\" myChildren=\""+myChildrenDivID+"\" style=\"padding-left: "+this.paddingVert+"px; padding-top: "+this.paddingHor+"px; padding-bottom: "+this.paddingHor+"px; padding-right: "+this.paddingVert+"px; border: 1px solid "+this.borderColor+"; white-space: nowrap; background:"+this.bckgColor+"; font-family: "+this.fontFamily+"; font-size:"+this.fontSize+"; color: "+this.fontColor+"; height: "+eval(elemHeight+2*this.paddingHor)+"; width: "+this.getMyParent().subMenuWidth+"; display:"+display+";\"";
		str += " onClick=\"pc."+this.compName+".mouseClickItem( this.id, '"+myChildrenDivID+"', '"+topMenu+"', "+this.index+");\"";
		str += " onMouseover=\"pc."+this.compName+".mouseOverItem(event, this, this.id, '"+this.index+"');\"";
		str += " onMouseout=\"pc."+this.compName+".mouseOutItem( this.id );\"";	
		str += ">";
		if (!this.editorPaint && this.children.length > 0 && !this.rootParent)
		{
			if (this.dir == "ltr")
			{
				str += "<div id='"+this.id+"_subMenu' style='position: absolute; right: 5px;' ";
				str += ">";
				str += "<img src='"+this.resourcesURL + this.subMenu+"' >";
				str += "</div>";
			}else{
				str += "<div id='"+this.id+"_subMenu' style='position: absolute; left: 5px;' ";
				str += ">";
				str += "<img src='"+this.resourcesURL + this.subMenu+"' >";
				str += "</div>";
			}
		}
		
		str += this.title;
		
		if (!this.editorPaint && this.children.length > 0) {
			if (is.ie){
				var elemW = this.subMenuWidth+2;
			}else{
				var elemW = this.subMenuWidth+2*this.paddingVert+2;
			}
			str += "<div id=\""+myChildrenDivID+"\" class=\"children\" style=\"display: none; visibility: hidden; border: 1px solid gray; position: absolute; width:"+elemW+"px;\">";
			for (var i = 0; i < this.children.length; i++) {
				str += this.children[i].toString();
			};
			str += "</div>";
		};
		str += "</div>";
		str += breakLine;
	}else{
		str += "<div id=\"separator"+this.getMyParent().id+"\" style=\"position: relative; background:"+this.bckgColor+" width:"+(this.getMyParent().subMenuWidth+2*this.paddingVert+2)+"px; height: 1px;\">";
		str += "<img src='"+this.resourcesURL+"__.SLWMenu.separator.gif' width='100%' height='1px' >";
		str += "</div>";
	}
	
	return str;
};

SLWMenuItem.prototype.getCaptionWidth = function(text, fontFamily, fontSize)
{
	var obj = document.getElementById(this.compName+"sizeDiv");
	if (obj) {
		obj.innerHTML = text;
		obj.style.fontFamily = fontFamily;
		obj.style.fontSize = fontSize;
		return obj.offsetWidth;
	};
	return 0;
}

SLWMenuItem.prototype.getCaptionHeight = function(text, fontFamily, fontSize)
{
	var obj = document.getElementById(this.compName+"sizeDiv");
	if (obj) {
		obj.innerHTML = text;
		obj.style.fontFamily = fontFamily;
		obj.style.fontSize = fontSize;
		return obj.offsetHeight;
	};
	return 0;
}
















