﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

__componentText = function(name)
{
	//inherited
	this.componentElement = componentElement;
	this.componentElement(name);

	this.allowGF = true;
	this.font = {};
	this.font.family = 'Arial';
	this.font.size = 2;
	this.font.color = "#000000";
	this.font.bold = false;
	this.font.italic = false;
	this.font.underline = false;
	this.wrap = true;
	this.padding = 3;
	this.rtl = false;
	this.scrollOffset = 0;
	this.lineHeight = "100%";
	this.orgText = null;
	this.scrollable = false;
};

__componentText.prototype = new componentElement;
__componentText.prototype.type = "__componentText";

__componentText.prototype.onCreate = function(obj)
{
	this.contentObj = this.findContentObj();

	if (this.allowGF && project.globalFormating && isDefaultFont(this.font) && !isDefaultFont(project.font)) {
		this.font.family = project.font.family;
		this.font.size = project.font.size;
		this.font.color = project.font.color;
	};
};

__componentText.prototype.onPaint = function(rPngFix)
{
	if (typeof(rPngFix) != "boolean") rPngFix = false;

	this.reinitText();
	this.text = this.reformatText();

	if (this.execution) {
		if (rPngFix) this._setHTMLDef(this.text, true);
	} else {
		this._setHTMLDef(this.text, false);
	};

	if (this.execution) this.reinit();
	if (typeof(this.visualTimerDesc) != 'undefined' && typeof(config.hideVisualTimerText) != 'undefined' &&
		typeof(config.overwriteVisualTimerSettings) != 'undefined' && this.visualTimerDesc && config.overwriteVisualTimerSettings &&
		config.hideVisualTimerText)
	{
		this.hide(); //pg2-axa knf
	};
};

__componentText.prototype.reinitText = function()
{
	if (this.orgText == null) {
		this.orgText = this.text;
	} else {
		this.text = this.orgText;
	};
};

__componentText.prototype.reformatText = function()
{
	var text = this.initText(this.text);
	this.contentObj = this.findContentObj();
	//var contentDiv = document.getElementById(this.id + "Content"); //pg2-remove content from div - in new Firefox (9) o.innerHTML has at startup empty "" value - __text is modyfied in the same way. Key div is added in bodyEx.html
	//if (contentDiv) contentDiv.innerHTML = "";

	if (this.contentObj) {
		this.contentObj.innerHTML = text;
	};

	//text protector
	if (this.scrollable === false && this.contentObj && typeof(this.contentObj.offsetHeight != 'undefined')) { //pg2- in any component but TEXT it will throw an exception
		var v = 0.0;
		while (this.contentObj.offsetHeight > this.h && v > -1.0) {
			v = v - 0.05;
			//if (v < 0) break; //pg2-fix_to_AW -otherwise some texts ain't displayed as designed
			this.contentObj.style.letterSpacing = v.toString()+'px';
		};
		//if (v < 0) this.contentObj.style.letterSpacing = '0px'; //pg2-fix_to_AW -otherwise some texts ain't displayed as designed
	};

	return text;
};

__componentText.prototype.onRepaint = function(obj)
{
	this.onPaint(obj, true);
};

__componentText.prototype._setHTMLDef = function(text, rPngFix)
{
	text = this._getHTMLDef(text);
	this.setHTML(text, rPngFix);
};

__componentText.prototype.setFontStyle = function(text)
{
	if (this.font.bold  == true) text = '<b>' + text + '</b>';
	if (this.font.italic == true) text = '<i>' + text + '</i>';
	if (this.font.underline == true) text = '<u>' + text + '</u>';

	return text;
};

__componentText.prototype.replaceTextMarkers = function(text)
{
	var arr = PlayerInterface.GetValue("getTextMarkers");
	if (arr) {
		for (var key in arr) {
			var value = arr[key];
			while (text.indexOf("{=%" + key + "}") > -1) {
				res = true;
				text = text.replace("{=%" + key + "}", value);
			};
		};
	};
	return text;
}
__componentText.prototype.replaceMarkers = function(text)
{
	if (this.p_checkMarkers) {
		for (var key in me) {
			var value = me[key];
			if (value != "") {
				while (text.indexOf("{=" + key + "}") > -1) {
					text = text.replace("{=" + key + "}", value);
				};
			};
		};
	};
	return text;
};

__componentText.prototype.initDynamicContent = function(text)
{
	if (config.allowDynamicContent) {
		var properties = PlayerInterface.GetValue("dynamicContent");
		if (properties) {
			for (var key in properties) {
				var value = properties[key];
				if (value != "") {
					while (text.indexOf("*{" + key + "}*") > -1) {
						text = text.replace("*{" + key + "}*", value);
					};
				};
			};
		};
	};
	return text;
};

__componentText.prototype.initText = function(text)
{
	if (PageInterface.GetValue("state") == psDesigning) return text;

	text = text || "";

	if (text != "") {
		text = this.replaceMarkers(text);
		text = this.replaceTextMarkers(text);
		text = this.initDynamicContent(text);
		text = this.setFontStyle(text);

		while (text.indexOf('"../resources/') > -1) {
			text = text.replace('"../resources/', '"wbtres://');
		};

		while (text.indexOf("'../resources/") > -1) {
			text = text.replace("'../resources/", "'wbtres://");
		};

		while (text.indexOf('wbtres://') > -1) {
			text = text.replace('wbtres://', resourcesURL);
		};
	};

	return text;
};

__componentText.prototype._getHTMLDef = function(text)
{
	text = this.initText(text);

	this.txtw = this.w - ((is.ns4) ? 0 : (this.borderWidth * 2))-this.scrollOffset;
	this.txth = this.h - ((is.ns4) ? 0 : (this.borderWidth * 2));

	var styled = '<font id="' + this.id + '_contentObj" style="font-family:' + this.font.family
		+ ';font-size:' + getFontSize(this.font.size, "px") + 'px;color:' + this.font.color + ';'
		+ 'line-height:' + this.lineHeight + ';"'
		+ ((this.allowGF && (project.rtl || this.rtl)) ? ' dir="rtl" align="right" ' : '') + '>'
		+ text + '</font>';

	if (this.font.bold == true) styled = '<b>' + styled + '</b>';
	if (this.font.italic == true) styled = '<i>' + styled + '</i>';
	if (this.font.underline == true) styled = '<u>' + styled + '</u>';
	var t = "";
	t += '<table id="' + this.id + 'Table"';
	t += ' dir="' + this.dir + '"';
	t += ' width="' + this.txtw + '"';
	t += ' height="' + this.txth + '"';
	t += ' border="0"';
	t += ' cellpadding="' + this.padding + '" cellspacing="0"';
	t += '>';
	t += '<tr>';
	t += '<td ';

	if (typeof(this.valign) == 'undefined' || this.valign == '') this.valign = 'baseline';
	if (typeof(this.align) == 'undefined' || this.align == '') this.align = 'left';

	t += ' valign="' + this.valign + '"';

	t += ' style="text-align:'
	if (this.allowGF && (project.rtl || this.rtl))  {
		t += 'right';
	} else {
		t += this.align;
	};
	t += '"';

	t += ' ' + (this.wrap ? '' : 'nowrap');
	t += '>' + styled + '</td></tr></table>'; 
	if (this.allowGF && (project.rtl || this.rtl))  t = t.replace(/<p /gim, '<p dir="rtl" align="right" ');
	return t;
};
