﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

function formatCrossWord(ans, data)
{
	var res = "";
	try {
		var splitData = data.split("#@#");
		var arrData = splitData[0].split("!#!");
		var pos = 0;

		for (var i in arrData) {
			var line = arrData[i];
			var s = "";
			for (var j=0; j<line.length; j++) {
				if (line.charAt(j) == "&") continue;
				s += ans.charAt(pos);
				pos++;
			};
			if (s != "") {
				res += (parseInt(i)+1) + ". " + s + "<br/>";
			};
		};
	} catch (e) {
		res = ans;
	};
	return res;
};

function formatMatchDots(ans, data)
{
	var res = "";
	try {
		data = unescape(data);
		var splitData = unescape(data).split("||");
		var arrData = new Array();
		for (var i in splitData) {
			arrData[arrData.length] = splitData[i].split("#!#");
		};

		var splitAns = ans.split("||");
		var arrAns = new Array();
		for (var i in splitAns) {
			var lr = splitAns[i].split("##");
			if (lr.length >= 1) {
				var rx = new RegExp("([0-9]+):([0-9]+)","gi");
				var m = rx.exec(lr[0]);
				if (m && m.length == 3) {
					res += arrData[m[1]][m[2]] + "&nbsp;<=>&nbsp;";
				};
			};
			if (lr.length >= 2) {
				var rx = new RegExp("([0-9]+):([0-9]+)","gi");
				var m = rx.exec(lr[1]);
				if (m && m.length == 3) {
					res += arrData[m[1]][m[2]];
				}
			} else {
				res += "(&nbsp;)";
			};
			res += "<br/>";
		};
	} catch (e) {
		res = ans;
	};
	return res;
};
 
function formatSolveText(ans, data)
{
	var res = "";
	try {
		var arrAns = ans.split("#!#");
		var arrElem = new Array();
		var res = data;

		for (var i = 0; i < arrAns.length; i++) {
			arrElem[arrElem.length] = -1;
		};

		for (var i in arrAns) {
			var v = arrAns[i].split("||");
			if (v.length == 2) {
				var rx = new RegExp("(?:DDE_)([0-9]+)","gi");
				var e = rx.exec(v[0]);
				var rx = new RegExp("(?:_)([0-9]+)","gi");
				var b = rx.exec(v[1]);
				if (e && e.length == 2 && b && b.length == 2) {
					arrElem[b[1]] = e[1];
				};
			};
		};

		var match = data.match(/\{[^\{]+\}/gi);
		var s = "";
		for (var i = 0; i < match.length; i++) {
			if (arrElem[i] != -1) {
				s = match[arrElem[i]].substr(1,match[arrElem[i]].length-2);
			} else {
				s = "&nbsp;&nbsp;";
			};
			res = res.replace(match[i], "["+s+"]");
		};
	} catch(e) {
		res = ans;
	};
	return res;
};

componentDetailedReport = function(name){
    this.__componentText = __componentText;
    this.__componentText(name);
    
    this.studentScores = 0;
    this.maxScores = 0;
    this.percent = 0;
    this.mailReportText = '';
	this.enter = "%0D%0A";
};

componentDetailedReport.prototype = new __componentText;
componentDetailedReport.prototype.type = "componentDetailedReport";

componentDetailedReport.prototype.onBaseCreate = function(obj){
	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;	else this.resourcesURL = lms.resourcesURL();
		};
		this.resourcesURL = unescape(this.resourcesURL);

		this.imagesNameArr = [ this.srcOk, this.srcNotOk ];
		this.getPreloadImagesArr();
	};

	this.captureMouseEvents();
};

componentDetailedReport.prototype.getLocalUELO = function(obj)
{
	var UELO = new Object();
	UELO.beginTime = new Date(2009, 0, 1);
	UELO.endTime = new Date(2999, 11, 31);
	UELO.courseName = "Example Course Name";
	UELO.courseDescription = "Example Course Description";
	UELO.username = "User Name";
	UELO.sessionTime = calculateTimeToString(UELO.beginTime, UELO.endTime);
	UELO.pages = new Array();
	UELO.passThreshold = 100;
	return UELO;
}

componentDetailedReport.prototype.onPaint = function(obj){
	var UELO = page.getUELO();
	if (!UELO) UELO = this.getLocalUELO()

	if (UELO) {
		var localPassThreshold; //pg2-new property - during display, use different passTrheshold instead of global one (defined for entire course)
		if (this.overwritePassThreshold) {
			try {
				var val = parseInt(this.overwritePassThresholdVal);
				if (val < 0 || val > 100) this.overwritePassThresholdVal = UELO.passThreshold;
			} catch(e) {
				this.overwritePassThresholdVal = UELO.passThreshold;
			};
			localPassThreshold = this.overwritePassThresholdVal;
		} else {
			localPassThreshold = UELO.passThreshold;
		};

		var isMulti = checkExportType(config.exportDetails, 'multi');
		var struct = getStruct();
		var structPage = null;
		var p = null;

		var startTObj = UELO.beginTime;
		var startDate = startTObj.toLocaleString();
		var Sh = (startTObj.getHours < 10) ? "0" + startTObj.getHours() : startTObj.getHours();
		var Sm = (startTObj.getMinutes() < 10) ? "0" + startTObj.getMinutes() : startTObj.getMinutes();
		var Ss = (startTObj.getSeconds() < 10) ? "0" + startTObj.getSeconds() : startTObj.getSeconds();

		var endTObj = UELO.endTime;
		var endDate = endTObj.toLocaleString();

		var Sdate = UELO.beginTime;
		var Sd = (Sdate.getDate() < 10) ? "0" + Sdate.getDate() : Sdate.getDate();
		var Smo = (Sdate.getMonth() + 1 < 10) ? "0" + eval(Sdate.getMonth() + 1) : eval(Sdate.getMonth() + 1);
		var Sy = (Sdate.getFullYear() < 10) ? "0" + Sdate.getFullYear() : Sdate.getFullYear();

		var scores = 0;
		var maxScores = 0;
		var number = 1;
		var colspan = 0;
		var foundChosenPage = false;

		var stPageInfoArr = this.startPageName.split(':');
		var endPageInfoArr = this.endPageName.split(':');

		var pStartGix = -1;
		var pEndGix = -1;

		if (typeof(stPageInfoArr[1]) != 'undefined') {
			pStartGix = parseInt(stPageInfoArr[0]);
			var pStartName = stPageInfoArr[1];
		} else {
			var pStartName = stPageInfoArr[0];
		};

		if (typeof(endPageInfoArr[1]) != 'undefined') {
			pEndGix = parseInt(endPageInfoArr[0]);
			var pEndName = endPageInfoArr[1];
		} else {
			var pEndName = endPageInfoArr[0];
		};
		this.mailReportText = '';//clear to next str build

		var t = "<div id='"+this.id+"_courseData' >";
		t += "<font "+this.getCssStyle("reportTitle")+">"+this.detailedReport+"</font>";

		if (this.generalInfo) {
			t += "<TABLE CELLPADDING='2' CELLSPACING='0' BORDER='0' WIDTH='100%'>";

			if (this.showPrint) {
				t += "<TR>";
				t += '<td colspan="2" align="right"><input id="' + this.id + '_printButton" type="button" onClick="page.all[\'' + this.id + '\'].makePrintWindow();" value="'+this.reportPrint+'"></td>';
				t += "</TR>";
			};
			if (this.sendMail) {
				t += "<TR>";
				t += '<td colspan="2" align="right"><input id="' + this.id + '_mailButton" type="button" onClick="page.all[\'' + this.id + '\'].sendReportInMail();" value="'+this.reportMail+'"></td>';
				t += "</TR>";
			};
			t += "<TR>";
			t += '<td colspan="2"><HR style="height: 1px"></td>';
			t += "</TR>";
			t += "<TR>";
			t += "<TD WIDTH='200' STYLE='" + this.getCssStyle("style1") + "'>"+this.reportTitle+ "</TD>";
			t += "<TD STYLE='" + this.getCssStyle("style2") + "'>" + struct.getRootVersion(getPlayer().courseVersion) + "</TD>";
			t += "</TR>";
			this.addToMailText(this.reportTitle + ': ' + UELO.courseName + this.enter);
			t += "<TR>";
			t += "<TD STYLE='" + this.getCssStyle("style1") + "'>"+this.reportDescription+"</TD>";
			t += "<TD STYLE='" + this.getCssStyle("style2") + "'>" + UELO.courseDescription + "</TD>";
			t += "</TR>";
			this.addToMailText(this.reportDescription + ': ' + UELO.courseDescription + this.enter);
			t += "<TR>";
			t += "<TD STYLE='" + this.getCssStyle("style1") + "'>"+this.reportUserInfo+"</TD>";
			t += "<TD STYLE='" + this.getCssStyle("style2") + "'>" + this.getStudentName(UELO) + "</TD>";
			t += "</TR>";
			this.addToMailText(this.reportUserInfo + ': ' + UELO.username + this.enter);
			if (!isMulti) {
				t += "<TR>";
				t += "<TD STYLE='" + this.getCssStyle("style1") + "'>"+this.reportStart+"</TD>";
				t += "<TD STYLE='" + this.getCssStyle("style2") + "'>" + startDate + "</TD>";
				t += "</TR>";
				this.addToMailText(this.reportStart + ': ' + startDate + this.enter);
				t += "<TR>";
				t += "<TD STYLE='" + this.getCssStyle("style1") + "'>"+this.reportEnd+"</TD>";
				t += "<TD STYLE='" + this.getCssStyle("style2") + "'> " + endDate + "</TD>";
				t += "</TR>";
				this.addToMailText(this.reportEnd + ': ' + endDate + this.enter);
				t += "<TR>";
				t += "<TD STYLE='" + this.getCssStyle("style1") + "'>"+this.reportDuration+"</TD>";
				t += "<TD STYLE='" + this.getCssStyle("style2") + "'> " + UELO.getSimpleSessionTime() + "</TD>";
				t += "</TR>";
				//this.addToMailText(this.reportDuration + ':' + UELO.sessionTime + this.enter); //pg2-remove
				this.addToMailText(this.reportDuration + ': ' + UELO.getSimpleSessionTime() + this.enter); //pg2
			};
			t += "<TR>";
			t += "<TD STYLE='" + this.getCssStyle("style1") + "'>"+this.reportStatus+"</TD>";
			t += "<TD ID='"+this.id+"status' STYLE='" + this.getCssStyle("style2") + "'></TD>";
			t += "</TR>";
			t += "<TR>";
			t += "<TD STYLE='" + this.getCssStyle("style1") + "'>"+this.reportPoints+"</TD>";
			t += "<TD ID='"+this.id+"scores_maxScores' STYLE='" + this.getCssStyle("style2") + "'></TD>";
			t += "</TR>";
			t += "<TR>";
			t += "<TD STYLE='" + this.getCssStyle("style1") + "'>"+this.reportPercentage+"</TD>";
			t += "<TD ID='"+this.id+"percent' STYLE='" + this.getCssStyle("style2") + "'></TD>";
			t += "</TR>";
			t += "<TR>";
			t += "<TD ID='"+this.id+"comment' STYLE='" + this.getCssStyle("style3") + "' colspan='2'></TD>";
			t += "</TR>";
			t += "</TABLE>";
		};

		t += "<table cellpadding='2' cellspacing='1' width='100%' style='font-family: time new roman; font-size: 10pt'>";
		t += this.getTableColgroup(this.scrollableRaport);
		t += "<TR STYLE='"+this.getCssStyle("rowAlignLeft")+"'>";
		t += "<TD>"+this.reportNo+"</TD>";
		t += "<TD>"+this.reportQuestion+"</TD>";
		var colums = 0;
		if (this.answer) {
			t += "<TD>"+this.reportAnswer+"</TD>";
			colums++;
		};
		if (this.corrAnswer) {
			t += "<TD>"+this.reportCorrectAnswer+"</TD>";
			colums++;
		};
		if (this.tryPoints) {
			t += "<TD>"+this.reportTryPoints+"</TD>";
			colums++;
		};
		if (this.points) {
			t += "<TD>"+this.reportPoints+"</TD>";
			colums++;
		};
		if (this.correct) {
			t += "<TD>"+this.reportStatus+"</TD>";
			colums++;
		};

		if (this.scrollableRaport) t += "<TD width='10px'>&nbsp;</TD>";
		this.addToMailText(this.enter+'________________________________________________________________'+this.enter);

		if (colums == 0) { 
			t += "<TD></TD>";
		};

		t += "</TR>";
		t += "</table>";
		t += "</div>"

		if (this.scrollableRaport) {
			var width = this.w - 2 * this.borderWidth - 5;
			t += '<div id="' + this.id + 'scrolableDIV" style="position: relative; width:' + width + 'px; height: 0px; overflow: auto;">';
		};

		t += "<table cellpadding='2' cellspacing='1' border='0' width='100%' style='font-family: time new roman; font-size: 10pt'>";
		t += this.getTableColgroup(false);
		t += "<tr>";

		var chapterPageName = "";
		var displayedPage = "";
		var nextPageChapterName = '';
		foundChosenPage = false;
		number = 1;
		scores = 0;

		var rowIndex = 0;
		var trStyle = '';
		var pageTitle = "";
		var isStronglyInfo = false;
		var structPageStatus = "";
		var pageIndex = -1;

		var player = getPlayer(); //pg2-qr -in raport there is displayed current structure, but if course has mixed structure but wasn't solved in this session, repaint previous structure
		var isCourseMixedAndNotSolvetDuringThisSession = (player && struct && struct.isCourseMixed && !player.checkExamWasSolved() && UELO.previousMixedStructure != '' && !UELO.pageInAssessmentCheckAnswerInSession);
		//var reallyMixedAndAssesment = UELO.wasCourseReallyMixedAndPagesInAssessment();
		//if (isCourseMixedAndNotSolvetDuringThisSession && !reallyMixedAndAssesment[1]) isCourseMixedAndNotSolvetDuringThisSession = false;
		//
		for (var i = 0; i < UELO.pages.length; i++) {
			p = UELO.pages[i];
			if (pStartName == '' || (p.title == pStartName && pStartGix == -1) || p.globalIndex == pStartGix) {
				foundChosenPage = true;
			};
			isStronglyInfo = false;

			//if (p.visible == 0) { //pg2-qr -replaced with below one
			if (isCourseMixedAndNotSolvetDuringThisSession && p.isAssessment) { //pg2-qr -new
				if (!p.previouslyVisible) {
					if ((p.title == pEndName && pEndGix == -1) || p.globalIndex == pEndGix) break; else	continue;
				};
			} else { //pg2-qr -default block, with previous functionality (course structure isn't mixed, or is mixed nad during current session was solved
				if (p.visible == 0) {
					if (!config.sendDataFromHiddenPages) { //pg2-lean_om - hidden exercise pages
						if ((p.title == pEndName && pEndGix == -1) || p.globalIndex == pEndGix) {
							break;
						} else {
							continue;
						};
					};
				};
			};

			if (p.isAssessment == 0) isStronglyInfo = true;

			if (number % 2 == 0) {
				trStyle = this.getCssStyle("rowColOdd");
			} else {
				trStyle = this.getCssStyle("rowColEven");
			};
			rowIndex++;

			nextPageChapterName = '';
			if (UELO.pages[i + 1] && typeof(UELO.pages[i + 1]) != 'undefined') {
				nextPageChapterName = UELO.pages[i + 1].chapterName;
			};
			if (foundChosenPage) {
				if (isMulti) {
					structPage = struct.findItem(p.globalIndex);
					pageIndex = structPage.index;
				};
				if ((this.chapterPages) && (chapterPageName != p.chapterName) && (displayedPage != p.chapterName) && (nextPageChapterName != p.chapterName)) {
					displayedPage = p.chapterName;                    
					if (UELO.courseName != p.chapterName) {
						t += "<tr " + trStyle + "><td style='" + this.getCssStyle("es") + "' colspan='" + (2 + colums) + "'>" + p.versionChapterName + "</td></tr>";
						displayedPage = p.chapterName;
					} else {
						t += "<tr " + trStyle + "><td style='" + this.getCssStyle("es") + "' colspan='" + (2 + colums) + "'>" + p.versionTitle + "</td></tr>";
						displayedPage = p.title;
					};
				} else 
				if (p.pageType == 'Exercise' && !isStronglyInfo) {
					if (p.interactions.length > 0) {
						var interStr = "";
						var corResp = "";
						var userResp = "";
						var userPoints = 0; //pg2-qr -todo -w przypadku poprzedniego wyniku nie wyswietlac tych danych dla zadania
						var maxPoints = 0;
						var userTryNr = 0;
						var correct = true;
						var pageTitleStr = "";
						var interPointsArr = [];
						var correctStatus = [];
						var createLink = false;
						var interactionsCount = (p.interactions.length > 0)?p.interactions.length:1;

						for (var j = 0; j < p.interactions.length; j++) {
							interStr = "";
							if (!this.groupPageInter) userResp = "";
							if (this.exerciseTitle) {
								pageTitle = this.removeNotAllowedCharacters(p.versionTitle);
								if (pageTitle == "") pageTitle = p.title; //pg2
								pageTitleStr = pageTitle; //pg2-completion
							} else {
								pageTitle = this.removeNotAllowedCharacters(p.interactions[j].question);
								if (pageTitle != "") pageTitleStr += pageTitle + "<br>"; //pg2- do not add empty question string
							};

							var userPointsToDisplay = "";
							var maxPointsToDisplay = "";
							if (p.interactions[j].status == 'P') {
								if (this.groupPageInter) {
									userPoints += 1 / interactionsCount;
								} else {
									userPoints = 1 / interactionsCount;
								};
							} else {
								if (!this.groupPageInter) {
									userPoints = 0;
								};
							};

							if (number % 2 == 0) {
								trStyle = this.getCssStyle("rowColOdd");
							} else {
								trStyle = this.getCssStyle("rowColEven");
							};

							if (this.show_all_ex || (p.interactions[j].status == 'P' && this.show_passes_ex) || (p.interactions[j].status == 'F' && this.show_failed_ex)) {
								interStr += "<TR " + trStyle + ">";
								interStr += "<TD STYLE='" + this.getCssStyle("LP") + "'>" + number + "</TD>";
								switch (p.interactions[j].status) {
									case 'P':
										if (this.solved) {
											interStr += this.getPageTitleAction(p.globalIndex, pageTitle);
											createLink = true;
										} else {
											interStr += "<TD style='" + this.getCssStyle("es") + "'>" + pageTitle + "</TD>";
										};
										break;
									case 'F':
										if (this.unsolved) {
											interStr += this.getPageTitleAction(p.globalIndex, pageTitle);
											createLink = true;
										} else {
											interStr += "<TD style='" + this.getCssStyle("es") + "'>" + pageTitle + "</TD>";
										};
										break;
									case 'N':
										if (this.notAttemted) {
											interStr += this.getPageTitleAction(p.globalIndex, pageTitle);
											createLink = true;
										} else {
											interStr += "<TD style='" + this.getCssStyle("es") + "'>" + pageTitle + "</TD>";
										};
										break;
									default:
										if (this.notChecked) {
											interStr += this.getPageTitleAction(p.globalIndex, pageTitle);
											createLink = true;
										} else {
											interStr += "<TD style='" + this.getCssStyle("es") + "'>" + pageTitle + "</TD>";
										};
										break;
								};

								this.addToMailText(this.enter + this.enter);
								this.addToMailText(number + '.' + this.enter);
								this.addToMailText(this.reportQuestion + ': ');

								this.addToMailText(pageTitle + this.enter);

								if (this.answer) {
									userResp += this.getUserAnswerCellInner(isMulti, p, j, pageIndex) + "<br>";
									interStr += "<TD STYLE='" + this.getCssStyle("es") + "'>" + userResp + "</td>";
								};

								if (this.corrAnswer) {
									corResp += this.getCorrectAnswerCellInner(isMulti, p, j, pageIndex) + "<br>";
									interStr += "<TD STYLE='" + this.getCssStyle("es") + "'>" + corResp + "</td>";
								};

								if (this.tryPoints) {
									userTryNr = this.getTryCountCellInner(isMulti, p, j, pageIndex);
									interStr += "<TD STYLE='" + this.getCssStyle("es1") + "'>" + userTryNr + "</td>";
								};

								maxPoints = 1 / interactionsCount;
								if (this.points) {
									interPointsArr = this.getPointsCellInnerArr(isMulti, p, j, pageIndex, maxPoints, userPoints);
									maxPointsToDisplay = interPointsArr[0]; 
									userPointsToDisplay = interPointsArr[1]; 

									interStr += "<TD STYLE='" + this.getCssStyle("es1") + "'>" +maxPointsToDisplay+ "/" +userPointsToDisplay+ "</td>";
								};

								if (this.correct) {
									if (isCourseMixedAndNotSolvetDuringThisSession && p.isAssessment) { //pg2-qr new
										correctStatus = (p.previousStatus == 'P');
									} else {
										correctStatus = this.getStatusBoolean(isMulti, p, j, pageIndex, maxPoints, userPoints, "passed", "P"); //pg2-qr -old
									};

									correct = (correct && correctStatus);
									var fontStr = this.getStatusCellInner(correctStatus, false);
									interStr += "<TD STYLE='" + this.getCssStyle("es1") + "'>" + fontStr + "</td>";
								};
								if (!this.groupPageInter) number++;
							};
							if (!this.groupPageInter) t += interStr;
						};
						if (this.groupPageInter) {
							maxPoints = 1;

							t += "<TR " + trStyle + ">";
							t += "<TD STYLE='" + this.getCssStyle("LP") + "'>" + number + "</TD>";
							if (this.exerciseTitle) {
								if (createLink) {
									t += this.getPageTitleAction(p.globalIndex, pageTitleStr); //pg2-pageTitle to pageTitleStr
								} else {
									t += "<TD style='" + this.getCssStyle("es") + "'>" + pageTitleStr + "</td>"; //pg2-pageTitle changed to pageTitleStr
								};
							} else {
								if (createLink) {
									t += this.getPageTitleAction(p.globalIndex, pageTitleStr); //pg2-pageTitle to pageTitleStr
								} else {
									t += "<TD style='" + this.getCssStyle("es") + "'>" + pageTitleStr + "</td>";
								};
							};
							if (this.answer) {
								t += "<TD STYLE='" + this.getCssStyle("es") + "'>"+userResp+"</td>";
							};
							if (this.corrAnswer) {
								t += "<TD STYLE='" + this.getCssStyle("es") + "'>" + corResp + "</td>";
							};
							if (this.tryPoints) {
								t += "<TD STYLE='" + this.getCssStyle("es1") + "'>" + userTryNr + "</td>";                                
							};
							if (this.points) {
								t += "<TD STYLE='" + this.getCssStyle("es1") + "'>" + interPointsArr[0] + "/1</td>"; 
							};
							if (this.correct) {
								var fontStr = this.getStatusCellInner(correct, false);
								t += "<TD STYLE='" + this.getCssStyle("es1") + "'>" + fontStr + "</td>";
							};
							t += "</tr>";
							number++;
						} else {
							maxPoints += 1;
						};
						if (isMulti) {
							structPageStatus = this.getSCOStatus(pageIndex);
							if (structPageStatus == "passed") scores += 1;
						} else {
							if (isCourseMixedAndNotSolvetDuringThisSession && p.isAssessment) { //pg2-qr new
								scores += (p.previousStatus == 'P'?1:0);
							} else
							if (p.status == "P") scores += 1;
						};
						maxScores += 1;
					};
				} else 
				if (p.pageType == 'Poll' && !isStronglyInfo) {
					if (p.interactions.length > 0) {
						for (var j = 0; j < p.interactions.length; j++) {
							if (this.exerciseTitle) {
								pageTitle = ((p.versionTitle == "")?p.title:p.versionTitle);
							} else {
								pageTitle = this.removeNotAllowedCharacters(p.interactions[j].question);
							};
							if (number % 2 == 0) {
								trStyle = this.getCssStyle("rowColOdd");
							} else {
								trStyle = this.getCssStyle("rowColEven");
							};
							correctA = (p.interactions[j].result.toString() == "true") ? this.reportPassed: this.reportFailed;
							t += "<TR>";
							t += "<TD STYLE='" + this.getCssStyle("LP") + "'>" + number + "</TD>";

							this.addToMailText(this.enter+this.enter);
							this.addToMailText(number + '.' + this.enter);

							t += "<TD style='" + this.getCssStyle("es") + "'>" + pageTitle + "</TD>";

							this.addToMailText(this.reportQuestion + ': ');
							this.addToMailText(pageTitle + this.enter);
							if (this.answer) {
								var sAnswer = this.removeNotAllowedCharacters(p.interactions[j].studentResponse);
								if (sAnswer.indexOf("||[%Open%]:") > -1) {
									sAnswer = sAnswer.replace("||[%Open%]:", "/");
								};
								if (sAnswer == "") {
									sAnswer = "&nbsp;";
								};
								t += "<TD STYLE='" + this.getCssStyle("es") + "'>" + sAnswer + "</TD>";
								this.addToMailText(this.reportAnswer + ': ');
								this.addToMailText(sAnswer + this.enter);
							};
							t += "<TD STYLE='" + this.getCssStyle("es") + "'>&nbsp;</TD>";
							t += "<TD STYLE='" + this.getCssStyle("es") + "'>&nbsp;</TD>";
							this.addToMailText(this.reportStatus + ': ');
							this.addToMailText(((p.pageVisited == 0) ? this.reportNotVisited : this.reportVisited) + this.enter);
							t += "</TR>";
							number++;
						};
					};
				} else
				if (p.pageType == 'Information' || isStronglyInfo) {
					if (number % 2 == 0) {
						trStyle = this.getCssStyle("rowColOdd");
					} else {
						trStyle = this.getCssStyle("rowColEven");
					};
					var p1 = '';
					if (UELO.pages[i + 1] && typeof(UELO.pages[i + 1]) != 'undefined') {
						p1 = UELO.pages[i + 1].chapterName;
					};

					if (this.informationPages && displayedPage != p.title) {
						colspan = 1;
						p.pageVisited = 1;

						if (this.points) colspan += 1;
						if (this.answer) colspan += 1;
						if (this.corrAnswer) colspan += 1;
						if (this.tryPoints) colspan += 1;

						if (colspan == 0) colspan = 1;

						t += "<TR " + trStyle + ">";
						t += "<TD STYLE='" + this.getCssStyle("LP") + "'>" + number + "</TD>";
						this.addToMailText(this.enter+this.enter);
						this.addToMailText(number + '.' + this.enter);
						t += "<TD colspan='" + colspan + "' style='" + this.getCssStyle("es") + "'>" + ((p.versionTitle == "")?p.title:p.versionTitle) + "</TD>";
						//this.addToMailText(this.reportQuestion + ': '); //pg2-remove
						this.addToMailText(((p.versionTitle == "")?p.title:p.versionTitle) + this.enter);
						if (this.correct) {
							correctStatus = this.getStatusBoolean(isMulti, p, 0, pageIndex, 0, 0, "completed", "C");
							if (parseInt(p.globalIndex) == parseInt(page.p_globalIndex) && p.pageType == 'Information') correctStatus = true; //pg2-current page with detailed report- show it as visited
							var fontStr = this.getStatusCellInner(correctStatus, true);

							t += "<TD STYLE='" + this.getCssStyle("es") + "' style='white-space: nowrap;'>" + fontStr + "</TD>";
						};
						t += "</TR>";
						//this.addToMailText(this.reportStart + ':'); //pg2-remove
						//this.addToMailText(((p.status == 'N') ? this.reportNotVisited : this.reportVisited) + this.enter); //pg2-remove
						number++;
					};
				};
				chapterPageName = p.chapterName;
			};
			if ((p.title == pEndName && pEndGix == -1) || p.globalIndex == pEndGix) {
				break;
			};
		};

		this.addToMailText(this.enter+'________________________________________________________________'+this.enter);

		scores = (scores) ? scores : 0;
		var percent = 0;
		if (maxScores != 0){
			var scorePrec = parseInt(this.reportPointsPrecision);
			percent = ((scores * 100) / maxScores).toFixed(scorePrec);
		} else {
			percent = 0;
		};
		this.studentScores = scores;
		this.maxScores = maxScores;
		this.percent = percent;

		t += "<TR>";
		t += "<TD></TD>";
		t += "<TD></TD>";
		if (this.answer) {
			t += "<TD></TD>";
		};
		if (this.corrAnswer) {
			t += "<TD></TD>";
		};
		if (this.tryPoints) {
			t += "<TD></TD>";
		};
		if (this.points) {
			t += "<TD STYLE='" + this.getCssStyle("rowAlignLeft") + "'>" + scores + "/" + maxScores + "</TD>";
		};
		this.addToMailText(this.reportPoints + ': ' + scores + "/" + maxScores + this.enter);
		this.addToMailText(this.reportPercentage + ': ' + ((percent != "NaN") ? percent : 0) + '%'+this.enter);

		//this.addToMailText(this.reportStatus + ':' + ((parseInt(percent) >= UELO.passThreshold) ? this.reportNotVisited : this.reportVisited) + this.enter); //pg2-remove
		//this.addToMailText(this.reportStatus + ': ' + ((parseInt(percent) >= UELO.passThreshold) ? this.reportPassed : this.reportFailed) + this.enter); //pg2 //pg2-removed, replaced with below one
		this.addToMailText(this.reportStatus + ': ' + ((parseInt(percent) >= localPassThreshold) ? this.reportPassed : this.reportFailed) + this.enter); //pg2

		t += "</TR>";
		t += "</TABLE>";

		if (this.scrollableRaport) {
			t += '</DIV>';
		};
		if (this.execution) {
			var content = this.findContentObj();
			if (content) content.innerHTML = t;
			var scoreTD = document.getElementById(this.id + "scores_maxScores")
			if (scoreTD) scoreTD.innerHTML = scores + "/" + maxScores;
			var percentTD = document.getElementById(this.id + "percent")
			if (percentTD) percentTD.innerHTML = percent + "%";
			var statusTD = document.getElementById(this.id + "status")

			//if (statusTD) statusTD.innerHTML = (parseInt(percent) >= UELO.passThreshold) ? this.reportPassed : this.reportFailed; //pg2-replaced with below one
			if (statusTD) statusTD.innerHTML = (parseInt(percent) >= localPassThreshold) ? this.reportPassed : this.reportFailed;

			var commentTD = document.getElementById(this.id + "comment")
			//if (parseInt(percent) >= UELO.passThreshold) { //pg2-replaced with below one
			if (parseInt(percent) >= localPassThreshold) {
				this.addToMailText(this.textWhenPass + this.enter + this.enter);
				if (commentTD) commentTD.innerHTML = this.textWhenPass;
				window.setTimeout("pc." + this.id + ".invokeEvent('Passed');",100); //this.invokeEvent('Passed'); //pg2- if order in step0 (example) is 'detRep1.show(); text1.hide(); text2.hide()', in 'detRep1.show()' text2 will be shown, and next- hidden; so delay this action
			} else {
				this.addToMailText(this.textWhenFail + this.enter + this.enter);
				if (commentTD) commentTD.innerHTML = this.textWhenFail;
				window.setTimeout("pc." + this.id + ".invokeEvent('Failed');",100); //this.invokeEvent('Failed'); //pg2-just as above with 'passed'
			};
		} else {
			this.text = t;
		};
	} else {
		if (this.execution) {
			document.getElementById(this.id + "_contentObj").innerHTML = this.componentInfo;
		} else {
			this.text = this.componentInfo;
		};
	};
	this.setInteractionDivHeight();
};

componentDetailedReport.prototype.getPageTitleAction = function(gotoPage, pageTitle)
{
	return "<TD style='" + this.getCssStyle("es") + "' onClick='pc." + this.id + ".gotoPage(" + gotoPage + ");'><u><font style='cursor: pointer'>" + pageTitle + "</font></u></TD>";
};

componentDetailedReport.prototype.getCorrectAnswerCellInner = function(isMulti, ueloPage, iIndex, pageIndex)
{
	var result = "";
	if (isMulti) {
		var cRes = this.getValueFromSCO("cmi.interactions.0.correct_responses.0.pattern", pageIndex-2);
		if (cRes != null && cRes != "null" && cRes != "") {
			cRes = cRes.replace(/_/ig, " ");
			cRes = cRes.replace(/\[,\]/ig, "<br>");
			result += cRes;
		} else {
			result += "";
		};
	} else {
		var cResponse = unescape(ueloPage.interactions[iIndex].correctResponsesAsText);
		if (cResponse == "" && ueloPage.interactions[iIndex].type == 'choice') {
			cResponse = unescape(ueloPage.interactions[iIndex].correctResponses);
			cResponse = this.getAsText(ueloPage.interactions[iIndex].answerValuesString, cResponse);
		};
		result += cResponse;

		this.addToMailText(this.reportCorrectAnswer + ': ');
		this.addToMailText(cResponse + this.enter);
	};
	result = result.replace(new RegExp('#&034', "g"), '"'); //pg2-replacing '#&034' with quotation marks
	return result;
};

componentDetailedReport.prototype.getUserAnswerCellInner = function(isMulti, ueloPage, iIndex, pageIndex)
{
	var result = "";
	if (isMulti) {
		var lRes = this.getValueFromSCO("cmi.interactions.0.learner_response", pageIndex-2);
		if (lRes != null && lRes != "null" && lRes != "") {
			var lRes = this.getValueFromSCO("cmi.interactions.0.student_response", pageIndex-2);
			if (lRes != null && lRes != "null" && lRes != "") {
				lRes = lRes.replace(/_/ig, " ");
				lRes = lRes.replace(/\[,\]/ig, "<br>");
				result += lRes;
			} else {
				result += "";
			};
		} else {
			result += "";
		};
	} else {
		var sResponse = "";
		if (ueloPage.interactions[iIndex].elementType == 'solveText') {
			sResponse = formatSolveText(ueloPage.interactions[iIndex].studentResponse, ueloPage.interactions[iIndex].reportData);
		} else
		if (ueloPage.interactions[iIndex].elementType == 'matchDots') {
			sResponse = formatMatchDots(ueloPage.interactions[iIndex].studentResponse, ueloPage.interactions[iIndex].reportData);
		} else
		if (ueloPage.interactions[iIndex].elementType == 'crossWord') {
			sResponse = formatCrossWord(ueloPage.interactions[iIndex].studentResponse, ueloPage.interactions[iIndex].reportData);
		} else {
			sResponse = unescape(ueloPage.interactions[iIndex].studentResponseAsText);
		};

		if (sResponse == "") {
			if (ueloPage.interactions[iIndex].type == 'choice') {
				sResponse = unescape(ueloPage.interactions[iIndex].studentResponse);
				sResponse = this.getAsText(ueloPage.interactions[iIndex].answerValuesString, sResponse);
			} else { //pg2-new
				sResponse = unescape(ueloPage.interactions[iIndex].studentResponse);
			};
		};
		result += sResponse;

		this.addToMailText(this.reportAnswer + ': ');
		this.addToMailText(sResponse + this.enter);
	};

	result = result.replace(new RegExp('#&034', "g"), '"'); //pg2-replacing '#&034' with quotation marks
	return result;
};

componentDetailedReport.prototype.getTryCountCellInner = function(isMulti, ueloPage, iIndex, pageIndex)
{
	var result = "";
	if (isMulti) {
		var sd = this.getValueFromSCO("cmi.suspend_data", pageIndex-2);
		if (sd != null && sd != "") {
			var sdArr = sd.split("_tn=");
			if (typeof(sdArr[1]) != 'undefined') {
				result += sdArr[1].split("|")[0];
			} else {
				result += 0;
			};
		} else {
			result += 0;
		};
	} else {
		result += ueloPage.interactions[iIndex].tryNumber;

		this.addToMailText(this.reportTryPoints + ': ');
		this.addToMailText(ueloPage.interactions[iIndex].tryNumber + this.enter);
	};
	return result;
};

componentDetailedReport.prototype.getPointsCellInnerArr = function(isMulti, ueloPage, iIndex, pageIndex, maxPoints, userPoints)
{
	var result = [];
	if (isMulti) {
		structPageStatus = this.getSCOStatus(pageIndex);
		if (structPageStatus == "passed") {
			if (this.groupPageInter) {
				result = [1, 1];
			} else {
				result = [maxPoints.toFixed(3), maxPoints.toFixed(3)];
			};
		} else {
			result = [0, maxPoints.toFixed(3)];
		};
	} else {
		var maxPointsToDisplay = (maxPoints == 1 || maxPoints == 0)?maxPoints:maxPoints.toFixed(3); 
		var userPointsToDisplay = (userPoints == 1 || userPoints == 0)?userPoints:userPoints.toFixed(3);

		result = [userPointsToDisplay, maxPointsToDisplay];

		this.addToMailText(this.reportPoints + ': ');
		this.addToMailText(((ueloPage.interactions[iIndex].result.toString() == "true") ? userPointsToDisplay : 0) + " / " + maxPointsToDisplay + this.enter);
	};
	return result;
};

componentDetailedReport.prototype.getStatusBoolean = function(isMulti, ueloPage, iIndex, pageIndex, maxPoints, userPoints, compareStatusLong, compareStatusShort)
{
	var result = "";
	var fontStr = "";
	var isCorrect = true;

	if (isMulti) {
		var assessment = true; //pg2
		if (struct) {
			var item = struct.item(pageIndex-2);
			if (item) assessment = (item["iss"] == "1");
		};
		var structPageStatus = this.getSCOStatus(pageIndex);
		result = ((structPageStatus == compareStatusLong) || ((structPageStatus == "passed" || structPageStatus == "failed") && assessment == "0"));
	} else {
		var assessment = (ueloPage.isAssessment == 1); //pg2
		if (assessment) {
			if (compareStatusShort == "P") {
				result = (ueloPage.interactions[iIndex].result.toString() == "true");
			} else
			if (compareStatusShort == "C"){
				result = (ueloPage.status == compareStatusShort);
			};
		} else {
			result = (ueloPage.status != "N"); //pg2
		};
	};
	this.addToMailText(this.reportStatus + ': ');
	//pg2
	var strStatus = "";
	if (compareStatusShort == "C") strStatus = this.reportVisited; else
	if (compareStatusShort == "N") strStatus = this.reportNotVisited; else
	if (compareStatusShort == "P" || compareStatusShort == "C") strStatus = compareStatusLong;
	//this.addToMailText(result ? ":)" : ":("); //pg2-remove
	this.addToMailText(strStatus + this.enter); //pg2

	return result;
};

componentDetailedReport.prototype.getStatusCellInner = function(isCorrect, informationPage)
{
	var fontStr = "";
	var color = this.getCssStyle("color");

	if (informationPage) {
		var correctA = (isCorrect) ? this.reportVisited : this.reportNotVisited;
		fontStr =  "<FONT '" + color + "'>" + correctA + "</FONT>";
	} else
	if (this.showGraph) {
		var correctA = isCorrect ? this.srcOk : this.srcNotOk;
		fontStr = '<img src="' + this.resourcesURL + correctA + '">';
	} else {
		var color = (isCorrect) ? this.correctAnswer : this.inCorrectAnswer;
		var correctA = (isCorrect) ? this.reportPassed : this.reportFailed;
		fontStr =  "<FONT COLOR='" + color + "'>" + ((this.correct) ? correctA : "-") + "</FONT>";
	};
	return fontStr;
};

componentDetailedReport.prototype.getSCOStatus = function(pageIndex)
{
	var SCOStatus = "";
	var isExam = PageInterface.GetValue("isExam");

	if (isExam) {
		SCOStatus = lms.getValueForSco(pageIndex-2);
	} else {
		SCOStatus = this.getValueFromSCO('cmi.core.lesson_status', pageIndex-2);
	};
	if (SCOStatus == null || SCOStatus.toString() == "null") {
		SCOStatus = this.getValueFromSCO('cmi.success_status', pageIndex-2);
		if (SCOStatus == 'unknown'){
			SCOStatus = this.getValueFromSCO('cmi.completion_status', pageIndex-2);
		};
	};
	return SCOStatus;
};

componentDetailedReport.prototype.getStudentName = function(UELO)
{
	var username = "";
	if (UELO.username != "") return UELO.username;

	if (lms.LMSGetValue) {
		username = lms.LMSGetValue("cmi.learner_name");
		if (username == null || username.toString() == "null") {
			username = lms.LMSGetValue("cmi.core.student_name");
		};
	};
	return username;
};

componentDetailedReport.prototype.getValueFromSCO = function(valueParam, pageIndex)
{
	var result = "";
	if (lms) {
		if (lms.name == "lmsExam") {
			result = lms.getValueForSco(pageIndex);
		} else {
			result = lms.getValueForSco(valueParam, pageIndex);
		};
		if (result == null) result = "";
	};
	//return (lms)?lms.getValueForSco(valueParam, pageIndex):"";
	return result;
};

componentDetailedReport.prototype.setInteractionDivHeight = function()
{
	if (this.scrollableRaport) {
		var courseData = document.getElementById(this.id + "_courseData");
		var height = this.h - 2 * this.borderWidth - courseData.offsetHeight - 5;

		var scrolableDIV = document.getElementById(this.id + "scrolableDIV");
		if (scrolableDIV) scrolableDIV.style.height = height+"px"; //pg2- if found...
	};
};

componentDetailedReport.prototype.getCssStyle = function(cssStyle)
{
	var result = "";
	var font = getProjectFont(this.allowGF, this.fontFamily, this.fontSize, this.fontColor);
	switch (cssStyle)
	{
		case "color" : 
			result = "color: " + font.color;
			break;
		case "style1" : 
			if (this.dir == "rtl") {
				result = "vertical-align: top; font-family: " + font.family + "; font-size: " + getFontSize(font.size, 'px') + "; text-align: left; font-weight: bold; color: " + font.color + "";
			} else {
				result = "vertical-align: top; font-family: " + font.family + "; font-size: " + getFontSize(font.size, 'px') + "; text-align: left; font-weight: bold; color: " + font.color + "";
			};
			break;
		case "style2" : 
			if (this.dir == "rtl") {
				result = "vertical-align: top; font-family: " + font.family + "; font-size: " + getFontSize(font.size, 'px') + "; text-align: right; color: " + font.color + "";
			} else {
				result = "vertical-align: top; font-family: " + font.family + "; font-size: " + getFontSize(font.size, 'px') + "; text-align: right; color: " + font.color + "";
			};
			break;
		case "style3" : 
			result = "vertical-align: top; font-family: " + font.family + "; font-size: " + getFontSize(font.size, 'px') + "; text-align: center; color: " + font.color + "";
			break;
		case "rowAlignLeft" : 
			result = "vertical-align: top; background: #F3F3F3; font-family: " + font.family + "; font-size: " + getFontSize(font.size, 'px') + "; text-align: center; font-weight: bold; color: " + font.color + "; white-space: nowrap;";
			break;
		case "LP" : 
			result = "vertical-align: top; font-family: " + font.family + "; font-size: " + getFontSize(font.size, 'px') + "; text-align: right; font-weight: normal; padding-right: 5px; color: " + font.color + "";
			break;
		case "es" : 
			result = "vertical-align: top; font-family: " + font.family + "; font-size: " + getFontSize(font.size, 'px') + "; text-align: left; font-weight: normal; color: " + font.color + "";
			break;
		case "es1" : 
			result = "vertical-align: top; font-family: " + font.family + "; font-size: " + getFontSize(font.size, 'px') + "; text-align: center; font-weight: normal; color: " + font.color + "";
			break;
		case "rowColEven" : 
			result = "style='background:" + this.rowEvenColour + ";'";
			break;
		case "rowColOdd" : 
			result = "style='background:" + this.oddEvenColour + ";'";
			break;
		case "reportTitle" : 
			result = "style='font-weight: bold; font-size: +" + getFontSize(font.size, 'px') + "pt; font-family: Times New Roman'";
			break;
	};
	return result;
};

componentDetailedReport.prototype.addToMailText = function(text)
{
	this.mailReportText += text;
};

componentDetailedReport.prototype.getColWidth = function(width)
{
	var t = "";
	if (width == '*') {
		t += "<col/>";
	} else {
		t += "<col width='"+width+"'>";
	};
	return t;
};

componentDetailedReport.prototype.getTableColgroup = function(extra)
{
	var t = "";
	t += "<colgroup>";
	t += this.getColWidth('30px');
	t += this.getColWidth(this.questionCol);
	if (this.answer) t += this.getColWidth(this.answerCol);
	if (this.corrAnswer) t += this.getColWidth(this.corrAnswerCol);
	if (this.tryPoints) t += this.getColWidth(this.tryPointsCol);
	if (this.points) t += this.getColWidth(this.pointsCol);
	if (this.correct) t += this.getColWidth(this.resultCol);
	if (extra) t += this.getColWidth('10px');
	t += "</colgroup>";
	return t;
};

componentDetailedReport.prototype.gotoPage = function(pageGI)
{
	me.backToPageAddress = page.p_globalIndex; //pg2-axa_template
	if (opener) {
		opener.PlayerInterface.Execute('gotoPage', pageGI);
		if (this.closeOpenerPage) window.close();
	} else {
		PlayerInterface.Execute('gotoPage', pageGI);
	};
};

componentDetailedReport.prototype.getAsText = function(valuesStr, ind)
{
	if (valuesStr == "") return "";
    var corrArr = decIntoBin(ind).split('');
    var result = "";
    var sep = "";
    var valuesArr = valuesStr.split('||');

    for (var i = 0; i < corrArr.length; i++) {
        if (result != "") sep = "<br>";
        if (corrArr[i] == '1') result += valuesArr[i];
    };
    return result;
};

componentDetailedReport.prototype.makePrintWindow = function(obj){
	var width = this.w - 2 * this.borderWidth - 2;
	if (this.generalInfo) {
		var height = this.h - 2 * this.borderWidth - 248;
	} else {
		var height = this.h - 2 * this.borderWidth - 115;
	};
	if (document.getElementById(this.id + "_printButton")) {
		document.getElementById(this.id + "_printButton").style.display = 'none';
	};
	if (document.getElementById(this.id + "_mailButton")) {
		document.getElementById(this.id + "_mailButton").style.display = 'none';
	};

	var scrolableDIV = document.getElementById(this.id + "scrolableDIV");
	var Table = document.getElementById(this.id + "Table");
	var tmpWidth = this.obj.offsetWidth;
	if (scrolableDIV) {
		scrolableDIV.style.height = "100%";
		tmpHeight = scrolableDIV.offsetHeight;
		tmpWidth = scrolableDIV.offsetWidth;
		scrolableDIV.style.width = "100%";
		scrolableDIV.style.overflowX = "hidden";
		scrolableDIV.style.overflowY = "hidden";
		if (Table) Table.width = "100%";
	};
	var temp = this.obj.innerHTML;
	temp = temp.replace(/style='cursor: pointer'/gm, '');
	while (temp.indexOf('pc.' + this.id + '.gotoPage') > -1) {
		temp = temp.replace('pc.' + this.id + '.gotoPage', 'gotoPage');
	};

	if (scrolableDIV) {
		scrolableDIV.style.height = tmpHeight;
		scrolableDIV.style.width = tmpWidth;
		scrolableDIV.style.overflowX = "hidden";
		scrolableDIV.style.overflowY = "auto";
	};
	if (Table) {
		Table.width = tmpWidth + "px";
	};
	if (document.getElementById(this.id + "_printButton")) {
		document.getElementById(this.id + "_printButton").style.display = '';
	};
	if (document.getElementById(this.id + "_mailButton")) {
		document.getElementById(this.id + "_mailButton").style.display = '';
	};
	temp = '<!doctype html><html><script type="text/javascript">function gotoPage(){return};</script><body onload="self.print();">' + temp + '</body><html>';
	var win = window.open("", '_blank', 'menubar=no, toolbar=no, location=no, scrollbars=yes, resizable=yes, status=yes, width='+this.printWindowW+', height='+this.printWindowH);

	win.document.write(temp);
	win.document.close();
	win.focus();
};

componentDetailedReport.prototype.sendReportInMail = function(obj){
    var UELO = page.getUELO();
    if (top.isWBTServer) {
        mailWindow = this.openWin("/4ses/servlet/MainServlet?method=lms.SendMail&email=" + this.eMailAdress + "&title=" + "E-mail from " + this.replaceCharsInMail(UELO.courseName) + "&mailBody=" + this.replaceCharsInMail(this.mailReportText), 5, 5, 100, 100, "resizable=yes", "mailWindow");
    } else {
        //window.location = "mailto:" + this.eMailAdress + "?subject=" + escape("E-mail from " + this.replaceCharsInMail(UELO.courseName)) + "&body=" + this.replaceCharsInMail(this.mailReportText), 5, 5, 100, 100, "resizable=yes", "mailWindow";
		var sendMailStr = "mailto:" + this.eMailAdress + "?subject=" + escape("E-mail from " + this.replaceCharsInMail(UELO.courseName)) + "&body=" + this.replaceCharsInMail(this.mailReportText);
		window.location = sendMailStr;
    };
};

componentDetailedReport.prototype.openWin = function(urlname,xpos,ypos,w,h,windowParam,windowName) 
{
	urlname = urlname.replace(/%0D%0A/gi, '\n');
	urlname = urlname.replace(/%20/gi, '&nbsp;');
	urlname = urlname.replace(/%/gi, 'perc');

	var newWindowPointer=null;
	x = xpos;
	y = ypos;

	if (!xpos) x = 100;
	if (!ypos) y = 100;
	if (!w) w = 400;
	if (!h) h = 300;

	if (!windowParam) windowParam = "resizable=yes";
	if (!windowName) windowName = "subWindow";

	if (newWindowPointer != null && newWindowPointer.closed == false) {
		newWindowPointer.close();
	};

	newWindowPointer=window.open(urlname,windowName,"width="+w+",height="+h+",screenX="+x+",screenY="+y+","+windowParam+"");
	newWindowPointer.moveTo(x,y);
	newWindowPointer.focus();
	return (newWindowPointer);
};

componentDetailedReport.prototype.replaceCharsInMail = function(text){
    text = text.replace(/Ą/ig, 'A');
    text = text.replace(/ą/ig, 'a');
    text = text.replace(/ć/ig, 'c');
    text = text.replace(/Ć/ig, 'C');
    text = text.replace(/ę/ig, 'e');
    text = text.replace(/Ę/ig, 'E');
    text = text.replace(/ł/ig, 'l');
    text = text.replace(/Ł/ig, 'L');
    text = text.replace(/ń/ig, 'n');
    text = text.replace(/Ń/ig, 'N');
    text = text.replace(/ó/ig, 'o');
    text = text.replace(/Ó/ig, 'O');
    text = text.replace(/ś/ig, 's');
    text = text.replace(/Ś/ig, 'S');
    text = text.replace(/ż/ig, 'z');
    text = text.replace(/Ż/ig, 'Z');
    text = text.replace(/ź/ig, 'z');
    text = text.replace(/Ź/ig, 'Z');
    text = text.replace(/&/ig, 'and');
	text = this.removeNotAllowedCharacters(text);
    return text;
};

componentDetailedReport.prototype.removeNotAllowedCharacters = function(text) {
	text = text.replace(new RegExp('&nbsp;', "g"), ' ');
	text = text.replace(new RegExp('&nbsp', "g"), ' ');
	text = text.replace(new RegExp('&amp;', "g"), '&');
	text = text.replace(new RegExp('&amp', "g"), '&');
	return text;
};

componentDetailedReport.prototype.isReady = function(){
    if (this.execution) {
        this.isLoaded = preloadImage(this, "_1") && preloadImage(this, "_2");
        return this.isLoaded;
    };
};
