var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MazeInstruments;
(function (_MazeInstruments) {
    var MazeInstruments = (function (_super) {
        __extends(MazeInstruments, _super);
        function MazeInstruments(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.koniec = false;
            this.fail = false;
            this.ready = false;
        }
        MazeInstruments.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        MazeInstruments.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
            this.map = this.Elements.Tilemap[0].layers[0].data;
            this.game.load.spritesheet('player', 'Graphics/Games/MW_G_II_10/MW_g_II_10_gracz.png', 64, 64, 12);
        };
        MazeInstruments.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
            this.cursors = this.game.input.keyboard.createCursorKeys();
        };
        MazeInstruments.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.game.physics.startSystem(Phaser.Physics.ARCADE);
            this.wall = this.game.add.group();
            this.addChild(this.wall);
            this.player = this.game.add.sprite(180, 50, 'player');
            this.player.animations.add('walkDown', [0, 1, 2], 9, true);
            this.player.animations.add('walkUp', [3, 4, 5], 9, true);
            this.player.animations.add('walkRight', [7, 6, 8], 9, true);
            this.player.animations.add('walkLeft', [11, 9, 10], 9, true);
            this.addChild(this.player);
            this.instruments = this.game.add.group();
            this.addChild(this.instruments);
            this.instruments.add(this.game.add.sprite(1430, 640, 'filharmonia'));
            this.instruments.add(this.game.add.sprite(550, 50, 'akordeon'));
            this.instruments.add(this.game.add.sprite(1460, 30, 'fortepian'));
            this.instruments.add(this.game.add.sprite(1000, 230, 'gitara'));
            this.instruments.add(this.game.add.sprite(930, 620, 'harfa'));
            this.instruments.add(this.game.add.sprite(920, 40, 'kontrabas'));
            this.instruments.add(this.game.add.sprite(350, 200, 'organy'));
            this.instruments.add(this.game.add.sprite(400, 400, 'puzon'));
            this.instruments.add(this.game.add.sprite(1220, 450, 'skrzypce'));
            this.instruments.add(this.game.add.sprite(200, 600, 'trabka'));
            this.instruments.add(this.game.add.sprite(450, 600, 'trojkat'));
            this.przewodnik = this.game.add.sprite(1150, 255, 'przewodnik');
            this.przewodnik.inputEnabled = true;
            this.przewodnik.events.onInputDown.add(function () {
                this.przewodnik.visible = false;
                this.ready = true;
            }, this);
            this.addChild(this.przewodnik);
            this.dymek = this.game.add.sprite(-700, -200, 'dymek');
            this.przewodnik.addChild(this.dymek);
            this.polecenie = this.game.add.text(70, 200, "Znajdź drogę do filharmonii.\nPomogą ci w tym instrumenty strunowe.", { font: "32px Arial", fill: "#000000", wordWrap: true, wordWrapWidth: this.dymek.width, align: "center" });
            this.dymek.addChild(this.polecenie);
            this.game.physics.enable([this.player, this.instruments], Phaser.Physics.ARCADE);
            var idx = 0;
            for (var i = 0; i < 24; i++)
                for (var j = 0; j < 46; j++) {
                    if (this.map[idx++] == 1)
                        var spr = this.game.add.sprite(130 + (j * 32), (i * 32), 'blok');
                    this.game.physics.enable(spr, Phaser.Physics.ARCADE);
                    this.addChild(spr);
                    this.wall.add(spr);
                }
            this.wall.setAll('body.immovable', true);
        };
        MazeInstruments.prototype.resetStage = function () {
            this.player.x = 560;
            this.player.y = 64;
            this.koniec = false;
            this.fail = false;
        };
        MazeInstruments.prototype.update = function () {
            if (this.ready) {
                if (this.koniec == true) {
                    this.player.animations.stop();
                    this.player.body.moves = false;
                    EU.setGameCompletion(this.parent, 1);
                    EU.Log("Gra ukończona z sukcesem.");
                    this.ready = false;
                }
                this.game.physics.arcade.collide(this.player, this.wall);
                this.game.physics.arcade.collide(this.player, this.instruments, function (obj1, obj2) {
                    if (obj2.key == 'filharmonia')
                        this.koniec = true;
                    if (obj2.key == 'akordeon')
                        console.log('akordeon zagral');
                    obj2.kill();
                }, null, this);
                this.player.body.velocity.x = 0;
                this.player.body.velocity.y = 0;
                if (this.cursors.left.isDown) {
                    this.player.body.velocity.x = -200;
                    if (this.player.body.moves != false)
                        this.player.animations.play('walkLeft');
                }
                else if (this.cursors.right.isDown) {
                    this.player.body.velocity.x = 200;
                    if (this.player.body.moves != false)
                        this.player.animations.play('walkRight');
                }
                else if (this.cursors.up.isDown) {
                    this.player.body.velocity.y = -200;
                    if (this.player.body.moves != false)
                        this.player.animations.play('walkUp');
                }
                else if (this.cursors.down.isDown) {
                    this.player.body.velocity.y = 200;
                    if (this.player.body.moves != false)
                        this.player.animations.play('walkDown');
                }
                else
                    this.player.animations.stop();
            }
        };
        return MazeInstruments;
    })(Base.BasicGroup);
    _MazeInstruments.MazeInstruments = MazeInstruments;
})(MazeInstruments || (MazeInstruments = {}));
//# sourceMappingURL=MazeInstruments.js.map