var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var ColorText;
var zad_zaliczone = 0;
(function (_ColorText) {
    var ColorText = (function (_super) {
        __extends(ColorText, _super);
        function ColorText(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        ColorText.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        ColorText.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        ColorText.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
            this.numberOfChecked = 0;
            this.createSourceText();
            this.createTextToFind();
            this.color = this.Elements.Colors[0];
            if (this.Elements.Colors.length > 1)
                this.createColorPallete();
        };
        ColorText.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        ColorText.prototype.createColorPallete = function () {
            this.PalleteColors = [];
            for (var i = 0; i < this.Elements.Colors.length; i++) {
                var el = this.drawRect(this.Elements.Colors[i], 100, 40);
                el.anchor.x = 0.5;
                el.anchor.y = 0.5;
                el.alpha = 0.7;
                el.name = this.Elements.Colors[i];
                if (i == 0) {
                    el.scale.x = 1.2;
                    el.scale.y = 1.2;
                    el.alpha = 1;
                    this.color = el.name;
                }
                el.position.set(this.Elements.PalletePosition.x, this.Elements.PalletePosition.y + i * 50);
                el.inputEnabled = true;
                el.events.onInputOver.add(this.onColorOver, this);
                el.events.onInputOut.add(this.onColorOut, this);
                el.events.onInputDown.add(this.onColorClicked, this);
                this.PalleteColors.push(el);
                this.addChild(el);
            }
        };
        ColorText.prototype.clearColorSelection = function () {
            for (var i = 0; i < this.PalleteColors.length; i++) {
                this.PalleteColors[i].scale.x = 1;
                this.PalleteColors[i].scale.y = 1;
                this.PalleteColors[i].alpha = 0.7;
            }
        };
        ColorText.prototype.onColorClicked = function (el, pointer) {
            this.clearColorSelection();
            if (el.scale.x == 1) {
                el.scale.x = 1.2;
                el.scale.y = 1.2;
                el.alpha = 1;
                this.color = el.name;
            }
            else {
                el.scale.x = 1;
                el.scale.y = 1;
                el.alpha = 0.7;
            }
        };
        ColorText.prototype.onColorOver = function (el, pointer) {
            if (el.scale.x == 1) {
                el.alpha = 0.5;
            }
        };
        ColorText.prototype.onColorOut = function (el, pointer) {
            if (el.scale.x == 1) {
                el.alpha = 0.7;
            }
        };
        ColorText.prototype.drawRect = function (color, width, height) {
            var drawnObject;
            var bmd = this.game.add.bitmapData(width, height);
            bmd.ctx.beginPath();
            bmd.ctx.moveTo(10, 0);
            bmd.ctx.lineTo(width - 10, 0);
            bmd.ctx.quadraticCurveTo(width, 0, width, 10);
            bmd.ctx.lineTo(width, height - 10);
            bmd.ctx.quadraticCurveTo(width, height, width - 10, height);
            bmd.ctx.lineTo(10, height);
            bmd.ctx.quadraticCurveTo(0, height, 0, height - 10);
            bmd.ctx.lineTo(0, 10);
            bmd.ctx.quadraticCurveTo(0, 0, 10, 0);
            bmd.ctx.stroke();
            bmd.ctx.fillStyle = color;
            bmd.ctx.fill();
            bmd.ctx.stroke();
            return this.game.add.sprite(0, 0, bmd);
        };
        ColorText.prototype.createTextToFind = function () {
            for (var k = 0; k < this.Elements.SourceText.length; k++) {
                this.SourceText[k].toFind = this.Elements.SourceText[k].TextToFind;
            }
        };
        ColorText.prototype.createSourceText = function () {
            this.SourceText = [];
            for (var k = 0; k < this.Elements.SourceText.length; k++) {
                var Text = [];
                var verses = this.Elements.SourceText[k].Text.split("@");
                var posX = this.Elements.SourceText[k].Position.x;
                var posY = this.Elements.SourceText[k].Position.y;
                var style = this.Elements.SourceText[k].Style;
                var counter = 0;
                for (var i = 0; i < verses.length; i++) {
                    var words = verses[i].split("");
                    words.push(' ');
                    counter++;
                    var el = this.game.add.text(0, 0, words[0], style);
                    var versePosY = posY + i * el.height;
                    el.position.set(posX, versePosY);
                    el.inputEnabled = true;
                    el.events.onInputOver.add(this.onInputOver, this);
                    el.events.onInputOut.add(this.onInputOut, this);
                    if (this.Elements.MarkType == "crossable") {
                        el.events.onInputDown.add(this.onWordClickedCrossable, this);
                    }
                    else {
                        el.events.onInputDown.add(this.onWordClicked, this);
                    }
                    ;
                    el.name = "unchecked";
                    if (el.text == ' ')
                        el.name = "space";
                    Text.push(el);
                    this.addChild(el);
                    for (var j = 1; j < words.length; j++) {
                        el = this.game.add.text(0, 0, words[j], style);
                        el.position.set(Text[counter - 1].position.x + Text[counter - 1].width, versePosY);
                        el.inputEnabled = true;
                        el.events.onInputOver.add(this.onInputOver, this);
                        el.events.onInputOut.add(this.onInputOut, this);
                        if (this.Elements.MarkType == "crossable") {
                            el.events.onInputDown.add(this.onWordClickedCrossable, this);
                        }
                        else {
                            el.events.onInputDown.add(this.onWordClicked, this);
                        }
                        ;
                        el.name = "unchecked";
                        if (el.text == ' ')
                            el.name = "space";
                        Text.push(el);
                        this.addChild(el);
                        counter++;
                    }
                }
                this.SourceText.push({ "Text": Text, "toFind": null });
            }
        };
        ColorText.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        ColorText.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        ColorText.prototype.onWordClicked = function (el, pointer) {
            if (el.text != " ") {
                if (el.name == "unchecked") {
                    el.setShadow(el.height / 25, el.height / 25, this.color);
                    this.numberOfChecked++;
                    el.name = "checked" + this.color;
                    if (this.Elements.MarkWholeWords == true)
                        this.markWholeWords();
                }
                else {
                    el.setShadow(0, 0, "black");
                    this.numberOfChecked--;
                    el.name = "unchecked";
                    if (this.Elements.MarkWholeWords == true)
                        this.unmarkWholeWords();
                }
                this.checkIfEverythingIsCorrect();
            }
        };
        ColorText.prototype.onWordClickedCrossable = function (el, pointer) {
            if (el.text != " ") {
                if (el.name == "unchecked") {
                    this.numberOfChecked++;
                    el.name = "checked" + this.color;
                    if (this.Elements.MarkWholeWords == true) {
                        this.markWholeWordsCrossable();
                    }
                    else {
                        el.addChild(EU.drawLine(this.color, -el.anchor.x * el.width, -el.anchor.y * el.height, el.width - el.width * el.anchor.x, el.height - el.anchor.y * el.height, this, el.height / 10));
                    }
                }
                else {
                    this.numberOfChecked--;
                    el.name = "unchecked";
                    if (this.Elements.MarkWholeWords == true) {
                        this.unmarkWholeWordsCrossable();
                        el.removeChildren();
                    }
                    else {
                        el.removeChildren();
                    }
                }
                this.checkIfEverythingIsCorrect();
            }
        };
        ColorText.prototype.unmarkWholeWords = function () {
            for (var i = 0; i < this.SourceText.length; i++) {
                for (var j = 0; j < this.SourceText[i].Text.length; j++) {
                    if (this.SourceText[i].Text[j].name == "unchecked") {
                        var k = -1;
                        while (j + k >= 0 && this.SourceText[i].Text[j + k].name != "space") {
                            if (this.SourceText[i].Text[j + k].name != "unchecked") {
                                this.SourceText[i].Text[j + k].setShadow(0, 0, "black");
                                this.numberOfChecked--;
                                this.SourceText[i].Text[j + k].name = "unchecked";
                            }
                            k--;
                        }
                        k = 1;
                        while (j + k < this.SourceText[i].Text.length - 1 && this.SourceText[i].Text[j + k].name != "space") {
                            if (this.SourceText[i].Text[j + k].name != "unchecked") {
                                this.SourceText[i].Text[j + k].setShadow(0, 0, "black");
                                this.numberOfChecked--;
                                this.SourceText[i].Text[j + k].name = "unchecked";
                            }
                            k++;
                        }
                        j += k;
                    }
                }
            }
        };
        ColorText.prototype.markWholeWords = function () {
            for (var i = 0; i < this.SourceText.length; i++) {
                for (var j = 0; j < this.SourceText[i].Text.length; j++) {
                    if (this.SourceText[i].Text[j].name == "checked" + this.color) {
                        var k = -1;
                        while (j + k >= 0 && this.SourceText[i].Text[j + k].name != "space") {
                            if (this.SourceText[i].Text[j + k].name != "checked" + this.SourceText[i].Text[j].shadowColor) {
                                this.SourceText[i].Text[j + k].setShadow(this.SourceText[i].Text[j + k].height / 25, this.SourceText[i].Text[j + k].height / 25, this.SourceText[i].Text[j].shadowColor);
                                this.numberOfChecked++;
                                this.SourceText[i].Text[j + k].name = this.SourceText[i].Text[j].name;
                            }
                            k--;
                        }
                        k = 1;
                        while (j + k < this.SourceText[i].Text.length - 1 && this.SourceText[i].Text[j + k].name != "space") {
                            if (this.SourceText[i].Text[j + k].name != "checked" + this.SourceText[i].Text[j].shadowColor) {
                                this.SourceText[i].Text[j + k].setShadow(this.SourceText[i].Text[j + k].height / 25, this.SourceText[i].Text[j + k].height / 25, this.SourceText[i].Text[j].shadowColor);
                                this.numberOfChecked++;
                                this.SourceText[i].Text[j + k].name = this.SourceText[i].Text[j].name;
                            }
                            k++;
                        }
                        j += k;
                    }
                }
            }
        };
        ColorText.prototype.markWholeWordsCrossable = function () {
            for (var i = 0; i < this.SourceText.length; i++) {
                for (var j = 0; j < this.SourceText[i].Text.length; j++) {
                    if (this.SourceText[i].Text[j].name == "checked" + this.color) {
                        var k = -1;
                        var width = this.SourceText[i].Text[j].width;
                        var widthleft = 0;
                        var widthright = 0;
                        while (j + k >= 0 && this.SourceText[i].Text[j + k].name != "space") {
                            if (this.SourceText[i].Text[j + k].name != "checked" + this.color) {
                                this.numberOfChecked++;
                                this.SourceText[i].Text[j + k].name = this.SourceText[i].Text[j].name;
                            }
                            width += this.SourceText[i].Text[j + k].width;
                            widthleft += this.SourceText[i].Text[j + k].width;
                            k--;
                        }
                        k = 1;
                        while (j + k < this.SourceText[i].Text.length - 1 && this.SourceText[i].Text[j + k].name != "space") {
                            if (this.SourceText[i].Text[j + k].name != "checked" + this.color) {
                                this.numberOfChecked++;
                                this.SourceText[i].Text[j + k].name = this.SourceText[i].Text[j].name;
                            }
                            width += this.SourceText[i].Text[j + k].width;
                            widthright += this.SourceText[i].Text[j + k].width;
                            k++;
                        }
                        if (this.SourceText[i].Text[j].name == "checked" + this.color) {
                            this.SourceText[i].Text[j].removeChildren();
                            this.SourceText[i].Text[j].addChild(EU.drawLine(this.color, -widthleft - this.SourceText[i].Text[j].anchor.x * this.SourceText[i].Text[j].width, -this.SourceText[i].Text[j].anchor.y * this.SourceText[i].Text[j].height, widthright + (1 - this.SourceText[i].Text[j].anchor.x) * this.SourceText[i].Text[j].width, this.SourceText[i].Text[j].height - this.SourceText[i].Text[j].anchor.y * this.SourceText[i].Text[j].height, this, this.SourceText[i].Text[j].height / 10));
                        }
                        j += k;
                    }
                }
            }
        };
        ColorText.prototype.unmarkWholeWordsCrossable = function () {
            for (var i = 0; i < this.SourceText.length; i++) {
                for (var j = 0; j < this.SourceText[i].Text.length; j++) {
                    if (this.SourceText[i].Text[j].name == "unchecked") {
                        var k = -1;
                        while (j + k >= 0 && this.SourceText[i].Text[j + k].name != "space") {
                            if (this.SourceText[i].Text[j + k].name != "unchecked") {
                                this.SourceText[i].Text[j + k].removeChildren();
                                this.numberOfChecked--;
                                this.SourceText[i].Text[j + k].name = "unchecked";
                            }
                            k--;
                        }
                        k = 1;
                        while (j + k < this.SourceText[i].Text.length - 1 && this.SourceText[i].Text[j + k].name != "space") {
                            if (this.SourceText[i].Text[j + k].name != "unchecked") {
                                this.SourceText[i].Text[j + k].removeChildren();
                                this.numberOfChecked--;
                                this.SourceText[i].Text[j + k].name = "unchecked";
                            }
                            k++;
                        }
                        j += k;
                    }
                }
            }
        };
        ColorText.prototype.findIndexes = function (source, toFind) {
            var result = [];
            for (var i = 0; i < source.length; i++) {
                if (source.substring(i, i + toFind.length) == toFind) {
                    result.push(i);
                }
            }
            return result;
        };
		ColorText.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
		ColorText.prototype.prevScreen = function () {
			if(zad_zaliczone == 1){
				if (this.game.camera.x - Global.Main.dims.x > 0) {
					this.game.input.enabled = false;
					var tw = this.game.add.tween(this.game.camera);
					tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
					tw.onComplete.add(function () {
						this.game.input.enabled = true;
					}, this);
					tw.start();
					Global.Main.currentPageNumber--;
					if (this.json.Lector)
						Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
					console.log(Global.Main.currentPageNumber);
				}
			}
			else {
				//nic nie rób
			}
        };
        ColorText.prototype.checkIfEverythingIsCorrect = function () {
            EU.Log("Points: " + this.calculatePlayerPoints() + "/" + this.calculateMaxPoints());
            EU.Log("Checked: " + this.numberOfChecked + "/" + this.numberOfCorrectChars);
            if (this.calculatePlayerPoints() == this.calculateMaxPoints() && this.numberOfChecked == this.numberOfCorrectChars && EU.checkIfFillsAreCorrect(this) && EU.checkIfSelectablesAreCorrect(this)) {
                if (TYPE === "gm") {
					var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8,0.8);
					this.addChild(next);
					var prev = this.game.add.button(151 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
					prev.scale.setTo(0.8,0.8);
					this.addChild(prev);
                    _super.prototype.nextTask.call(this);
                }
				zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
                return true;
            }
			zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            return false;
        };
        ColorText.prototype.calculateMaxPoints = function () {
            this.numberOfCorrectChars = 0;
            var points = 0;
            for (var i = 0; i < this.Elements.SourceText.length; i++) {
                for (var j = 0; j < this.SourceText[i].toFind.length; j++) {
                    for (var z = 0; z < this.SourceText[i].toFind[j].Text.length; z++) {
                        var indexes = this.findIndexes(this.Elements.SourceText[i].Text, this.SourceText[i].toFind[j].Text[z]);
                        points += indexes.length;
                        for (var k = 0; k < indexes.length; k++) {
                            for (var l = 0; l < this.SourceText[i].toFind[j].Text[z].length; l++) {
                                if (this.SourceText[i].Text[indexes[k] + l].name != "space")
                                    this.numberOfCorrectChars++;
                            }
                        }
                    }
                }
            }
            return points;
        };
        ColorText.prototype.calculatePlayerPoints = function () {
            var points = 0;
            for (var i = 0; i < this.Elements.SourceText.length; i++) {
                for (var j = 0; j < this.SourceText[i].toFind.length; j++) {
                    for (var z = 0; z < this.SourceText[i].toFind[j].Text.length; z++) {
                        var indexes = this.findIndexes(this.Elements.SourceText[i].Text, this.SourceText[i].toFind[j].Text[z]);
                        for (var k = 0; k < indexes.length; k++) {
                            var allCharChecked = true;
                            for (var l = 0; l < this.SourceText[i].toFind[j].Text[z].length; l++) {
                                if (this.SourceText[i].Text[indexes[k] + l].name != ("checked" + this.SourceText[i].toFind[j].Color) && this.SourceText[i].Text[indexes[k] + l].name != "space") {
                                    allCharChecked = false;
                                }
                            }
                            if (allCharChecked)
                                points++;
                        }
                    }
                }
            }
            return points;
        };
        return ColorText;
    })(Base.BasicGroup);
    _ColorText.ColorText = ColorText;
})(ColorText || (ColorText = {}));
//# sourceMappingURL=ColorText.js.map