﻿/** Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentSimpleCourseTree = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.src = '';
	this.menu = '';
	this.buttons = '';

	this.treeCreated = false;
	this.pagesArr = new Array();
	this.imagesArr = new Array();
};

componentSimpleCourseTree.prototype = new componentElement();
componentSimpleCourseTree.prototype.type = "componentSimpleCourseTree";

componentSimpleCourseTree.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL);

	this.imagesNameArr = [ this.bckg, this.buttonCloseOut, this.buttonCloseOver, this.TREE_maksymalize, this.TREE_minimalize ];
	this.setNewTreeImages(this.treeImages);
	this.getPreloadImagesArr();
};

componentSimpleCourseTree.prototype.setImagesIntoHTMLObj = function()
{
	var bckgImg = document.getElementById(this.id + "_bckgImg");
	var closeImg = document.getElementById(this.id + "_closeImg");

	bckgImg.src = this.resourcesURL + this.bckg;
	closeImg.src = this.resourcesURL + this.buttonCloseOut;
};

componentSimpleCourseTree.prototype.onShow = function()
{
	if (this.useImagesBckg) {
		var bckgTopH = getImageHeight(this.bckgTop);
	} else {
		var bckgTopH = 0;
	};

	var struct = getStruct();
	var player = getPlayer(); //pg2-multiversions

	if ( struct ){
		var structLength = struct.length();
	} else {
		var page1 = {"gix":1, "index":1, "title":this.exampleTitle+" 1", "realParent": 0, "status":"N", "visible":1, "haveParent":false};
		var page2 = {"gix":2, "index":2, "title":this.exampleTitle+" 2", "realParent": 0, "status":"N", "visible":1, "haveParent":false};
		var page3 = {"gix":3, "index":3, "title":this.exampleTitle, "realParent": 2, "status":"N", "visible":1, "haveParent":false};
		struct = new Object();

		struct.m_list = new Array ();
		struct.m_list = [ page1, page2, page3];
		var structLength = struct.m_list.length;
	};

	if (!this.treeCreated) {
		var fontSize = getFontSize(this.treeFontSize, 'px');
		var structPage = struct.m_list[0];
		var addIndexShift = 0;
		if (structPage.index == 0) addIndexShift = 2;
		var multiSCOInd = 0;

		for (var i=0; i < structLength; i++) {
			var structPage = struct.m_list[i];
			if (structPage.visible == 1){
				//pg2-multiversions
				var pageTitle = structPage.title;
				if (player) {
					try {
						var version = player.courseVersion;
						pageTitle = struct.item(i)["title" + version];
					} catch(e) {
						pageTitle = structPage.title;
					};
				};
				//

				var pageIndex = parseInt(structPage.index) + addIndexShift;
				var item = new treePageItem(
								i,
								this.id,
								structPage.gix, 
								pageIndex, 
								//structPage.title,  //pg2-replaced with below one
								pageTitle, //pg2-multiversions
								'pc.'+this.id+'.checkIsGoToAllowed('+structPage.gix+', '+pageIndex+', '+multiSCOInd+')',
								structPage.realParent, 
								structPage.status, 
								this.resourcesURL,
								this.imagesArr['pageNotAtt'],
								this.imagesArr['pageIncomplete'],
								this.imagesArr['pageCompleted'],
								this.imagesArr['pagePass'],
								this.imagesArr['pageFail'],
								this.imagesArr['blankIcon'],
								this.imagesArr['minusIcon'],
								this.imagesArr['plusIcon'],
								this.treeFontFamily,
								fontSize,
								this.treeFontColor
							);
				multiSCOInd++;
				this.addChildToParent(structPage.realParent, item);
				this.pagesArr[pageIndex] = item;
			};
		};
		this.treeCreated = true
		if (this.showTREEicons) {
			this.buttons += '<p>';
			this.buttons += '<img src="'+this.resourcesURL+this.TREE_maksymalize+'" border="0" style="cursor: pointer;" onClick="pc.'+this.id+'.expandAllTree();"/>';
			this.buttons += '&nbsp;';
			this.buttons += '<img src="'+this.resourcesURL+this.TREE_minimalize+'" border="0" style="cursor: pointer;" onClick="pc.'+this.id+'.collapseAllTree();"/>';
			this.buttons += '</p>';
		};

		for (var i in this.pagesArr) {
			if (this.pagesArr[i] && !this.pagesArr[i].haveParent){
				this.menu += this.pagesArr[i].toString();
			};
		};
	};
	this.onPaint(); //pg2
};

componentSimpleCourseTree.prototype.setDivElements = function()
{
	var titleDiv = document.getElementById(this.id + "_titleDiv");
	var closeDiv = document.getElementById(this.id + "_closeDiv");
	var treeDIV = document.getElementById(this.id + "_treeDIV");
	var treeButtonsDIV = document.getElementById(this.id + "_treeButtonsDIV");

	var widthDIV  = this.w - 2*this.contentPadding;
	var heightDIV = this.h - this.headerHeight - this.contentPadding;
	if (closeDiv) {
		var buttonH = getImageHeight(this.buttonCloseOut);
		var buttonW = getImageWidth(this.buttonCloseOut);
		closeDiv.style.left = this.w - buttonW - this.buttonSpaceRight;
		closeDiv.style.top = this.buttonSpaceUp;
		closeDiv.style.height = buttonH;
		closeDiv.style.width = buttonW;
		closeDiv.style.clip = 'rect(0px '+buttonW+'px '+buttonH+'px 0px)';
		closeDiv.dir = this.dir;
	};

	if (titleDiv) {
		titleDiv.style.left = this.contentPadding;
		titleDiv.style.top = 0;
		titleDiv.style.height = this.headerHeight;
		titleDiv.style.width = widthDIV;
		titleDiv.style.clip = 'rect(0px '+widthDIV+'px '+this.headerHeight+'px 0px)';
		titleDiv.dir = this.dir;
	};
	var maxButtonH = 0;
	if (treeButtonsDIV) {
		if(this.showTREEicons){
			maxButtonH = getImageHeight(this.TREE_maksymalize);
			treeButtonsDIV.style.left = this.contentPadding;
			treeButtonsDIV.style.top = this.headerHeight;
			treeButtonsDIV.style.height = maxButtonH;
			treeButtonsDIV.style.width = this.w-(this.contentPadding*2);
			treeButtonsDIV.style.clip = 'rect(0px '+this.w+'px '+maxButtonH+'px 0px)';
			treeButtonsDIV.dir = this.dir;
			treeButtonsDIV.innerHTML = this.buttons;
		} else {
			treeButtonsDIV.style.display = 'none';
		};
	};

	if (treeDIV) {
		treeDIV.style.left = this.contentPadding;
		treeDIV.style.top = this.headerHeight + maxButtonH;
		treeDIV.style.height = heightDIV - maxButtonH;
		treeDIV.style.width = widthDIV;
		treeDIV.style.clip = 'rect(0px '+widthDIV+'px '+eval(heightDIV - maxButtonH)+'px 0px)';
		treeDIV.dir = this.dir;
		treeDIV.innerHTML = this.menu;
		if (is.ie){
			treeDIV.style.scrollbarFaceColor = this.getColor('FaceColor');
			treeDIV.style.scrollbarTrackColor = this.getColor('TrackColor');
			treeDIV.style.scrollbar3dlightColor = this.getColor('3dlightColor');
			treeDIV.style.scrollbarDarkshadowColor = this.getColor('DarkshadowColor');
			treeDIV.style.scrollbarArrowColor = this.getColor('ArrowColor');
			treeDIV.style.scrollbarShadowColor = this.getColor('ShadowColor');
			treeDIV.style.scrollbarHighlightColor = this.getColor('HighlightColor');
		};
	};
};

componentSimpleCourseTree.prototype.onRepaint = function () 
{
	if (PageInterface.GetValue("pageType") != "Exercise") return;
	var answer = page.countAnswer();
	//var corAns = (page.answerWeighting)?(answer >= page.masteryScore):(answer == page.maxScore); //pg2-removed
	var pageIndex = PageInterface.GetValue('pageIndex');// - 2;
	var pInStruct = 0;

	if (this.pagesArr){
		var item = this.pagesArr[pageIndex];
		if (item) {
			pInStruct = item.posInStruct;
		};
	};

	var treeItemIcon = document.getElementById(this.id+"_"+pInStruct+"_icon");
	if (treeItemIcon) {
		var iconSrc = ""; //pg2
		if (page.pageStatus == "incomplete") iconSrc = this.imagesArr['pageIncomplete']; else
		if (page.pageStatus == "completed") iconSrc = this.imagesArr['pageCompleted']; else
		if (page.pageStatus == "failed") iconSrc = this.imagesArr['pageFail']; else
		if (page.pageStatus == "passed") iconSrc = this.imagesArr['pagePass']; else
		if (page.pageStatus == "not attempted") {
            if (config.setCompleteStatusAtPageStartup) iconSrc = this.imagesArr['pageCompleted']; else iconSrc = this.imagesArr['pageIncomplete'];
        } else iconSrc = this.imagesArr['pageNotAtt'];

		/* //pg2-removed
		if (corAns){
			treeItemIcon.src = this.resourcesURL + this.imagesArr['pagePass'];
		}else{
			treeItemIcon.src = this.resourcesURL + this.imagesArr['pageFail'];
		};*/

		treeItemIcon.src = this.resourcesURL + iconSrc; //pg2
	};

	var treeDIV = document.getElementById(this.id + "_treeDIV"); //pg2
	if (treeDIV) {
		if (treeDIV.innerHTML != '') this.menu = treeDIV.innerHTML;
	};
};

componentSimpleCourseTree.prototype.componentSimpleCourseTreeResetElement = componentSimpleCourseTree.prototype.resetElement;
componentSimpleCourseTree.prototype.resetElement = function () 
{
	this.componentSimpleCourseTreeResetElement();

	var pageIndex = PageInterface.GetValue('pageIndex') - 2;

	var treeItemIcon = document.getElementById(this.id+"_"+pageIndex+"_icon");
	if (treeItemIcon) {
		treeItemIcon.src = this.resourcesURL + this.imagesArr['pageNotAtt'];
	};
}

componentSimpleCourseTree.prototype.hideImages = function()
{
	var bckgDiv = document.getElementById(this.id + "_bckgDiv");
	var titleDiv = document.getElementById(this.id + "_titleDiv");
	var closeDiv = document.getElementById(this.id + "_closeDiv");

	if (bckgDiv) {
		bckgDiv.style.display = 'none';
	};
	if (closeDiv) {
		closeDiv.style.display = 'none';
	};
	if (titleDiv) {
		titleDiv.style.display = 'none';
	};
};

componentSimpleCourseTree.prototype.onPaint = function()
{
	this.setImagesIntoHTMLObj();
	this.setDivElements();
	var chaptersArr = this.chaptersNames.split('||');

	for (var i=0; i < chaptersArr.length; i++){
		if (chaptersArr[i] != '') this.showHideChoosenChapters(chaptersArr[i], 'hide', true);
	};

	if (!this.useImagesBckg){
		this.hideImages();
	};

	if (PageInterface.GetValue("state") != psDesigning){
		if (opener) {
			var index = opener.PageInterface.GetValue('pageIndex');
		} else {
			var index = PageInterface.GetValue('pageIndex');
		};

		this.setFocus(index);

		switch (this.expand) {
			case 'openBranch' :
				if (opener) {
					this.expandPageParents(opener.PageInterface.GetValue("pageIndex"));
				} else {
					this.expandPageParents(PageInterface.GetValue("pageIndex"));
				};
				break;
			case 'openAll' :
				this.expandAllTree();
				break;
		};
	} else {
		this.setFocus(1);
	};
};

componentSimpleCourseTree.prototype.showHideChoosenChapters = function(chapterName, action, onlyHide)
{
	if (!this.visible) return;

	var chapterPages = '';
	var restCoursePages = '';

	if (action == 'show') {
		chapterPages = 'block';
		restCoursePages = 'none';
	} else {
		chapterPages = 'none';
		restCoursePages = 'block';
	};
	chapterName = unescape(chapterName);

	var chapterParent = -1;
	var pageChapter = null;
	var hideOtherPages = false;
	var foundChapterPage = false;

	for (var i in this.pagesArr){
		var item = this.pagesArr[i];

		if (item) {
			if (chapterName == item.title) {
				chapterParent = item.parent;
				pageChapter = item;
				document.getElementById(item.id+'-focus').style.display = chapterPages;
				foundChapterPage = true;
			} else {
				if (foundChapterPage && chapterParent >= item.parent) {
					hideOtherPages = true;
					foundChapterPage = false;
				};
				if (!foundChapterPage || hideOtherPages) {
					if (!onlyHide)
						document.getElementById(item.id+'-focus').style.display = restCoursePages;
				} else {
					document.getElementById(item.id+'-focus').style.display = chapterPages;
				};
			};
		};
	};
	return pageChapter;
}

componentSimpleCourseTree.prototype.detectBrokenConnection = function(pageGix, pageIndex, multiSCOInd) //pg2-BV
{
	var imgID = 'testConectionImage';
	var imageCheckConnectionName = 'check_connection_image.gif';
	var imgSrc = resourcesURL + imageCheckConnectionName + '?' + (+new Date);
	var imgObj = document.getElementById(imgID);
	if (imgObj) {
		var detectProgressName = 'detectConnectionProgressPopup';
		var progressComp = getComponentByPartialId(detectProgressName);
		if (progressComp) {
			progressComp.show();
			progressComp.bringToFront();
		};

		var f;
		var str = 'try { pc.' + this.id + '.gotoPage(' + pageGix + ',' + multiSCOInd + '); } catch(e) {};';
		eval('f = function() { ' + str + '};');
		imgObj.onload = f;
		imgObj.onerror = function() {
			try {
				var p = getPage();
				if (p) {
					p.brokenConnectionInfoShow();
				};
			} catch(e) {};
		};
		imgObj.src = imgSrc;
		return;
	};
};

componentSimpleCourseTree.prototype.checkIsGoToAllowed = function(pageGix, pageIndex, multiSCOInd)
{
	if (this.blockGoToPages){
		var openPage = {};
		if (opener) {
			openPage.gix = opener.PageInterface.GetValue('pageGix');
			openPage.index = opener.PageInterface.GetValue('pageIndex');
		} else {
			openPage.gix = PageInterface.GetValue('pageGix');
			openPage.index = PageInterface.GetValue('pageIndex');
		};

		var gotoPage = {};
		gotoPage.gix = pageGix;
		gotoPage.index = pageIndex;

		var opened = this.checkWasPageOpened(pageIndex);
		if (opened) {
			if (config.DetectBrokenConnection) this.detectBrokenConnection(pageGix, pageIndex, multiSCOInd); else //pg2-BV
			this.gotoPage(pageGix, multiSCOInd);
		} else {
			if (parseInt(openPage.index) + 1 == gotoPage.index) {
				if (config.DetectBrokenConnection) this.detectBrokenConnection(pageGix, pageIndex, multiSCOInd); else //pg2-BV
				this.gotoPage(pageGix, multiSCOInd);
			} else {
				var allOpened = this.checkWereAllPagesBeforeOpened(pageGix);
				if (allOpened) {
					if (config.DetectBrokenConnection) this.detectBrokenConnection(pageGix, pageIndex, multiSCOInd); else //pg2-BV
					this.gotoPage(pageGix, multiSCOInd);
				} else
				if (this.showAlert) {
					showMessage(this.alertText);
				};
			};
		};
	} else {
		if (config.DetectBrokenConnection) this.detectBrokenConnection(pageGix, pageIndex, multiSCOInd); else //pg2-BV
		this.gotoPage(pageGix, multiSCOInd);
	};
};

componentSimpleCourseTree.prototype.gotoPage = function(pageGix, multiSCOInd)
{
	var topWin = null;
	if (typeof(getWBTServerTop) != 'undefined') {
		topWin = getWBTServerTop();
	};
	if (opener && opener.lms) { 
		opener.lms.gotoPage(pageGix);
	} else
	if (PageInterface.GetValue('isExam') || (topWin && topWin.oneSCOCourse && topWin.oneSCOCourse.toString() == 'false')) {
		window.parent.changePage(multiSCOInd);
	} else {
		PlayerInterface.Execute('gotoPage', pageGix);
	};

	try { //pg2-if it is in new window which isn't closed after "gotoPage", select proper item in the tree
		if (opener && !this.closeOpenerPage) {
			var struct = getStruct();
			for (var i=0; i<this.pagesArr.length; i++) {
				var item = this.pagesArr[i];
				if (item) {
					if (item.gix == pageGix) {
						item.focus(this.focusColor);
					} else item.unselect();

					var imgObj = document.getElementById(item.compName + '_' + item.posInStruct + '_icon');
					if (struct && imgObj) {
						var p = struct.findItem(item.gix);
						if (p) {
							var pageStatus = p["status"];

							var iconSrc = "";
							if (pageStatus == "I") iconSrc = item.pageIncompleted; else
							if (pageStatus == "C") iconSrc = item.pageCompleted; else
							if (pageStatus == "P") iconSrc = item.pagePass; else //pg2-fixed
							if (pageStatus == "F") iconSrc = item.pageFail; else
							//if (pageStatus == "N") 
							iconSrc = item.pageNotAtt;
							imgObj.src = item.resourcesURL + iconSrc;
						};
					};
				};
			};
		};
	} catch (e) {};
	if (opener && this.closeOpenerPage) window.close(); else
	if (opener) window.focus(); //pg2
}

componentSimpleCourseTree.prototype.setNewTreeImages = function(str)
{
	var images = str.split(';');
	for (var i=0; i < images.length; i++) {
		var oneImg = images[i].split(':');
		if (images[i] != ''){
			this.imagesArr[oneImg[0]] = oneImg[1];
			this.imagesNameArr.push(oneImg[1]);
		};
	};
};

componentSimpleCourseTree.prototype.getColor = function( value )
{
	var colorArr = this.treeCSSStyle.split(';')
	for (var i=0; i < colorArr.length; i++) {
		var oneColor = colorArr[i].split(':');
		if (oneColor[0].indexOf(value) > -1) return oneColor[1];
	};
	return 'transparent';
};

componentSimpleCourseTree.prototype.checkWereAllPagesBeforeOpened = function( pageGix )
{
	for (var i in this.pagesArr) {
		var item = this.pagesArr[i];
		if (item.gix == pageGix ) {
			return true;
		} else
		if (item.status == 'N') {
			return false;
		};
	};
};

componentSimpleCourseTree.prototype.checkWasPageOpened = function( pageIndex )
{
	var item = this.pagesArr[pageIndex];
	if (item) {
		return (item.status != 'N');
	};
	return false;
};

componentSimpleCourseTree.prototype.addChildToParent = function( pageIndex, child )
{
	var item = this.pagesArr[pageIndex];
	if (item) {
		item.children.push(child);
		child.haveParent = true;
		child.parentObj = item;
	} else {
		child.haveParent = false;
	};
}

componentSimpleCourseTree.prototype.expandAllTree = function()
{
	for (var i in this.pagesArr)
	{
		var item = this.pagesArr[i];

		if (item && item.children.length > 0)
		{
			item.expand();
		};
	};
};

componentSimpleCourseTree.prototype.collapseAllTree = function()
{
	for (var i in this.pagesArr) {
		var item = this.pagesArr[i];
		if (item && item.children.length > 0) {
			item.collapse();
		};
	};
};

componentSimpleCourseTree.prototype.expandPageParents = function( index )
{
	if (this.pagesArr) {
		var item = this.pagesArr[index];
		if (item) var itemParent = this.pagesArr[item.parent];

		while (itemParent) {
			if (itemParent && itemParent.children.length > 0) itemParent.expand();
			itemParent = this.pagesArr[itemParent.parent];
		};
	};
};

componentSimpleCourseTree.prototype.setFocus = function(index)
{
	if (this.pagesArr) {
		var item = this.pagesArr[index];

		if (item) item.focus(this.focusColor);
	};
};

componentSimpleCourseTree.prototype.expandAllBranch = function(branchParent)
{
	branchParent.expand();
	for (var i=0; i < branchParent.children.length; i++) {
		var item = branchParent.children[i];
		if (item && item.children.length > 0) {
			this.expandAllBranch(item);
		};
	};
}

componentSimpleCourseTree.prototype.showChapter = function(chapterName)
{
	var pageChapter = this.showHideChoosenChapters(chapterName, 'show', false);
	if (pageChapter) this.expandAllBranch(pageChapter);
}

componentSimpleCourseTree.prototype.changeImage = function(obj, imgName)
{
	if (obj) obj.src = this.resourcesURL + imgName;
}

function treePageItem(posInStruct, compName, gix, index, title, action, parent, status, resourcesURL, pageNotAtt, pageIncompleted, pageCompleted, pagePass, pageFail, blankIcon, minusIcon, plusIcon, fontFamily, fontSize, fontColor )
{
	this.posInStruct = posInStruct;
	this.compName = compName;
	this.id = compName+'-tree-item-'+index;
	this.gix = gix;
	this.index = index;
	this.title = title;
	this.action = action;
	this.parent = parent;
	this.status = status;
	this.haveParent = false;
	this.parentObj = null;
	this.open = false;

	this.resourcesURL = resourcesURL;
	this.pageNotAtt = pageNotAtt;
	this.pageIncompleted = pageIncompleted;
	this.pageCompleted = pageCompleted;
	this.pagePass = pagePass;
	this.pageFail = pageFail;
	this.blankIcon = blankIcon;
	this.minusIcon = minusIcon;
	this.plusIcon = plusIcon;

	this.fontFamily = fontFamily;
	this.fontSize = fontSize;
	this.fontColor = fontColor;

	this.children = new Array();
};

treePageItem.prototype.expand = function ()
{
	var obj = document.getElementById(this.id+'-cont');
	var objSrc = document.getElementById(this.id+'-indent');

	if (obj) {
		obj.style.display = "block";
		this.open = true;
	};
	if (objSrc) {
		objSrc.src = this.resourcesURL + this.minusIcon;
	};
};

treePageItem.prototype.collapse = function ()
{
	var obj = document.getElementById(this.id+'-cont');
	var objSrc = document.getElementById(this.id+'-indent');

	if (obj) {
		obj.style.display = "none";
		this.open = false;
	};
	if (objSrc) {
		objSrc.src = this.resourcesURL + this.plusIcon;
	};
};

treePageItem.prototype.expandCollapse = function ()
{
	if (this.open) {
		this.collapse();
	} else {
		this.expand();
	};
};

treePageItem.prototype.focus = function (color)
{
	var span = document.getElementById(this.id+'-anchor');
	var par = document.getElementById(this.id+'-focus');

	if (span) span.style.background = color;
	if (par) par.style.background = color;
};

treePageItem.prototype.unselect = function() //pg2
{
	var span = document.getElementById(this.id+'-anchor');
	var par = document.getElementById(this.id+'-focus');

	if (span) span.style.background = 'transparent'; //'#FFFFFF'; //pg2-fix -after click on page (component on external page in new window), all rows' background turns to white (not transparent)
	if (par) par.style.background = 'transparent'; //'#FFFFFF';
};

treePageItem.prototype.toString = function ()
{
	var myParent = this.parentObj;
	var compName = '';
	var expandStr = '';
	var indent = '';
	var fixDisplay = '';
	if (!is.ie) fixDisplay = 'display: table;'; //pg2-in Firefox div wasn't resized to span's width
	var str = '<p id="' + this.id + '-focus" style="white-space: nowrap; ' + fixDisplay + '">';

	while (myParent) {
		myParent = myParent.parentObj;
		indent = "<img src=\"" + this.resourcesURL + this.blankIcon + "\">" + indent;
	};

	if (this.children.length > 0) {
		expandStr += "<img id=\"" + this.id + "-indent\" onclick=\"page.all['"+this.compName+"'].pagesArr["+this.index+"].expandCollapse();\" src=\"" + this.resourcesURL + this.plusIcon + "\">";
	} else {
		expandStr += "<img src=\"" + this.resourcesURL + this.blankIcon + "\">"
	};

	str += indent;
	str += expandStr;

	switch (this.status){
		case 'I' :
			str += "<img id=\""+this.compName+"_"+this.posInStruct+"_icon\" src=\"" + this.resourcesURL + this.pageIncompleted + "\">";
			break;
		case 'C' :
			str += "<img id=\""+this.compName+"_"+this.posInStruct+"_icon\" src=\"" + this.resourcesURL + this.pageCompleted + "\">";
			break;
		case 'P' :
			str += "<img id=\""+this.compName+"_"+this.posInStruct+"_icon\" src=\"" + this.resourcesURL + this.pagePass + "\">";
			break;
		case 'F' :
			str += "<img id=\""+this.compName+"_"+this.posInStruct+"_icon\" src=\"" + this.resourcesURL + this.pageFail + "\">";
			break;
		default :
			str += "<img id=\""+this.compName+"_"+this.posInStruct+"_icon\" src=\"" + this.resourcesURL + this.pageNotAtt + "\">";
			break;
	};

	str += "<span id=\"" + this.id + "-anchor\" title=\"" + this.title + "\" style=\"font-family: " + this.fontFamily + "; font-size:"+this.fontSize +
			"; color: " + this.fontColor + "; cursor:pointer;\" onclick=\"" + this.action + "\" ><u>" + this.title + "</u>" + 
			"<img src=\"" + this.resourcesURL + this.blankIcon + "\">" + //pg2-to extend backlight
			"</span>";

	str += "<div id=\"" + this.id + "-cont\" style=\"position: relative; display: " + ((this.open) ? 'block' : 'none') + ";\">";

	for (var i = 0; i < this.children.length; i++) {
		str += this.children[i].toString();
	};

	str += "</div>";
	str += "</p>";

	return str;
};
