﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
componentTextMark = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.correctAnswersList = new Array();
	this.userAnswersList = new Array();
	this.interactions = true;
	this.interactionsType = "choice";

	this.correctColor = "#00FF00";
	this.incorrectColorNotSelected = "#0000FF";
	this.incorrectColor = "#FF0000";
	this.numberOfWords = 0;

	this.allowGF = true;
};

componentTextMark.prototype = new componentElement();
componentTextMark.prototype.type = "componentTextMark";

componentTextMark.prototype.onCreate = function(obj)
{
	this.captureMouseEvents();
	this.correctAnswersList = this.correctAnswer = this.correctAnswer.replace(/,/g, ":");

	var font = {};
	font.family = this.fontFamily;
	font.size = this.fontSize;
	font.color = this.fontColor;

	if (this.allowGF && project.globalFormating) {
		this.fontFamily = project.font.family;
		this.fontSize = project.font.size;
		this.fontColor = project.font.color;
	};
	if (this.answerValuesString == '' && this.text != '') this.answerValuesString = this.text; //pg2-test
};

componentTextMark.prototype.getFontSize = function(value, format)
{
	var fontSizesPX = new Array(0,10,13,16,18,24,32,48);
	var fontSizesPT = new Array(0, 8,10,12,14,18,24,36);
	var pxSize = fontSizesPT[parseInt(value)];
	if (format == "px") {
		pxSize = fontSizesPX[parseInt(value)];
	};
	return pxSize;
};

componentTextMark.prototype.onPaint = function(obj)
{
	this.obj.dir = this.dir;
	var s = '';
	var textArray = this.text.toString().split("||");
	selectedColor = this.selectedColor;
	bgColor = this.bgColor;
	if (page.state == psDesigning) {
		var ansArray = this.correctAnswer.split(":");
		var wasHit = false;
		for (var i=0; i < textArray.length; i++) {
			for (var j=0; j < ansArray.length; j++) {
				if (i.toString() == ansArray[j].toString()) {
					s += "<span id='" + this.id + "_span_" + i + "' "+
						"style='background-color:" + this.selectedColor + "; font-size:" + this.getFontSize(this.fontSize, "px") + "px; color:" + this.fontColor + "; font-family:" + this.fontFamily + ";' "+
						"onclick = \"(this.style.backgroundColor == '" + bgColor + "')?this.style.backgroundColor='" + selectedColor + "':this.style.backgroundColor='" + bgColor + "'; pc." + this.id + ".updateUserAnswer();\">"+
						unquotedString(textArray[i]) + "</span> ";
					wasHit = true;
					break;
				};
			};
			if (!wasHit)
				s += "<span id='" + this.id + "_span_" + i + "' "+
					"style='background-color:" + this.bgColor + "; font-size:" + this.getFontSize(this.fontSize, "px") + "px; color:" + this.fontColor + "; font-family:" + this.fontFamily + ";' "+
					"onclick = \"(this.style.backgroundColor == '" + bgColor + "')?this.style.backgroundColor='" + selectedColor + "':this.style.backgroundColor='" + bgColor + "'; pc." + this.id + ".updateUserAnswer();\">"+ 
					unquotedString(textArray[i]) + "</span> ";
			wasHit = false;
		};
	} else {
		for (var i=0; i < textArray.length; i++) {
		 	s += "<span id='" + this.id + "_span_" + i + "' "+
				"style='background-color:" + this.bgColor + "; font-size:" + this.getFontSize(this.fontSize, "px") + "px; color:" + this.fontColor + "; font-family:" + this.fontFamily + ";' "+
				"onclick = \'pc."+this.id+".clickSPAN(this, \""+bgColor+"\", \""+selectedColor+"\");\'>"+
				unquotedString(textArray[i]) + "</span> ";
		};
	};
	this.numberOfWords = textArray.length;

	this.setHTML(s);
	this.onRepaint();
};

componentTextMark.prototype.clickSPAN = function(sender, bgCol, selCol)
{
	var ns = (navigator.appName.indexOf("Netscape") != -1);
	if (ns) var spanColor = this.RGBtoHex(sender.style.backgroundColor);
	else var spanColor = sender.style.backgroundColor;
	
	//(spanColor.toLowerCase() == selCol) ? sender.style.backgroundColor = bgCol:sender.style.backgroundColor = selCol; //pg2-wsptwp -chrome uses '#....' instead of 'lightblue', etc; replaced with below one
	(spanColor.toLowerCase() != this.bgColor) ? sender.style.backgroundColor = bgCol : sender.style.backgroundColor = selCol;

	this.updateUserAnswer();
};

componentTextMark.prototype.inTable = function(table, value)
{
	for (var i=0; i < table.length; i++ ) {
		if (value == table[i] && table[i] != ''){
			return true;
		};
	};
	return false;
};

componentTextMark.prototype.onRepaint = function(obj)
{
	if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator) {
		var textArray = this.text.toString().split("||");
		var userAnswer = this.getAnswer().toString().split(":");
		var ansArray = this.correctAnswer.split(":");

		for (var i=0; i < textArray.length; i++ ) {
			span = document.getElementById(this.id+"_span_" + i);
			if (span) {
				if (ansArray == '-1') {
					if (userAnswer == '') {
						span.style.backgroundColor = this.correctColor;
					} else
					if (this.inTable(userAnswer, i)) {
						span.style.backgroundColor = this.incorrectColor;
					} else {
						span.style.backgroundColor = this.correctColor;
					};
				} else {
					if (this.inTable(ansArray, i)) {
						if (userAnswer != "" && this.inTable(userAnswer, i)) {
							span.style.backgroundColor = this.correctColor;
						} else {
							span.style.backgroundColor = this.incorrectColor;
						};
					} else
					if (this.inTable(userAnswer, i)) {
						span.style.backgroundColor = this.incorrectColor;
					} else {
						if (this.markCorrectNotClickedAnswer) span.style.backgroundColor = this.correctColor;
					};
				};
			};
		};
	};
};

componentTextMark.prototype.RGBtoHex =  function(color)
{
	if (color.indexOf('rgb') == -1) return color;
	color = color.replace('rgb(', '');
	color = color.replace(')', '');
	color = color.replace(/ /g, '');

	var arr = color.split(',');
	return '#' + this.toHex(parseInt(arr[0])) + this.toHex(parseInt(arr[1])) + this.toHex(parseInt(arr[2]));
};

componentTextMark.prototype.toHex =  function(N)
{
	if (N==null) return "00";
	N=parseInt(N); if (N==0 || isNaN(N)) return "00";
	N=Math.max(0,N); N=Math.min(N,255); N=Math.round(N);

	return "0123456789ABCDEF".charAt((N-N%16)/16) + "0123456789ABCDEF".charAt(N%16);
};

componentTextMark.prototype.updateUserAnswer = function(obj)
{
	this.userAnswersList = "";
	var sep = "";
	var textArray = this.text.toString().split("||");
	var ns = (navigator.appName.indexOf("Netscape") != -1);
	for (var i=0; i < textArray.length; i++) {
		span = document.getElementById(this.id + "_span_" + i);
		if (ns) var spanColor = this.RGBtoHex(span.style.backgroundColor);
		else var spanColor = span.style.backgroundColor;

		//if ((span) && (spanColor.toLowerCase() == this.selectedColor)) { //pg2-wsptwp -chrome uses '#....' instead of 'lightblue', etc; replaced with below one
		if (span && spanColor != this.bgColor) {
			this.userAnswersList += sep + i;
			sep = ":";
		};
	};
};

componentTextMark.prototype.getAnswer = function(obj)
{
	var valInt = "";
	var sep = "";
	var textArray = this.text.toString().split("||");
	var ns = (navigator.appName.indexOf("Netscape") != -1);
  	if (this.ignoreAnswer) return "";

	return this.userAnswersList;

	for (var i=0; i < textArray.length; i++ ) {
		span = document.getElementById(this.id + "_span_" + i);
		if (ns) var spanColor = this.RGBtoHex(span.style.backgroundColor); 
		else var spanColor = span.style.backgroundColor;

		if ((span) && (spanColor.toLowerCase() == this.selectedColor)) {
			valInt += sep + i;
			sep = ":";
		};
	};

	return(valInt);
};

componentTextMark.prototype.setAnswer = function(valInt, showCorrect)
{
	if (typeof(valInt) == "undefined" || valInt == "") return;
	valInt = valInt.toString().replace(/,/g, ":");
	var ansArray = valInt.split(":");

	for (var i=0; i < this.numberOfWords; i++) {
		span = document.getElementById(this.id + "_span_" + i);
		if (span) {
			if (this.isInArray(i, ansArray)) {
				span.style.backgroundColor = this.selectedColor;
			} else {
				span.style.backgroundColor = 'transparent';
			};
		};
	};

	this.updateUserAnswer();

	return(valInt);
};

componentTextMark.prototype.isInArray = function(value, arr)
{
	for(var i=0; i < arr.length; i++) {
		if(value == arr[i]) return true;
	};
	return false;
};

componentTextMark.prototype.checkAnswer = function()
{
	return(this.parseCheckAnswer(this)); 
};

componentTextMark.prototype.parseCheckAnswer = function(obj)
{
	var retVal = false;
	var actAnswer = this.getAnswer().toString();
	if ((actAnswer == this.correctAnswer) || (actAnswer == '' && this.correctAnswer == '-1')) retVal = true;
	return retVal;
};

componentTextMark.prototype.onLock = function()
{
	var textArray = this.text.toString().split("||");
	var span = null;

 	for (var i=0; i < textArray.length; i++ ) {
		span = document.getElementById(this.id+"_span_"+i);
		if (span) span.onclick = "";
	};
  
  	return true;
};

componentTextMark.prototype.onUnLock = function()
{
	var textArray = this.text.toString().split("||");
	var span = null;
 	for (var i=0; i < textArray.length; i++ ) {
		span = document.getElementById(this.id+"_span_"+i);
		if (span) span.onclick = "this.style.backgroundColor == '" + this.bgColor + "')?this.style.backgroundColor='" + this.selectedColor + "':this.style.backgroundColor='" + this.bgColor + "'";
	};

  	return true; 
};

componentTextMark.prototype.interactionsCorrectResponsesCount = function()
{
	var length = 1;
	return length;
};

componentTextMark.prototype.interactionsCorrectResponses = function()
{
	return this.correctAnswersList;
};

componentTextMark.prototype.interactionsStudentResponse = function()
{
	return this.getAnswer().toString(); //pg2-
};

componentTextMark.prototype.interactionsCorrectResponsesAsText = function(index)
{
	if (typeof(this.answerValuesString) != "undefined" && this.answerValuesString != "") {
		var ansArr = this.answerValuesString.split("||");
		var corArr = this.interactionsCorrectResponses(index).split(":");
		var ans = "";
		for (var i=0; i<corArr.length; i++) {
			if (ans != "") ans += ":";
			ans += escape(ansArr[corArr[i]]);
		};
		if (typeof(ans) != "undefined" && ans != "") {
			return ans;
		} else {
			return this.interactionsCorrectResponses(index);
		};
	} else {
		return this.interactionsCorrectResponses(index);
	};
};

componentTextMark.prototype.interactionsStudentResponseAsText = function()
{
	if (typeof(this.answerValuesString) != "undefined" && this.answerValuesString != "") {
		var ansArr = this.answerValuesString.split("||");
		var corArr = this.interactionsStudentResponse().toString().split(":");
		var ans = "";
		for (var i=0; i<corArr.length; i++) {
			if (ans != "") ans += ":";
			var idx = parseInt(corArr[i]);
			if (!isNaN(idx)) {
				ans += escape(ansArr[idx]);
			};
		};
		if (typeof(ans) != "undefined" && ans != "") {
			return ans;
		} else {
			return this.interactionsStudentResponse();
		};
	} else {
		return this.interactionsStudentResponse();
	};
};
