﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentBookmarks = function(name)
{
	this.componentElement = componentElement;
	this.componentElement(name);

	this.button = this.addChild(new componentRollover(null));
	this.popup = this.addChild(new componentPopup(null));
	this.buttonAdd = this.popup.addChild(new componentRollover(null));
	this.buttonAdd.stopPropagation = true;
	this.buttonAdd.onClick = this.buttonAddClick;
	this.button.onClick = this.buttonClick;

	this.cookie = new Cookie();
}

componentBookmarks.prototype = new componentElement();
componentBookmarks.prototype.type = "componentBookmarks";

componentBookmarks.prototype.onCreate = function(text)
{
	if (!this.execution) {
		this.button.p_checkMarkers = this.p_checkMarkers;
		this.button.p_checkPNG = this.p_checkPNG;
		this.button.pngFix = this.pngFix;

		this.popup.p_checkMarkers = this.p_checkMarkers;
		this.popup.p_checkPNG = this.p_checkPNG;
		this.popup.pngFix = this.pngFix;

		this.buttonAdd.p_checkMarkers = this.p_checkMarkers;
		this.buttonAdd.p_checkPNG = this.p_checkPNG;
		this.buttonAdd.pngFix = this.pngFix;
	};

	this.popup.text.text = "<SELECT dir=\""+this.dir+"\" onClick='page.all[\""+this.id+"\"].onSelectUrl(this.selectedIndex)' id='"+this.id+"SELECT' size='5' style='width: 100%; height: 100%'></SELECT>";
	this.popup.text.align="right";

	this.captureMouseEvents();

	this.popup.h = (this.height) - this.button.h - 5;

	switch(this.buttonAlign) {
		case 0:
			this.popup.y = this.button.h + 5;
			this.button.x = 0;
			this.button.y = 0;
			break;
		case 1:
			this.popup.y = this.button.h + 5;
			this.button.x = this.width - this.button.w;
			this.button.y = 0;
			break;
		case 2:
			this.button.x = 0;
			this.button.y = this.popup.h + 5;
			break;
		case 3:
			this.button.x = this.popup.w - this.button.w;
			this.button.y = this.popup.h + 5;
			break;
	};

	this.popup.button.noDisplay();
	this.popup.buttonCross.noDisplay();
};

componentBookmarks.prototype.onShow = function ()
{
	this.popup.hide();
};

componentBookmarks.prototype.componentBookmarksBaseSetSizeScaledElement = componentBookmarks.prototype.setSizeScaledElement;
componentBookmarks.prototype.setSizeScaledElement = function (x, y, w, h)
{
	if (this.execution) {
		if (is.ie) {
			//this.obj.all[this.id + "_textTitleDIV"].style.width = w-(this.borderWidth*2);
		} else {
			//document.all[this.id + "_textTitleDIV"].style.width = w-(this.borderWidth*2);
		};
	};
	this.componentBookmarksBaseSetSizeScaledElement(x, y, w, h);
};

componentBookmarks.prototype.setPagesName = function(e)
{
	var select = document.getElementById(this.id+'SELECT');
	var params = lms.getCourseData('_bMark_pages');
	if (params != '' && params != null) {
		var pagesArr = params.split('|$|');
		for (var i=0; i< pagesArr.length; i++){
			var splited = pagesArr[i].split("#!#");
			var option = new Option(splited[0])
			option.value = splited[1];
			select.options[i] = option;
		};
	};
};

componentBookmarks.prototype.setSizeScaledElement = function(x, y, w, h)
{
	if (this.execution) {
		this.obj.style.clip = 'rect(0px '+w+' '+h+' 0px)';
		this.obj.style.left = x;
		this.obj.style.top = y;
		this.obj.style.width = w;
		this.obj.style.height = h;
	};
	this.popup.w = w;
	this.popup.h = h - this.button.h;
	if (this.dir == "rtl") {
		this.button.x = 0;
		this.button.y = 0;
	} else {
		this.button.x = w - this.button.w;
		this.button.y = h - this.button.h;
	};
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
};

componentBookmarks.prototype.onPaint = function(e)
{
	if (this.dir == "rtl") {
		this.buttonAdd.x = 7;
	} else {
		this.buttonAdd.x = this.popup.w - this.buttonAdd.w - 7;
	};
	this.popup.canDragging = false;
};

componentBookmarks.prototype.saveBookmarksName = function(e)
{
	var select = document.getElementById(this.id+'SELECT');
	var length = select.options.length;

	var t = '';
	var sep = '';
	for (var i=0; i<length; i++) {
		if (t != '') sep = '|$|';
		t += sep+select.options[i].text+"#!#"+select.options[i].value;
	};
	lms.setCourseData('_bMark_pages', t);
};

componentBookmarks.prototype.buttonClick = function(e)
{
	if (!this.parent.popup.visible) {
		this.parent.popup.show();
		this.parent.popup.text.stopPropagation = true;
	} else this.parent.popup.hide();

	this.parent.setPagesName();
};

componentBookmarks.prototype.getPageName = function(index)
{
	if (top.sw) {
		for (var i=0; i<top.sw.pages.length; i++) {
			if (top.sw.pages[i].globalIndex == index) return top.sw.pages[i].pageName;
		};
		return false;
	} else return false;
};

componentBookmarks.prototype.buttonAddClick = function(e)
{
	var select = document.getElementById(this.parent.parent.id + 'SELECT');

	//var pageN = this.parent.parent.getPageName(project.pageRealGlobalIndex);
	var pageN = project.pageName;

	if (!pageN) pageN =  'Page preview'; else //project.pageRealGlobalIndex;
	if (pageN.length > 50) pageN = pageN.subtring(0,50)+"...";

	var option = new Option(pageN)
	option.value = project.pageRealGlobalIndex;
	select.options[select.length] = option;

	this.parent.parent.saveBookmarksName();
};

componentBookmarks.prototype.onSelectUrl = function(i)
{
	if (i != -1 && document.getElementById(this.id+'SELECT').options.length  != 0 && 
		document.getElementById(this.id+'SELECT').options[i].value != -1)
	{
		page.gotoPage(document.getElementById(this.id+'SELECT').options[i].value);
	};
};
