var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var ConnectDots;
var zad_zaliczone = 0;
(function (_ConnectDots) {
    var ConnectDots = (function (_super) {
        __extends(ConnectDots, _super);
        function ConnectDots(game, name, x, y, json) {
            _super.call(this, game, name, x + 400, y, json);
            this.order = [];
        }
        ConnectDots.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        ConnectDots.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        ConnectDots.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        ConnectDots.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            var airplane = this.game.add.sprite(0, 0, 'airplane');
            this.addChild(airplane);
            this.drawNumbers();
        };
        ConnectDots.prototype.createStaticElements = function () {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        };
        ConnectDots.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        ConnectDots.prototype.drawNumbers = function () {
            var liczby = [];
            for (var i = 0; i < this.Elements.Dots.length; i++) {
                liczby.push({ x: this.Elements.Dots[i].x, y: this.Elements.Dots[i].y });
                if (i == 0) {
                    this.lastX = this.Elements.Dots[i].x;
                    this.lastY = this.Elements.Dots[i].y;
                }
            }
            for (i = 0; i < liczby.length; i++) {
                if (i > 0)
                    this.order.push(i.toString());
                var txt = this.game.add.text(liczby[i].x, liczby[i].y, i.toString(), { font: "18px Arial", fill: "#000000", align: "center" });
                txt.anchor.set(0.5, 0.5);
                txt.inputEnabled = true;
                txt.events.onInputDown.add(this.drawLine, this);
                this.addChild(txt);
                var dot = this.game.add.graphics(0, 0);
                dot.lineStyle(5, 0x000000, 1);
                dot.moveTo(liczby[i].x - 2, liczby[i].y + 10);
                dot.lineTo(liczby[i].x + 2, liczby[i].y + 10);
                this.addChild(dot);
            }
        };
		ConnectDots.prototype.nextScreen = function () {
            if (this.gameCompletion < 1 && (TYPE === "wc" || TYPE === "gm" || TYPE === "fi"))
                return false;
            EU.Log("game completion: " + this.gameCompletion);
            this.game.input.enabled = false;
            EU.killKeyboard();
            var tw = this.game.add.tween(this.game.camera);
            tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
            tw.onComplete.add(function () {
                this.game.input.enabled = true;
            }, this);
            tw.start();
            Global.Main.currentPageNumber++;
            Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
            console.log(Global.Main.currentPageNumber);
        };
        ConnectDots.prototype.drawLine = function (item) {
            if (this.order[0] != item.text && this.order.length > 0) {
                this.gfx = this.game.add.graphics(0, 0);
                this.gfx.lineStyle(3, 0xff0000, 1);
                this.gfx.moveTo(this.lastX, this.lastY + 10);
                this.gfx.lineTo(item.x, item.y + 10);
                this.addChild(this.gfx);
                var tw = this.game.add.tween(this.gfx).to({ alpha: 0 }, 1500, "Linear", true);
				zad_zaliczone = 0;
				console.log("zad_zaliczone = "+zad_zaliczone);
            }
            else if (this.order.length > 0) {
                this.order.shift();
                this.gfx = this.game.add.graphics(0, 0);
                this.gfx.lineStyle(3, 0x0000000, 1);
                this.gfx.moveTo(this.lastX, this.lastY + 10);
                this.gfx.lineTo(item.x, item.y + 10);
                this.addChild(this.gfx);
                this.lastX = item.x;
                this.lastY = item.y;
				zad_zaliczone = 0;
				console.log("zad_zaliczone = "+zad_zaliczone);
            }
            if (this.order.length == 0) {
				zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
                if (TYPE === "gm") {
					var next = this.game.add.button(1350 - 120, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8, 0.8);
					this.addChild(next);
                    _super.prototype.nextTask.call(this);
                }
            }
        };
        return ConnectDots;
    })(Base.BasicGroup);
    _ConnectDots.ConnectDots = ConnectDots;
})(ConnectDots || (ConnectDots = {}));
//# sourceMappingURL=ConnectDots.js.map