var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Fiche;
(function (_Fiche) {
    var Fiche = (function (_super) {
        __extends(Fiche, _super);
        function Fiche(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.currentFiche = 1;
        }
        Fiche.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.GameData = json.GameData;
        };
        Fiche.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        Fiche.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.isPolish = true;
            this.Loader = new Phaser.Loader(this.game);
            var back = this.game.add.image(50, -150, "bck");
            var prev = this.game.add.button(175, 650, "prevF", this.prevFiche, this, 0, 0, 1, 0);
            var next = this.game.add.button(1200, 650, "nextF", this.nextFiche, this, 0, 0, 1, 0);
            var fSpeaker = this.game.add.button(100, -100, "fSpeaker", this.readLector, this, 0, 0, 1, 0);
            var flip = this.game.add.button(1230, -90, "flip", this.flip, this, 0, 0, 1, 0);
            this.FicheImage = this.game.add.image(450, 0, "firstImage");
            this.description = this.game.add.text(500, 550, this.GameData.words[0].term_PL, { font: "42pt Arial", wordWrap: false }, this);
            this.addChild(back);
            this.addChild(fSpeaker);
            this.addChild(flip);
            this.addChild(prev);
            this.addChild(next);
            this.addChild(this.description);
            this.addChild(this.FicheImage);
        };
        Fiche.prototype.flip = function () {
            if (this.isPolish) {
                this.description.setText(this.GameData.words[this.currentFiche].term_EN);
                this.isPolish = false;
            }
            else {
                this.description.setText(this.GameData.words[this.currentFiche].term_PL);
                this.isPolish = true;
            }
        };
        Fiche.prototype.readLector = function () {
        };
        Fiche.prototype.nextFiche = function () {
            this.currentFiche++;
            this.description.setText(this.GameData.words[this.currentFiche].term_PL);
            this.loadFiche();
        };
        Fiche.prototype.prevFiche = function () {
            this.currentFiche--;
            this.loadFiche();
        };
        Fiche.prototype.loadFiche = function () {
            this.Loader.image(this.currentFiche + "", "Graphics/Games/OS_G_FI_I" + "/1_" + this.currentFiche + ".jpg");
            this.Loader.onLoadComplete.addOnce(this.setFiche, this);
            this.Loader.start();
        };
        Fiche.prototype.setFiche = function () {
            this.FicheImage.loadTexture(this.currentFiche, 0);
        };
        Fiche.prototype.loadGraphics = function () {
            this.game.load.image("bck", "Graphics/GUI/" + CardChooser.getModule() + "/" + "modul1.png");
            this.game.load.spritesheet("prevF", "Graphics/GUI/OS/prev1.png", 100, 100, 2);
            this.game.load.spritesheet("flip", "Graphics/GUI/OS/flipButton1.png", 115, 115, 2);
            this.game.load.spritesheet("fSpeaker", "Graphics/GUI/OS/speaker1.png", 115, 115, 2);
            this.game.load.image("firstImage", "Graphics/Games/OS_G_FI_I" + "/1_1.jpg");
            this.game.load.spritesheet("nextF", "Graphics/GUI/OS/next1.png", 100, 100, 2);
        };
        return Fiche;
    })(Base.BasicGroup);
    _Fiche.Fiche = Fiche;
})(Fiche || (Fiche = {}));
//# sourceMappingURL=Fiche.js.map