﻿/*
 * Copyright (C) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
 
componentSLWCursor = function(name)
{
	//inherited
	this.__componentImage = __componentImage;
	this.__componentImage(name);
	
	this.imagesNameArr = new Array();
	this.timerIDAnim = null;
	this.timerIDClick = null;
	this.clickTime = 400;
	this.offsetX = 16;
	this.offsetY = 13;
	this.isStepStop = false;
	this.offsetDone = false;
	this.remainderTime = 0;
	this.imagesNameArr = new Array();	
};

componentSLWCursor.prototype = new __componentImage();
componentSLWCursor.prototype.type = "componentSLWCursor";

componentSLWCursor.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	}
	this.resourcesURL = unescape(this.resourcesURL);
	
	this.imagesNameArr = [ this.src, this.srcAnim ];	
	this.getPreloadImagesArr();
	this.contentObj = this.findContentObj();

	this.captureMouseEvents();
};

componentSLWCursor.prototype.distance = function(x2, y2)
{
	function sqr(x) { return x * x; };
	return Math.sqrt(sqr(this.x - x2) + sqr(this.y - y2));
};

componentSLWCursor.prototype.componentSLWCursorAnimationMoveTo = componentSLWCursor.prototype.animationMoveTo;
componentSLWCursor.prototype.animationMoveTo = function(x, y, time)
{
	this.anim.animated = true;
	this.isStepStop = false;
	var stepTime = page.steps[page.stepIndex + 1][0];

	if (stepTime > this.clickTime)
	{
		var optimalMoveTime = parseInt((this.distance(x, y) * 1000) / 400);
		var realMoveTime = stepTime - this.clickTime;
		var moveTime = (realMoveTime < optimalMoveTime) ? realMoveTime:optimalMoveTime;
		var startMoveTime = stepTime - moveTime - this.clickTime;
		this.remainderTime = this.clickTime;
		if (startMoveTime < 100)
		{
			this.timerAnimStart(x,y,moveTime);
		} else {
			this.timerIDAnim = window.setTimeout('pc.'+this.id+'.timerAnimStart('+x+','+y+','+moveTime+');', startMoveTime);
		}
	} else {
		this.remainderTime = stepTime;
		this.timerAnimStart(x, y, 0);
	}
};

componentSLWCursor.prototype.stepStop = function()
{
	this.isStepStop = true;
	this._animationTimerStop();
	this.moveTo(this.anim.ex, this.anim.ey);
	this.resetAnimClick(this.anim.ex, this.anim.ey);
};

componentSLWCursor.prototype.componentSLWCursorAnimationStop = componentSLWCursor.prototype.animationStop;
componentSLWCursor.prototype.animationStop = function()
{
	if (!this.isStepStop)
	{
		this.moveTo(this.anim.ex, this.anim.ey);
		this.changeImg(this.srcAnim);
		this.timerIDClick = window.setTimeout('pc.'+this.id+'.resetAnimClick('+this.anim.ex+','+this.anim.ey+');', this.remainderTime);
	}
	this.componentSLWCursorAnimationStop();
};

componentSLWCursor.prototype.timerAnimStart = function(x, y, time)
{
	if (!this.offsetDone)
	{
		this.offsetDone = true;
		x -= this.offsetX;
		y -= this.offsetY;
	}
	this.componentSLWCursorAnimationMoveTo(x, y, time);
};

componentSLWCursor.prototype.super_resetElement = componentSLWCursor.prototype.resetElement;
componentSLWCursor.prototype.resetElement = function()
{
	this.resetTimers();
	this.super_resetElement();
}

componentSLWCursor.prototype.resetPosition = function()
{
	this.resetElement();
	this.offsetDone = false;
}

componentSLWCursor.prototype.resetAnimClick = function(x, y)
{
	this.changeImg(this.src);
}

componentSLWCursor.prototype.resetTimers = function()
{
	if (this.timerIDAnim != null)  {
		window.clearTimeout(this.timerIDAnim);
		this.timerIDAnim = null;
	}
	if (this.timerIDClick != null)  {
		window.clearTimeout(this.timerIDClick);
		this.timerIDClick = null;
	}
}

componentSLWCursor.prototype.changeImg = function(img)
{
	var contentObj = this.findContentObj();
	contentObj.src = this.resourcesURL + img;
}

componentSLWCursor.prototype.onFree = function()
{
	this.resetTimers();
};
