var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Memo;
(function (_Memo) {
    var Memo = (function (_super) {
        __extends(Memo, _super);
        function Memo(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.unhide = 0;
            this.totalPair = 8;
            this.cards = ['brzoza1', 'brzoza2', 'buk1', 'buk2', 'dab1', 'dab2', 'jodla1', 'jodla2', 'klon1', 'klon2', 'modrzew1', 'modrzew2', 'sosna1', 'sosna2', 'swierk1', 'swierk2'];
        }
        Memo.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Memo.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        Memo.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Memo.prototype.shuffle = function (o) {
            for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x)
                ;
            return o;
        };
        Memo.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.shuffle(this.cards);
            var variant = 1;
            for (var i = 0; i < 4; i++)
                for (var j = 0; j < 4; j++) {
                    var m = new MemoCard(this.game, 400 + (i * 220), 0 + (j * 220), this.cards[0]);
                    m.inputEnabled = true;
                    m.events.onInputDown.add(this.clickCard, this);
                    this.cards.shift();
                    this.addChild(m);
                }
        };
        Memo.prototype.clickCard = function (obj) {
            this.unhide++;
            if (this.unhide == 1) {
                this.firstCard = obj;
                this.firstCard.inputEnabled = false;
                this.firstCard.showKey();
            }
            if (this.unhide == 2) {
                this.secondCard = obj;
                this.secondCard.inputEnabled = false;
                this.secondCard.showKey();
                this.game.time.events.add(Phaser.Timer.SECOND * 2, this.checkPair, this);
            }
        };
        Memo.prototype.checkPair = function () {
            if (this.firstCard.group == this.secondCard.group) {
                this.firstCard.done = true;
                this.secondCard.done = true;
                this.unhide = 0;
                this.totalPair--;
                if (this.totalPair == 0) {
                    EU.setGameCompletion(this.parent, 1);
                    _super.prototype.nextTask.call(this);
                }
                console.log('Pair');
            }
            else {
                this.firstCard.back();
                this.secondCard.back();
                this.unhide = 0;
            }
        };
        return Memo;
    })(Base.BasicGroup);
    _Memo.Memo = Memo;
    var MemoCard = (function (_super) {
        __extends(MemoCard, _super);
        function MemoCard(game, x, y, key) {
            _super.call(this, game, x, y, 'memo');
            this.done = false;
            this.group = key.substring(0, key.length - 1);
            this.imgKey = key;
            this.game = game;
        }
        MemoCard.prototype.showKey = function () {
            this.loadTexture(this.imgKey, 0, true);
        };
        MemoCard.prototype.back = function () {
            this.loadTexture('memo', 0, true);
            this.inputEnabled = true;
        };
        return MemoCard;
    })(Phaser.Sprite);
})(Memo || (Memo = {}));
//# sourceMappingURL=Memo.js.map