var EU;
(function (EU) {
    function generatePositions(startPos, elementWidth, margin, amount) {
        var ret = [];
        for (var i = 0; i < amount; i++) {
            var t = startPos + i * (elementWidth + margin);
            ret.push(t);
        }
        return ret;
    }
    EU.generatePositions = generatePositions;
    function Log(message) {
        if (DEBUG)
            console.log(message);
    }
    EU.Log = Log;
    function shuffleArray(arr) {
        var t = arr.length;
        var temp = generateUniqueRandoms(0, t, t);
        var ret = [];
        for (var i = 0; i < t; i++) {
            ret.push(arr[temp[i]]);
        }
        return ret;
    }
    EU.shuffleArray = shuffleArray;
    function generateGridPositions(cols, rows, width, height, marginX, marginY, startPosX, startPosY, upDown) {
        var xPos = generatePositions(startPosX, width, marginX, cols);
        var yPos = generatePositions(startPosY, height, marginY, rows);
        var ret = [];
        var xLen = xPos.length;
        var yLen = yPos.length;
        if (upDown) {
            for (var i = 0; i < xLen; i++) {
                for (var j = 0; j < yLen; j++) {
                    var t = { x: xPos[i], y: yPos[j] };
                    ret.push(t);
                }
            }
        }
        else {
            for (var i = 0; i < yLen; i++) {
                for (var j = 0; j < xLen; j++) {
                    var t = { x: xPos[j], y: yPos[i] };
                    ret.push(t);
                }
            }
        }
        return ret;
    }
    EU.generateGridPositions = generateGridPositions;
    function setGameCompletion(context, value) {
        context.gameCompletion = value;
    }
    EU.setGameCompletion = setGameCompletion;
    function generateUniqueRandoms(min, max, amount) {
        var ret = [];
        if ((amount > max - min || max < min) && min !== 0) {
            return undefined;
        }
        for (var i = 0; i < amount; i++) {
            var maxIterations = 0;
            var s = min + Math.floor(Math.random() * max);
            while ($.inArray(s, ret) !== -1 && maxIterations < 500) {
                s = min + Math.floor(Math.random() * max);
                maxIterations++;
            }
            ret.push(s);
        }
        return ret;
    }
    EU.generateUniqueRandoms = generateUniqueRandoms;
    function createStaticSounds(game) {
        if (game.GameData.StaticSounds)
            for (var i = 0; i < game.GameData.StaticSounds.el.length; i++) {
                var el;
                el = game.game.add.sprite(0, 0, "speaker");
                el.inputEnabled = true;
                el.name = game.GameData.StaticSounds.el[i].sound;
                el.events.onInputUp.add(EU.soundButtonDown, game);
                var posX = game.GameData.StaticSounds.el[i].pos.x;
                var posY = game.GameData.StaticSounds.el[i].pos.y;
                if (game.GameData.StaticSounds.Options.Just) {
                    switch (game.GameData.StaticSounds.Options.Just.x) {
                        case "center":
                            posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                            el.anchor.x = 0.5;
                            break;
                        case "right":
                            posX += Global.Main.mainContainerDims.wd - 120;
                            el.anchor.x = 1;
                            break;
                    }
                    switch (game.Elements.StaticElements.Options.Just.y) {
                        case "center":
                            posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                            el.anchor.y = 0.5;
                            break;
                        case "bottom":
                            posY += Global.Main.mainContainerDims.hg - 65;
                            el.anchor.y = 1;
                            break;
                    }
                }
                el.position.set(posX, posY);
                game.addChild(el);
            }
    }
    EU.createStaticSounds = createStaticSounds;
    function createStaticElements(game) {
        if (game.Elements.StaticElements)
            for (var i = 0; i < game.Elements.StaticElements.el.length; i++) {
                var el;
                switch (game.Elements.StaticElements.el[i].type) {
                    case "image":
                        el = game.game.add.image(0, 0, game.PREFIX + game.Elements.StaticElements.el[i].key);
                        break;
                    case "text":
                        el = game.game.add.text(0, 0, game.Elements.StaticElements.el[i].text, game.Elements.StaticElements.Options.Style);
                        break;
                    case "sound":
                        el = game.game.add.sprite(0, 0, "speaker");
                        el.inputEnabled = true;
                        el.name = game.Elements.StaticElements.el[i].sound;
                        el.events.onInputUp.add(EU.soundButtonDown, game);
                        break;
                }
                var posX = game.Elements.StaticElements.el[i].pos.x;
                var posY = game.Elements.StaticElements.el[i].pos.y;
                if (game.Elements.StaticElements.Options.Just) {
                    switch (game.Elements.StaticElements.Options.Just.x) {
                        case "center":
                            posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                            el.anchor.x = 0.5;
                            break;
                        case "right":
                            posX += Global.Main.mainContainerDims.wd - 120;
                            el.anchor.x = 1;
                            break;
                    }
                    switch (game.Elements.StaticElements.Options.Just.y) {
                        case "center":
                            posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                            el.anchor.y = 0.5;
                            break;
                        case "bottom":
                            posY += Global.Main.mainContainerDims.hg - 65;
                            el.anchor.y = 1;
                            break;
                    }
                }
                el.position.set(posX, posY);
                game.addChild(el);
            }
    }
    EU.createStaticElements = createStaticElements;
    function soundButtonDown(button) {
        Global.Main.PlayMusic(new Audio(button.name));
    }
    EU.soundButtonDown = soundButtonDown;
    function createSelectableElements(game) {
        if (game.Elements.SelectableElements)
            for (var i = 0; i < game.Elements.SelectableElements.el.length; i++) {
                var el;
                switch (game.Elements.SelectableElements.el[i].type) {
                    case "image":
                        el = game.game.add.image(0, 0, game.Elements.TaskPrefix + game.Elements.SelectableElements.el[i].key);
                        if (game.Elements.SelectableElements.el[i].exit && game.Elements.SelectableElements.el[i].exit == true) {
                            el.inputEnabled = true;
                            el.events.onInputDown.add(this.exit, { "game": game });
                        }
                        else
                            this.appendInputHandlersImage(el, game);
                        break;
                    case "text":
                        el = game.game.add.text(0, 0, game.Elements.SelectableElements.el[i].text, game.Elements.SelectableElements.Options.Style);
                        if (game.Elements.SelectableElements.el[i].exit && game.Elements.SelectableElements.el[i].exit == true) {
                            el.inputEnabled = true;
                            el.events.onInputDown.add(this.exit, { "game": game });
                        }
                        else
                            this.appendInputHandlersText(el, game);
                        break;
                }
                el.name = "unchecked";
                if (game.Elements.SelectableElements.Options.Type && game.Elements.SelectableElements.Options.Type == "ChangeAfterClick")
                    el.name = i;
                var posX = game.Elements.SelectableElements.el[i].pos.x;
                var posY = game.Elements.SelectableElements.el[i].pos.y;
                if (game.Elements.SelectableElements.Options.Just) {
                    switch (game.Elements.SelectableElements.Options.Just.x) {
                        case "center":
                            posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                            el.anchor.x = 0.5;
                            break;
                        case "right":
                            posX += Global.Main.mainContainerDims.wd - 120;
                            el.anchor.x = 1;
                            break;
                    }
                    switch (game.Elements.SelectableElements.Options.Just.y) {
                        case "center":
                            posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                            el.anchor.y = 0.5;
                            break;
                        case "bottom":
                            posY += Global.Main.mainContainerDims.hg - 65;
                            el.anchor.y = 1;
                            break;
                    }
                }
                el.position.set(posX, posY);
                game.Elements.SelectableElements.el[i].name = el;
                game.addChild(el);
            }
    }
    EU.createSelectableElements = createSelectableElements;
    function appendInputHandlersText(el, game) {
        el.inputEnabled = true;
        switch (game.Elements.SelectableElements.Options.TextInputOverHandle) {
            default:
                el.events.onInputOver.add(this.onInputOver, game);
        }
        switch (game.Elements.SelectableElements.Options.TextInputOutHandle) {
            default:
                el.events.onInputOut.add(this.onInputOut, game);
        }
        switch (game.Elements.SelectableElements.Options.TextInputDownHandle) {
            case "rect":
                el.events.onInputDown.add(this.onRectDown, { "game": game });
                break;
            case "underline":
                el.events.onInputDown.add(this.onUnderlineDown, { "game": game });
                break;
            case "crossing":
                el.events.onInputDown.add(this.onCrossingDown, { "game": game });
                break;
            case "shadow":
                el.events.onInputDown.add(this.onShadowDown, { "game": game });
                break;
            default:
                el.events.onInputDown.add(this.onInputDown, { "game": game });
        }
    }
    EU.appendInputHandlersText = appendInputHandlersText;
    function appendInputHandlersImage(el, game) {
        el.inputEnabled = true;
        switch (game.Elements.SelectableElements.Options.ImageInputOverHandle) {
            default:
                el.events.onInputOver.add(this.onInputOver, game);
        }
        switch (game.Elements.SelectableElements.Options.ImageInputOutHandle) {
            default:
                el.events.onInputOut.add(this.onInputOut, game);
        }
        switch (game.Elements.SelectableElements.Options.ImageInputDownHandle) {
            case "assistant":
                el.events.onInputDown.add(this.showAssistant, { "game": game });
                break;
            case "change":
                el.events.onInputDown.add(this.changeImage, { "game": game });
                break;
            case "showText":
                el.events.onInputDown.add(this.showText, { "game": game });
                break;
            case "change2":
                el.events.onInputDown.add(this.changeImage2, { "game": game });
                break;
            case "rect":
                el.events.onInputDown.add(this.onRectDown, { "game": game });
                break;
            case "underline":
                el.events.onInputDown.add(this.onUnderlineDown, { "game": game });
                break;
            case "crossing":
                el.events.onInputDown.add(this.onCrossingDown, { "game": game });
                break;
            default:
                el.events.onInputDown.add(this.onInputDown, { "game": game });
        }
    }
    EU.appendInputHandlersImage = appendInputHandlersImage;
    function onInputOver(el, pointer) {
        el.alpha = 0.5;
    }
    EU.onInputOver = onInputOver;
    function exit(el, pointer) {
        this.game.nextTask();
        Global.Main.PlayMusic(new Audio(this.game.Elements.SelectableElements.Options.EndSound));
    }
    EU.exit = exit;
    function onInputOut(el, pointer) {
        el.alpha = 1.0;
    }
    EU.onInputOut = onInputOut;
    function onInputDown(el, pointer) {
        if (el.name == "unchecked") {
            el.name = "checked";
            el.scale.set(1.1, 1.1);
        }
        else {
            el.name = "unchecked";
            el.scale.set(1, 1);
            el.tint = 0xFFFFFF;
        }
        this.game.checkIfEverythingIsCorrect();
    }
    EU.onInputDown = onInputDown;
    function showAssistant(el, pointer) {
        var ass = this.game.game.add.image(-120, -200, this.game.Elements.TaskPrefix + this.game.Elements.SelectableElements.Options.Assistant);
        this.game.addChild(ass);
        ass.inputEnabled = true;
        Global.Main.PlayMusic(new Audio(this.game.Elements.SelectableElements.Options.AssistantSound));
        var text = this.game.game.add.text(1120, 200, this.game.Elements.SelectableElements.Options.AssistantText, { font: "25px Arial", fill: 'black' });
        ass.addChild(text);
        ass.events.onInputDown.add(ass.destroy, ass);
    }
    EU.showAssistant = showAssistant;
    function showText(el, pointer) {
        var text = this.game.game.add.text(el.position.x + this.game.Elements.SelectableElements.el[el.name].pivot, el.position.y + 20, this.game.Elements.SelectableElements.el[el.name].showtext, { font: "50px Arial", fill: 'black' });
        text.anchor.set(0.5, 0.5);
        this.game.addChild(text);
        el.inputEnabled = false;
    }
    EU.showText = showText;
    function changeImage(el, pointer) {
        var text = this.game.game.add.text(el.position.x, el.position.y, this.game.Elements.SelectableElements.el[el.name].changetext, { font: "20px Arial", fill: 'black' });
        text.anchor.set(0.5, 0.5);
        this.game.addChild(text);
        el.destroy();
    }
    EU.changeImage = changeImage;
    function changeImage2(el, pointer) {
        var text = this.game.game.add.text(el.position.x, el.position.y, this.game.Elements.SelectableElements.el[el.name].changetext, { font: "40px Arial", fill: 'black' });
        text.anchor.set(0.5, 0.5);
        this.game.addChild(text);
        el.destroy();
    }
    EU.changeImage2 = changeImage2;
    function onShadowDown(el, pointer) {
        if (el.name == "unchecked") {
            el.name = "checked";
            el.scale.set(1.1, 1.1);
            el.setShadow(el.height / 20, el.height / 20, "green");
        }
        else {
            el.name = "unchecked";
            el.scale.set(1, 1);
            el.setShadow(0, 0, "black");
        }
        this.game.checkIfEverythingIsCorrect();
    }
    EU.onShadowDown = onShadowDown;
    function onCrossingDown(el, pointer) {
        if (el.name == "unchecked") {
            el.name = "checked";
            el.addChild(drawLine("red", -el.anchor.x * el.width, -el.anchor.y * el.height, el.width - el.width * el.anchor.x, el.height - el.anchor.y * el.height, this.game, 12));
        }
        else {
            el.name = "unchecked";
            el.removeChildren();
        }
        this.game.checkIfEverythingIsCorrect();
    }
    EU.onCrossingDown = onCrossingDown;
    function onUnderlineDown(el, pointer) {
        if (el.name == "unchecked") {
            el.name = "checked";
            el.addChild(drawLine("red", -el.anchor.x * el.width, el.height - el.anchor.y * el.height, el.width - el.width * el.anchor.x, el.height - el.anchor.y * el.height, this.game, 12));
        }
        else {
            el.name = "unchecked";
            el.removeChildren();
        }
        this.game.checkIfEverythingIsCorrect();
    }
    EU.onUnderlineDown = onUnderlineDown;
    function onRectDown(el, pointer) {
        if (el.name == "unchecked") {
            el.name = "checked";
            var rect = drawRect("red", 1.1 * el.width, 1.1 * el.height, el.height / 5, 8, this.game);
            rect.position.set(-1.1 * el.anchor.x * el.width, -1.1 * el.anchor.y * el.height);
            el.addChild(rect);
        }
        else {
            el.name = "unchecked";
            el.removeChildren();
        }
        this.game.checkIfEverythingIsCorrect();
    }
    EU.onRectDown = onRectDown;
    function drawLine(color, x1, y1, x2, y2, game, lineWidth) {
        var lineLength = Phaser.Math.distance(x1, y1, x2, y2);
        var lineAngle = Phaser.Math.angleBetween(x1, y1, x2, y2);
        var bmd = game.game.add.bitmapData(lineLength, lineWidth);
        bmd.ctx.beginPath();
        bmd.ctx.strokeStyle = color;
        bmd.ctx.stroke();
        var line = game.game.add.sprite(x1, y1, bmd);
        line.anchor.y = 0.5;
        line.smoothed = true;
        line.angle = Phaser.Math.radToDeg(lineAngle);
        bmd.ctx.beginPath();
        bmd.ctx.moveTo(0, lineWidth / 2);
        bmd.ctx.lineTo(lineLength, lineWidth / 2);
        bmd.ctx.lineWidth = lineWidth;
        bmd.ctx.stroke();
        bmd.ctx.closePath();
        bmd.render();
        return line;
    }
    EU.drawLine = drawLine;
    function drawRect(color, width, height, roundness, thickness, game) {
        var bmd = game.game.add.bitmapData(width, height);
        bmd.ctx.beginPath();
        bmd.ctx.moveTo(roundness, 0);
        bmd.ctx.lineTo(width - roundness, 0);
        bmd.ctx.quadraticCurveTo(width, 0, width, roundness);
        bmd.ctx.lineTo(width, height - roundness);
        bmd.ctx.quadraticCurveTo(width, height, width - roundness, height);
        bmd.ctx.lineTo(roundness, height);
        bmd.ctx.quadraticCurveTo(0, height, 0, height - roundness);
        bmd.ctx.lineTo(0, roundness);
        bmd.ctx.quadraticCurveTo(0, 0, roundness, 0);
        bmd.ctx.stroke();
        bmd.ctx.strokeStyle = color;
        bmd.ctx.lineWidth = thickness;
        bmd.ctx.stroke();
        return game.game.add.sprite(0, 0, bmd);
    }
    EU.drawRect = drawRect;
    function checkIfSelectablesAreCorrect(game) {
        if (game.Elements.SelectableElements)
            for (var i = 0; i < game.Elements.SelectableElements.el.length; i++) {
                if ((game.Elements.SelectableElements.el[i].name.name == "checked" && game.Elements.SelectableElements.el[i].correct == true) || (game.Elements.SelectableElements.el[i].name.name == "unchecked" && game.Elements.SelectableElements.el[i].correct == false)) {
                }
                else {
                    return false;
                }
            }
        return true;
    }
    EU.checkIfSelectablesAreCorrect = checkIfSelectablesAreCorrect;
    EU.KBoard;
    function createFillElements(game) {
        if (game.Elements.FillElements) {
            var BoxSize = 8 / 5 * game.Elements.FillElements.Options.CharacterSize;
            var LetterAmountmultipler = 70 * (game.Elements.FillElements.Options.MaxCharacters / 2);
            var inputBoxStyle = { "font": null, "fill": "black" };
            inputBoxStyle.font = "normal " + game.Elements.FillElements.Options.CharacterSize + "pt Arial";
            var bmd = game.game.add.bitmapData(LetterAmountmultipler, BoxSize);
            bmd.ctx.rect(0, 0, LetterAmountmultipler, BoxSize);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();
            for (var i = 0; i < game.Elements.FillElements.el.length; i++) {
                createOneFillElement(i, bmd, LetterAmountmultipler, inputBoxStyle, game);
            }
        }
    }
    EU.createFillElements = createFillElements;
    function createOneFillElement(i, bmd, LetterAmountmultipler, inputBoxStyle, game) {
        var posX = game.Elements.FillElements.el[i].pos.x;
        var posY = game.Elements.FillElements.el[i].pos.y;
        var box = game.game.add.sprite(0, 0, bmd);
        box.alpha = 0.5;
        box.width = LetterAmountmultipler;
        var item = game.game.add.text(0, 0, "?", inputBoxStyle);
        item.father = box;
        box.text = item;
        box.inputEnabled = true;
        game.Elements.FillElements.el[i].name = item;
        box.events.onInputUp.add(showKeyboard, { "game": game, "KB": EU.KBoard });
        game.addChild(box);
        game.addChild(item);
        if (game.Elements.FillElements.Options.Just) {
            switch (game.Elements.FillElements.Options.Just.x) {
                case "center":
                    posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                    box.anchor.x = 0.5;
                    item.anchor.x = 0.5;
                    break;
                case "right":
                    posX += Global.Main.mainContainerDims.wd - 120;
                    box.anchor.x = 1;
                    item.anchor.x = 1;
                    break;
            }
            switch (game.Elements.FillElements.Options.Just.y) {
                case "center":
                    posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                    box.anchor.y = 0.5;
                    item.anchor.y = 0.5;
                    break;
                case "bottom":
                    posY += Global.Main.mainContainerDims.hg - 65;
                    box.anchor.y = 1;
                    item.anchor.y = 1;
                    break;
            }
        }
        if (game.Elements.FillElements.el[i].just) {
            switch (game.Elements.FillElements.el[i].just) {
                case "left":
                    box.anchor.x = 0;
                    item.anchor.x = 0;
                    break;
                case "center":
                    box.anchor.x = 0.5;
                    item.anchor.x = 0.5;
                    break;
                case "right":
                    box.anchor.x = 1;
                    item.anchor.x = 1;
                    break;
            }
        }
        box.position.set(posX, posY);
        item.position.set(posX, posY);
    }
    EU.createOneFillElement = createOneFillElement;
    function keyboardInit(game, button) {
        EU.KBoard = new KB.Keyboard(game.game, game.Elements.FillElements.Options.AcceptedCharacters, 500, 0, true);
        if (game.Elements.FillElements.Options.AcceptedCharacters.length >= 2) {
            EU.KBoard.initialize(game.Elements.FillElements.Options.AcceptedCharacters, "key", "key");
        }
        else {
            EU.KBoard.initialize("qwertyuiop" + EU.KBoard.arrSeparator + "asdfghjkl" + EU.KBoard.arrSeparator + "zxcvbnm^& .,", "key", "key");
        }
        EU.KBoard.scale.setTo(0.5, 0.5);
        EU.KBoard.alive = false;
        EU.KBoard.fixedToCamera = true;
        EU.KBoard.maxLetters = game.Elements.FillElements.Options.MaxCharacters;
        game.game.add.existing(EU.KBoard);
    }
    EU.keyboardInit = keyboardInit;
    function showKeyboard(button) {
        if (EU.KBoard == undefined) {
            keyboardInit(this.game, button);
        }
        EU.KBoard.controller = button.text;
        EU.KBoard.RootController = this.game;
        EU.KBoard.navClick();
        EU.Log(EU.KBoard);
    }
    EU.showKeyboard = showKeyboard;
    function killKeyboard() {
        if (EU.KBoard != undefined) {
            EU.KBoard.destroy(false, false);
            EU.KBoard = undefined;
        }
    }
    EU.killKeyboard = killKeyboard;
    function checkIfFillsAreCorrect(game) {
        if (game.Elements.FillElements) {
            killKeyboard();
            for (var i = 0; i < game.Elements.FillElements.el.length; i++) {
                if (!game.Elements.FillElements.el[i].name || game.Elements.FillElements.el[i].name.text != game.Elements.FillElements.el[i].Answer)
                    if (game.Elements.FillElements.el[i].Answer != "")
                        return false;
            }
        }
        return true;
    }
    EU.checkIfFillsAreCorrect = checkIfFillsAreCorrect;
    EU.groups;
    EU.usedWords;
    function loadVocabulary(game) {
        EU.usedWords = [];
        EU.groups = game.Elements.Groups;
    }
    EU.loadVocabulary = loadVocabulary;
})(EU || (EU = {}));
//# sourceMappingURL=ExtraUtilities.js.map