﻿module Memo {

    export class Memo extends Base.BasicGroup {


        Elements: any;
        PREFIX: any;

        unhide: number = 0;

        totalPair = 8;

        firstCard: MemoCard;
        secondCard: MemoCard;

        cards: Array<string> = ['brzoza1', 'brzoza2', 'buk1', 'buk2', 'dab1', 'dab2', 'jodla1', 'jodla2', 'klon1', 'klon2', 'modrzew1', 'modrzew2', 'sosna1', 'sosna2', 'swierk1', 'swierk2'];

        init(json) {
            super.init(json);
            this.Elements = json.GameData;

        }

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        }

        loadGraphics() {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        shuffle(o) {
            for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
            return o;
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }

            this.shuffle(this.cards);
            var variant = 1;
            for (var i = 0; i < 4; i++) 
                for (var j = 0; j < 4; j++) {
                    var m = new MemoCard(this.game, 400 + (i * 220), 0 + (j * 220), this.cards[0]);
                    m.inputEnabled = true;
                    m.events.onInputDown.add(this.clickCard, this);
                    this.cards.shift();
                    this.addChild(m);
            }

        }

        clickCard(obj: MemoCard) {
            this.unhide++
            if (this.unhide == 1) {
                this.firstCard = obj;
                this.firstCard.inputEnabled = false;
                this.firstCard.showKey();
                //console.log(obj.group);
            }

            if (this.unhide == 2) {
                this.secondCard = obj;
                this.secondCard.inputEnabled = false;
                this.secondCard.showKey();
                //console.log(obj.group);
                this.game.time.events.add(Phaser.Timer.SECOND * 2, this.checkPair, this);
                
            }
        }

        checkPair() {
            if (this.firstCard.group == this.secondCard.group) {
                this.firstCard.done = true;
                this.secondCard.done = true;
                this.unhide = 0;
                this.totalPair--;
                if (this.totalPair == 0) {
                    EU.setGameCompletion(this.parent, 1);
                    super.nextTask();
                }
                console.log('Pair');
            }
            else {
                this.firstCard.back();
                this.secondCard.back();
                this.unhide = 0;
            }


        }

    }

    class MemoCard extends Phaser.Sprite {

        group: string;
        imgKey: string;
        game: Phaser.Game;
        done: boolean = false;

        constructor(game, x, y, key) {
            super(game, x, y, 'memo');
            this.group = key.substring(0, key.length - 1);
            this.imgKey = key;
            this.game = game;
        }

        showKey() {
            this.loadTexture(this.imgKey, 0, true);
        }

        back() {
            this.loadTexture('memo', 0, true);
            this.inputEnabled = true;
        }

    }

} 