﻿module Fill {
    export class Fill extends Base.BasicGroup {
        connectElementCount: number;
        GameData: any;
        HorizontalPlacementArray: Array<number> = [];
        VerticalPlacementArray: Array<number> = [];
        tst2: any;
        text: Phaser.Text;
        item: any;
        box: any;
        CaseSensitivity: boolean = true;
        public keyboard: any;
        isGrid: Boolean = false;
        StartingPosX: number = 0;
        StartingPosY: number = 0;
        Columns: number = 0;
        Rows: number = 0;
        Spacing: number = 0;
        initializationKeys: string = "";
        maxCharacters: number = 0;
        FillList: Array<any> = [];
        AlwaysGood: boolean = false;
        fontSize;


        public inputBoxStyle = { font: "normal 80pt Arial", fill: "black" };

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();

        }
        public killKeyborad() {
            if (this.keyboard != undefined) {

                this.keyboard.destroy(false, false);
                this.keyboard = undefined;
            }
        }
        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            this.loadInit();
            // this.keyboardInit();
            this.createStaticElements();
            this.createActiveElments();
            EU.createStaticSounds(this);


        }
        loadInit() {
            this.initializationKeys = this.GameData.AcceptedCharacters;
            this.maxCharacters = this.GameData.MaxCharacters;
            if (this.GameData.CaseSensitivity === true || this.GameData.CaseSensitivity === false)
            {
                this.CaseSensitivity = this.GameData.CaseSensitivity;
            }
            this.AlwaysGood = this.GameData.AlwaysGood;
            if (this.GameData.isGrid == true) {
                this.isGrid = this.GameData.isGrid;
                this.StartingPosX = this.GameData.StartingPos.x;
                this.StartingPosY = this.GameData.StartingPos.y;
                this.Columns = this.GameData.Columns;
                this.Rows = this.GameData.Rows;
                this.Spacing = this.GameData.Spacing;
               

            }
            // EU.Log("isGrid?" + this.isGrid);
        }
        loadGraphics() {
            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
        }

        createStaticElements() {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            if (this.isGrid) {
                var currHeight = this.StartingPosY;

                for (var i = 0; i < this.GameData.StaticElements.length; i++) {

                    var currWidth = this.StartingPosX;
                    if (this.GameData.StaticElements[i].HasImage) {
                        var el = this.game.add.image(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].key);
                        //el.anchor.set(0.5, 0.5);
                       // el.scale.setTo(0.5, 0.5);
                        currWidth += el.width;
                        currHeight += el.height;
                        this.HorizontalPlacementArray.push(currWidth + this.Spacing);
                        this.VerticalPlacementArray.push(el.height / 2 + this.Spacing);
                        this.addChild(el);
                    }
                    if (this.GameData.StaticElements[i].HasText) {

                        var el_text = this.game.add.text(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.HorizontalPlacementArray.push(el_text.width + (LetterAmountmultipler / 2) + currWidth);
                        this.addChild(el_text);
                    
                        // this.createActiveTextElment(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].id);
                       
                        el_text = this.game.add.text(this.HorizontalPlacementArray[i] + LetterAmountmultipler / 2, currHeight + (100 * i), this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        currWidth += el_text.width;
                        this.VerticalPlacementArray.push(currHeight + (100 * i));
                        this.addChild(el_text);
                    }
                }
            } else { // manual image and text placement.
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                   
                    if (this.GameData.StaticElements[i].HasImage) {
                        var el = this.game.add.image(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].key);
                        //el.scale.setTo(0.5, 0.5);

                        this.addChild(el);
                    }
                    if (this.GameData.StaticElements[i].HasText) {

                        var el_text = this.game.add.text(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.addChild(el_text);
                        el_text = this.game.add.text(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.addChild(el_text);
                    }

                }
            }
        }

        createActiveElments() {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
            }
            var BoxSize = 8 / 5 * this.fontSize;
            var LetterAmountmultipler = 70 * (this.maxCharacters / 3);

            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            var bmd = this.game.add.bitmapData(LetterAmountmultipler, BoxSize);
            bmd.ctx.rect(0, 0, LetterAmountmultipler, BoxSize);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();

            var currHeight = this.StartingPosY;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                if (this.isGrid)
                    this.box = this.game.add.sprite(this.HorizontalPlacementArray[i], this.VerticalPlacementArray[i], bmd);
                else
                    this.box = this.game.add.sprite(this.GameData.TaskList[i].pos.x, this.GameData.TaskList[i].pos.y, bmd);

                this.box.anchor.set(0.5, 0.5);
                this.box.alpha = 0.5;
                //this.box.height = 100;
                this.box.width = LetterAmountmultipler;
                this.item = this.game.add.text(0, 0, "?", this.inputBoxStyle);
                // this.box.width = this.item.width + 50;
                this.item.anchor.set(0.5, 0.5);
                this.item.father = this.box;
                this.item.x = this.box.x;
                this.item.y = this.box.y;
               // this.item.MultipleAnswers = this.GameData.TaskList[i].MultipleAnswers;
                this.addChild(this.item);
                this.box.text = this.item;
              //  if (this.item.MultipleAnswers) {
             //       for (var j = 0; j < this.GameData.TaskList[i].Answer.Lenght; j++)
              //      {
             //           this.item.answer.push(this.GameData.TaskList[i].Answer[j]);
              //      }
              //      EU.Log(this.item);
              //  }
              //  else{
                    this.item.answer = this.GameData.TaskList[i].Answer;
               // }
                this.box.inputEnabled = true;
                this.box.events.onInputUp.add(this.showKeyboard, this);
                this.addChild(this.box);
                this.FillList.push(this.item);
            }

        }

        keyboardInit() {

            this.keyboard = new KB.Keyboard(this.game, this.initializationKeys, 500, 0, true);
            if (this.initializationKeys.length >= 2) {
                EU.Log(this.keyboard);
                this.keyboard.initialize(this.initializationKeys, "key", "key");
            }
            else {
                this.keyboard.initialize("qwertyuiop+-" + this.keyboard.arrSeparator + "asdfghjkl" + this.keyboard.arrSeparator + "zxcvbnm^& .,", "key", "key");
            }
            //}
                
            this.keyboard.scale.setTo(0.5, 0.5);
            this.keyboard.alive = false;
            this.keyboard.fixedToCamera = true;
            this.keyboard.maxLetters = this.maxCharacters;
            this.game.add.existing(this.keyboard);
            //this.addChild(this.keyboard);          
            // lis.add(this.checkComplition);
        }
        showKeyboard(button) {
            if (this.keyboard == undefined)
                this.keyboardInit();
            //EU.Log(button.width);
            // this.keyboardInit();
            this.keyboard.controller = button.text;
            this.keyboard.RootController = this;
            this.keyboard.navClick(this.keyboard);
            // EU.Log(this.keyboard.input.text);
            // EU.Log("test");
            //  console.log;
            // this.ShowKeyboard = true;
        }
        public checkComplition() {
            
            // EU.Log("asda");
            var TotalAnswers = this.GameData.TaskList.length;
            var GoodAnswers = 0;
            var BadAnswers = 0;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                if (this.AlwaysGood) {
                    if (this.FillList[i].text.toUpperCase() != "?") {
                        GoodAnswers++;
                    }

                }
                else {
                    if (this.CaseSensitivity) {
                        // EU.Log("CaseSensitivity:" + this.CaseSensitivity+" FillList[i]= " + this.FillList[i].text + "===" + this.GameData.TaskList[i].Answer);
                        if (this.GameData.TaskList[i].MultipleAnswers) {
                            var istrue = false;
                            for (var j = 0; j < this.GameData.TaskList[i].Answer.length; j++) {

                                if (this.FillList[i].text === this.GameData.TaskList[i].Answer[j]) {
                                    // EU.Log("FillList[i]= " + this.FillList[i].text + "===" + this.GameData.TaskList[i].Answer);
                                    // TotalAnswers++;
                                    istrue = true;


                                }
                                else {
                                    if (this.FillList[i].text.toUpperCase() != "?" && !istrue)
                                        //TotalAnswers++;
                                        istrue = false;
                                    // BadAnswers++;
                                }
                            }
                            if (istrue) {
                                GoodAnswers++;
                            }
                            else {
                                BadAnswers++;
                            }
                        }
                        else {
                            if (this.FillList[i].text === this.GameData.TaskList[i].Answer || this.GameData.TaskList[i].Answer === "") {
                                // EU.Log("FillList[i]= " + this.FillList[i].text + "===" + this.GameData.TaskList[i].Answer);
                                // TotalAnswers++;
                                if (this.GameData.CorrectSound) {

                                    Global.Main.PlayMusic(new Audio('Sounds/win.mp3'));
                                }
                                GoodAnswers++;
                            }
                            else {
                                if (this.FillList[i].text.toUpperCase() != "?")
                                    //TotalAnswers++;
                                    if (this.GameData.CorrectSound) {

                                        Global.Main.PlayMusic(new Audio('Sounds/err.mp3'));
                                    }
                                    BadAnswers++;
                            }
                        }
                    }
                    else {
                        // EU.Log("CaseSensitivity:" + this.CaseSensitivity + " FillList[i]= " + this.FillList[i].text.toUpperCase() + "===" + this.GameData.TaskList[i].Answer.toUpperCase());
                        if (this.GameData.TaskList[i].MultipleAnswers) {
                            var istrue = false;
                            for (var j = 0; j < this.GameData.TaskList[i].Answer.length; j++) {

                                if (this.FillList[i].text.toUpperCase() === this.GameData.TaskList[i].Answer[j].toUpperCase()) {
                                    // EU.Log("FillList[i]= " + this.FillList[i].text + "===" + this.GameData.TaskList[i].Answer);
                                    // TotalAnswers++;
                                    istrue = true;


                                }
                                else {
                                    if (this.FillList[i].text.toUpperCase() != "?" && !istrue)
                                        //TotalAnswers++;
                                        istrue = false;
                                    // BadAnswers++;
                                }
                            }
                            if (istrue) {
                                if (this.GameData.CorrectSound) {

                                    Global.Main.PlayMusic(new Audio('Sounds/win.mp3'));
                                }
                                GoodAnswers++;
                            }
                            else {
                                if (this.GameData.CorrectSound) {

                                    Global.Main.PlayMusic(new Audio('Sounds/err.mp3'));
                                }
                                BadAnswers++;
                            }
                        }
                        else {
                            if (this.FillList[i].text.toUpperCase() === this.GameData.TaskList[i].Answer.toUpperCase() || this.GameData.TaskList[i].Answer === "") {
                                //  EU.Log("FillList[i]= " + this.FillList[i].text + "===" + this.GameData.TaskList[i].Answer);
                                // TotalAnswers++;
                                if (this.GameData.CorrectSound) {

                                    Global.Main.PlayMusic(new Audio('Sounds/win.mp3'));
                                }
                                GoodAnswers++;
                            }
                            else {
                                if (this.FillList[i].text.toUpperCase() != "?")
                                    //TotalAnswers++;
                                    if (this.GameData.CorrectSound) {

                                        Global.Main.PlayMusic(new Audio('Sounds/err.mp3'));
                                    }
                                    BadAnswers++;
                            }
                        }
                    }
                }

            }
            if (TotalAnswers == GoodAnswers) {
                //  EU.Log("All Good!");
                EU.setGameCompletion(this.parent, 1);
                if (TYPE === "gm") {
                    super.nextTask();
                }
            }
            else {
                var complition = GoodAnswers / TotalAnswers;
                var tmpCheck = BadAnswers / TotalAnswers;
                EU.Log(complition + " + " + tmpCheck + " = " + (tmpCheck + complition));
                if (tmpCheck + complition != 1) {
                    EU.Log("zaznacz wszystkie ocje");
                }
                else {
                    EU.setGameCompletion(this.parent, 0);
                }

            }
            this.killKeyborad()
        }
        update() {
            
            //   this.tst2.text.slice(-1);
        }
        init(json) {
            super.init(json);
            //ladowanie danych wejsciowych
            // EU.Log(json);
            this.GameData = json.GameData;
            
            //this.elementArr.push({ "Title": "1. Wpisz odpowiednia literkę 'w' lub 'f' w wyrazach.", "Sound": "MW_kp_I_1_0.mp3","maxcharacters": "1", });
            //  this.connectElementCount = 8;
            
            //1. Wpisz odpowiednia literkę 'w' lub 'f' w wyrazach.
            //dzwięk: MW_kp_I_1_0.mp3

            //foka f
            //flaga f
            //waga w
            //futro f
            //kowal w
            //kawa w
            //worek w
            //kilof f
        }

    }

}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////            FORMAT JSONA           ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//    JSON = {
//              completeText: "caly tekst do wyswietlenia",
//              searched: [["znak lub wyraz", (true/false || true szuka znaku lub wyrazu oddzielonego spacjami, kropka, myslnikiem lub cudzyslowiem; false szuka podciągu)], [], []]    
//           }
//
// Dodane CaseSensitivity dla calosci gry poprzez ustawienie zmiennej  "CaseSensitivity" na starcie GameData.
// "CaseSensitivity"
//Dodanie Wielokrotnych dobrych odpowiedzi poprzez zmiane w TaskList :
//
//{ "pos": { "x": 1160, "y": 75 }, "MultipleAnswers": true, "Answer":["Polska", "Niemcy", "usa"], "id": 2 }, wielokrotna odpowiedz
//{ "pos": { "x": 800, "y": 160 }, "Answer": "Europie", "id": 3 },
 