﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

function SuspendData()
{
	this.items = new Array();
	this.sys = config.sysVars;
	this.me = config.meVars;
};

SuspendData.prototype.setFromString = function(d)
{
	this.items = new Array();
	if (d && d != "") {
		var arr = d.split(";");
		for (var i = 0; i < arr.length; i++) {
			var n = arr[i].slice(0, arr[i].indexOf( '=' ));
			var v = arr[i].slice(arr[i].indexOf( '=' ) + 1);
			if (n != "") this.items[n] = v.replace(/%3B/gi, ";");
		};
	};

	this._unpack(this.me,this.getValue('me'));
	this._unpack(this.sys,this.getValue('sys'));
};

SuspendData.prototype.getToString = function()
{
	this.setValue('me', this._pack(this.me));
	this.setValue('sys', this._pack(this.sys));

	var out = "";
	for (var k in this.items) {
		out += k + "=" + this.items[k].toString().replace(/\|/g, "%3B") + ";";
	};
	out = out.replace(new RegExp('"', "g"), '%22'); //pg2-pcen -eis doesn't handle quotation marks
	return out;
};

SuspendData.prototype._unpack = function(struct, v){
	if (typeof(v) != "string" || v == "") return;
	var arr = v.split(",");
	var i = 0;
	for (var i=0; i<arr.length; i++) {
		var k = unescape(arr[i].substr(0, arr[i].indexOf("#")));
		var val = unescape(arr[i].substr(arr[i].indexOf("#") + 1, arr[i].length));
		struct[k] = val;
	};
};

SuspendData.prototype._pack = function(struct)
{
	var result = new Array();
	for (var k in struct) {
		var val = struct[k].toString();
		val = val.replace(/,/g, "%2C");
		val = val.replace(/#/g, "%23");
		val = val.replace(/=/g, "%3D");
		val = val.replace(/\|/g, "%7C");
		result[result.length] = k + "#" + val;
	};
	return result.toString();
};

SuspendData.prototype.getValue = function(name)
{
	var v = this.items[name];
	return (typeof(v) == "undefined") ? null:v;
};

SuspendData.prototype.setValue = function(name, value)
{
	this.items[name] = value;
};

suspendData = new SuspendData();
