var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var zad_zaliczone = 0;
var KeyboardGame_mod;
(function (_KeyboardGame_mod) {
    var KeyboardGame_mod = (function (_super) {
        __extends(KeyboardGame_mod, _super);
        function KeyboardGame_mod(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        KeyboardGame_mod.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        KeyboardGame_mod.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        KeyboardGame_mod.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            if (this.json.isFirst2 && this.json.isFirst2 == true) {
                EU.loadVocabulary(this);
            }
            ;
            this.createFillQuestion();
            EU.createStaticElements(this);
            EU.createSelectableElements(this);
            EU.createFillElements(this);
        };
        KeyboardGame_mod.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        KeyboardGame_mod.prototype.createFillQuestion = function () {
            this.addChild(this.game.add.image(450, 50, "kb"));
            var question;
            var flag = false;
            while (flag == false) {
                flag = true;
                this.categoryIndex = Math.floor((Math.random() * EU.groups.length));
                this.wordIndex = Math.floor((Math.random() * EU.groups[this.categoryIndex].vocabulary.length));
                EU.Log(this.categoryIndex + " " + this.wordIndex);
                question = EU.groups[this.categoryIndex].vocabulary[this.wordIndex];
                EU.Log(question);
                for (var i = 0; i < EU.usedWords.length; i++) {
                    if (EU.usedWords[i] == question) {
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            EU.usedWords.push(question);
            this.Qtext = this.game.add.text(840, 450, question, this.Elements.FillElements.Options.Style);
            this.Qtext.anchor.set(0.5, 0.5);
            this.addChild(this.Qtext);
            this.Elements.FillElements.el.push({
                "pos": this.Elements.Position,
                "Answer": question
            });
        };
		KeyboardGame_mod.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
        KeyboardGame_mod.prototype.checkIfEverythingIsCorrect = function () {
            EU.Log("Selectables: " + EU.checkIfSelectablesAreCorrect(this));
            EU.Log("Fills: " + EU.checkIfFillsAreCorrect(this));
            if (EU.checkIfSelectablesAreCorrect(this) && EU.checkIfFillsAreCorrect(this)) {
                zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
                if (TYPE === "gm") {
					var next = this.game.add.button(1825 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8,0.8);
					this.addChild(next);
                    _super.prototype.nextTaskforKeyboardGame.call(this);
                }
                return true;
            }
            zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            return false;
        };
        return KeyboardGame_mod;
    })(Base.BasicGroup);
    _KeyboardGame_mod.KeyboardGame_mod = KeyboardGame_mod;
})(KeyboardGame_mod || (KeyboardGame_mod = {}));
//# sourceMappingURL=KeyboardGame_mod.js.map