﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

componentSLWTable = function(name)
{
	//inherited	
	this.componentElement = componentElement;
	this.componentElement(name);
	
	this.confirmAnswer = false;
	
	this.count = 0;
};

componentSLWTable.prototype = new componentElement();
componentSLWTable.prototype.type = "componentSLWTable";

componentSLWTable.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();
	
	var tableObj = document.getElementById(this.id + "_tableObj")
	
//	this.headers = 'header=L:label11:200|header=C:label12:100|header=R:checkbox13:100';
	
//	this.data = '';
//	this.data += 'header=L:label11:100|header=C:label12:200|header=R:checkbox13:100';
//	this.data += '||';
//	this.data += 'label=L:label11:1|label=C:label12:0|checkbox=R:checkbox13:1:1';
//	this.data += '||';
//	this.data += 'checkbox=L:checkbox21:1:1|checkbox=C:checkbox22:0:1|checkbox=R:checkbox23:1:0';
//	this.data += '||';
//	this.data += 'button=L:button1:1|button=C:button2:0|button=R:Ä…ĹĽĹ›ĹşÄ‡Ĺ„Ĺ‚ĂłÄ™Ä„Ĺ»ĹšĹąÄ†ĹĹĂ“Ä:0';
//	this.data += '||';
//	this.data += 'radio=L:radio1:1:1|radio=C:radio2:0:1|radio=R:radio3:1:0';
//	this.data += '||';
//	this.data += 'input=L:input1:1|input=C:input2:0|input=R:input3:1';
//	this.data += '||';
//	this.data += 'combobox=L:aaa,bbb,ccc:1:0|combobox=C:aaa,bbb,ccc:0:2|combobox=R:zzz,xxx,ccc:1:1';
	
	this.insertHeader();
	this.insertData();
};

componentSLWTable.prototype.insertHeader = function() {
	var a = this.headers.split("|");
	var cTR, cTD;
	var tableObj = document.getElementById(this.id + "_headObj")

	cTR = tableObj.insertRow(0)
	for (var i = 0; i < a.length; i++) {
		var c = a[i].split("=");
		if (c.length == 2) {
			cTD = cTR.insertCell();
			this.insertHeaderCell(cTD, c[1]);
		}
	}
}

componentSLWTable.prototype.insertHeaderCell = function(o, formatParams) {
	var a = formatParams.split(':');
	
	if (a.length == 3)
	{
		this.alignData(o, a[0]);
		var s = "";
		s += a[1];
		o.innerHTML = s;
		o.width = a[2] + "px";
		var o = document.getElementById(this.id+'_header_'+this.count);
	}
}

componentSLWTable.prototype.insertData = function() {
	var a = this.data.split("||");
	var cTR, cTD;
	var tableObj = document.getElementById(this.id + "_bodyObj")
	
	for (var i = 0; i < a.length; i++) {
		cTR = tableObj.insertRow(tableObj.rows.length)
		var b = a[i].split("|");
		for (var j = 0; j < b.length; j++) {
			var c = b[j].split("=");
			if (c.length == 2) {
				cTD = cTR.insertCell();
				switch (c[0]) {
					//case "header":
					//	this.insertHeader(cTD, c[1]);
					//	break;
					case "checkbox":
						this.insertCheckBox(cTD, c[1]);
						break;
					case "radio":
						this.insertRadio(cTD, c[1]);
						break;
					case "label":
						this.insertLabel(cTD, c[1]);
						break;
					case "button":
						this.insertButton(cTD, c[1]);
						break;
					case "input":
						this.insertInput(cTD, c[1]);
						break;
					case "combobox":
						this.insertComboBox(cTD, c[1]);
						break;
					default:
						this.insertMsg(cTD, "<span style=\"color:red\">Unknown Component</span>");
				}
				this.count++;
			}
		}
	}
}

componentSLWTable.prototype.alignData = function(o, alignCode) {
	switch (alignCode) {
		case "C":
			o.style.textAlign = "center";
			break;
		case "R":
			o.style.textAlign = "right";
			break;
		default:
			o.style.textAlign = "left";
			break;
	}
}

componentSLWTable.prototype.insertMsg = function(o, text) {
	var s = "";
	s += '<label id="'+this.id+'_combobox_'+this.count+'">'+text+'</label>';
	o.innerHTML = s;
}

componentSLWTable.prototype.insertCheckBox = function(o, formatParams) {
	var a = formatParams.split(':');
	
	if (a.length == 4)
	{
		this.alignData(o, a[0]);
		var s = "";
		s += '<div>';
		s += '	<span style="display: table-cell;">';
		s += '	<input type="checkbox" id="'+this.id+'_combobox_'+this.count+'" value="Button" style="vertical-align: middle;"/>';
		s += '</span>';
		s += '<label id="'+this.id+'_label_'+this.count+'" for="'+this.id+'_combobox_'+this.count+'" style="vertical-align: middle; display: table-cell;">'+a[1]+'</label>';
		s += '</div>';
		o.innerHTML = s;
		var o = document.getElementById(this.id+'_combobox_'+this.count);
		if (a[2] == '1') o.disabled = "disabled";
		if (a[3] == '1') o.checked = "checked";
	}
}

componentSLWTable.prototype.insertRadio = function(o, formatParams) {
	var a = formatParams.split(':');
	
	if (a.length == 4)
	{
		this.alignData(o, a[0]);
		var s = "";
		s += '<div style="white-space: nowrap;">';
		s += '	<span style="display: table-cell;">';
		s += '	<input type="radio" id="'+this.id+'_radio_'+this.count+'" name="radiogroup1" value="Button" style="vertical-align: middle;"/>';
		s += '</span>';
		s += '<label id="'+this.id+'_label_'+this.count+'" for="'+this.id+'_radio_'+this.count+'" style="vertical-align: middle; display: table-cell;">'+a[1]+'</label>';
		s += '</div>';
		o.innerHTML = s;
		var o = document.getElementById(this.id+'_radio_'+this.count);
		if (a[2] == '1') o.disabled = "disabled";
		if (a[3] == '1') o.checked = "checked";
	}
}

componentSLWTable.prototype.insertLabel = function(o, formatParams) {
	var a = formatParams.split(':');
	
	if (a.length == 3)
	{
		this.alignData(o, a[0]);
		var s = "";
		s += '<label id="'+this.id+'_label_'+this.count+'">'+a[1]+'</label>';
		o.innerHTML = s;
		var o = document.getElementById(this.id+'_label_'+this.count);
		if (a[2] == '1') o.disabled = "disabled";
	}
}

componentSLWTable.prototype.insertButton = function(o, formatParams) {
	var a = formatParams.split(':');
	
	if (a.length == 3)
	{
		this.alignData(o, a[0]);
		var s = "";
		s += '<button id="'+this.id+'_button_'+this.count+'" style="white-space: nowrap; background-color: ButtonFace; font: 11px Tahoma;" />'+a[1]+'</button>';
		o.innerHTML = s;
		var o = document.getElementById(this.id+'_button_'+this.count);
		if (a[2] == '1') o.disabled = "disabled";
	}
}

componentSLWTable.prototype.insertInput = function(o, formatParams) {
	var a = formatParams.split(':');
	
	if (a.length == 3)
	{
		this.alignData(o, a[0]);
		var s = "";
		s += '<input type="input" id="'+this.id+'_input_'+this.count+'" style="white-space: nowrap; background-color: ButtonFace; font: 11px Tahoma; width=100%;" value="'+a[1]+'"/>';
		o.innerHTML = s;
		var o = document.getElementById(this.id+'_input_'+this.count);
		if (a[2] == '1') o.disabled = "disabled";
	}
}

componentSLWTable.prototype.insertComboBox = function(o, formatParams) {
	var a = formatParams.split(':');
	
	if (a.length == 4)
	{
		this.alignData(o, a[0]);
		var s = "";
		s += '<select id="'+this.id+'_combobox_'+this.count+'" style="white-space: nowrap; background-color: ButtonFace; font: 11px Tahoma; width=100%;">';
		var opt = a[1].split(",");
		for (var i = 0; i < opt.length; i++) {
			s += '<option value="'+i+'">'+opt[i]+'</option>';
		}
		s += '</select>';
		o.innerHTML = s;
		var o = document.getElementById(this.id+'_combobox_'+this.count);
		o.selectedIndex = a[3];
		if (a[2] == '1') o.disabled = "disabled";
	}
}
