var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Compass;
(function (_Compass) {
    var Compass = (function (_super) {
        __extends(Compass, _super);
        function Compass(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Compass.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Compass.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        };
        Compass.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
            this.cursors = this.game.input.keyboard.createCursorKeys();
        };
        Compass.prototype.create = function () {
            this.game.physics.startSystem(Phaser.Physics.ARCADE);
            this.player = this.game.add.sprite(180, 50, 'player');
            this.player.animations.add('walkDown', [0, 1, 2], 9, true);
            this.player.animations.add('walkUp', [3, 4, 5], 9, true);
            this.player.animations.add('walkRight', [7, 6, 8], 9, true);
            this.player.animations.add('walkLeft', [11, 9, 10], 9, true);
            this.addChild(this.player);
        };
        Compass.prototype.update = function () {
            if (this.ready) {
                if (this.cursors.left.isDown) {
                    this.player.body.velocity.x = -200;
                    if (this.player.body.moves != false)
                        this.player.animations.play('walkLeft');
                }
                else if (this.cursors.right.isDown) {
                    this.player.body.velocity.x = 200;
                    if (this.player.body.moves != false)
                        this.player.animations.play('walkRight');
                }
                else if (this.cursors.up.isDown) {
                    this.player.body.velocity.y = -200;
                    if (this.player.body.moves != false)
                        this.player.animations.play('walkUp');
                }
                else if (this.cursors.down.isDown) {
                    this.player.body.velocity.y = 200;
                    if (this.player.body.moves != false)
                        this.player.animations.play('walkDown');
                }
                else
                    this.player.animations.stop();
            }
        };
        return Compass;
    })(Base.BasicGroup);
    _Compass.Compass = Compass;
})(Compass || (Compass = {}));
//# sourceMappingURL=Compass.js.map