var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Quiz2;
(function (_Quiz2) {
    var Quiz2 = (function (_super) {
        __extends(Quiz2, _super);
        function Quiz2(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.CreateAnimals = false;
        }
        Quiz2.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        Quiz2.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Quiz2.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            if (this.Elements.Color) {
                this.Color = this.Elements.Color;
            }
            else
                this.Color = "red";
            this.numberOfChecked = 0;
            EU.createStaticElements(this);
            this.createQuestions();
            this.LocalPoints = [];
            this.initPointingSystem();
        };
        Quiz2.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Quiz2.prototype.createStaticElements = function () {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        };
        Quiz2.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        Quiz2.prototype.createQuestions = function () {
            this.Questions = [];
            for (var i = 0; i < this.Elements.Questions.length; i++) {
                var el = this.game.add.text(0, 0, this.Elements.Questions[i].QuestionText, this.Elements.Questions[i].QuestionStyle);
                this.addChild(el);
                var posX = this.Elements.Questions[i].Position.x;
                var posY = this.Elements.Questions[i].Position.y;
                el.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, el), posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, el));
                el.align = (this.Elements.Questions[i].Just).toLowerCase();
                var Answers = [];
                for (var j = 0; j < this.Elements.Questions[i].Answers.length; j++) {
                    var ans = this.game.add.text(0, 0, this.Elements.Questions[i].Answers[j].Text, this.Elements.Questions[i].AnswerFont);
                    this.addChild(ans);
                    ans.position.set(posX + this.getJustedPositionX(this.Elements.Questions[i].Position.JustX, ans), posY + this.getJustedPositionY(this.Elements.Questions[i].Position.JustY, ans) + (j + 1) * this.Elements.Questions[i].Spacing + el.height + j * ans.height);
                    ans.inputEnabled = true;
                    ans.align = (this.Elements.Questions[i].Just).toLowerCase();
                    ans.events.onInputOver.add(this.onInputOver, this);
                    ans.events.onInputOut.add(this.onInputOut, this);
                    ans.events.onInputDown.add(this.onInputDown, this);
                    Answers.push({
                        "Element": ans,
                        "isTrue": this.Elements.Questions[i].Answers[j].isTrue,
                        "points": this.Elements.Questions[i].Answers[j].points
                    });
                }
                this.Questions.push({
                    "Text": this.Elements.Questions[i].QuestionText,
                    "Answers": Answers
                });
            }
        };
        Quiz2.prototype.getJustedPositionX = function (just, element) {
            var posX = 0;
            switch (just) {
                case "Center":
                    posX += (Global.Main.mainContainerDims.wd - 120) / 2 - element.width / 2;
                    break;
                case "Right":
                    posX += Global.Main.mainContainerDims.wd - 120 - element.width;
                    break;
            }
            return posX;
        };
        Quiz2.prototype.getJustedPositionY = function (just, element) {
            var posY = 0;
            switch (just) {
                case "Center":
                    posY += (Global.Main.mainContainerDims.hg - 65) / 2 - element.height / 2;
                    break;
                case "Bottom":
                    posY += Global.Main.mainContainerDims.hg - 65 - element.height;
                    break;
            }
            return posY;
        };
        Quiz2.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        Quiz2.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        Quiz2.prototype.onInputDown = function (el, pointer) {
            if (el.name == "checked") {
                el.setShadow(0, 0, "black");
                this.numberOfChecked--;
                el.name = "unchecked";
            }
            else {
                el.setShadow(el.height / 25, el.height / 25, this.Color);
                this.numberOfChecked++;
                el.name = "checked";
            }
            this.checkIfEverythingIsCorrect();
        };
        Quiz2.prototype.checkIfEverythingIsCorrect = function () {
            if (this.numberOfChecked == 1) {
                for (var i = 0; i < this.Questions.length; i++) {
                    for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                        if (this.Questions[i].Answers[j].Element.name == "checked") {
                            for (var m = 0; m < this.LocalPoints.length; m++) {
                                this.LocalPoints[m] = this.LocalPoints[m] + this.Questions[i].Answers[j].points[m];
                                EU.Log(this.LocalPoints);
                            }
                            EU.savePoints(this.LocalPoints);
                            EU.saveCreationState(true, (this.Elements.CurrentPage + 1));
                        }
                    }
                }
                EU.setGameCompletion(this.parent, 1);
                EU.Log("Correct!!!");
                if (TYPE === "gm") {
                    _super.prototype.nextTask.call(this);
                }
                return true;
            }
            EU.setGameCompletion(this.parent, 0);
            return false;
        };
        Quiz2.prototype.calculateMaxPoints = function () {
            var points = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue)
                        points++;
                }
            }
            return points;
        };
        Quiz2.prototype.calculatePlayerPoints = function () {
            var points = 0;
            this.numberOfCorrect = 0;
            for (var i = 0; i < this.Questions.length; i++) {
                for (var j = 0; j < this.Questions[i].Answers.length; j++) {
                    if (this.Questions[i].Answers[j].isTrue && this.Questions[i].Answers[j].Element.name == "checked") {
                        var tmp = this.Questions[i].Answers[j].points;
                        for (var m = 0; m < this.LocalPoints.length; m++)
                            this.LocalPoints[m] = this.LocalPoints[m] + tmp[m];
                        points++;
                    }
                }
            }
            return points;
        };
        Quiz2.prototype.initPointingSystem = function () {
            if (this.Elements.InitPoints) {
                EU.saveCreationState(true, this.Elements.CurrentPage);
                this.LocalPoints = this.Elements.points;
                EU.initPointingSystem(this.Elements.points);
                this.createGraphicRepresentation();
            }
        };
        Quiz2.prototype.createGraphicRepresentation = function () {
            if (EU.loadCreationState(this.Elements.CurrentPage)) {
                if (this.LocalPoints[1] <= 0 && this.LocalPoints[1] != -999) {
                    this.LocalPoints[1] = -999;
                    EU.savePoints(this.LocalPoints);
                    EU.saveCreationState(true, (this.Elements.CurrentPage + 1));
                    EU.Log("wykonane w :" + this.Elements.CurrentPage);
                    EU.setGameCompletion(this.parent, 1);
                    var maxpage = 21;
                    _super.prototype.superNextTask.call(this, maxpage);
                }
                else {
                    for (var m1 = 0; m1 < this.LocalPoints[0]; m1++) {
                        var el;
                        el = this.game.add.image(0, 0, this.PREFIX + this.Elements.Reperesentation[0].key);
                        el.scale.setTo(0.5, 0.5);
                        var posY = this.Elements.Reperesentation[0].pos.y + 50 * (m1 % 3);
                        var posX = this.Elements.Reperesentation[0].pos.x + 25 + 50 * (m1 % 25);
                        el.position.set(posX, posY);
                        this.addChild(el);
                    }
                    for (var m2 = 0; m2 < this.LocalPoints[1]; m2++) {
                        var el;
                        el = this.game.add.image(0, 0, this.PREFIX + this.Elements.Reperesentation[1].key);
                        el.scale.setTo(0.5, 0.5);
                        var posY = this.Elements.Reperesentation[0].pos.y + 200 + 50 * (m2 % 3);
                        var posX = this.Elements.Reperesentation[1].pos.x + 25 + 50 * (m2 % 25);
                        el.position.set(posX, posY);
                        this.addChild(el);
                    }
                }
            }
        };
        Quiz2.prototype.update = function () {
            if ((EU.points != undefined && this.LocalPoints != undefined) && (EU.points[0] != this.LocalPoints[0] || EU.points[1] != this.LocalPoints[1])) {
                this.LocalPoints = EU.loadPoints(this.LocalPoints);
                this.createGraphicRepresentation();
            }
        };
        return Quiz2;
    })(Base.BasicGroup);
    _Quiz2.Quiz2 = Quiz2;
})(Quiz2 || (Quiz2 = {}));
//# sourceMappingURL=Quiz2.js.map