var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Connect;
var zad_zaliczone = 0;
(function (_Connect) {
    var colors = ["blue", "red", "green", "orange", "yellow", "pink", "magenta", "purple", "darkred", "lightseagreen"];
    var Connect = (function (_super) {
        __extends(Connect, _super);
        function Connect(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Connect.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        Connect.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Connect.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.GAME_TYPE = this.Elements.GameType;
            this.drawingsAreAnswers = this.Elements.DrawingsAreAnswers;
            this.loadPositionsDrawings();
            this.loadPositionsAnswers();
            this.connectDrowingsToSounds();
            EU.createStaticElements(this);
            EU.createFillElements(this);
            EU.createSelectableElements(this);
            this.createDrawings();
            this.createAnswers();
        };
        Connect.prototype.loadPositionsDrawings = function () {
            this.drawingsPositions = [];
            for (var i = 0; i < this.Elements.Drawings.el.length; i++) {
                this.drawingsPositions.push(this.Elements.Drawings.el[i].pos);
            }
            if (this.Elements.RandomPositions && this.Elements.RandomPositions == true) {
                this.drawingsPositions = EU.shuffleArray(this.drawingsPositions);
            }
        };
        Connect.prototype.loadPositionsAnswers = function () {
            this.answersPositions = [];
            for (var i = 0; i < this.Elements.Answers.el.length; i++) {
                this.answersPositions.push(this.Elements.Answers.el[i].pos);
            }
            if (this.Elements.RandomPositions && this.Elements.RandomPositions == true) {
                this.answersPositions = EU.shuffleArray(this.answersPositions);
            }
        };
        Connect.prototype.connectDrowingsToSounds = function () {
            if (this.Elements.StaticElements.Options.ConnectToDrowings && this.Elements.StaticElements.Options.ConnectToDrowings == "true")
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    this.Elements.StaticElements.el[i].pos.x = this.drawingsPositions[i].x + this.Elements.StaticElements.Options.OffsetX;
                    this.Elements.StaticElements.el[i].pos.y = this.drawingsPositions[i].y + this.Elements.StaticElements.Options.OffsetY;
                }
            if (this.Elements.StaticElements.Options.ConnectToAnsers && this.Elements.StaticElements.Options.ConnectToAnsers == "true")
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    this.Elements.StaticElements.el[i].pos.x = this.answersPositions[i].x + this.Elements.StaticElements.Options.OffsetX;
                    this.Elements.StaticElements.el[i].pos.y = this.answersPositions[i].y + this.Elements.StaticElements.Options.OffsetY;
                }
        };
        Connect.prototype.createDrawings = function () {
            this.shadow = [];
            this.drawings = [];
            this.connections = [];
            var color = this.randomColor();
            for (var i = 0; i < this.Elements.Drawings.el.length; i++) {
                var el;
                var shad;
                if (this.Elements.Drawings.el[i].type && this.Elements.Drawings.el[i].type == "text") {
                    el = this.game.add.text(this.drawingsPositions[i].x, this.drawingsPositions[i].y, this.Elements.Drawings.el[i].text, this.Elements.Drawings.Options.Style);
                    if (this.Elements.Drawings.Options.Border) {
                        var rect = EU.drawRect(color, el.width * this.Elements.Drawings.Options.Border.width / 100, el.height * this.Elements.Drawings.Options.Border.height / 100, this.Elements.Drawings.Options.Border.roundness, this.Elements.Drawings.Options.Border.thickness, this);
                        rect.position.set(el.width * (1 - this.Elements.Drawings.Options.Border.width / 100) / 2, el.height * (1 - this.Elements.Drawings.Options.Border.height / 100) / 2);
                        el.addChild(rect);
                    }
                    shad = this.game.add.text(this.drawingsPositions[i].x + 3, this.drawingsPositions[i].y + 10, this.Elements.Drawings.el[i].text, this.Elements.Drawings.Options.Style);
                    el.key = this.Elements.Drawings.el[i].key;
                }
                else {
                    el = this.game.add.image(this.drawingsPositions[i].x, this.drawingsPositions[i].y, this.PREFIX + this.Elements.Drawings.el[i].key);
                    shad = this.game.add.image(this.drawingsPositions[i].x + 3, this.drawingsPositions[i].y + 10, this.PREFIX + this.Elements.Drawings.el[i].key);
                }
                shad.alpha = 0;
                shad.tint = 0x000000;
                shad.inputEnabled = true;
                el.inputEnabled = true;
                el.events.onInputOver.add(this.onInputOver, this);
                el.events.onInputOut.add(this.onInputOut, this);
                if (this.drawingsAreAnswers) {
                    el.events.onInputDown.add(this.onDrawingAnswerClicked, this);
                }
                else {
                    el.events.onInputDown.add(this.onDrawingClicked, this);
                }
                this.drawings.push({
                    "el": el,
                    "val": this.Elements.Drawings.el[i].val,
                    "lineStyleX": this.Elements.Drawings.el[i].lineStyleX,
                    "lineStyleY": this.Elements.Drawings.el[i].lineStyleY
                });
                this.shadow.push(shad);
                this.addChild(shad);
                this.addChild(el);
            }
        };
        Connect.prototype.createAnswers = function () {
            this.answers = [];
            var color = this.randomColor();
            for (var i = 0; i < this.Elements.Answers.el.length; i++) {
                var el;
                if (this.Elements.Answers.el[i].type && this.Elements.Answers.el[i].type == "text") {
                    el = this.game.add.text(this.answersPositions[i].x, this.answersPositions[i].y, this.Elements.Answers.el[i].text, this.Elements.Answers.Options.Style);
                    el.key = this.Elements.Answers.el[i].key;
                    if (this.Elements.Answers.Options.Border) {
                        var rect = EU.drawRect(color, el.width * this.Elements.Answers.Options.Border.width / 100, el.height * this.Elements.Answers.Options.Border.height / 100, this.Elements.Answers.Options.Border.roundness, this.Elements.Answers.Options.Border.thickness, this);
                        rect.position.set(el.width * (1 - this.Elements.Answers.Options.Border.width / 100) / 2, el.height * (1 - this.Elements.Answers.Options.Border.height / 100) / 2);
                        el.addChild(rect);
                    }
                }
                else {
                    el = this.game.add.image(this.answersPositions[i].x, this.answersPositions[i].y, this.PREFIX + this.Elements.Answers.el[i].key);
                }
                el.inputEnabled = true;
                el.events.onInputDown.add(this.createConnectionOnClick, this);
                this.answers.push({
                    "el": el,
                    "val": this.Elements.Answers.el[i].val,
                    "lineStyleX": this.Elements.Answers.el[i].lineStyleX,
                    "lineStyleY": this.Elements.Answers.el[i].lineStyleY
                });
                this.addChild(el);
            }
        };
        Connect.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.5;
        };
        Connect.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        Connect.prototype.onDrawingClicked = function (el, pointer) {
            var elementIndex = this.getElementIndex(el, this.drawings);
            if ((this.GAME_TYPE == "ManyToMany" || this.GAME_TYPE == "OneToMany" || !this.checkIfDrawingHasConnection(elementIndex))) {
                if (!this.checkIfDrawingMarked()) {
                    this.shadow[elementIndex].alpha = 0.3;
                }
                else {
                    this.shadow[elementIndex].alpha = 0;
                }
            }
        };
        Connect.prototype.onDrawingAnswerClicked = function (el, pointer) {
            var elementIndex = this.getElementIndex(el, this.drawings);
            if ((this.GAME_TYPE == "ManyToMany" || this.GAME_TYPE == "OneToMany") || (!this.checkIfDrawingHasConnection(elementIndex) && !this.checkIfAnswerHasConnection(elementIndex))) {
                if (!this.checkIfDrawingMarked()) {
                    this.shadow[elementIndex].alpha = 0.3;
                }
                else {
                    this.shadow[elementIndex].alpha = 0;
                }
            }
            if (this.shadow[elementIndex].alpha == 0 && this.checkIfDrawingMarked() && ((this.GAME_TYPE == "ManyToMany" || this.GAME_TYPE == "OneToMany") || (!this.checkIfDrawingHasConnection(elementIndex) && !this.checkIfAnswerHasConnection(elementIndex)))) {
                this.createConnectionIfDaA(el, this.checkIfDrawingMarked().index, elementIndex);
            }
        };
        Connect.prototype.onConnectionClicked = function (el, pointer) {
            for (var i = 0; i < this.connections.length; i++) {
                if (this.connections[i].img == el) {
                    el.destroy();
                    this.connections.splice(i, 1);
                }
            }
            this.checkIfEverythingIsCorrect();
        };
        Connect.prototype.createConnectionOnClick = function (el, pointer) {
            var answerIndex = this.getElementIndex(el, this.answers);
            this.createConnection(el, answerIndex);
        };
        Connect.prototype.createConnection = function (element, answerIndex) {
            if (this.GAME_TYPE == "ManyToOne" || this.GAME_TYPE == "ManyToMany" || !this.checkIfAnswerHasConnection(answerIndex)) {
                var img;
                if (img = this.checkIfDrawingMarked()) {
                    var connection = {
                        DrawingIndex: null,
                        AnswerIndex: null,
                        img: null
                    };
                    connection['DrawingIndex'] = img.index;
                    connection['AnswerIndex'] = answerIndex;
                    if (this.Elements.ForceCorrect == true) {
                        if (this.drawings[img.index].val == this.answers[answerIndex].val) {
                            this.addConnectionToArray(connection, this.connections, this.drawings, this.answers);
                            EU.Log(this.checkIfConnectionIsCorrect(connection, this.drawings, this.answers));
                            this.clearMarkedDrawings();
                            this.debugPoints();
                            this.checkIfEverythingIsCorrect();
                        }
                    }
                    else {
                        this.addConnectionToArray(connection, this.connections, this.drawings, this.answers);
                        EU.Log(this.checkIfConnectionIsCorrect(connection, this.drawings, this.answers));
                        this.clearMarkedDrawings();
                        this.debugPoints();
                        this.checkIfEverythingIsCorrect();
                    }
                }
            }
        };
        Connect.prototype.createConnectionIfDaA = function (element, answerIndex, drawingIndex) {
            var connection = {
                DrawingIndex: drawingIndex,
                AnswerIndex: answerIndex,
                img: null
            };
            if (this.Elements.ForceCorrect == true) {
                if (this.drawings[drawingIndex].val == this.answers[answerIndex].val) {
                    this.addConnectionToArrayDAA(connection, this.connections, this.drawings, this.drawings);
                    EU.Log(this.checkIfConnectionIsCorrect(connection, this.drawings, this.drawings));
                    this.clearMarkedDrawings();
                    this.debugPoints();
                    this.checkIfEverythingIsCorrect();
                }
            }
            else {
                this.addConnectionToArrayDAA(connection, this.connections, this.drawings, this.drawings);
                EU.Log(this.checkIfConnectionIsCorrect(connection, this.drawings, this.drawings));
                this.clearMarkedDrawings();
                this.debugPoints();
                this.checkIfEverythingIsCorrect();
            }
        };
        Connect.prototype.clearMarkedDrawings = function () {
            for (var i = 0; i < this.shadow.length; i++) {
                this.shadow[i].alpha = 0;
            }
        };
        Connect.prototype.getElementIndex = function (element, array) {
            for (var i = 0; i < array.length; i++) {
                if (array[i].el.key == element.key)
                    return i;
            }
        };
        Connect.prototype.randomColor = function () {
            return Phaser.Math.getRandom(colors, 0, colors.length);
        };
        Connect.prototype.addConnectionToArray = function (connection, array, drawings, answers) {
            for (var i = 0; i < array.length; i++) {
                if (connection.DrawingIndex == array[i].DrawingIndex && connection.AnswerIndex == array[i].AnswerIndex) {
                    return false;
                }
            }
            connection['img'] = this.drawStyledConnection(drawings[connection.DrawingIndex], answers[connection.AnswerIndex]);
            array.push(connection);
            return true;
        };
        Connect.prototype.addConnectionToArrayDAA = function (connection, array, drawings, answers) {
            for (var i = 0; i < array.length; i++) {
                if ((connection.DrawingIndex == array[i].DrawingIndex && connection.AnswerIndex == array[i].AnswerIndex) || (connection.DrawingIndex == array[i].AnswerIndex && connection.AnswerIndex == array[i].DrawingIndex)) {
                    return false;
                }
            }
            connection['img'] = this.drawStyledConnection(drawings[connection.DrawingIndex], answers[connection.AnswerIndex]);
            array.push(connection);
            return true;
        };
        Connect.prototype.drawStyledConnection = function (drawing, answer) {
            var x1, y1, x2, y2;
            y1 = drawing.el.y + drawing.el.height / 2 + drawing.lineStyleY / 200 * drawing.el.height;
            y2 = answer.el.y + answer.el.height / 2 + answer.lineStyleY / 200 * answer.el.height;
            x1 = drawing.el.x + drawing.el.width / 2 + drawing.lineStyleX / 200 * drawing.el.width;
            x2 = answer.el.x + answer.el.width / 2 + answer.lineStyleX / 200 * answer.el.width;
            ;
            return this.drawConnection(x1, y1, x2, y2);
        };
        Connect.prototype.drawConnection = function (x1, y1, x2, y2) {
            var lineWidth = 12;
            var lineLength = Phaser.Math.distance(x1, y1, x2, y2);
            var lineAngle = Phaser.Math.angleBetween(x1, y1, x2, y2);
            this.bmd = this.game.add.bitmapData(lineLength, lineWidth);
            this.bmd.ctx.beginPath();
            this.bmd.ctx.strokeStyle = this.randomColor();
            this.bmd.ctx.stroke();
            this.line = this.game.add.sprite(x1, y1, this.bmd);
            this.line.anchor.y = 0.5;
            this.line.smoothed = true;
            this.line.angle = Phaser.Math.radToDeg(lineAngle);
            this.line.inputEnabled = true;
            this.line.events.onInputOver.add(this.onInputOver, this);
            this.line.events.onInputOut.add(this.onInputOut, this);
            this.line.events.onInputDown.add(this.onConnectionClicked, this);
            this.addChild(this.line);
            this.bmd.ctx.beginPath();
            this.bmd.ctx.moveTo(0, lineWidth / 2);
            this.bmd.ctx.lineTo(lineLength, lineWidth / 2);
            this.bmd.ctx.lineWidth = lineWidth;
            this.bmd.ctx.stroke();
            this.bmd.ctx.closePath();
            this.bmd.render();
            return this.line;
        };
        Connect.prototype.checkIfDrawingMarked = function () {
            for (var i = 0; i < this.shadow.length; i++) {
                if (this.shadow[i].alpha == 0.3) {
                    var temp = {
                        index: i,
                        el: this.shadow[i]
                    };
                    return temp;
                }
            }
        };
        Connect.prototype.checkIfAnswerHasConnection = function (answerIndex) {
            for (var i = 0; i < this.connections.length; i++) {
                if (this.connections[i].AnswerIndex == answerIndex) {
                    return true;
                }
            }
            return false;
        };
        Connect.prototype.checkIfDrawingHasConnection = function (drawingIndex) {
            for (var i = 0; i < this.connections.length; i++) {
                if (this.connections[i].DrawingIndex == drawingIndex) {
                    return true;
                }
            }
            return false;
        };
        Connect.prototype.checkIfConnectionIsCorrect = function (connection, drawings, answers) {
            if (answers[connection.AnswerIndex].val == drawings[connection.DrawingIndex].val) {
                return true;
            }
            return false;
        };
		Connect.prototype.nextScreen = function () {
			if (zad_zaliczone == 1){
				this.game.input.enabled = false;
				EU.killKeyboard();
				var tw = this.game.add.tween(this.game.camera);
				tw.to({ x: this.game.camera.x + Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
				tw.onComplete.add(function () {
					this.game.input.enabled = true;
				}, this);
				tw.start();
				Global.Main.currentPageNumber++;
				Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
				console.log(Global.Main.currentPageNumber);
			}
			else {
				//nie rób nic
			}
        };
		Connect.prototype.prevScreen = function () {
			if (zad_zaliczone == 1){
				if (this.game.camera.x - Global.Main.dims.x > 0){
					this.game.input.enabled = false;
					var tw = this.game.add.tween(this.game.camera);
					tw.to({ x: this.game.camera.x - Global.Main.dims.x }, 1500, Phaser.Easing.Exponential.Out);
					tw.onComplete.add(function () {
						this.game.input.enabled = true;
					}, this);
					tw.start();
					Global.Main.currentPageNumber--;
					if (this.json.Lector)
						Global.Main.returnPage(Global.Main.currentPageNumber).playLector();
						console.log(Global.Main.currentPageNumber);
				}
			}
			else {
				//nie rób nic
			}
        };
        Connect.prototype.checkIfEverythingIsCorrect = function () {
            if (EU.checkIfFillsAreCorrect(this) && EU.checkIfSelectablesAreCorrect(this) && this.calculateMaxPoints() == this.calculatePlayerPoints() && this.connections.length == this.calculatePlayerPoints()) {
				zad_zaliczone = 1;
				console.log("zad_zaliczone = "+zad_zaliczone);
                if (TYPE === "gm") {
					var next = this.game.add.button(1835 - 120 - 76, 730, "next", this.nextScreen, this, 0, 0, 1, 0);
					next.scale.setTo(0.8,0.8);
					this.addChild(next);
					var prev = this.game.add.button(141 - 120 - 76, 730, "prev", this.prevScreen, this, 0, 0, 1, 0);
					prev.scale.setTo(0.8,0.8);
					this.addChild(prev);
                    _super.prototype.nextTaskforConnect.call(this);
                }
                return true;
            }
            zad_zaliczone = 0;
			console.log("zad_zaliczone = "+zad_zaliczone);
            return false;
        };
        Connect.prototype.calculatePlayerPoints = function () {
            var points = 0;
            if (this.drawingsAreAnswers) {
                for (var i = 0; i < this.connections.length; i++) {
                    if (this.checkIfConnectionIsCorrect(this.connections[i], this.drawings, this.drawings)) {
                        points++;
                    }
                }
            }
            else {
                for (var i = 0; i < this.connections.length; i++) {
                    if (this.checkIfConnectionIsCorrect(this.connections[i], this.drawings, this.answers)) {
                        points++;
                    }
                }
            }
            return points;
        };
        Connect.prototype.calculateMaxPoints = function () {
            var points = 0;
            if (this.drawingsAreAnswers) {
                for (var i = 0; i < this.drawings.length; i++) {
                    for (var j = i + 1; j < this.drawings.length; j++) {
                        if (this.drawings[i].val == this.drawings[j].val) {
                            points++;
                            if (this.GAME_TYPE == "OneToOne" || this.GAME_TYPE == "ManyToOne")
                                break;
                        }
                    }
                }
            }
            else {
                for (var i = 0; i < this.drawings.length; i++) {
                    for (var j = 0; j < this.answers.length; j++) {
                        if (this.drawings[i].val == this.answers[j].val) {
                            points++;
                            if (this.GAME_TYPE == "OneToOne" || this.GAME_TYPE == "ManyToOne")
                                break;
                        }
                    }
                }
            }
            return points;
        };
        Connect.prototype.debugConnections = function () {
            for (var i = 0; i < this.connections.length; i++) {
                EU.Log(this.connections[i].DrawingIndex + " " + this.connections.length);
            }
        };
        Connect.prototype.debugPoints = function () {
            var playerPoints = this.calculatePlayerPoints();
            var maxPoints = this.calculateMaxPoints();
            EU.Log("NumberOfConnections: " + this.connections.length + " Correct: " + playerPoints + " MaxCorrect: " + maxPoints);
        };
        Connect.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        return Connect;
    })(Base.BasicGroup);
    _Connect.Connect = Connect;
})(Connect || (Connect = {}));
//# sourceMappingURL=Connect.js.map